/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.model;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jomc.model.ModelContext;
import org.jomc.model.ModelException;
import org.jomc.model.ModelProvider;
import org.jomc.model.Module;
import org.jomc.model.Modules;
import org.jomc.model.Text;
import org.jomc.model.Texts;

public class DefaultModelProvider
implements ModelProvider {
    private static final String DEFAULT_MODULE_LOCATION = "META-INF/jomc.xml";
    private static volatile String defaultModuleLocation;
    private String moduleLocation;

    public static String getDefaultModuleLocation() {
        if (defaultModuleLocation == null) {
            defaultModuleLocation = System.getProperty("org.jomc.model.DefaultModelProvider.defaultModuleLocation", DEFAULT_MODULE_LOCATION);
        }
        return defaultModuleLocation;
    }

    public static void setDefaultModuleLocation(String value) {
        defaultModuleLocation = value;
    }

    public String getModuleLocation() {
        if (this.moduleLocation == null) {
            this.moduleLocation = DefaultModelProvider.getDefaultModuleLocation();
        }
        return this.moduleLocation;
    }

    public void setModuleLocation(String value) {
        this.moduleLocation = value;
    }

    public Modules findModules(ModelContext context, String location) throws ModelException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (location == null) {
            throw new NullPointerException("location");
        }
        try {
            long t0 = System.currentTimeMillis();
            Text text = new Text();
            text.setLanguage("en");
            text.setValue(this.getMessage("contextModulesInfo", new Object[]{location}));
            Modules modules = new Modules();
            modules.setDocumentation(new Texts());
            modules.getDocumentation().setDefaultLanguage("en");
            modules.getDocumentation().getText().add(text);
            Unmarshaller u = context.createUnmarshaller();
            Enumeration<URL> resources = context.findResources(location);
            int count = 0;
            while (resources.hasMoreElements()) {
                Object content;
                ++count;
                URL url = resources.nextElement();
                if (context.isLoggable(Level.FINE)) {
                    context.log(Level.FINE, this.getMessage("processing", new Object[]{url.toExternalForm()}), null);
                }
                if ((content = u.unmarshal(url)) instanceof JAXBElement) {
                    content = ((JAXBElement)content).getValue();
                }
                if (content instanceof Module) {
                    Module m = (Module)content;
                    if (context.isLoggable(Level.CONFIG)) {
                        context.log(Level.CONFIG, this.getMessage("foundModule", new Object[]{m.getName(), m.getVersion() == null ? "" : m.getVersion()}), null);
                    }
                    modules.getModule().add(m);
                    continue;
                }
                if (!context.isLoggable(Level.WARNING)) continue;
                context.log(Level.WARNING, this.getMessage("ignoringDocument", new Object[]{content == null ? "<>" : content.toString(), url.toExternalForm()}), null);
            }
            if (context.isLoggable(Level.FINE)) {
                context.log(Level.FINE, this.getMessage("contextReport", new Object[]{count, location, System.currentTimeMillis() - t0}), null);
            }
            return modules.getModule().isEmpty() ? null : modules;
        }
        catch (JAXBException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    public Modules findModules(ModelContext context) throws ModelException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return this.findModules(context, this.getModuleLocation());
    }

    private String getMessage(String key, Object args) {
        return new MessageFormat(ResourceBundle.getBundle(DefaultModelProvider.class.getName().replace('.', '/'), Locale.getDefault()).getString(key)).format(args);
    }
}

