/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.model;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import org.jomc.model.Dependencies;
import org.jomc.model.Dependency;
import org.jomc.model.Implementation;
import org.jomc.model.ImplementationReference;
import org.jomc.model.Implementations;
import org.jomc.model.Message;
import org.jomc.model.MessageReference;
import org.jomc.model.Messages;
import org.jomc.model.ModelContext;
import org.jomc.model.ModelException;
import org.jomc.model.ModelObject;
import org.jomc.model.ModelValidationReport;
import org.jomc.model.ModelValidator;
import org.jomc.model.Module;
import org.jomc.model.Modules;
import org.jomc.model.Multiplicity;
import org.jomc.model.ObjectFactory;
import org.jomc.model.Properties;
import org.jomc.model.Property;
import org.jomc.model.PropertyReference;
import org.jomc.model.Specification;
import org.jomc.model.SpecificationReference;
import org.jomc.model.Specifications;
import org.jomc.model.Text;
import org.jomc.util.ParseException;
import org.jomc.util.TokenMgrError;
import org.jomc.util.VersionParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModelValidator
implements ModelValidator {
    @Override
    public ModelValidationReport validateModel(ModelContext context, Modules modules) throws ModelException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        try {
            ModelValidationReport report = context.validateModel((Source)new JAXBSource(context.createContext(), new ObjectFactory().createModules(modules)));
            this.assertClassDeclarationUniqueness(modules, report);
            for (Module m : modules.getModule()) {
                this.assertNoSpecificationReferenceDeclarations(m, report);
                this.assertNoImplementationReferenceDeclarations(m, report);
                this.assertNoMessageReferenceDeclarations(m, report);
                this.assertNoFinalMessageDeclarations(m, report);
                this.assertNoOverrideMessageDeclarations(m, report);
                this.assertNoPropertyReferenceDeclarations(m, report);
                this.assertNoFinalPropertyDeclarations(m, report);
                this.assertNoOverridePropertyDeclarations(m, report);
                this.assertNoPropertyValueAndAnyObject(m, report);
                this.assertPropertyTypeWithAnyObject(m, report);
                this.assertValidPropertyJavaValues(context, m, report);
                if (m.getImplementations() != null) {
                    for (Implementation i : m.getImplementations().getImplementation()) {
                        this.assertNoDependencyPropertyReferenceDeclarations(i, report);
                        this.assertNoImplementationDeclarations(i, report);
                        this.assertNoLocationWhenAbstract(i, report);
                        this.assertNoSpecificationDeclarations(i, report);
                        this.assertImplementationMessagesUniqueness(i, report);
                        this.assertImplementationPropertiesUniqueness(i, report);
                        this.assertImplementationDependencyCompatibility(context, modules, i, report);
                        this.assertImplementationInheritanceCompatibility(context, modules, i, report);
                        this.assertImplementationSpecificationCompatibility(context, modules, i, report);
                        this.assertNoMissingMandatoryDependencies(modules, i, report);
                        this.assertNoDependenciesWithoutSpecificationClass(modules, i, report);
                        this.assertNoInheritanceCycle(modules, i, report);
                        this.assertNoInheritanceClashes(modules, i, report);
                        this.assertNoOverridenDependencyPropertiesWhenNotMultiton(modules, i, report);
                        this.assertImplementationOverrideConstraints(modules, i, report);
                        this.assertSpecificationOverrideConstraints(modules, i, report);
                        this.assertDependencyOverrideConstraints(modules, i, report);
                        this.assertMessageOverrideConstraints(modules, i, report);
                        this.assertPropertyOverrideConstraints(modules, i, report);
                        this.assertDependencyPropertiesOverrideConstraints(modules, i, report);
                        this.assertValidMessageTemplates(context, modules, i, report);
                        this.assertNoPropertyValueAndAnyObject(i, report);
                        this.assertPropertyTypeWithAnyObject(i, report);
                        this.assertValidPropertyJavaValues(context, i, report);
                    }
                }
                if (m.getSpecifications() == null) continue;
                for (Specification s : m.getSpecifications().getSpecification()) {
                    this.assertNoSpecificationPropertyReferenceDeclarations(s, report);
                    this.assertSpecificationImplementationNameUniqueness(modules, s, report);
                    this.assertSpecificationMultiplicityConstraint(modules, s, report);
                    this.assertNoPropertyValueAndAnyObject(s, report);
                    this.assertPropertyTypeWithAnyObject(s, report);
                    this.assertValidPropertyJavaValues(context, s, report);
                }
            }
            return report;
        }
        catch (JAXBException e) {
            if (context.isLoggable(Level.FINE)) {
                context.log(Level.FINE, e.getMessage(), e);
            }
            throw new ModelException(e.getMessage(), e);
        }
    }

    private void assertValidPropertyJavaValues(ModelContext context, Module module, ModelValidationReport report) {
        if (module.getProperties() != null) {
            for (Property p : module.getProperties().getProperty()) {
                try {
                    p.getJavaValue(context.getClassLoader());
                }
                catch (ModelException e) {
                    if (context.isLoggable(Level.FINE)) {
                        context.log(Level.FINE, e.getMessage(), e);
                    }
                    report.getDetails().add(this.createDetail("MODULE_PROPERTY_JAVA_VALUE_CONSTRAINT", Level.SEVERE, "modulePropertyJavaValueConstraint", new Object[]{module.getName(), p.getName(), e.getMessage()}, new ObjectFactory().createModule(module)));
                }
            }
        }
    }

    private void assertValidPropertyJavaValues(ModelContext context, Specification specification, ModelValidationReport report) {
        if (specification.getProperties() != null) {
            for (Property p : specification.getProperties().getProperty()) {
                try {
                    p.getJavaValue(context.getClassLoader());
                }
                catch (ModelException e) {
                    if (context.isLoggable(Level.FINE)) {
                        context.log(Level.FINE, e.getMessage(), e);
                    }
                    report.getDetails().add(this.createDetail("SPECIFICATION_PROPERTY_JAVA_VALUE_CONSTRAINT", Level.SEVERE, "specificationPropertyJavaValueConstraint", new Object[]{specification.getIdentifier(), p.getName(), e.getMessage()}, new ObjectFactory().createSpecification(specification)));
                }
            }
        }
    }

    private void assertValidPropertyJavaValues(ModelContext context, Implementation implementation, ModelValidationReport report) {
        if (implementation.getProperties() != null) {
            for (Property p : implementation.getProperties().getProperty()) {
                try {
                    p.getJavaValue(context.getClassLoader());
                }
                catch (ModelException e) {
                    if (context.isLoggable(Level.FINE)) {
                        context.log(Level.FINE, e.getMessage(), e);
                    }
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_PROPERTY_JAVA_VALUE_CONSTRAINT", Level.SEVERE, "implementationPropertyJavaValueConstraint", new Object[]{implementation.getIdentifier(), p.getName(), e.getMessage()}, new ObjectFactory().createImplementation(implementation)));
                }
            }
        }
    }

    private void assertValidMessageTemplates(ModelContext context, Modules modules, Implementation implementation, ModelValidationReport report) {
        Messages messages = modules.getMessages(implementation.getIdentifier());
        if (messages != null) {
            for (Message message : messages.getMessage()) {
                if (message.getTemplate() == null) continue;
                for (Text t : message.getTemplate().getText()) {
                    try {
                        new MessageFormat(t.getValue(), new Locale(t.getLanguage()));
                    }
                    catch (IllegalArgumentException e) {
                        if (context.isLoggable(Level.FINE)) {
                            context.log(Level.FINE, e.getMessage(), e);
                        }
                        report.getDetails().add(this.createDetail("IMPLEMENTATION_MESSAGE_TEMPLATE_CONSTRAINT", Level.SEVERE, "implementationMessageTemplateConstraint", new Object[]{implementation.getIdentifier(), message.getName(), t.getValue(), e.getMessage()}, new ObjectFactory().createImplementation(implementation)));
                    }
                }
            }
        }
    }

    private void assertClassDeclarationUniqueness(Modules modules, ModelValidationReport report) {
        HashMap<String, Specification> specificationClassDeclarations = new HashMap<String, Specification>();
        HashMap<String, Implementation> implementationClassDeclarations = new HashMap<String, Implementation>();
        for (Module m : modules.getModule()) {
            ModelObject prev;
            if (m.getSpecifications() != null) {
                for (Specification s : m.getSpecifications().getSpecification()) {
                    if (!s.isClassDeclaration()) continue;
                    if (s.getClazz() == null) {
                        report.getDetails().add(this.createDetail("SPECIFICATION_CLASS_CONSTRAINT", Level.SEVERE, "specificationClassConstraint", new Object[]{s.getIdentifier()}, new ObjectFactory().createSpecification(s)));
                        continue;
                    }
                    prev = (Specification)specificationClassDeclarations.get(s.getClazz());
                    if (prev != null) {
                        report.getDetails().add(this.createDetail("SPECIFICATION_CLASS_DECLARATION_CONSTRAINT", Level.SEVERE, "specificationClassDeclarationConstraint", new Object[]{s.getIdentifier(), s.getClazz(), ((Specification)prev).getIdentifier()}, new ObjectFactory().createSpecification(s)));
                        continue;
                    }
                    specificationClassDeclarations.put(s.getClazz(), s);
                }
            }
            if (m.getImplementations() == null) continue;
            for (Implementation i : m.getImplementations().getImplementation()) {
                if (!i.isClassDeclaration()) continue;
                if (i.getClazz() == null) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_CLASS_CONSTRAINT", Level.SEVERE, "implementationClassConstraint", new Object[]{i.getIdentifier()}, new ObjectFactory().createImplementation(i)));
                    continue;
                }
                prev = (Implementation)implementationClassDeclarations.get(i.getClazz());
                if (prev != null) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_CLASS_DECLARATION_CONSTRAINT", Level.SEVERE, "implementationClassDeclarationConstraint", new Object[]{i.getIdentifier(), i.getClazz(), ((Implementation)prev).getIdentifier()}, new ObjectFactory().createImplementation(i)));
                    continue;
                }
                implementationClassDeclarations.put(i.getClazz(), i);
            }
        }
    }

    private void assertNoPropertyValueAndAnyObject(Module module, ModelValidationReport report) {
        if (module.getProperties() != null) {
            for (Property p : module.getProperties().getProperty()) {
                if (p.getValue() == null || p.getAny() == null) continue;
                report.getDetails().add(this.createDetail("MODULE_PROPERTY_VALUE_CONSTRAINT", Level.SEVERE, "modulePropertyValueConstraint", new Object[]{module.getName(), p.getName()}, new ObjectFactory().createModule(module)));
            }
        }
    }

    private void assertNoPropertyValueAndAnyObject(Implementation implementation, ModelValidationReport report) {
        if (implementation.getProperties() != null) {
            for (Property p : implementation.getProperties().getProperty()) {
                if (p.getValue() == null || p.getAny() == null) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_PROPERTY_VALUE_CONSTRAINT", Level.SEVERE, "implementationPropertyValueConstraint", new Object[]{implementation.getIdentifier(), p.getName()}, new ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertNoPropertyValueAndAnyObject(Specification specification, ModelValidationReport report) {
        if (specification.getProperties() != null) {
            for (Property p : specification.getProperties().getProperty()) {
                if (p.getValue() == null || p.getAny() == null) continue;
                report.getDetails().add(this.createDetail("SPECIFICATION_PROPERTY_VALUE_CONSTRAINT", Level.SEVERE, "specificationPropertyValueConstraint", new Object[]{specification.getIdentifier(), p.getName()}, new ObjectFactory().createSpecification(specification)));
            }
        }
    }

    private void assertPropertyTypeWithAnyObject(Module module, ModelValidationReport report) {
        if (module.getProperties() != null) {
            for (Property p : module.getProperties().getProperty()) {
                if (p.getAny() == null || p.getType() != null) continue;
                report.getDetails().add(this.createDetail("MODULE_PROPERTY_TYPE_CONSTRAINT", Level.SEVERE, "modulePropertyTypeConstraint", new Object[]{module.getName(), p.getName()}, new ObjectFactory().createModule(module)));
            }
        }
    }

    private void assertPropertyTypeWithAnyObject(Implementation implementation, ModelValidationReport report) {
        if (implementation.getProperties() != null) {
            for (Property p : implementation.getProperties().getProperty()) {
                if (p.getAny() == null || p.getType() != null) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_PROPERTY_TYPE_CONSTRAINT", Level.SEVERE, "implementationPropertyTypeConstraint", new Object[]{implementation.getIdentifier(), p.getName()}, new ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertPropertyTypeWithAnyObject(Specification specification, ModelValidationReport report) {
        if (specification.getProperties() != null) {
            for (Property p : specification.getProperties().getProperty()) {
                if (p.getAny() == null || p.getType() != null) continue;
                report.getDetails().add(this.createDetail("SPECIFICATION_PROPERTY_TYPE_CONSTRAINT", Level.SEVERE, "specificationPropertyTypeConstraint", new Object[]{specification.getIdentifier(), p.getName()}, new ObjectFactory().createSpecification(specification)));
            }
        }
    }

    private void assertNoSpecificationReferenceDeclarations(Module module, ModelValidationReport report) {
        if (module.getSpecifications() != null) {
            for (SpecificationReference r : module.getSpecifications().getReference()) {
                report.getDetails().add(this.createDetail("MODULE_SPECIFICATION_REFERENCE_DECLARATION_CONSTRAINT", Level.SEVERE, "moduleSpecificationReferenceDeclarationConstraint", new Object[]{module.getName(), r.getIdentifier()}, new ObjectFactory().createModule(module)));
            }
        }
    }

    private void assertNoImplementationReferenceDeclarations(Module module, ModelValidationReport report) {
        if (module.getImplementations() != null) {
            for (ImplementationReference r : module.getImplementations().getReference()) {
                report.getDetails().add(this.createDetail("MODULE_IMPLEMENTATION_REFERENCE_DECLARATION_CONSTRAINT", Level.SEVERE, "moduleImplementationReferenceDeclarationConstraint", new Object[]{module.getName(), r.getIdentifier()}, new ObjectFactory().createModule(module)));
            }
        }
    }

    private void assertNoMessageReferenceDeclarations(Module module, ModelValidationReport report) {
        if (module.getMessages() != null) {
            for (MessageReference r : module.getMessages().getReference()) {
                report.getDetails().add(this.createDetail("MODULE_MESSAGE_REFERENCE_DECLARATION_CONSTRAINT", Level.SEVERE, "moduleMessageReferenceDeclarationConstraint", new Object[]{module.getName(), r.getName()}, new ObjectFactory().createModule(module)));
            }
        }
    }

    private void assertNoFinalMessageDeclarations(Module module, ModelValidationReport report) {
        if (module.getMessages() != null) {
            for (Message m : module.getMessages().getMessage()) {
                if (!m.isFinal()) continue;
                report.getDetails().add(this.createDetail("MODULE_FINAL_MESSAGE_DECLARATION_CONSTRAINT", Level.SEVERE, "moduleFinalMessageConstraint", new Object[]{module.getName(), m.getName()}, new ObjectFactory().createModule(module)));
            }
        }
    }

    private void assertNoOverrideMessageDeclarations(Module module, ModelValidationReport report) {
        if (module.getMessages() != null) {
            for (Message m : module.getMessages().getMessage()) {
                if (!m.isOverride()) continue;
                report.getDetails().add(this.createDetail("MODULE_OVERRIDE_MESSAGE_DECLARATION_CONSTRAINT", Level.SEVERE, "moduleOverrideMessageConstraint", new Object[]{module.getName(), m.getName()}, new ObjectFactory().createModule(module)));
            }
        }
    }

    private void assertNoPropertyReferenceDeclarations(Module module, ModelValidationReport report) {
        if (module.getProperties() != null) {
            for (PropertyReference r : module.getProperties().getReference()) {
                report.getDetails().add(this.createDetail("MODULE_PROPERTY_REFERENCE_DECLARATION_CONSTRAINT", Level.SEVERE, "modulePropertyReferenceDeclarationConstraint", new Object[]{module.getName(), r.getName()}, new ObjectFactory().createModule(module)));
            }
        }
    }

    private void assertNoFinalPropertyDeclarations(Module module, ModelValidationReport report) {
        if (module.getProperties() != null) {
            for (Property p : module.getProperties().getProperty()) {
                if (!p.isFinal()) continue;
                report.getDetails().add(this.createDetail("MODULE_FINAL_PROPERTY_DECLARATION_CONSTRAINT", Level.SEVERE, "moduleFinalPropertyConstraint", new Object[]{module.getName(), p.getName()}, new ObjectFactory().createModule(module)));
            }
        }
    }

    private void assertNoOverridePropertyDeclarations(Module module, ModelValidationReport report) {
        if (module.getProperties() != null) {
            for (Property p : module.getProperties().getProperty()) {
                if (!p.isOverride()) continue;
                report.getDetails().add(this.createDetail("MODULE_OVERRIDE_PROPERTY_DECLARATION_CONSTRAINT", Level.SEVERE, "moduleOverridePropertyConstraint", new Object[]{module.getName(), p.getName()}, new ObjectFactory().createModule(module)));
            }
        }
    }

    private void assertNoSpecificationDeclarations(Implementation implementation, ModelValidationReport report) {
        if (implementation.getSpecifications() != null) {
            for (Specification s : implementation.getSpecifications().getSpecification()) {
                report.getDetails().add(this.createDetail("IMPLEMENTATION_SPECIFICATION_DECLARATION_CONSTRAINT", Level.SEVERE, "implementationSpecificationDeclarationConstraint", new Object[]{implementation.getIdentifier(), s.getIdentifier()}, new ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertNoImplementationDeclarations(Implementation implementation, ModelValidationReport report) {
        if (implementation.getImplementations() != null) {
            for (Implementation i : implementation.getImplementations().getImplementation()) {
                report.getDetails().add(this.createDetail("IMPLEMENTATION_IMPLEMENTATION_DECLARATION_CONSTRAINT", Level.SEVERE, "implementationImplementationDeclarationConstraint", new Object[]{implementation.getIdentifier(), i.getIdentifier()}, new ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertNoLocationWhenAbstract(Implementation implementation, ModelValidationReport report) {
        if (implementation.isAbstract() && implementation.getLocation() != null) {
            report.getDetails().add(this.createDetail("IMPLEMENTATION_ABSTRACT_LOCATION_DECLARATION_CONSTRAINT", Level.SEVERE, "implementationAbstractLocationDeclarationConstraint", new Object[]{implementation.getIdentifier(), implementation.getLocation()}, new ObjectFactory().createImplementation(implementation)));
        }
    }

    private void assertNoInheritanceCycle(Modules modules, Implementation implementation, ModelValidationReport report) {
        Implementation cycle = this.findInheritanceCycle(modules, implementation, implementation, new Implementations());
        if (cycle != null) {
            report.getDetails().add(this.createDetail("IMPLEMENTATION_INHERITANCE_CYCLE_CONSTRAINT", Level.SEVERE, "implementationInheritanceCycleConstraint", new Object[]{implementation.getIdentifier(), cycle.getIdentifier()}, new ObjectFactory().createImplementation(implementation)));
        }
    }

    private void assertImplementationSpecificationCompatibility(ModelContext context, Modules modules, Implementation implementation, ModelValidationReport report) {
        Specifications specs = modules.getSpecifications(implementation.getIdentifier());
        if (specs != null) {
            for (SpecificationReference r : specs.getReference()) {
                ModelValidationReport.Detail d;
                Specification s = specs.getSpecification(r.getIdentifier());
                if (s == null || r.getVersion() == null) continue;
                if (s.getVersion() == null) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_SPECIFICATION_VERSIONING_CONSTRAINT", Level.SEVERE, "implementationSpecificationVersioningConstraint", new Object[]{implementation.getIdentifier(), s.getIdentifier()}, new ObjectFactory().createImplementation(implementation)));
                    continue;
                }
                try {
                    if (VersionParser.compare((String)r.getVersion(), (String)s.getVersion()) == 0) continue;
                    Module moduleOfImplementation = modules.getModuleOfImplementation(implementation.getIdentifier());
                    Module moduleOfSpecification = modules.getModuleOfSpecification(s.getIdentifier());
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_SPECIFICATION_COMPATIBILITY_CONSTRAINT", Level.SEVERE, "implementationSpecificationCompatibilityConstraint", new Object[]{implementation.getIdentifier(), moduleOfImplementation != null ? moduleOfImplementation.getName() : "<>", s.getIdentifier(), moduleOfSpecification != null ? moduleOfSpecification.getName() : "<>", r.getVersion(), s.getVersion()}, new ObjectFactory().createImplementation(implementation)));
                }
                catch (ParseException e) {
                    if (context.isLoggable(Level.FINE)) {
                        context.log(Level.FINE, e.getMessage(), e);
                    }
                    d = new ModelValidationReport.Detail("IMPLEMENTATION_SPECIFICATION_COMPATIBILITY_VERSIONING_PARSE_EXCEPTION", Level.SEVERE, e.getMessage(), new ObjectFactory().createImplementation(implementation));
                    report.getDetails().add(d);
                }
                catch (TokenMgrError e) {
                    if (context.isLoggable(Level.FINE)) {
                        context.log(Level.FINE, e.getMessage(), e);
                    }
                    d = new ModelValidationReport.Detail("IMPLEMENTATION_SPECIFICATION_COMPATIBILITY_VERSIONING_TOKEN_MANAGER_ERROR", Level.SEVERE, e.getMessage(), new ObjectFactory().createImplementation(implementation));
                    report.getDetails().add(d);
                }
            }
        }
    }

    private void assertImplementationDependencyCompatibility(ModelContext context, Modules modules, Implementation implementation, ModelValidationReport report) {
        Dependencies dependencies = modules.getDependencies(implementation.getIdentifier());
        if (dependencies != null) {
            for (Dependency d : dependencies.getDependency()) {
                ModelValidationReport.Detail detail;
                Specification s = modules.getSpecification(d.getIdentifier());
                if (s == null || d.getVersion() == null) continue;
                if (s.getVersion() == null) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_DEPENDENCY_SPECIFICATION_VERSIONING_CONSTRAINT", Level.SEVERE, "implementationDependencySpecificationVersioningConstraint", new Object[]{implementation.getIdentifier(), d.getName(), s.getIdentifier()}, new ObjectFactory().createImplementation(implementation)));
                    continue;
                }
                try {
                    if (VersionParser.compare((String)d.getVersion(), (String)s.getVersion()) <= 0) continue;
                    Module moduleOfImplementation = modules.getModuleOfImplementation(implementation.getIdentifier());
                    Module moduleOfSpecification = modules.getModuleOfSpecification(s.getIdentifier());
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_DEPENDENCY_SPECIFICATION_COMPATIBILITY_CONSTRAINT", Level.SEVERE, "implementationDependencySpecificationCompatibilityConstraint", new Object[]{implementation.getIdentifier(), moduleOfImplementation != null ? moduleOfImplementation.getName() : "<>", s.getIdentifier(), moduleOfSpecification != null ? moduleOfSpecification.getName() : "<>", d.getVersion(), s.getVersion()}, new ObjectFactory().createImplementation(implementation)));
                }
                catch (ParseException e) {
                    if (context.isLoggable(Level.FINE)) {
                        context.log(Level.FINE, e.getMessage(), e);
                    }
                    detail = new ModelValidationReport.Detail("IMPLEMENTATION_DEPENDENCY_SPECIFICATION_COMPATIBILITY_VERSIONING_PARSE_EXCEPTION", Level.SEVERE, e.getMessage(), new ObjectFactory().createImplementation(implementation));
                    report.getDetails().add(detail);
                }
                catch (TokenMgrError e) {
                    if (context.isLoggable(Level.FINE)) {
                        context.log(Level.FINE, e.getMessage(), e);
                    }
                    detail = new ModelValidationReport.Detail("IMPLEMENTATION_DEPENDENCY_SPECIFICATION_COMPATIBILITY_VERSIONING_TOKEN_MANAGER_ERROR", Level.SEVERE, e.getMessage(), new ObjectFactory().createImplementation(implementation));
                    report.getDetails().add(detail);
                }
            }
        }
    }

    private void assertNoDependencyPropertyReferenceDeclarations(Implementation implementation, ModelValidationReport report) {
        if (implementation.getDependencies() != null) {
            for (Dependency d : implementation.getDependencies().getDependency()) {
                if (d.getProperties() == null) continue;
                for (PropertyReference r : d.getProperties().getReference()) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_DEPENDENCY_PROPERTY_REFERENCE_DECLARATION_CONSTRAINT", Level.SEVERE, "implementationDependencyPropertyReferenceDeclarationConstraint", new Object[]{implementation.getIdentifier(), d.getName(), r.getName()}, new ObjectFactory().createImplementation(implementation)));
                }
            }
        }
    }

    private void assertNoOverridenDependencyPropertiesWhenNotMultiton(Modules modules, Implementation implementation, ModelValidationReport report) {
        if (implementation.getDependencies() != null) {
            for (Dependency d : implementation.getDependencies().getDependency()) {
                Specification s = modules.getSpecification(d.getIdentifier());
                if (s == null || s.getScope() == null || d.getProperties() == null) continue;
                for (Property p : d.getProperties().getProperty()) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_DEPENDENCY_PROPERTIES_OVERRIDE_CONSTRAINT", Level.SEVERE, "implementationDependencyPropertiesOverrideConstraint", new Object[]{implementation.getIdentifier(), d.getName(), s.getIdentifier(), s.getScope(), p.getName()}, new ObjectFactory().createImplementation(implementation)));
                }
            }
        }
    }

    private void assertDependencyPropertiesOverrideConstraints(Modules modules, Implementation implementation, ModelValidationReport report) {
        if (implementation.getDependencies() != null) {
            for (Dependency d : implementation.getDependencies().getDependency()) {
                Implementations available = modules.getImplementations(d.getIdentifier());
                if (available == null) continue;
                if (d.getImplementationName() != null) {
                    Implementation i = available.getImplementationByName(d.getImplementationName());
                    if (i == null) continue;
                    this.assertDependencyDoesNotOverrideFinalPropertyAndDoesNotFlagNonOverridenPropertyOverride(modules, implementation, d, i, report);
                    continue;
                }
                for (Implementation i : available.getImplementation()) {
                    this.assertDependencyDoesNotOverrideFinalPropertyAndDoesNotFlagNonOverridenPropertyOverride(modules, implementation, d, i, report);
                }
            }
        }
    }

    private void assertDependencyDoesNotOverrideFinalPropertyAndDoesNotFlagNonOverridenPropertyOverride(Modules modules, Implementation implementation, Dependency dependency, Implementation dependencyImplementation, ModelValidationReport report) {
        Properties properties;
        if (dependency.getProperties() != null && (properties = modules.getProperties(dependencyImplementation.getIdentifier())) != null) {
            for (Property override : dependency.getProperties().getProperty()) {
                Property overriden = properties.getProperty(override.getName());
                if (overriden != null && overriden.isFinal()) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_DEPENDENCY_FINAL_PROPERTY_CONSTRAINT", Level.SEVERE, "implementationDependencyFinalPropertyConstraint", new Object[]{implementation.getIdentifier(), dependency.getName(), dependencyImplementation.getIdentifier(), override.getName()}, new ObjectFactory().createImplementation(implementation)));
                }
                if (overriden != null || !override.isOverride()) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_DEPENDENCY_OVERRIDE_PROPERTY_CONSTRAINT", Level.SEVERE, "implementationDependencyOverridePropertyConstraint", new Object[]{implementation.getIdentifier(), dependency.getName(), dependencyImplementation.getIdentifier(), override.getName()}, new ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertNoMissingMandatoryDependencies(Modules modules, Implementation implementation, ModelValidationReport report) {
        if (implementation.getDependencies() != null) {
            for (Dependency d : implementation.getDependencies().getDependency()) {
                Implementations available = modules.getImplementations(d.getIdentifier());
                if (d.isOptional()) continue;
                boolean missing = false;
                if (available == null) {
                    missing = true;
                } else if (available.getImplementation().isEmpty()) {
                    missing = true;
                } else if (d.getImplementationName() != null && available.getImplementationByName(d.getImplementationName()) == null) {
                    missing = true;
                }
                if (!missing) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_MANDATORY_DEPENDENCY_CONSTRAINT", Level.SEVERE, "implementationMandatoryDependencyConstraint", new Object[]{implementation.getIdentifier(), d.getName()}, new ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertNoDependenciesWithoutSpecificationClass(Modules modules, Implementation implementation, ModelValidationReport report) {
        if (implementation.getDependencies() != null) {
            for (Dependency d : implementation.getDependencies().getDependency()) {
                Specification s = modules.getSpecification(d.getIdentifier());
                if (s == null || s.getClazz() != null) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_DEPENDENCY_SPECIFICATION_CLASS_CONSTRAINT", Level.SEVERE, "implementationDependencySpecificationClassConstraint", new Object[]{implementation.getIdentifier(), d.getName(), d.getIdentifier()}, new ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertImplementationInheritanceCompatibility(ModelContext context, Modules modules, Implementation implementation, ModelValidationReport report) {
        if (implementation.getImplementations() != null) {
            for (ImplementationReference r : implementation.getImplementations().getReference()) {
                ModelValidationReport.Detail detail;
                Implementation referenced = modules.getImplementation(r.getIdentifier());
                if (referenced == null || r.getVersion() == null) continue;
                if (referenced.getVersion() == null) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_IMPLEMENTATION_VERSIONING_CONSTRAINT", Level.SEVERE, "implementationImplementationVersioningConstraint", new Object[]{implementation.getIdentifier(), referenced.getIdentifier()}, new ObjectFactory().createImplementation(implementation)));
                    continue;
                }
                try {
                    if (VersionParser.compare((String)r.getVersion(), (String)referenced.getVersion()) <= 0) continue;
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_INHERITANCE_COMPATIBILITY_CONSTRAINT", Level.SEVERE, "implementationInheritanceCompatibilityConstraint", new Object[]{implementation.getIdentifier(), referenced.getIdentifier(), r.getVersion(), referenced.getVersion()}, new ObjectFactory().createImplementation(implementation)));
                }
                catch (ParseException e) {
                    if (context.isLoggable(Level.FINE)) {
                        context.log(Level.FINE, e.getMessage(), e);
                    }
                    detail = new ModelValidationReport.Detail("IMPLEMENTATION_INHERITANCE_COMPATIBILITY_VERSIONING_PARSE_EXCEPTION", Level.SEVERE, e.getMessage(), new ObjectFactory().createImplementation(implementation));
                    report.getDetails().add(detail);
                }
                catch (TokenMgrError e) {
                    if (context.isLoggable(Level.FINE)) {
                        context.log(Level.FINE, e.getMessage(), e);
                    }
                    detail = new ModelValidationReport.Detail("IMPLEMENTATION_INHERITANCE_COMPATIBILITY_VERSIONING_TOKEN_MANAGER_ERROR", Level.SEVERE, e.getMessage(), new ObjectFactory().createImplementation(implementation));
                    report.getDetails().add(detail);
                }
            }
        }
    }

    private void assertImplementationOverrideConstraints(Modules modules, Implementation implementation, ModelValidationReport report) {
        Implementations parentImplementations = new Implementations();
        this.collectParentImplementations(modules, implementation, parentImplementations, new Implementations(), false);
        if (implementation.getImplementations() != null) {
            for (ImplementationReference r : implementation.getImplementations().getReference()) {
                Implementation referenced = modules.getImplementation(r.getIdentifier());
                ImplementationReference parentReference = parentImplementations.getReference(r.getIdentifier());
                if (referenced.isFinal()) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_IMPLEMENTATION_INHERITANCE_CONSTRAINT", Level.SEVERE, "implementationFinalImplementationConstraint", new Object[]{implementation.getIdentifier(), referenced.getIdentifier()}, new ObjectFactory().createImplementation(implementation)));
                }
                if (parentReference != null && parentReference.isFinal()) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_IMPLEMENTATION_REFERENCE_INHERITANCE_CONSTRAINT", Level.SEVERE, "implementationFinalImplementatioReferenceConstraint", new Object[]{implementation.getIdentifier(), parentReference.getIdentifier()}, new ObjectFactory().createImplementation(implementation)));
                }
                if (!r.isOverride() || parentReference != null) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_IMPLEMENTATION_OVERRIDE_CONSTRAINT", Level.SEVERE, "implementationImplementationOverrideConstraint", new Object[]{implementation.getIdentifier(), r.getIdentifier()}, new ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertSpecificationOverrideConstraints(Modules modules, Implementation implementation, ModelValidationReport report) {
        Specifications parentSpecifications = new Specifications();
        this.collectParentSpecifications(modules, implementation, parentSpecifications, new Implementations(), false);
        if (implementation.getSpecifications() != null) {
            for (SpecificationReference r : implementation.getSpecifications().getReference()) {
                SpecificationReference parent = parentSpecifications.getReference(r.getIdentifier());
                if (r.isOverride() && parent == null) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_SPECIFICATION_OVERRIDE_CONSTRAINT", Level.SEVERE, "implementationSpecificationOverrideConstraint", new Object[]{implementation.getIdentifier(), r.getIdentifier()}, new ObjectFactory().createImplementation(implementation)));
                }
                if (parent == null || !parent.isFinal()) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_SPECIFICATION_INHERITANCE_CONSTRAINT", Level.SEVERE, "implementationSpecificationFinalConstraint", new Object[]{implementation.getIdentifier(), r.getIdentifier()}, new ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertDependencyOverrideConstraints(Modules modules, Implementation implementation, ModelValidationReport report) {
        Dependencies parentDependencies = new Dependencies();
        this.collectParentDependencies(modules, implementation, parentDependencies, new Implementations(), false);
        if (implementation.getDependencies() != null) {
            for (Dependency d : implementation.getDependencies().getDependency()) {
                Dependency parent = parentDependencies.getDependency(d.getName());
                if (d.isOverride() && parent == null) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_DEPENDENCY_OVERRIDE_CONSTRAINT", Level.SEVERE, "implementationDependencyOverrideConstraint", new Object[]{implementation.getIdentifier(), d.getName()}, new ObjectFactory().createImplementation(implementation)));
                }
                if (parent == null || !parent.isFinal()) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_DEPENDENCY_INHERITANCE_CONSTRAINT", Level.SEVERE, "implementationDependencyFinalConstraint", new Object[]{implementation.getIdentifier(), d.getName()}, new ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertMessageOverrideConstraints(Modules modules, Implementation implementation, ModelValidationReport report) {
        Messages parentMessages = new Messages();
        this.collectParentMessages(modules, implementation, parentMessages, new Implementations(), false);
        if (implementation.getMessages() != null) {
            MessageReference parentReference;
            Message parentMessage;
            for (Message m : implementation.getMessages().getMessage()) {
                parentMessage = parentMessages.getMessage(m.getName());
                parentReference = parentMessages.getReference(m.getName());
                if (m.isOverride() && parentMessage == null && parentReference == null) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_MESSAGE_OVERRIDE_CONSTRAINT", Level.SEVERE, "implementationMessageOverrideConstraint", new Object[]{implementation.getIdentifier(), m.getName()}, new ObjectFactory().createImplementation(implementation)));
                }
                if ((parentMessage == null || !parentMessage.isFinal()) && (parentReference == null || !parentReference.isFinal())) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_MESSAGE_INHERITANCE_CONSTRAINT", Level.SEVERE, "implementationMessageFinalConstraint", new Object[]{implementation.getIdentifier(), m.getName()}, new ObjectFactory().createImplementation(implementation)));
            }
            for (MessageReference r : implementation.getMessages().getReference()) {
                parentMessage = parentMessages.getMessage(r.getName());
                parentReference = parentMessages.getReference(r.getName());
                if (r.isOverride() && parentMessage == null && parentReference == null) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_MESSAGE_OVERRIDE_CONSTRAINT", Level.SEVERE, "implementationMessageOverrideConstraint", new Object[]{implementation.getIdentifier(), r.getName()}, new ObjectFactory().createImplementation(implementation)));
                }
                if ((parentMessage == null || !parentMessage.isFinal()) && (parentReference == null || !parentReference.isFinal())) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_MESSAGE_INHERITANCE_CONSTRAINT", Level.SEVERE, "implementationMessageFinalConstraint", new Object[]{implementation.getIdentifier(), r.getName()}, new ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertPropertyOverrideConstraints(Modules modules, Implementation implementation, ModelValidationReport report) {
        Properties parentProperties = new Properties();
        this.collectParentProperties(modules, implementation, parentProperties, new Implementations(), false);
        if (implementation.getProperties() != null) {
            PropertyReference parentReference;
            Property parentProperty;
            for (Property p : implementation.getProperties().getProperty()) {
                parentProperty = parentProperties.getProperty(p.getName());
                parentReference = parentProperties.getReference(p.getName());
                if (p.isOverride() && parentProperty == null && parentReference == null) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_PROPERTY_OVERRIDE_CONSTRAINT", Level.SEVERE, "implementationPropertyOverrideConstraint", new Object[]{implementation.getIdentifier(), p.getName()}, new ObjectFactory().createImplementation(implementation)));
                }
                if ((parentProperty == null || !parentProperty.isFinal()) && (parentReference == null || !parentReference.isFinal())) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_PROPERTY_INHERITANCE_CONSTRAINT", Level.SEVERE, "implementationPropertyFinalConstraint", new Object[]{implementation.getIdentifier(), p.getName()}, new ObjectFactory().createImplementation(implementation)));
            }
            for (PropertyReference r : implementation.getProperties().getReference()) {
                parentProperty = parentProperties.getProperty(r.getName());
                parentReference = parentProperties.getReference(r.getName());
                if (r.isOverride() && parentProperty == null && parentReference == null) {
                    report.getDetails().add(this.createDetail("IMPLEMENTATION_PROPERTY_OVERRIDE_CONSTRAINT", Level.SEVERE, "implementationPropertyOverrideConstraint", new Object[]{implementation.getIdentifier(), r.getName()}, new ObjectFactory().createImplementation(implementation)));
                }
                if ((parentProperty == null || !parentProperty.isFinal()) && (parentReference == null || !parentReference.isFinal())) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_PROPERTY_INHERITANCE_CONSTRAINT", Level.SEVERE, "implementationPropertyFinalConstraint", new Object[]{implementation.getIdentifier(), r.getName()}, new ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertImplementationMessagesUniqueness(Implementation implementation, ModelValidationReport report) {
        if (implementation.getMessages() != null) {
            for (Message m : implementation.getMessages().getMessage()) {
                if (implementation.getMessages().getReference(m.getName()) == null) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_MESSAGES_UNIQUENESS_CONSTRAINT", Level.SEVERE, "implementationMessagesUniquenessConstraint", new Object[]{implementation.getIdentifier(), m.getName()}, new ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertImplementationPropertiesUniqueness(Implementation implementation, ModelValidationReport report) {
        if (implementation.getProperties() != null) {
            for (Property p : implementation.getProperties().getProperty()) {
                if (implementation.getProperties().getReference(p.getName()) == null) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_PROPERTIES_UNIQUENESS_CONSTRAINT", Level.SEVERE, "implementationPropertiesUniquenessConstraint", new Object[]{implementation.getIdentifier(), p.getName()}, new ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertNoInheritanceClashes(Modules modules, Implementation implementation, ModelValidationReport report) {
        if (implementation.getImplementations() != null) {
            HashMap<String, List<Message>> dependencyMap = new HashMap<String, List<Message>>();
            HashMap<String, List<Message>> messageMap = new HashMap<String, List<Message>>();
            HashMap<String, List<Message>> propertyMap = new HashMap<String, List<Message>>();
            HashMap<String, List<Message>> specMap = new HashMap<String, List<Message>>();
            for (ImplementationReference implementationReference : implementation.getImplementations().getReference()) {
                List<Message> list;
                Specifications currentSpecs = new Specifications();
                Dependencies currentDependencies = new Dependencies();
                Properties currentProperties = new Properties();
                Messages currentMessages = new Messages();
                Implementation current = modules.getImplementation(implementationReference.getIdentifier());
                modules.collectSpecifications(current, currentSpecs, new Implementations(), true);
                modules.collectDependencies(current, currentDependencies, new Implementations(), true);
                modules.collectMessages(current, currentMessages, new Implementations(), true);
                modules.collectProperties(current, currentProperties, new Implementations(), true);
                for (SpecificationReference ref : currentSpecs.getReference()) {
                    list = (LinkedList<SpecificationReference>)specMap.get(ref.getIdentifier());
                    if (list == null) {
                        list = new LinkedList<SpecificationReference>();
                        specMap.put(ref.getIdentifier(), list);
                    }
                    list.add((Message)((Object)ref));
                }
                for (Dependency d : currentDependencies.getDependency()) {
                    list = (List)dependencyMap.get(d.getName());
                    if (list == null) {
                        list = new LinkedList();
                        dependencyMap.put(d.getName(), list);
                    }
                    list.add((Message)((Object)d));
                }
                for (Message msg : currentMessages.getMessage()) {
                    list = (List)messageMap.get(msg.getName());
                    if (list == null) {
                        list = new LinkedList();
                        messageMap.put(msg.getName(), list);
                    }
                    list.add(msg);
                }
                for (Property p : currentProperties.getProperty()) {
                    list = (List)propertyMap.get(p.getName());
                    if (list == null) {
                        list = new LinkedList();
                        propertyMap.put(p.getName(), list);
                    }
                    list.add((Message)((Object)p));
                }
            }
            for (Map.Entry entry : specMap.entrySet()) {
                if (((List)entry.getValue()).size() <= 1 || implementation.getSpecifications() != null && implementation.getSpecifications().getReference((String)entry.getKey()) != null) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_SPECIFICATION_MULTIPLE_INHERITANCE_CONSTRAINT", Level.SEVERE, "implementationMultipleInheritanceSpecificationConstraint", new Object[]{implementation.getIdentifier(), entry.getKey()}, new ObjectFactory().createImplementation(implementation)));
            }
            for (Map.Entry entry : dependencyMap.entrySet()) {
                if (((List)entry.getValue()).size() <= 1 || implementation.getDependencies() != null && implementation.getDependencies().getDependency((String)entry.getKey()) != null) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_DEPENDENCY_MULTIPLE_INHERITANCE_CONSTRAINT", Level.SEVERE, "implementationMultipleInheritanceDependencyConstraint", new Object[]{implementation.getIdentifier(), entry.getKey()}, new ObjectFactory().createImplementation(implementation)));
            }
            for (Map.Entry entry : messageMap.entrySet()) {
                if (((List)entry.getValue()).size() <= 1 || implementation.getMessages() != null && (implementation.getMessages().getMessage((String)entry.getKey()) != null || implementation.getMessages().getReference((String)entry.getKey()) != null)) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_MESSAGE_MULTIPLE_INHERITANCE_CONSTRAINT", Level.SEVERE, "implementationMultipleInheritanceMessageConstraint", new Object[]{implementation.getIdentifier(), entry.getKey()}, new ObjectFactory().createImplementation(implementation)));
            }
            for (Map.Entry entry : propertyMap.entrySet()) {
                if (((List)entry.getValue()).size() <= 1 || implementation.getProperties() != null && (implementation.getProperties().getProperty((String)entry.getKey()) != null || implementation.getProperties().getReference((String)entry.getKey()) != null)) continue;
                report.getDetails().add(this.createDetail("IMPLEMENTATION_PROPERTY_MULTIPLE_INHERITANCE_CONSTRAINT", Level.SEVERE, "implementationMultipleInheritancePropertyConstraint", new Object[]{implementation.getIdentifier(), entry.getKey()}, new ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertSpecificationImplementationNameUniqueness(Modules modules, Specification specification, ModelValidationReport report) {
        Implementations impls = modules.getImplementations(specification.getIdentifier());
        if (impls != null) {
            HashMap<String, Implementations> map = new HashMap<String, Implementations>();
            for (Implementation implementation : impls.getImplementation()) {
                Implementations implementations = (Implementations)map.get(implementation.getName());
                if (implementations == null) {
                    implementations = new Implementations();
                    map.put(implementation.getName(), implementations);
                }
                implementations.getImplementation().add(implementation);
            }
            for (Map.Entry entry : map.entrySet()) {
                if (((Implementations)entry.getValue()).getImplementation().size() <= 1) continue;
                for (Implementation i : ((Implementations)entry.getValue()).getImplementation()) {
                    report.getDetails().add(this.createDetail("SPECIFICATION_IMPLEMENTATION_NAME_UNIQUENESS_CONSTRAINT", Level.SEVERE, "specificationImplementationNameConstraint", new Object[]{i.getIdentifier(), specification.getIdentifier(), i.getName()}, new ObjectFactory().createImplementation(i)));
                }
            }
        }
    }

    private void assertSpecificationMultiplicityConstraint(Modules modules, Specification specification, ModelValidationReport report) {
        Implementations impls = modules.getImplementations(specification.getIdentifier());
        if (specification.getMultiplicity() == Multiplicity.ONE && impls != null && impls.getImplementation().size() > 1) {
            for (Implementation i : impls.getImplementation()) {
                report.getDetails().add(this.createDetail("SPECIFICATION_IMPLEMENTATION_MULTIPLICITY_CONSTRAINT", Level.SEVERE, "specificationMultiplicityConstraint", new Object[]{i.getIdentifier(), specification.getIdentifier(), specification.getMultiplicity()}, new ObjectFactory().createImplementation(i)));
            }
        }
    }

    private void assertNoSpecificationPropertyReferenceDeclarations(Specification specification, ModelValidationReport report) {
        if (specification.getProperties() != null) {
            for (PropertyReference r : specification.getProperties().getReference()) {
                report.getDetails().add(this.createDetail("SPECIFICATION_PROPERTY_REFERENCE_DECLARATION_CONSTRAINT", Level.SEVERE, "specificationPropertyReferenceDeclarationConstraint", new Object[]{specification.getIdentifier(), r.getName()}, new ObjectFactory().createSpecification(specification)));
            }
        }
    }

    private Implementation findInheritanceCycle(Modules modules, Implementation current, Implementation report, Implementations implementations) {
        if (current != null) {
            Iterator<ImplementationReference> i$;
            if (implementations.getImplementation(current.getIdentifier()) != null) {
                return report;
            }
            implementations.getImplementation().add(current);
            if (current.getImplementations() != null && (i$ = current.getImplementations().getReference().iterator()).hasNext()) {
                ImplementationReference r = i$.next();
                return this.findInheritanceCycle(modules, modules.getImplementation(r.getIdentifier()), current, implementations);
            }
        }
        return null;
    }

    private void collectParentImplementations(Modules modules, Implementation implementation, Implementations implementations, Implementations seen, boolean includeImplementation) {
        if (implementation != null && seen.getImplementation(implementation.getIdentifier()) == null) {
            seen.getImplementation().add(implementation);
            if (includeImplementation && implementations.getImplementation(implementation.getIdentifier()) == null) {
                implementations.getImplementation().add(implementation);
            }
            if (implementation.getImplementations() != null) {
                for (ImplementationReference r : implementation.getImplementations().getReference()) {
                    if (includeImplementation && implementations.getReference(r.getIdentifier()) == null) {
                        implementations.getReference().add(r);
                    }
                    this.collectParentImplementations(modules, modules.getImplementation(r.getIdentifier()), implementations, seen, true);
                }
            }
        }
    }

    private void collectParentSpecifications(Modules modules, Implementation implementation, Specifications specifications, Implementations seen, boolean includeImplementation) {
        if (implementation != null && seen.getImplementation(implementation.getIdentifier()) == null) {
            seen.getImplementation().add(implementation);
            if (includeImplementation && implementation.getSpecifications() != null) {
                for (SpecificationReference specificationReference : implementation.getSpecifications().getReference()) {
                    if (specifications.getReference(specificationReference.getIdentifier()) != null) continue;
                    specifications.getReference().add(specificationReference);
                }
            }
            if (implementation.getImplementations() != null) {
                for (ImplementationReference implementationReference : implementation.getImplementations().getReference()) {
                    this.collectParentSpecifications(modules, modules.getImplementation(implementationReference.getIdentifier()), specifications, seen, true);
                }
            }
        }
    }

    private void collectParentDependencies(Modules modules, Implementation implementation, Dependencies dependencies, Implementations seen, boolean includeImplementation) {
        if (implementation != null && seen.getImplementation(implementation.getIdentifier()) == null) {
            seen.getImplementation().add(implementation);
            if (includeImplementation && implementation.getDependencies() != null) {
                for (Dependency d : implementation.getDependencies().getDependency()) {
                    if (dependencies.getDependency(d.getName()) != null) continue;
                    dependencies.getDependency().add(d);
                }
            }
            if (implementation.getImplementations() != null) {
                for (ImplementationReference r : implementation.getImplementations().getReference()) {
                    this.collectParentDependencies(modules, modules.getImplementation(r.getIdentifier()), dependencies, seen, true);
                }
            }
        }
    }

    private void collectParentMessages(Modules modules, Implementation implementation, Messages messages, Implementations seen, boolean includeImplementation) {
        if (implementation != null && seen.getImplementation(implementation.getIdentifier()) == null) {
            seen.getImplementation().add(implementation);
            if (includeImplementation && implementation.getMessages() != null) {
                for (Message message : implementation.getMessages().getMessage()) {
                    if (messages.getMessage(message.getName()) != null) continue;
                    messages.getMessage().add(message);
                }
                for (MessageReference messageReference : implementation.getMessages().getReference()) {
                    if (messages.getReference(messageReference.getName()) != null) continue;
                    messages.getReference().add(messageReference);
                }
            }
            if (implementation.getImplementations() != null) {
                for (ImplementationReference implementationReference : implementation.getImplementations().getReference()) {
                    this.collectParentMessages(modules, modules.getImplementation(implementationReference.getIdentifier()), messages, seen, true);
                }
            }
        }
    }

    private void collectParentProperties(Modules modules, Implementation implementation, Properties properties, Implementations seen, boolean includeImplementation) {
        if (implementation != null && seen.getImplementation(implementation.getIdentifier()) == null) {
            seen.getImplementation().add(implementation);
            if (includeImplementation && implementation.getProperties() != null) {
                for (Property property : implementation.getProperties().getProperty()) {
                    if (properties.getProperty(property.getName()) != null) continue;
                    properties.getProperty().add(property);
                }
                for (PropertyReference propertyReference : implementation.getProperties().getReference()) {
                    if (properties.getReference(propertyReference.getName()) != null) continue;
                    properties.getReference().add(propertyReference);
                }
            }
            if (implementation.getImplementations() != null) {
                for (ImplementationReference implementationReference : implementation.getImplementations().getReference()) {
                    this.collectParentProperties(modules, modules.getImplementation(implementationReference.getIdentifier()), properties, seen, true);
                }
            }
        }
    }

    private ModelValidationReport.Detail createDetail(String identifier, Level level, String messageKey, Object messageArguments, JAXBElement<? extends ModelObject> element) {
        return new ModelValidationReport.Detail(identifier, level, this.getMessage(messageKey, messageArguments), element);
    }

    private String getMessage(String key, Object args) {
        return new MessageFormat(ResourceBundle.getBundle(DefaultModelValidator.class.getName().replace('.', '/'), Locale.getDefault()).getString(key)).format(args);
    }
}

