/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.jomc.model.Implementation;
import org.jomc.model.ImplementationReference;
import org.jomc.model.ModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Implementations", propOrder={"implementation", "reference"})
public class Implementations
extends ModelObject
implements Cloneable {
    protected List<Implementation> implementation;
    protected List<ImplementationReference> reference;

    public Implementations() {
    }

    public Implementations(Implementations o) {
        super(o);
        if (o == null) {
            throw new NullPointerException("Cannot create a copy of 'Implementations' from 'null'.");
        }
        Implementations.copyImplementation(o.getImplementation(), this.getImplementation());
        Implementations.copyReference(o.getReference(), this.getReference());
    }

    public List<Implementation> getImplementation() {
        if (this.implementation == null) {
            this.implementation = new ArrayList<Implementation>();
        }
        return this.implementation;
    }

    public List<ImplementationReference> getReference() {
        if (this.reference == null) {
            this.reference = new ArrayList<ImplementationReference>();
        }
        return this.reference;
    }

    private static void copyImplementation(List<Implementation> source, List<Implementation> target) {
        if (!source.isEmpty()) {
            for (Implementation next : source) {
                if (next instanceof Implementation) {
                    target.add(next.clone());
                    continue;
                }
                throw new AssertionError((Object)("Unexpected instance '" + next + "' for property 'Implementation' of class 'org.jomc.model.Implementations'."));
            }
        }
    }

    private static void copyReference(List<ImplementationReference> source, List<ImplementationReference> target) {
        if (!source.isEmpty()) {
            for (ImplementationReference next : source) {
                if (next instanceof ImplementationReference) {
                    target.add(next.clone());
                    continue;
                }
                throw new AssertionError((Object)("Unexpected instance '" + next + "' for property 'Reference' of class 'org.jomc.model.Implementations'."));
            }
        }
    }

    @Override
    public Implementations clone() {
        return new Implementations(this);
    }

    public Implementation getImplementation(String implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        for (Implementation i : this.getImplementation()) {
            if (!implementation.equals(i.getIdentifier())) continue;
            return i;
        }
        return null;
    }

    public Implementation getImplementation(Class implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        for (Implementation i : this.getImplementation()) {
            if (!i.isClassDeclaration() || !implementation.getName().equals(i.getClazz())) continue;
            return i;
        }
        return null;
    }

    public Implementation getImplementationByName(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        for (Implementation i : this.getImplementation()) {
            if (!name.equals(i.getName())) continue;
            return i;
        }
        return null;
    }

    public ImplementationReference getReference(String implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        for (ImplementationReference r : this.getReference()) {
            if (!implementation.equals(r.getIdentifier())) continue;
            return r;
        }
        return null;
    }
}

