/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.model;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import org.jomc.model.DefaultModelContext;
import org.jomc.model.ModelException;
import org.jomc.model.ModelValidationReport;
import org.jomc.model.Modules;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelContext {
    private static final Level DEFAULT_LOG_LEVEL = Level.WARNING;
    private static volatile Level defaultLogLevel;
    private static volatile String modelContextClassName;
    private List<Listener> listeners;
    private Level logLevel;
    private ClassLoader classLoader;

    public ModelContext(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new ClassLoader(null){

                public String toString() {
                    return ModelContext.class.getName() + ".BootstrapClassLoader@" + System.identityHashCode(this);
                }
            };
        }
        return this.classLoader;
    }

    public List<Listener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new LinkedList<Listener>();
        }
        return this.listeners;
    }

    public static Level getDefaultLogLevel() {
        if (defaultLogLevel == null) {
            defaultLogLevel = Level.parse(System.getProperty("org.jomc.model.ModelContext.defaultLogLevel", DEFAULT_LOG_LEVEL.getName()));
        }
        return defaultLogLevel;
    }

    public static void setDefaultLogLevel(Level value) {
        defaultLogLevel = value;
    }

    public Level getLogLevel() {
        if (this.logLevel == null) {
            this.logLevel = ModelContext.getDefaultLogLevel();
            this.log(Level.CONFIG, ModelContext.getMessage("defaultLogLevelInfo", this.getClass().getCanonicalName(), this.logLevel.getLocalizedName()), null);
        }
        return this.logLevel;
    }

    public void setLogLevel(Level value) {
        this.logLevel = value;
    }

    public boolean isLoggable(Level level) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        return level.intValue() >= this.getLogLevel().intValue();
    }

    public void log(Level level, String message, Throwable throwable) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        if (this.isLoggable(level)) {
            for (Listener l : this.getListeners()) {
                l.onLog(level, message, throwable);
            }
        }
    }

    public static String getModelContextClassName() {
        if (modelContextClassName == null) {
            modelContextClassName = System.getProperty("org.jomc.model.ModelContext.className", DefaultModelContext.class.getName());
        }
        return modelContextClassName;
    }

    public static void setModelContextClassName(String value) {
        modelContextClassName = value;
    }

    public Class findClass(String name) throws ModelException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            return Class.forName(name, true, this.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            if (this.isLoggable(Level.FINE)) {
                this.log(Level.FINE, ModelContext.getMessage("classNotFound", name), e);
            }
            return null;
        }
    }

    public URL findResource(String name) throws ModelException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.getClassLoader().getResource(name);
    }

    public Enumeration<URL> findResources(String name) throws ModelException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            return this.getClassLoader().getResources(name);
        }
        catch (IOException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    public abstract Modules findModules() throws ModelException;

    public abstract Modules processModules(Modules var1) throws ModelException;

    public abstract ModelValidationReport validateModel(Source var1) throws ModelException;

    public abstract ModelValidationReport validateModel(Modules var1) throws ModelException;

    public static ModelContext createModelContext(ClassLoader classLoader) throws ModelException {
        if (DefaultModelContext.class.getName().equals(ModelContext.getModelContextClassName())) {
            return new DefaultModelContext(classLoader);
        }
        try {
            Class<?> clazz = Class.forName(ModelContext.getModelContextClassName(), true, classLoader);
            Constructor<?> ctor = clazz.getConstructor(ClassLoader.class);
            return (ModelContext)ctor.newInstance(classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new ModelException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new ModelException(e.getMessage(), e);
        }
    }

    public abstract EntityResolver createEntityResolver() throws ModelException;

    public abstract LSResourceResolver createResourceResolver() throws ModelException;

    public abstract Schema createSchema() throws ModelException;

    public abstract JAXBContext createContext() throws ModelException;

    public abstract Marshaller createMarshaller() throws ModelException;

    public abstract Unmarshaller createUnmarshaller() throws ModelException;

    private static String getMessage(String key, Object ... args) {
        return MessageFormat.format(ResourceBundle.getBundle(ModelContext.class.getName().replace('.', '/'), Locale.getDefault()).getString(key), args);
    }

    public static abstract class Listener {
        public abstract void onLog(Level var1, String var2, Throwable var3);
    }
}

