/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.model;

import java.util.logging.Level;
import org.jomc.model.ModelContext;
import org.jomc.model.ModelValidationReport;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ModelErrorHandler
extends DefaultHandler {
    private ModelContext context;
    private ModelValidationReport report;

    public ModelErrorHandler(ModelContext context) {
        this(context, null);
    }

    public ModelErrorHandler(ModelContext context, ModelValidationReport report) {
        this.context = context;
        this.report = report;
    }

    public ModelValidationReport getReport() {
        if (this.report == null) {
            this.report = new ModelValidationReport();
        }
        return this.report;
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (this.context != null && this.context.isLoggable(Level.FINE)) {
            this.context.log(Level.FINE, exception.getMessage(), exception);
        }
        this.getReport().getDetails().add(new ModelValidationReport.Detail("W3C XML 1.0 Recommendation - Warning condition", Level.WARNING, exception.getMessage(), null));
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.context != null && this.context.isLoggable(Level.FINE)) {
            this.context.log(Level.FINE, exception.getMessage(), exception);
        }
        this.getReport().getDetails().add(new ModelValidationReport.Detail("W3C XML 1.0 Recommendation - Section 1.2 - Error", Level.SEVERE, exception.getMessage(), null));
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.context != null && this.context.isLoggable(Level.FINE)) {
            this.context.log(Level.FINE, exception.getMessage(), exception);
        }
        this.getReport().getDetails().add(new ModelValidationReport.Detail("W3C XML 1.0 Recommendation - Section 1.2 - Fatal Error", Level.SEVERE, exception.getMessage(), null));
    }
}

