/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.jomc.model.Dependencies;
import org.jomc.model.Dependency;
import org.jomc.model.Implementation;
import org.jomc.model.ImplementationReference;
import org.jomc.model.Implementations;
import org.jomc.model.Instance;
import org.jomc.model.Message;
import org.jomc.model.MessageReference;
import org.jomc.model.Messages;
import org.jomc.model.ModelObject;
import org.jomc.model.Module;
import org.jomc.model.Multiplicity;
import org.jomc.model.Properties;
import org.jomc.model.Property;
import org.jomc.model.PropertyReference;
import org.jomc.model.Specification;
import org.jomc.model.SpecificationReference;
import org.jomc.model.Specifications;
import org.jomc.util.WeakIdentityHashMap;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Modules", propOrder={"module"})
public class Modules
extends ModelObject
implements Cloneable {
    protected List<Module> module;
    private static final String DEFAULT_CLASSPATH_MODULE_NAME = "Java Classpath";
    private static volatile String defaultClasspathModuleName;
    private static final Class[] NO_CLASSES;
    @XmlTransient
    private Map<Object, Instance> objects = new WeakIdentityHashMap();

    public Modules() {
    }

    public Modules(Modules o) {
        super(o);
        if (o == null) {
            throw new NullPointerException("Cannot create a copy of 'Modules' from 'null'.");
        }
        Modules.copyModule(o.getModule(), this.getModule());
    }

    public List<Module> getModule() {
        if (this.module == null) {
            this.module = new ArrayList<Module>();
        }
        return this.module;
    }

    private static void copyModule(List<Module> source, List<Module> target) {
        if (!source.isEmpty()) {
            for (Module next : source) {
                if (next instanceof Module) {
                    target.add(next.clone());
                    continue;
                }
                throw new AssertionError((Object)("Unexpected instance '" + next + "' for property 'Module' of class 'org.jomc.model.Modules'."));
            }
        }
    }

    @Override
    public Modules clone() {
        return new Modules(this);
    }

    public Modules(Map<Object, Instance> objects) {
        if (objects == null) {
            throw new NullPointerException("objects");
        }
        this.objects = objects;
    }

    public Modules(Modules o, Map<Object, Instance> objects) {
        super(o);
        if (o == null) {
            throw new NullPointerException("Cannot create a copy of 'Modules' from 'null'.");
        }
        if (objects == null) {
            throw new NullPointerException("objects");
        }
        Modules.copyModule(o.getModule(), this.getModule());
        this.objects = objects;
    }

    public static String getDefaultClasspathModuleName() {
        if (defaultClasspathModuleName == null) {
            defaultClasspathModuleName = System.getProperty("org.jomc.model.Modules.defaultClasspathModuleName", DEFAULT_CLASSPATH_MODULE_NAME);
        }
        return defaultClasspathModuleName;
    }

    public static void setDefaultClasspathModuleName(String value) {
        defaultClasspathModuleName = value;
    }

    public Module getClasspathModule(String moduleName, ClassLoader classLoader) {
        if (moduleName == null) {
            throw new NullPointerException("moduleName,");
        }
        Module classpathModule = new Module();
        classpathModule.setVersion(System.getProperty("java.specification.version"));
        classpathModule.setName(moduleName);
        this.resolveClasspath(classpathModule, classLoader);
        boolean resolved = classpathModule.getSpecifications() != null && !classpathModule.getSpecifications().getSpecification().isEmpty() || classpathModule.getImplementations() != null && !classpathModule.getImplementations().getImplementation().isEmpty();
        return resolved ? classpathModule : null;
    }

    public Module getModule(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        for (Module m : this.getModule()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public Specifications getSpecifications() {
        Specifications specifications = new Specifications();
        for (Module m : this.getModule()) {
            if (m.getSpecifications() == null) continue;
            specifications.getSpecification().addAll(m.getSpecifications().getSpecification());
        }
        return specifications.getSpecification().isEmpty() ? null : specifications;
    }

    public Implementations getImplementations() {
        Implementations implementations = new Implementations();
        for (Module m : this.getModule()) {
            if (m.getImplementations() == null) continue;
            implementations.getImplementation().addAll(m.getImplementations().getImplementation());
        }
        return implementations.getImplementation().isEmpty() ? null : implementations;
    }

    public Module getModuleOfSpecification(String specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        for (Module m : this.getModule()) {
            if (m.getSpecifications() == null || m.getSpecifications().getSpecification(specification) == null) continue;
            return m;
        }
        return null;
    }

    public Module getModuleOfImplementation(String implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        for (Module m : this.getModule()) {
            if (m.getImplementations() == null || m.getImplementations().getImplementation(implementation) == null) continue;
            return m;
        }
        return null;
    }

    public Specification getSpecification(String specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        for (Module m : this.getModule()) {
            Specification s;
            if (m.getSpecifications() == null || (s = m.getSpecifications().getSpecification(specification)) == null) continue;
            return s;
        }
        return null;
    }

    public Specification getSpecification(Class specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        for (Module m : this.getModule()) {
            Specification s;
            if (m.getSpecifications() == null || (s = m.getSpecifications().getSpecification(specification)) == null) continue;
            return s;
        }
        return null;
    }

    public Specifications getSpecifications(String implementation) {
        Specifications declaredSpecifications;
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        Specifications specs = new Specifications();
        this.collectSpecifications(this.getImplementation(implementation), specs, new Implementations(), true);
        Implementation declaration = null;
        Implementation impl = this.getImplementation(implementation);
        if (impl != null && impl.getClazz() != null && !impl.getIdentifier().equals(impl.getClazz())) {
            block0: for (Module m : this.getModule()) {
                if (m.getImplementations() == null) continue;
                for (Implementation i : m.getImplementations().getImplementation()) {
                    if (i.getClazz() == null || !i.getClazz().equals(i.getIdentifier()) || !i.getClazz().equals(impl.getClazz())) continue;
                    declaration = i;
                    continue block0;
                }
            }
        }
        if (declaration != null && (declaredSpecifications = this.getSpecifications(declaration.getIdentifier())) != null) {
            for (SpecificationReference r : declaredSpecifications.getReference()) {
                if (specs.getReference(r.getIdentifier()) != null) continue;
                specs.getReference().add(r);
                Specification s = declaredSpecifications.getSpecification(r.getIdentifier());
                if (s == null) continue;
                specs.getSpecification().add(s);
            }
        }
        Collections.sort(specs.getSpecification(), new Comparator<Specification>(){

            @Override
            public int compare(Specification o1, Specification o2) {
                return o1.getIdentifier().compareTo(o2.getIdentifier());
            }
        });
        Collections.sort(specs.getReference(), new Comparator<SpecificationReference>(){

            @Override
            public int compare(SpecificationReference o1, SpecificationReference o2) {
                return o1.getIdentifier().compareTo(o2.getIdentifier());
            }
        });
        return specs.getSpecification().isEmpty() && specs.getReference().isEmpty() ? null : specs;
    }

    public Implementation getImplementation(String implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        for (Module m : this.getModule()) {
            Implementation i;
            if (m.getImplementations() == null || (i = m.getImplementations().getImplementation(implementation)) == null) continue;
            return i;
        }
        return null;
    }

    public Implementation getImplementation(Class implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        for (Module m : this.getModule()) {
            Implementation i;
            if (m.getImplementations() == null || (i = m.getImplementations().getImplementation(implementation)) == null) continue;
            return i;
        }
        return null;
    }

    public Implementation getImplementation(Object object) {
        return this.collectImplementation(object.getClass());
    }

    public Implementation getImplementation(String specification, String name) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        Implementations implementations = this.getImplementations(specification);
        if (implementations != null) {
            return implementations.getImplementationByName(name);
        }
        return null;
    }

    public Dependencies getDependencies(String implementation) {
        Dependencies declaredDependencies;
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        Dependencies dependencies = new Dependencies();
        this.collectDependencies(this.getImplementation(implementation), dependencies, new Implementations(), true);
        Implementation declaration = null;
        Implementation impl = this.getImplementation(implementation);
        if (impl != null && impl.getClazz() != null && !impl.getIdentifier().equals(impl.getClazz())) {
            block0: for (Module m : this.getModule()) {
                if (m.getImplementations() == null) continue;
                for (Implementation i : m.getImplementations().getImplementation()) {
                    if (i.getClazz() == null || !i.getClazz().equals(i.getIdentifier()) || !i.getClazz().equals(impl.getClazz())) continue;
                    declaration = i;
                    continue block0;
                }
            }
        }
        if (declaration != null && (declaredDependencies = this.getDependencies(declaration.getIdentifier())) != null) {
            for (Dependency d : declaredDependencies.getDependency()) {
                if (dependencies.getDependency(d.getName()) != null) continue;
                dependencies.getDependency().add(d);
            }
        }
        Collections.sort(dependencies.getDependency(), new Comparator<Dependency>(){

            @Override
            public int compare(Dependency o1, Dependency o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return dependencies.getDependency().isEmpty() ? null : dependencies;
    }

    public Properties getProperties(String implementation) {
        Properties specified;
        Properties declaredProperties;
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        Properties properties = new Properties();
        this.collectProperties(this.getImplementation(implementation), properties, new Implementations(), true);
        Implementation declaration = null;
        Implementation impl = this.getImplementation(implementation);
        if (impl != null && impl.getClazz() != null && !impl.getIdentifier().equals(impl.getClazz())) {
            block0: for (Module m : this.getModule()) {
                if (m.getImplementations() == null) continue;
                for (Implementation i : m.getImplementations().getImplementation()) {
                    if (i.getClazz() == null || !i.getClazz().equals(i.getIdentifier()) || !i.getClazz().equals(impl.getClazz())) continue;
                    declaration = i;
                    continue block0;
                }
            }
        }
        if (declaration != null && (declaredProperties = this.getProperties(declaration.getIdentifier())) != null) {
            for (Property p : declaredProperties.getProperty()) {
                if (properties.getProperty(p.getName()) != null) continue;
                properties.getProperty().add(p);
            }
        }
        if ((specified = this.getSpecifiedProperties(implementation)) != null) {
            for (Property p : specified.getProperty()) {
                if (properties.getProperty(p.getName()) != null) continue;
                properties.getProperty().add(p);
            }
        }
        Collections.sort(properties.getProperty(), new Comparator<Property>(){

            @Override
            public int compare(Property o1, Property o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return properties.getProperty().isEmpty() ? null : properties;
    }

    public Properties getSpecifiedProperties(String implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        Properties properties = new Properties();
        Specifications specs = this.getSpecifications(implementation);
        if (specs != null) {
            for (Specification s : specs.getSpecification()) {
                if (s.getProperties() == null) continue;
                properties.getProperty().addAll(s.getProperties().getProperty());
            }
        }
        Collections.sort(properties.getProperty(), new Comparator<Property>(){

            @Override
            public int compare(Property o1, Property o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return properties.getProperty().isEmpty() ? null : properties;
    }

    public Messages getMessages(String implementation) {
        Messages declaredMessages;
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        Messages msgs = new Messages();
        this.collectMessages(this.getImplementation(implementation), msgs, new Implementations(), true);
        Implementation declaration = null;
        Implementation impl = this.getImplementation(implementation);
        if (impl != null && impl.getClazz() != null && !impl.getIdentifier().equals(impl.getClazz())) {
            block0: for (Module m : this.getModule()) {
                if (m.getImplementations() == null) continue;
                for (Implementation i : m.getImplementations().getImplementation()) {
                    if (i.getClazz() == null || !i.getClazz().equals(i.getIdentifier()) || !i.getClazz().equals(impl.getClazz())) continue;
                    declaration = i;
                    continue block0;
                }
            }
        }
        if (declaration != null && (declaredMessages = this.getMessages(declaration.getIdentifier())) != null) {
            for (Message m : declaredMessages.getMessage()) {
                if (msgs.getMessage(m.getName()) != null) continue;
                msgs.getMessage().add(m);
            }
        }
        Collections.sort(msgs.getMessage(), new Comparator<Message>(){

            @Override
            public int compare(Message o1, Message o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return msgs.getMessage().isEmpty() ? null : msgs;
    }

    public Implementations getImplementations(String specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        Implementations implementations = new Implementations();
        for (Module m : this.getModule()) {
            if (m.getImplementations() == null) continue;
            for (Implementation i : m.getImplementations().getImplementation()) {
                Specifications specs = this.getSpecifications(i.getIdentifier());
                if (specs == null) continue;
                for (Specification s : specs.getSpecification()) {
                    if (!specification.equals(s.getIdentifier())) continue;
                    implementations.getImplementation().add(i);
                }
            }
        }
        return implementations.getImplementation().size() > 0 ? implementations : null;
    }

    public Module getMergedModule() {
        Modules copy = this.clone();
        Module mergedModule = new Module();
        for (Module m : copy.getModule()) {
            String propertyName;
            Iterator<ModelObject> it;
            HashSet<String> referencedMessages = new HashSet<String>();
            HashSet<String> referencedProperties = new HashSet<String>();
            if (m.getImplementations() != null) {
                for (Implementation i : m.getImplementations().getImplementation()) {
                    if (mergedModule.getImplementations() == null) {
                        mergedModule.setImplementations(new Implementations());
                    }
                    if (i.getMessages() != null && !i.getMessages().getReference().isEmpty()) {
                        it = i.getMessages().getReference().iterator();
                        while (it.hasNext()) {
                            String messageName = ((MessageReference)it.next()).getName();
                            i.getMessages().getMessage().add(m.getMessages().getMessage(messageName));
                            referencedMessages.add(messageName);
                            it.remove();
                        }
                    }
                    if (i.getProperties() != null && !i.getProperties().getReference().isEmpty()) {
                        it = i.getProperties().getReference().iterator();
                        while (it.hasNext()) {
                            propertyName = ((PropertyReference)it.next()).getName();
                            i.getProperties().getProperty().add(m.getProperties().getProperty(propertyName));
                            referencedProperties.add(propertyName);
                            it.remove();
                        }
                    }
                    mergedModule.getImplementations().getImplementation().add(i);
                }
            }
            if (m.getSpecifications() != null) {
                if (mergedModule.getSpecifications() == null) {
                    mergedModule.setSpecifications(new Specifications());
                }
                for (Specification s : m.getSpecifications().getSpecification()) {
                    if (s.getProperties() != null && !s.getProperties().getReference().isEmpty()) {
                        it = s.getProperties().getReference().iterator();
                        while (it.hasNext()) {
                            propertyName = ((PropertyReference)it.next()).getName();
                            s.getProperties().getProperty().add(m.getProperties().getProperty(propertyName));
                            referencedProperties.add(propertyName);
                            it.remove();
                        }
                    }
                    mergedModule.getSpecifications().getSpecification().add(s);
                }
            }
            block6: for (String messageName : referencedMessages) {
                it = m.getMessages().getMessage().iterator();
                while (it.hasNext()) {
                    if (!messageName.equals(it.next().getName())) continue;
                    it.remove();
                    continue block6;
                }
            }
            block8: for (String propertyName2 : referencedProperties) {
                it = m.getProperties().getProperty().iterator();
                while (it.hasNext()) {
                    if (!propertyName2.equals(((Property)it.next()).getName())) continue;
                    it.remove();
                    continue block8;
                }
            }
            if (m.getProperties() != null && !m.getProperties().getProperty().isEmpty()) {
                if (mergedModule.getProperties() == null) {
                    mergedModule.setProperties(new Properties());
                }
                mergedModule.getProperties().getProperty().addAll(m.getProperties().getProperty());
            }
            if (m.getMessages() == null || m.getMessages().getMessage().isEmpty()) continue;
            if (mergedModule.getMessages() == null) {
                mergedModule.setMessages(new Messages());
            }
            mergedModule.getMessages().getMessage().addAll(m.getMessages().getMessage());
        }
        return mergedModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Instance getInstance(Object object) {
        if (object == null) {
            throw new NullPointerException("object");
        }
        Map<Object, Instance> map = this.objects;
        synchronized (map) {
            Implementation i;
            Instance instance = this.objects.get(object);
            if (instance == null && (i = this.getImplementation(object)) != null && (instance = this.getInstance(i.getIdentifier())) != null) {
                this.objects.put(object, instance);
            }
            return instance;
        }
    }

    public Instance getInstance(String implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        Implementation i = this.getImplementation(implementation);
        if (i != null && i.getClazz() != null) {
            Instance instance = new Instance();
            instance.setIdentifier(i.getIdentifier());
            instance.setName(i.getName());
            instance.setClazz(i.getClazz());
            instance.setStateless(i.isStateless());
            instance.setDependencies(this.getDependencies(implementation));
            instance.setProperties(this.getProperties(implementation));
            instance.setMessages(this.getMessages(implementation));
            instance.setSpecifications(this.getSpecifications(implementation));
            this.collectAny(i, instance.getAny(), new Implementations(), true);
            return instance;
        }
        return null;
    }

    public Instance getInstance(String implementation, Dependency dependency) {
        Specification dependencySpecification;
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (dependency == null) {
            throw new NullPointerException("dependency");
        }
        Instance instance = this.getInstance(implementation);
        if (instance != null && (dependencySpecification = this.getSpecification(dependency.getIdentifier())) != null && dependencySpecification.getScope() == null && dependency.getProperties() != null && !dependency.getProperties().getProperty().isEmpty()) {
            instance = new Instance(instance);
            Properties properties = new Properties();
            properties.getProperty().addAll(dependency.getProperties().getProperty());
            if (instance.getProperties() != null) {
                for (Property p : instance.getProperties().getProperty()) {
                    if (properties.getProperty(p.getName()) != null) continue;
                    properties.getProperty().add(p);
                }
            }
            instance.setProperties(properties);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createObject(Instance instance, ClassLoader classLoader) throws InstantiationException {
        if (instance == null) {
            throw new NullPointerException("instance");
        }
        Object object = null;
        try {
            Class<?> clazz = Class.forName(instance.getClazz(), true, classLoader);
            if (Modifier.isPublic(clazz.getModifiers())) {
                Constructor<?> ctor = null;
                if (!Modifier.isAbstract(clazz.getModifiers())) {
                    try {
                        ctor = clazz.getConstructor(NO_CLASSES);
                    }
                    catch (NoSuchMethodException e) {
                        ctor = null;
                    }
                }
                boolean assignable = true;
                if (instance.getSpecifications() != null) {
                    for (Specification s : instance.getSpecifications().getSpecification()) {
                        Class<?> specClass;
                        if (s.getClazz() == null || (specClass = Class.forName(s.getClazz(), true, classLoader)).isAssignableFrom(clazz)) continue;
                        assignable = false;
                        break;
                    }
                }
                if (ctor != null && assignable) {
                    Map<Object, Instance> i$ = this.objects;
                    synchronized (i$) {
                        object = clazz.newInstance();
                        this.objects.put(object, instance);
                    }
                }
                Method factoryMethod = null;
                String methodName = null;
                char[] c = instance.getName().toCharArray();
                c[0] = Character.toUpperCase(c[0]);
                methodName = "get" + String.valueOf(c);
                boolean javaIdentifier = Character.isJavaIdentifierStart(c[0]);
                if (javaIdentifier) {
                    for (int idx = c.length - 1; idx > 0; --idx) {
                        if (Character.isJavaIdentifierPart(c[idx])) continue;
                        javaIdentifier = false;
                        break;
                    }
                }
                if (javaIdentifier) {
                    try {
                        factoryMethod = clazz.getMethod(methodName, null);
                    }
                    catch (NoSuchMethodException e) {
                        factoryMethod = null;
                    }
                }
                if (factoryMethod == null) {
                    try {
                        factoryMethod = clazz.getMethod("getObject", null);
                    }
                    catch (NoSuchMethodException e) {
                        factoryMethod = null;
                    }
                }
                if (factoryMethod == null) {
                    throw new InstantiationException(Modules.getMessage("failedCreatingObject", instance.getIdentifier(), clazz.getName(), methodName));
                }
                if (Modifier.isStatic(factoryMethod.getModifiers())) {
                    Map<Object, Instance> map = this.objects;
                    synchronized (map) {
                        object = factoryMethod.invoke(null, (Object[])null);
                        if (object != null) {
                            this.objects.put(object, instance);
                        }
                    }
                } else if (ctor != null) {
                    Map<Object, Instance> map = this.objects;
                    synchronized (map) {
                        Object o = ctor.newInstance(new Object[0]);
                        this.objects.put(o, instance);
                        object = factoryMethod.invoke(o, (Object[])null);
                        this.objects.remove(o);
                        if (object != null) {
                            this.objects.put(object, instance);
                        }
                    }
                } else {
                    throw new InstantiationException(Modules.getMessage("failedCreatingObject", instance.getIdentifier(), clazz.getName(), methodName));
                }
            }
            return object;
        }
        catch (InvocationTargetException e) {
            throw (InstantiationException)new InstantiationException().initCause(e.getTargetException() != null ? e.getTargetException() : e);
        }
        catch (IllegalAccessException e) {
            throw (InstantiationException)new InstantiationException(e.getMessage()).initCause(e);
        }
        catch (ClassNotFoundException e) {
            throw (InstantiationException)new InstantiationException(e.getMessage()).initCause(e);
        }
    }

    void collectSpecifications(Implementation implementation, Specifications specifications, Implementations seen, boolean includeDeclared) {
        if (implementation != null && seen.getImplementation(implementation.getIdentifier()) == null) {
            seen.getImplementation().add(implementation);
            if (includeDeclared && implementation.getSpecifications() != null) {
                for (SpecificationReference specificationReference : implementation.getSpecifications().getReference()) {
                    if (specifications.getReference(specificationReference.getIdentifier()) != null) continue;
                    specifications.getReference().add(specificationReference);
                    Specification s = this.getSpecification(specificationReference.getIdentifier());
                    if (s == null || specifications.getSpecification(s.getIdentifier()) != null) continue;
                    specifications.getSpecification().add(s);
                }
            }
            if (implementation.getImplementations() != null) {
                for (ImplementationReference implementationReference : implementation.getImplementations().getReference()) {
                    this.collectSpecifications(this.getImplementation(implementationReference.getIdentifier()), specifications, seen, true);
                }
            }
        }
    }

    void collectDependencies(Implementation implementation, Dependencies dependencies, Implementations seen, boolean includeDeclared) {
        if (implementation != null && seen.getImplementation(implementation.getIdentifier()) == null) {
            seen.getImplementation().add(implementation);
            if (includeDeclared && implementation.getDependencies() != null) {
                for (Dependency d : implementation.getDependencies().getDependency()) {
                    Dependency dependency = dependencies.getDependency(d.getName());
                    if (dependency != null) {
                        if (d.getProperties() == null) continue;
                        if (dependency.getProperties() == null) {
                            dependency.setProperties(new Properties());
                        }
                        for (Property p : d.getProperties().getProperty()) {
                            if (dependency.getProperties().getProperty(p.getName()) != null) continue;
                            dependency.getProperties().getProperty().add(p);
                        }
                        continue;
                    }
                    dependencies.getDependency().add(d);
                }
            }
            if (implementation.getImplementations() != null) {
                for (ImplementationReference r : implementation.getImplementations().getReference()) {
                    this.collectDependencies(this.getImplementation(r.getIdentifier()), dependencies, seen, true);
                }
            }
        }
    }

    void collectProperties(Implementation implementation, Properties properties, Implementations seen, boolean includeDeclared) {
        if (implementation != null && seen.getImplementation(implementation.getIdentifier()) == null) {
            seen.getImplementation().add(implementation);
            if (includeDeclared && implementation.getProperties() != null) {
                Module m;
                for (Property p : implementation.getProperties().getProperty()) {
                    if (properties.getProperty(p.getName()) != null) continue;
                    properties.getProperty().add(p);
                }
                if (!implementation.getProperties().getReference().isEmpty() && (m = this.getModuleOfImplementation(implementation.getIdentifier())) != null) {
                    for (PropertyReference ref : implementation.getProperties().getReference()) {
                        Property referenced;
                        if (properties.getProperty(ref.getName()) != null || (referenced = m.getProperties().getProperty(ref.getName())) == null) continue;
                        referenced = new Property(referenced);
                        referenced.setDeprecated(ref.isDeprecated());
                        referenced.setFinal(ref.isFinal());
                        referenced.setOverride(ref.isOverride());
                        properties.getProperty().add(referenced);
                    }
                }
            }
            if (implementation.getImplementations() != null) {
                for (ImplementationReference r : implementation.getImplementations().getReference()) {
                    this.collectProperties(this.getImplementation(r.getIdentifier()), properties, seen, true);
                }
            }
        }
    }

    void collectMessages(Implementation implementation, Messages messages, Implementations seen, boolean includeDeclared) {
        if (implementation != null && seen.getImplementation(implementation.getIdentifier()) == null) {
            seen.getImplementation().add(implementation);
            if (includeDeclared && implementation.getMessages() != null) {
                Module m;
                for (Message msg : implementation.getMessages().getMessage()) {
                    if (messages.getMessage(msg.getName()) != null) continue;
                    messages.getMessage().add(msg);
                }
                if (!implementation.getMessages().getReference().isEmpty() && (m = this.getModuleOfImplementation(implementation.getIdentifier())) != null) {
                    for (MessageReference ref : implementation.getMessages().getReference()) {
                        Message referenced;
                        if (messages.getMessage(ref.getName()) != null || (referenced = m.getMessages().getMessage(ref.getName())) == null) continue;
                        referenced = new Message(referenced);
                        referenced.setDeprecated(ref.isDeprecated());
                        referenced.setFinal(ref.isFinal());
                        referenced.setOverride(ref.isOverride());
                        messages.getMessage().add(referenced);
                    }
                }
            }
            if (implementation.getImplementations() != null) {
                for (ImplementationReference r : implementation.getImplementations().getReference()) {
                    this.collectMessages(this.getImplementation(r.getIdentifier()), messages, seen, true);
                }
            }
        }
    }

    void collectAny(Implementation implementation, List<Object> any, Implementations seen, boolean includeDeclared) {
        if (implementation != null && seen.getImplementation(implementation.getIdentifier()) == null) {
            seen.getImplementation().add(implementation);
            if (includeDeclared && !implementation.getAny().isEmpty()) {
                for (Object o : implementation.getAny()) {
                    if (o instanceof Element) {
                        if (this.getElement(any, (Element)o) != null) continue;
                        any.add(o);
                        continue;
                    }
                    if (o instanceof JAXBElement) {
                        if (this.getElement(any, (JAXBElement)o) != null) continue;
                        any.add(o);
                        continue;
                    }
                    any.add(o);
                }
            }
            if (implementation.getImplementations() != null) {
                for (ImplementationReference r : implementation.getImplementations().getReference()) {
                    this.collectAny(this.getImplementation(r.getIdentifier()), any, seen, true);
                }
            }
        }
    }

    private Implementation collectImplementation(Class clazz) {
        Implementation i = this.getImplementation(clazz);
        if (i == null && clazz.getSuperclass() != null) {
            i = this.collectImplementation(clazz.getSuperclass());
        }
        return i;
    }

    private Element getElement(List<Object> list, Element e) {
        for (Object o : list) {
            if (!(o instanceof Element)) continue;
            Element current = (Element)o;
            if (!(e.getNamespaceURI() == null ? current.getNamespaceURI() == null : e.getNamespaceURI().equals(current.getNamespaceURI())) || !(e.getLocalName() == null ? current.getLocalName() == null : e.getLocalName().equals(current.getLocalName()))) continue;
            return current;
        }
        return null;
    }

    private JAXBElement getElement(List<Object> list, JAXBElement e) {
        for (Object o : list) {
            if (!(o instanceof JAXBElement)) continue;
            JAXBElement current = (JAXBElement)o;
            if (!e.getName().equals(current.getName())) continue;
            return current;
        }
        return null;
    }

    private void resolveClasspath(Module cpModule, ClassLoader classLoader) {
        for (Module m : this.getModule()) {
            if (m.getSpecifications() != null) {
                this.resolveClasspath(m.getSpecifications(), cpModule, classLoader);
            }
            if (m.getImplementations() == null) continue;
            this.resolveClasspath(m.getImplementations(), cpModule, classLoader);
        }
    }

    private void resolveClasspath(SpecificationReference ref, Module cpModule, ClassLoader classLoader) {
        if (this.getSpecification(ref.getIdentifier()) == null) {
            this.resolveClasspath(ref.getIdentifier(), cpModule, classLoader);
        }
    }

    private void resolveClasspath(Specifications references, Module cpModule, ClassLoader classLoader) {
        for (SpecificationReference ref : references.getReference()) {
            this.resolveClasspath(ref, cpModule, classLoader);
        }
    }

    private void resolveClasspath(Implementations implementations, Module cpModule, ClassLoader classLoader) {
        for (Implementation implementation : implementations.getImplementation()) {
            if (implementation.getSpecifications() != null) {
                this.resolveClasspath(implementation.getSpecifications(), cpModule, classLoader);
            }
            if (implementation.getDependencies() == null) continue;
            this.resolveClasspath(implementation.getDependencies(), cpModule, classLoader);
        }
    }

    private void resolveClasspath(Dependencies dependencies, Module cpModule, ClassLoader classLoader) {
        for (Dependency dependency : dependencies.getDependency()) {
            this.resolveClasspath(dependency, cpModule, classLoader);
        }
    }

    private boolean resolveClasspath(String identifier, Module cpModule, ClassLoader classLoader) {
        Specification specification;
        boolean classpathSpecification = false;
        Specification specification2 = specification = cpModule.getSpecifications() == null ? null : cpModule.getSpecifications().getSpecification(identifier);
        if (specification == null) {
            try {
                Class<?> classpathSpec = Class.forName(identifier, true, classLoader);
                if (Modifier.isPublic(classpathSpec.getModifiers())) {
                    classpathSpecification = true;
                    String vendor = null;
                    String version = null;
                    if (classpathSpec.getPackage() != null) {
                        vendor = classpathSpec.getPackage().getSpecificationVendor();
                        version = classpathSpec.getPackage().getSpecificationVersion();
                    }
                    specification = new Specification();
                    specification.setIdentifier(identifier);
                    specification.setClazz(classpathSpec.getName());
                    specification.setMultiplicity(Multiplicity.MANY);
                    specification.setVendor(vendor);
                    specification.setVersion(version);
                    if (cpModule.getSpecifications() == null) {
                        cpModule.setSpecifications(new Specifications());
                    }
                    cpModule.getSpecifications().getSpecification().add(specification);
                    this.resolveClasspath(specification, cpModule, classLoader);
                }
            }
            catch (ClassNotFoundException e) {
                classpathSpecification = false;
            }
        }
        return classpathSpecification;
    }

    private boolean resolveClasspath(Specification specification, Module cpModule, ClassLoader classLoader) {
        boolean classpathImplementation;
        block15: {
            Implementation implementation;
            classpathImplementation = false;
            Implementation implementation2 = implementation = cpModule.getImplementations() == null ? null : cpModule.getImplementations().getImplementation(specification.getIdentifier());
            if (implementation == null) {
                String name = null;
                try {
                    Class<?> classpathImpl = Class.forName(specification.getClazz(), true, classLoader);
                    if (!Modifier.isPublic(classpathImpl.getModifiers())) break block15;
                    if (!Modifier.isAbstract(classpathImpl.getModifiers())) {
                        try {
                            classpathImpl.getConstructor(NO_CLASSES);
                            name = "init";
                            classpathImplementation = true;
                        }
                        catch (NoSuchMethodException e) {
                            classpathImplementation = false;
                        }
                    }
                    if (!classpathImplementation) {
                        char[] c = classpathImpl.getName().substring(classpathImpl.getPackage().getName().length() + 1).toCharArray();
                        name = String.valueOf(c);
                        c[0] = Character.toUpperCase(c[0]);
                        if (this.checkFactoryMethod(classpathImpl, classpathImpl, "getDefault")) {
                            name = "default";
                            classpathImplementation = true;
                        } else if (this.checkFactoryMethod(classpathImpl, classpathImpl, "getInstance")) {
                            name = "instance";
                            classpathImplementation = true;
                        } else if (this.checkFactoryMethod(classpathImpl, classpathImpl, "get" + String.valueOf(c))) {
                            classpathImplementation = true;
                        }
                    }
                    if (classpathImplementation) {
                        String vendor = null;
                        String version = null;
                        if (classpathImpl.getPackage() != null) {
                            vendor = classpathImpl.getPackage().getImplementationVendor();
                            version = classpathImpl.getPackage().getImplementationVersion();
                        }
                        implementation = new Implementation();
                        implementation.setVendor(vendor);
                        implementation.setFinal(true);
                        implementation.setName(name);
                        implementation.setIdentifier(specification.getIdentifier());
                        implementation.setClazz(classpathImpl.getName());
                        implementation.setVersion(version);
                        Specifications implemented = new Specifications();
                        SpecificationReference ref = new SpecificationReference();
                        ref.setIdentifier(specification.getIdentifier());
                        ref.setVersion(specification.getVersion());
                        implemented.getReference().add(ref);
                        implementation.setSpecifications(implemented);
                        if (cpModule.getImplementations() == null) {
                            cpModule.setImplementations(new Implementations());
                        }
                        cpModule.getImplementations().getImplementation().add(implementation);
                    }
                }
                catch (ClassNotFoundException e) {
                    classpathImplementation = false;
                }
            }
        }
        return classpathImplementation;
    }

    private boolean checkFactoryMethod(Class clazz, Class type, String methodName) {
        boolean factoryMethod = false;
        try {
            Method m = clazz.getMethod(methodName, null);
            factoryMethod = Modifier.isStatic(m.getModifiers()) && type.isAssignableFrom(m.getReturnType());
        }
        catch (NoSuchMethodException e) {
            factoryMethod = false;
        }
        return factoryMethod;
    }

    private static String getMessage(String key, Object ... args) {
        return MessageFormat.format(ResourceBundle.getBundle(Modules.class.getName().replace('.', '/'), Locale.getDefault()).getString(key), args);
    }

    static {
        NO_CLASSES = new Class[0];
    }
}

