/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.jomc.model.ModelException;
import org.jomc.model.ModelObject;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Property", propOrder={"any"})
public class Property
extends ModelObject
implements Cloneable {
    @XmlAnyElement(lax=true)
    protected Object any;
    @XmlAttribute(required=true)
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String name;
    @XmlAttribute
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    protected String type;
    @XmlAttribute
    protected String value;
    @XmlAttribute(name="final")
    protected Boolean _final;
    @XmlAttribute
    protected Boolean override;

    public Property() {
    }

    public Property(Property o) {
        super(o);
        if (o == null) {
            throw new NullPointerException("Cannot create a copy of 'Property' from 'null'.");
        }
        this.any = Property.copyAny(o.getAny());
        this.name = o.getName();
        this.type = o.getType();
        this.value = o.getValue();
        this._final = o.isFinal();
        this.override = o.isOverride();
    }

    public Object getAny() {
        return this.any;
    }

    public void setAny(Object value) {
        this.any = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        this.type = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isFinal() {
        if (this._final == null) {
            return false;
        }
        return this._final;
    }

    public void setFinal(Boolean value) {
        this._final = value;
    }

    public boolean isOverride() {
        if (this.override == null) {
            return false;
        }
        return this.override;
    }

    public void setOverride(Boolean value) {
        this.override = value;
    }

    private static Object copyAny(Object source) {
        if (source != null) {
            if (source instanceof Element) {
                return (Element)((Element)source).cloneNode(true);
            }
            if (source instanceof Object) {
                return Property.copyOfObject(source);
            }
            throw new AssertionError((Object)("Unexpected instance '" + source + "' for property 'Any' of class 'org.jomc.model.Property'."));
        }
        return null;
    }

    private static Object copyOfObject(Object o) {
        if (o != null) {
            if (o.getClass().isPrimitive()) {
                return o;
            }
            if (o.getClass().isArray()) {
                return Property.copyOfArray(o);
            }
            if (o instanceof Boolean) {
                return o;
            }
            if (o instanceof Byte) {
                return o;
            }
            if (o instanceof Character) {
                return o;
            }
            if (o instanceof Double) {
                return o;
            }
            if (o instanceof Enum) {
                return o;
            }
            if (o instanceof Float) {
                return o;
            }
            if (o instanceof Integer) {
                return o;
            }
            if (o instanceof Long) {
                return o;
            }
            if (o instanceof Short) {
                return o;
            }
            if (o instanceof String) {
                return o;
            }
            if (o instanceof BigDecimal) {
                return o;
            }
            if (o instanceof BigInteger) {
                return o;
            }
            if (o instanceof UUID) {
                return o;
            }
            if (o instanceof QName) {
                return o;
            }
            if (o instanceof Duration) {
                return o;
            }
            if (o instanceof Currency) {
                return o;
            }
            if (o instanceof XMLGregorianCalendar) {
                return ((XMLGregorianCalendar)o).clone();
            }
            if (o instanceof Date) {
                return ((Date)o).clone();
            }
            if (o instanceof Calendar) {
                return ((Calendar)o).clone();
            }
            if (o instanceof TimeZone) {
                return ((TimeZone)o).clone();
            }
            if (o instanceof Locale) {
                return ((Locale)o).clone();
            }
            if (o instanceof Element) {
                return (Element)((Element)o).cloneNode(true);
            }
            if (o instanceof JAXBElement) {
                return Property.copyOFJAXBElement((JAXBElement)o);
            }
            try {
                return o.getClass().getMethod("clone", null).invoke(o, (Object[])null);
            }
            catch (NoSuchMethodException e) {
                if (o instanceof Serializable) {
                    return Property.copyOfSerializable((Serializable)o);
                }
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Unexpected instance during copying object '" + o + "'.")))).initCause(e));
            }
            catch (IllegalAccessException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Unexpected instance during copying object '" + o + "'.")))).initCause(e));
            }
            catch (InvocationTargetException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Unexpected instance during copying object '" + o + "'.")))).initCause(e));
            }
            catch (SecurityException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Unexpected instance during copying object '" + o + "'.")))).initCause(e));
            }
            catch (IllegalArgumentException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Unexpected instance during copying object '" + o + "'.")))).initCause(e));
            }
            catch (ExceptionInInitializerError e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Unexpected instance during copying object '" + o + "'.")))).initCause(e));
            }
        }
        return null;
    }

    private static Object copyOfArray(Object array) {
        if (array != null) {
            if (array.getClass() == boolean[].class) {
                return Property.copyOf((boolean[])array);
            }
            if (array.getClass() == byte[].class) {
                return Property.copyOf((byte[])array);
            }
            if (array.getClass() == char[].class) {
                return Property.copyOf((char[])array);
            }
            if (array.getClass() == double[].class) {
                return Property.copyOf((double[])array);
            }
            if (array.getClass() == float[].class) {
                return Property.copyOf((float[])array);
            }
            if (array.getClass() == int[].class) {
                return Property.copyOf((int[])array);
            }
            if (array.getClass() == long[].class) {
                return Property.copyOf((long[])array);
            }
            if (array.getClass() == short[].class) {
                return Property.copyOf((short[])array);
            }
            int len = Array.getLength(array);
            Object copy = Array.newInstance(array.getClass().getComponentType(), len);
            for (int i = len - 1; i >= 0; --i) {
                Array.set(copy, i, Property.copyOfObject(Array.get(array, i)));
            }
            return copy;
        }
        return null;
    }

    private static boolean[] copyOf(boolean[] array) {
        if (array != null) {
            boolean[] copy = (boolean[])Array.newInstance(array.getClass().getComponentType(), array.length);
            System.arraycopy(array, 0, copy, 0, array.length);
            return copy;
        }
        return null;
    }

    private static byte[] copyOf(byte[] array) {
        if (array != null) {
            byte[] copy = (byte[])Array.newInstance(array.getClass().getComponentType(), array.length);
            System.arraycopy(array, 0, copy, 0, array.length);
            return copy;
        }
        return null;
    }

    private static char[] copyOf(char[] array) {
        if (array != null) {
            char[] copy = (char[])Array.newInstance(array.getClass().getComponentType(), array.length);
            System.arraycopy(array, 0, copy, 0, array.length);
            return copy;
        }
        return null;
    }

    private static double[] copyOf(double[] array) {
        if (array != null) {
            double[] copy = (double[])Array.newInstance(array.getClass().getComponentType(), array.length);
            System.arraycopy(array, 0, copy, 0, array.length);
            return copy;
        }
        return null;
    }

    private static float[] copyOf(float[] array) {
        if (array != null) {
            float[] copy = (float[])Array.newInstance(array.getClass().getComponentType(), array.length);
            System.arraycopy(array, 0, copy, 0, array.length);
            return copy;
        }
        return null;
    }

    private static int[] copyOf(int[] array) {
        if (array != null) {
            int[] copy = (int[])Array.newInstance(array.getClass().getComponentType(), array.length);
            System.arraycopy(array, 0, copy, 0, array.length);
            return copy;
        }
        return null;
    }

    private static long[] copyOf(long[] array) {
        if (array != null) {
            long[] copy = (long[])Array.newInstance(array.getClass().getComponentType(), array.length);
            System.arraycopy(array, 0, copy, 0, array.length);
            return copy;
        }
        return null;
    }

    private static short[] copyOf(short[] array) {
        if (array != null) {
            short[] copy = (short[])Array.newInstance(array.getClass().getComponentType(), array.length);
            System.arraycopy(array, 0, copy, 0, array.length);
            return copy;
        }
        return null;
    }

    private static JAXBElement copyOFJAXBElement(JAXBElement element) {
        if (element != null) {
            JAXBElement copy = new JAXBElement(element.getName(), element.getDeclaredType(), element.getScope(), element.getValue());
            copy.setNil(element.isNil());
            copy.setValue(Property.copyOfObject(copy.getValue()));
            return copy;
        }
        return null;
    }

    private static Serializable copyOfSerializable(Serializable serializable) {
        if (serializable != null) {
            try {
                ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(byteArrayOutput);
                out.writeObject(serializable);
                out.close();
                ByteArrayInputStream byteArrayInput = new ByteArrayInputStream(byteArrayOutput.toByteArray());
                ObjectInputStream in = new ObjectInputStream(byteArrayInput);
                Serializable copy = (Serializable)in.readObject();
                in.close();
                return copy;
            }
            catch (SecurityException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Unexpected instance during copying object '" + serializable + "'.")))).initCause(e));
            }
            catch (ClassNotFoundException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Unexpected instance during copying object '" + serializable + "'.")))).initCause(e));
            }
            catch (InvalidClassException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Unexpected instance during copying object '" + serializable + "'.")))).initCause(e));
            }
            catch (NotSerializableException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Unexpected instance during copying object '" + serializable + "'.")))).initCause(e));
            }
            catch (StreamCorruptedException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Unexpected instance during copying object '" + serializable + "'.")))).initCause(e));
            }
            catch (OptionalDataException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Unexpected instance during copying object '" + serializable + "'.")))).initCause(e));
            }
            catch (IOException e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("Unexpected instance during copying object '" + serializable + "'.")))).initCause(e));
            }
        }
        return null;
    }

    public Property clone() {
        return new Property(this);
    }

    public Object getJavaValue(ClassLoader classLoader) throws ModelException {
        try {
            if (this.getAny() != null) {
                if (this.getType() == null) {
                    throw new ModelException(Property.getMessage("mandatoryType", this.getName()));
                }
                String typeName = this.getType();
                int idx = typeName.indexOf("<");
                if (idx != -1) {
                    typeName = typeName.substring(0, idx);
                }
                Class<?> javaType = Class.forName(typeName, true, classLoader);
                Object anyObject = this.getAny() instanceof JAXBElement ? ((JAXBElement)this.getAny()).getValue() : this.getAny();
                return this.getJavaValue(classLoader, anyObject, javaType);
            }
            Class javaType = String.class;
            boolean primitive = false;
            if (this.getType() != null) {
                if (Boolean.TYPE.getName().equals(this.getType())) {
                    javaType = Boolean.class;
                    primitive = true;
                } else if (Byte.TYPE.getName().equals(this.getType())) {
                    javaType = Byte.class;
                    primitive = true;
                } else if (Character.TYPE.getName().equals(this.getType())) {
                    javaType = Character.class;
                    primitive = true;
                } else if (Double.TYPE.getName().equals(this.getType())) {
                    javaType = Double.class;
                    primitive = true;
                } else if (Float.TYPE.getName().equals(this.getType())) {
                    javaType = Float.class;
                    primitive = true;
                } else if (Integer.TYPE.getName().equals(this.getType())) {
                    javaType = Integer.class;
                    primitive = true;
                } else if (Long.TYPE.getName().equals(this.getType())) {
                    javaType = Long.class;
                    primitive = true;
                } else if (Short.TYPE.getName().equals(this.getType())) {
                    javaType = Short.class;
                    primitive = true;
                } else {
                    String typeName = this.getType();
                    int idx = typeName.indexOf("<");
                    if (idx != -1) {
                        typeName = typeName.substring(0, idx);
                    }
                    javaType = Class.forName(typeName, true, classLoader);
                }
            }
            if (this.getValue() == null && primitive) {
                throw new ModelException(Property.getMessage("mandatoryPrimitiveValue", this.getName(), this.getType()));
            }
            return this.getJavaValue(javaType, this.getValue());
        }
        catch (ClassNotFoundException e) {
            throw new ModelException(Property.getMessage("classNotFound", this.getName(), this.getType()), e);
        }
    }

    private Object getJavaValue(ClassLoader classLoader, Object any, Class returnType) throws ModelException {
        if (any != null) {
            String methodName = "getJavaValue";
            try {
                Method m = any.getClass().getMethod("getJavaValue", ClassLoader.class);
                Object result = m.invoke(any, classLoader);
                if (result != null && !returnType.isAssignableFrom(result.getClass())) {
                    throw new ModelException(Property.getMessage("illegalMethodInvocationResult", "getJavaValue", any.getClass().getName(), result.getClass().getName(), returnType.getName()));
                }
                return result;
            }
            catch (IllegalAccessException e) {
                throw new ModelException(Property.getMessage("methodAccessDenied", "getJavaValue", any.getClass().getName()), e);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw new ModelException(Property.getMessage("methodInvocationFailure", "getJavaValue", any.getClass().getName()), e);
            }
            catch (SecurityException e) {
                throw new ModelException(Property.getMessage("methodAccessDenied", "getJavaValue", any.getClass().getName()), e);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return any;
    }

    private Object getJavaValue(Class type, String value) throws ModelException {
        if (value != null) {
            try {
                if (type == Character.class) {
                    if (value.length() != 1) {
                        throw new ModelException(Property.getMessage("illegalValue", value, Character.class.getName()));
                    }
                    return type.getConstructor(Character.TYPE).newInstance(Character.valueOf(value.charAt(0)));
                }
                if (type == String.class) {
                    return value;
                }
                return type.getConstructor(String.class).newInstance(value);
            }
            catch (InstantiationException e) {
                throw new ModelException(Property.getMessage("instantiationException", type.getName()), e);
            }
            catch (IllegalAccessException e) {
                throw new ModelException(Property.getMessage("constructorAccessDenied", type.getName()), e);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw new ModelException(Property.getMessage("constructorInvocationFailure", type.getName()), e);
            }
            catch (NoSuchMethodException e) {
                throw new ModelException(Property.getMessage("constructorNotFound", type.getName()), e);
            }
        }
        return value;
    }

    private static String getMessage(String key, Object ... arguments) {
        return MessageFormat.format(ResourceBundle.getBundle(Property.class.getName().replace('.', '/'), Locale.getDefault()).getString(key), arguments);
    }
}

