/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.jomc.model.ModelObject;
import org.jomc.model.Specification;
import org.jomc.model.SpecificationReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Specifications", propOrder={"specification", "reference"})
public class Specifications
extends ModelObject
implements Cloneable {
    protected List<Specification> specification;
    protected List<SpecificationReference> reference;

    public Specifications() {
    }

    public Specifications(Specifications o) {
        super(o);
        if (o == null) {
            throw new NullPointerException("Cannot create a copy of 'Specifications' from 'null'.");
        }
        Specifications.copySpecification(o.getSpecification(), this.getSpecification());
        Specifications.copyReference(o.getReference(), this.getReference());
    }

    public List<Specification> getSpecification() {
        if (this.specification == null) {
            this.specification = new ArrayList<Specification>();
        }
        return this.specification;
    }

    public List<SpecificationReference> getReference() {
        if (this.reference == null) {
            this.reference = new ArrayList<SpecificationReference>();
        }
        return this.reference;
    }

    private static void copySpecification(List<Specification> source, List<Specification> target) {
        if (!source.isEmpty()) {
            for (Specification next : source) {
                if (next instanceof Specification) {
                    target.add(next.clone());
                    continue;
                }
                throw new AssertionError((Object)("Unexpected instance '" + next + "' for property 'Specification' of class 'org.jomc.model.Specifications'."));
            }
        }
    }

    private static void copyReference(List<SpecificationReference> source, List<SpecificationReference> target) {
        if (!source.isEmpty()) {
            for (SpecificationReference next : source) {
                if (next instanceof SpecificationReference) {
                    target.add(next.clone());
                    continue;
                }
                throw new AssertionError((Object)("Unexpected instance '" + next + "' for property 'Reference' of class 'org.jomc.model.Specifications'."));
            }
        }
    }

    @Override
    public Specifications clone() {
        return new Specifications(this);
    }

    public Specification getSpecification(String specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        for (Specification s : this.getSpecification()) {
            if (!specification.equals(s.getIdentifier())) continue;
            return s;
        }
        return null;
    }

    public Specification getSpecification(Class specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        for (Specification s : this.getSpecification()) {
            if (!s.isClassDeclaration() || !specification.getName().equals(s.getClazz())) continue;
            return s;
        }
        return null;
    }

    public SpecificationReference getReference(String specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        for (SpecificationReference r : this.getReference()) {
            if (!specification.equals(r.getIdentifier())) continue;
            return r;
        }
        return null;
    }
}

