/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.model.bootstrap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.jomc.model.bootstrap.BootstrapException;
import org.jomc.model.bootstrap.DefaultBootstrapContext;
import org.jomc.model.bootstrap.ObjectFactory;
import org.jomc.model.bootstrap.SchemaProvider;
import org.jomc.model.bootstrap.Schemas;
import org.jomc.model.bootstrap.ServiceProvider;
import org.jomc.model.bootstrap.Services;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BootstrapContext {
    private static volatile String bootstrapContextClassName;
    private ClassLoader classLoader;

    public BootstrapContext(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = new ClassLoader(null){

                public String toString() {
                    return BootstrapContext.class.getName() + ".BootstrapClassLoader@" + System.identityHashCode(this);
                }
            };
        }
        return this.classLoader;
    }

    public static String getBootstrapContextClassName() {
        if (bootstrapContextClassName == null) {
            bootstrapContextClassName = System.getProperty("org.jomc.model.bootstrap.BootstrapContext.className", DefaultBootstrapContext.class.getName());
        }
        return bootstrapContextClassName;
    }

    public static void setBootstrapContextClassName(String value) {
        bootstrapContextClassName = value;
    }

    public Class findClass(String name) throws BootstrapException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            return Class.forName(name, true, this.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public URL findResource(String name) throws BootstrapException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        return this.getClassLoader().getResource(name);
    }

    public Enumeration<URL> findResources(String name) throws BootstrapException {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            return this.getClassLoader().getResources(name);
        }
        catch (IOException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
    }

    public Schemas findSchemas() throws BootstrapException {
        try {
            Schemas schemas = new Schemas();
            Collection<Class<SchemaProvider>> providers = this.loadProviders(SchemaProvider.class);
            for (Class<SchemaProvider> provider : providers) {
                SchemaProvider schemaProvider = provider.newInstance();
                Schemas provided = schemaProvider.findSchemas(this);
                if (provided == null) continue;
                schemas.getSchema().addAll(provided.getSchema());
            }
            Schema bootstrapSchema = this.createSchema();
            Validator validator = bootstrapSchema.newValidator();
            validator.validate((Source)new JAXBSource(this.createContext(), new ObjectFactory().createSchemas(schemas)));
            return schemas;
        }
        catch (InstantiationException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
    }

    public Services findServices() throws BootstrapException {
        try {
            Services services = new Services();
            Collection<Class<ServiceProvider>> providers = this.loadProviders(ServiceProvider.class);
            for (Class<ServiceProvider> provider : providers) {
                ServiceProvider serviceProvider = provider.newInstance();
                Services provided = serviceProvider.findServices(this);
                if (provided == null) continue;
                services.getService().addAll(provided.getService());
            }
            Schema bootstrapSchema = this.createSchema();
            Validator validator = bootstrapSchema.newValidator();
            validator.validate((Source)new JAXBSource(this.createContext(), new ObjectFactory().createServices(services)));
            return services;
        }
        catch (InstantiationException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
    }

    public static BootstrapContext createBootstrapContext(ClassLoader classLoader) throws BootstrapException {
        if (DefaultBootstrapContext.class.getName().equals(BootstrapContext.getBootstrapContextClassName())) {
            return new DefaultBootstrapContext(classLoader);
        }
        try {
            Class<?> clazz = Class.forName(BootstrapContext.getBootstrapContextClassName(), true, classLoader);
            Constructor<?> ctor = clazz.getConstructor(ClassLoader.class);
            return (BootstrapContext)ctor.newInstance(classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
        catch (NoSuchMethodException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
    }

    public abstract Schema createSchema() throws BootstrapException;

    public abstract JAXBContext createContext() throws BootstrapException;

    public abstract Marshaller createMarshaller() throws BootstrapException;

    public abstract Unmarshaller createUnmarshaller() throws BootstrapException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Collection<Class<T>> loadProviders(Class<T> providerClass) throws BootstrapException {
        try {
            Class provider;
            String providerNamePrefix = providerClass.getName() + ".";
            TreeMap<String, Class> providers = new TreeMap<String, Class>(new Comparator<String>(){

                @Override
                public int compare(String key1, String key2) {
                    return key1.compareTo(key2);
                }
            });
            File platformProviders = new File(System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "jomc.properties");
            if (platformProviders.exists()) {
                FileInputStream in = null;
                Properties p = new Properties();
                try {
                    in = new FileInputStream(platformProviders);
                    p.load(in);
                }
                finally {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                for (Map.Entry<Object, Object> e : p.entrySet()) {
                    if (!e.getKey().toString().startsWith(providerNamePrefix) || (provider = this.findClass(e.getValue().toString())) == null) continue;
                    providers.put(e.getKey().toString(), provider);
                }
            }
            Enumeration<URL> serviceProviders = this.findResources("META-INF/services/" + providerClass.getName());
            while (serviceProviders.hasMoreElements()) {
                URL url = serviceProviders.nextElement();
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.contains("#") || (provider = this.findClass(line)) == null) continue;
                    providers.put(providerNamePrefix + providers.size(), provider);
                }
                reader.close();
            }
            return providers.values();
        }
        catch (IOException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
    }
}

