/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.model.bootstrap;

import java.net.URL;
import java.util.Enumeration;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jomc.model.bootstrap.BootstrapContext;
import org.jomc.model.bootstrap.BootstrapException;
import org.jomc.model.bootstrap.Schema;
import org.jomc.model.bootstrap.SchemaProvider;
import org.jomc.model.bootstrap.Schemas;

public class DefaultSchemaProvider
implements SchemaProvider {
    private static final String DEFAULT_SCHEMA_LOCATION = "META-INF/jomc-schemas.xml";
    private static volatile String defaultSchemaLocation;
    private String schemaLocation;

    public static String getDefaultSchemaLocation() {
        if (defaultSchemaLocation == null) {
            defaultSchemaLocation = System.getProperty("org.jomc.model.bootstrap.DefaultSchemaProvider.defaultSchemaLocation", DEFAULT_SCHEMA_LOCATION);
        }
        return defaultSchemaLocation;
    }

    public static void setDefaultSchemaLocation(String value) {
        defaultSchemaLocation = value;
    }

    public String getSchemaLocation() {
        if (this.schemaLocation == null) {
            this.schemaLocation = DefaultSchemaProvider.getDefaultSchemaLocation();
        }
        return this.schemaLocation;
    }

    public void setSchemaLocation(String value) {
        this.schemaLocation = value;
    }

    public Schemas findSchemas(BootstrapContext context, String location) throws BootstrapException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (location == null) {
            throw new NullPointerException("location");
        }
        try {
            Schemas schemas = new Schemas();
            JAXBContext ctx = context.createContext();
            Unmarshaller u = ctx.createUnmarshaller();
            Enumeration<URL> e = context.findResources(location);
            u.setSchema(context.createSchema());
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                Object content = u.unmarshal(url);
                if (content instanceof JAXBElement) {
                    content = ((JAXBElement)content).getValue();
                }
                if (content instanceof Schema) {
                    schemas.getSchema().add((Schema)content);
                    continue;
                }
                if (!(content instanceof Schemas)) continue;
                for (Schema s : ((Schemas)content).getSchema()) {
                    schemas.getSchema().add(s);
                }
            }
            return schemas.getSchema().isEmpty() ? null : schemas;
        }
        catch (JAXBException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
    }

    public Schemas findSchemas(BootstrapContext context) throws BootstrapException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return this.findSchemas(context, this.getSchemaLocation());
    }
}

