/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.model.bootstrap;

import java.net.URL;
import java.util.Enumeration;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jomc.model.bootstrap.BootstrapContext;
import org.jomc.model.bootstrap.BootstrapException;
import org.jomc.model.bootstrap.Service;
import org.jomc.model.bootstrap.ServiceProvider;
import org.jomc.model.bootstrap.Services;

public class DefaultServiceProvider
implements ServiceProvider {
    private static final String DEFAULT_SERVICE_LOCATION = "META-INF/jomc-services.xml";
    private static volatile String defaultServiceLocation;
    private String serviceLocation;

    public static String getDefaultServiceLocation() {
        if (defaultServiceLocation == null) {
            defaultServiceLocation = System.getProperty("org.jomc.model.bootstrap.DefaultServiceProvider.defaultServiceLocation", DEFAULT_SERVICE_LOCATION);
        }
        return defaultServiceLocation;
    }

    public static void setDefaultServiceLocation(String value) {
        defaultServiceLocation = value;
    }

    public String getServiceLocation() {
        if (this.serviceLocation == null) {
            this.serviceLocation = DefaultServiceProvider.getDefaultServiceLocation();
        }
        return this.serviceLocation;
    }

    public void setServiceLocation(String value) {
        this.serviceLocation = value;
    }

    public Services findServices(BootstrapContext context, String location) throws BootstrapException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (location == null) {
            throw new NullPointerException("location");
        }
        try {
            Services services = new Services();
            JAXBContext ctx = context.createContext();
            Unmarshaller u = ctx.createUnmarshaller();
            Enumeration<URL> e = context.findResources(location);
            u.setSchema(context.createSchema());
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                Object content = u.unmarshal(url);
                if (content instanceof JAXBElement) {
                    content = ((JAXBElement)content).getValue();
                }
                if (content instanceof Service) {
                    services.getService().add((Service)content);
                    continue;
                }
                if (!(content instanceof Services)) continue;
                for (Service s : ((Services)content).getService()) {
                    services.getService().add(s);
                }
            }
            return services.getService().isEmpty() ? null : services;
        }
        catch (JAXBException e) {
            throw new BootstrapException(e.getMessage(), e);
        }
    }

    public Services findServices(BootstrapContext context) throws BootstrapException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        return this.findServices(context, this.getServiceLocation());
    }
}

