/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.model.bootstrap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import org.jomc.model.bootstrap.BootstrapObject;
import org.jomc.model.bootstrap.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Services", propOrder={"service"})
public class Services
extends BootstrapObject
implements Cloneable {
    protected List<Service> service;

    public Services() {
    }

    public Services(Services o) {
        super(o);
        if (o == null) {
            throw new NullPointerException("Cannot create a copy of 'Services' from 'null'.");
        }
        Services.copyService(o.getService(), this.getService());
    }

    public List<Service> getService() {
        if (this.service == null) {
            this.service = new ArrayList<Service>();
        }
        return this.service;
    }

    private static void copyService(List<Service> source, List<Service> target) {
        if (!source.isEmpty()) {
            for (Service next : source) {
                if (next instanceof Service) {
                    target.add(next.clone());
                    continue;
                }
                throw new AssertionError((Object)("Unexpected instance '" + next + "' for property 'Service' of class 'org.jomc.model.bootstrap.Services'."));
            }
        }
    }

    @Override
    public Services clone() {
        return new Services(this);
    }

    public List<Service> getServices(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("identifier");
        }
        ArrayList<Service> services = new ArrayList<Service>(this.getService().size());
        for (Service s : this.getService()) {
            if (!identifier.equals(s.getIdentifier())) continue;
            services.add(s);
        }
        Collections.sort(services, new Comparator<Service>(){

            @Override
            public int compare(Service s1, Service s2) {
                return s1.getOrdinal() - s2.getOrdinal();
            }
        });
        return Collections.unmodifiableList(services);
    }

    public List<Service> getServices(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        return this.getServices(clazz.getName());
    }
}

