/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBResult;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.validation.Schema;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Unknown;
import org.jomc.model.Dependencies;
import org.jomc.model.Dependency;
import org.jomc.model.Implementation;
import org.jomc.model.Implementations;
import org.jomc.model.Message;
import org.jomc.model.Messages;
import org.jomc.model.ModelObject;
import org.jomc.model.ModelObjectException;
import org.jomc.model.Module;
import org.jomc.model.ObjectFactory;
import org.jomc.model.Properties;
import org.jomc.model.Property;
import org.jomc.model.Specification;
import org.jomc.model.SpecificationReference;
import org.jomc.model.Specifications;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelException;
import org.jomc.modlet.ModelValidationReport;
import org.jomc.tools.JomcTool;
import org.jomc.util.ParseException;
import org.jomc.util.TokenMgrError;
import org.jomc.util.VersionParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFileProcessor
extends JomcTool {
    private static final byte[] NO_BYTES = new byte[0];

    public ClassFileProcessor() {
    }

    public ClassFileProcessor(ClassFileProcessor tool) throws IOException {
        super(tool);
    }

    public final void commitModelObjects(ModelContext context, File classesDirectory) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        try {
            if (this.getModules() != null) {
                Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
                m.setSchema(context.createSchema(this.getModel().getIdentifier()));
                this.commitModelObjects(this.getModules().getSpecifications(), this.getModules().getImplementations(), m, classesDirectory);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("modulesNotFound", this.getModel().getIdentifier()), null);
            }
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public final void commitModelObjects(Module module, ModelContext context, File classesDirectory) throws IOException {
        if (module == null) {
            throw new NullPointerException("module");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        try {
            if (this.getModules() != null && this.getModules().getModule(module.getName()) != null) {
                Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
                m.setSchema(context.createSchema(this.getModel().getIdentifier()));
                this.commitModelObjects(module.getSpecifications(), module.getImplementations(), m, classesDirectory);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("moduleNotFound", module.getName()), null);
            }
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public final void commitModelObjects(Specification specification, ModelContext context, File classesDirectory) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        try {
            if (this.getModules() != null && this.getModules().getSpecification(specification.getIdentifier()) != null) {
                Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
                m.setSchema(context.createSchema(this.getModel().getIdentifier()));
                this.commitModelObjects(specification, m, classesDirectory);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("specificationNotFound", specification.getIdentifier()), null);
            }
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public final void commitModelObjects(Implementation implementation, ModelContext context, File classesDirectory) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        try {
            if (this.getModules() != null && this.getModules().getImplementation(implementation.getIdentifier()) != null) {
                Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
                m.setSchema(context.createSchema(this.getModel().getIdentifier()));
                this.commitModelObjects(implementation, m, classesDirectory);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("implementationNotFound", implementation.getIdentifier()), null);
            }
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public void commitModelObjects(Specification specification, Marshaller marshaller, JavaClass javaClass) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (marshaller == null) {
            throw new NullPointerException("marshaller");
        }
        if (javaClass == null) {
            throw new NullPointerException("javaClass");
        }
        if (this.getModules() != null && this.getModules().getSpecification(specification.getIdentifier()) != null) {
            this.setClassfileAttribute(javaClass, Specification.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)new ObjectFactory().createSpecification(specification)));
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, ClassFileProcessor.getMessage("specificationNotFound", specification.getIdentifier()), null);
        }
    }

    public void commitModelObjects(Implementation implementation, Marshaller marshaller, JavaClass javaClass) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (marshaller == null) {
            throw new NullPointerException("marshaller");
        }
        if (javaClass == null) {
            throw new NullPointerException("javaClass");
        }
        if (this.getModules() != null && this.getModules().getImplementation(implementation.getIdentifier()) != null) {
            int i;
            Specifications specifications;
            Messages messages;
            Properties properties;
            ObjectFactory of = new ObjectFactory();
            Dependencies dependencies = this.getModules().getDependencies(implementation.getIdentifier());
            if (dependencies == null) {
                dependencies = new Dependencies();
            }
            if ((properties = this.getModules().getProperties(implementation.getIdentifier())) == null) {
                properties = new Properties();
            }
            if ((messages = this.getModules().getMessages(implementation.getIdentifier())) == null) {
                messages = new Messages();
            }
            if ((specifications = this.getModules().getSpecifications(implementation.getIdentifier())) == null) {
                specifications = new Specifications();
            }
            int s0 = specifications.getReference().size();
            for (i = 0; i < s0; ++i) {
                SpecificationReference r = (SpecificationReference)specifications.getReference().get(i);
                if (specifications.getSpecification(r.getIdentifier()) != null || !this.isLoggable(Level.WARNING)) continue;
                this.log(Level.WARNING, ClassFileProcessor.getMessage("unresolvedSpecification", r.getIdentifier(), implementation.getIdentifier()), null);
            }
            s0 = dependencies.getDependency().size();
            for (i = 0; i < s0; ++i) {
                Dependency d = (Dependency)dependencies.getDependency().get(i);
                Specification s = this.getModules().getSpecification(d.getIdentifier());
                if (s != null) {
                    if (specifications.getSpecification(s.getIdentifier()) != null) continue;
                    specifications.getSpecification().add(s);
                    continue;
                }
                if (!this.isLoggable(Level.WARNING)) continue;
                this.log(Level.WARNING, ClassFileProcessor.getMessage("unresolvedDependencySpecification", d.getIdentifier(), d.getName(), implementation.getIdentifier()), null);
            }
            this.setClassfileAttribute(javaClass, Dependencies.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createDependencies(dependencies)));
            this.setClassfileAttribute(javaClass, Properties.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createProperties(properties)));
            this.setClassfileAttribute(javaClass, Messages.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createMessages(messages)));
            this.setClassfileAttribute(javaClass, Specifications.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createSpecifications(specifications)));
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, ClassFileProcessor.getMessage("implementationNotFound", implementation.getIdentifier()), null);
        }
    }

    public final ModelValidationReport validateModelObjects(ModelContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        try {
            ModelValidationReport report = null;
            if (this.getModules() != null) {
                Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
                u.setSchema(context.createSchema(this.getModel().getIdentifier()));
                report = this.validateModelObjects(this.getModules().getSpecifications(), this.getModules().getImplementations(), u, context);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("modulesNotFound", this.getModel().getIdentifier()), null);
            }
            return report;
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public final ModelValidationReport validateModelObjects(Module module, ModelContext context) throws IOException {
        if (module == null) {
            throw new NullPointerException("module");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        try {
            ModelValidationReport report = null;
            if (this.getModules() != null && this.getModules().getModule(module.getName()) != null) {
                Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
                u.setSchema(context.createSchema(this.getModel().getIdentifier()));
                report = this.validateModelObjects(module.getSpecifications(), module.getImplementations(), u, context);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("moduleNotFound", module.getName()), null);
            }
            return report;
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public final ModelValidationReport validateModelObjects(Specification specification, ModelContext context) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        try {
            ModelValidationReport report = null;
            if (this.getModules() != null && this.getModules().getSpecification(specification.getIdentifier()) != null) {
                Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
                u.setSchema(context.createSchema(this.getModel().getIdentifier()));
                report = this.validateModelObjects(specification, u, context);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("specificationNotFound", specification.getIdentifier()), null);
            }
            return report;
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public final ModelValidationReport validateModelObjects(Implementation implementation, ModelContext context) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        try {
            ModelValidationReport report = null;
            if (this.getModules() != null && this.getModules().getImplementation(implementation.getIdentifier()) != null) {
                Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
                u.setSchema(context.createSchema(this.getModel().getIdentifier()));
                report = this.validateModelObjects(implementation, u, context);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("implementationNotFound", implementation.getIdentifier()), null);
            }
            return report;
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public final ModelValidationReport validateModelObjects(ModelContext context, File classesDirectory) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        try {
            ModelValidationReport report = null;
            if (this.getModules() != null) {
                Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
                u.setSchema(context.createSchema(this.getModel().getIdentifier()));
                report = this.validateModelObjects(this.getModules().getSpecifications(), this.getModules().getImplementations(), u, classesDirectory);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("modulesNotFound", this.getModel().getIdentifier()), null);
            }
            return report;
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public final ModelValidationReport validateModelObjects(Module module, ModelContext context, File classesDirectory) throws IOException {
        if (module == null) {
            throw new NullPointerException("module");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        try {
            ModelValidationReport report = null;
            if (this.getModules() != null && this.getModules().getModule(module.getName()) != null) {
                Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
                u.setSchema(context.createSchema(this.getModel().getIdentifier()));
                report = this.validateModelObjects(module.getSpecifications(), module.getImplementations(), u, classesDirectory);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("moduleNotFound", module.getName()), null);
            }
            return report;
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public final ModelValidationReport validateModelObjects(Specification specification, ModelContext context, File classesDirectory) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        try {
            ModelValidationReport report = null;
            if (this.getModules() != null && this.getModules().getSpecification(specification.getIdentifier()) != null) {
                Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
                u.setSchema(context.createSchema(this.getModel().getIdentifier()));
                report = this.validateModelObjects(specification, u, classesDirectory);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("specificationNotFound", specification.getIdentifier()), null);
            }
            return report;
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public final ModelValidationReport validateModelObjects(Implementation implementation, ModelContext context, File classesDirectory) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        try {
            ModelValidationReport report = null;
            if (this.getModules() != null && this.getModules().getImplementation(implementation.getIdentifier()) != null) {
                Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
                u.setSchema(context.createSchema(this.getModel().getIdentifier()));
                report = this.validateModelObjects(implementation, u, classesDirectory);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("implementationNotFound", implementation.getIdentifier()), null);
            }
            return report;
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public ModelValidationReport validateModelObjects(Specification specification, Unmarshaller unmarshaller, JavaClass javaClass) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (unmarshaller == null) {
            throw new NullPointerException("unmarshaller");
        }
        if (javaClass == null) {
            throw new NullPointerException("javaClass");
        }
        ModelValidationReport report = null;
        if (this.getModules() != null && this.getModules().getSpecification(specification.getIdentifier()) != null) {
            report = new ModelValidationReport();
            Specification decoded = null;
            byte[] bytes = this.getClassfileAttribute(javaClass, Specification.class.getName());
            if (bytes != null) {
                decoded = this.decodeModelObject(unmarshaller, bytes, Specification.class);
            }
            if (decoded != null) {
                if (decoded.getMultiplicity() != specification.getMultiplicity()) {
                    report.getDetails().add(new ModelValidationReport.Detail("CLASS_ILLEGAL_SPECIFICATION_MULTIPLICITY", Level.SEVERE, ClassFileProcessor.getMessage("illegalMultiplicity", specification.getIdentifier(), specification.getMultiplicity().value(), decoded.getMultiplicity().value()), new ObjectFactory().createSpecification(specification)));
                }
                if (decoded.getScope() == null ? specification.getScope() != null : !decoded.getScope().equals(specification.getScope())) {
                    report.getDetails().add(new ModelValidationReport.Detail("CLASS_ILLEGAL_SPECIFICATION_SCOPE", Level.SEVERE, ClassFileProcessor.getMessage("illegalScope", specification.getIdentifier(), specification.getScope() == null ? "Multiton" : specification.getScope(), decoded.getScope() == null ? "Multiton" : decoded.getScope()), new ObjectFactory().createSpecification(specification)));
                }
                if (decoded.getClazz() == null ? specification.getClazz() != null : !decoded.getClazz().equals(specification.getClazz())) {
                    report.getDetails().add(new ModelValidationReport.Detail("CLASS_ILLEGAL_SPECIFICATION_CLASS", Level.SEVERE, ClassFileProcessor.getMessage("illegalSpecificationClass", decoded.getIdentifier(), specification.getClazz(), decoded.getClazz()), new ObjectFactory().createSpecification(specification)));
                }
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("cannotValidateSpecification", specification.getIdentifier(), Specification.class.getName()), null);
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, ClassFileProcessor.getMessage("specificationNotFound", specification.getIdentifier()), null);
        }
        return report;
    }

    public ModelValidationReport validateModelObjects(Implementation implementation, Unmarshaller unmarshaller, JavaClass javaClass) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (unmarshaller == null) {
            throw new NullPointerException("unmarshaller");
        }
        if (javaClass == null) {
            throw new NullPointerException("javaClass");
        }
        try {
            ModelValidationReport report = null;
            if (this.getModules() != null && this.getModules().getImplementation(implementation.getIdentifier()) != null) {
                int i;
                int s0;
                Specifications specifications;
                Messages messages;
                Properties properties;
                report = new ModelValidationReport();
                Dependencies dependencies = this.getModules().getDependencies(implementation.getIdentifier());
                if (dependencies == null) {
                    dependencies = new Dependencies();
                }
                if ((properties = this.getModules().getProperties(implementation.getIdentifier())) == null) {
                    properties = new Properties();
                }
                if ((messages = this.getModules().getMessages(implementation.getIdentifier())) == null) {
                    messages = new Messages();
                }
                if ((specifications = this.getModules().getSpecifications(implementation.getIdentifier())) == null) {
                    specifications = new Specifications();
                }
                Dependencies decodedDependencies = null;
                byte[] bytes = this.getClassfileAttribute(javaClass, Dependencies.class.getName());
                if (bytes != null) {
                    decodedDependencies = this.decodeModelObject(unmarshaller, bytes, Dependencies.class);
                }
                Properties decodedProperties = null;
                bytes = this.getClassfileAttribute(javaClass, Properties.class.getName());
                if (bytes != null) {
                    decodedProperties = this.decodeModelObject(unmarshaller, bytes, Properties.class);
                }
                Messages decodedMessages = null;
                bytes = this.getClassfileAttribute(javaClass, Messages.class.getName());
                if (bytes != null) {
                    decodedMessages = this.decodeModelObject(unmarshaller, bytes, Messages.class);
                }
                Specifications decodedSpecifications = null;
                bytes = this.getClassfileAttribute(javaClass, Specifications.class.getName());
                if (bytes != null) {
                    decodedSpecifications = this.decodeModelObject(unmarshaller, bytes, Specifications.class);
                }
                if (decodedDependencies != null) {
                    s0 = decodedDependencies.getDependency().size();
                    for (i = 0; i < s0; ++i) {
                        Dependency decodedDependency = (Dependency)decodedDependencies.getDependency().get(i);
                        Dependency dependency = dependencies.getDependency(decodedDependency.getName());
                        Specification s = this.getModules().getSpecification(decodedDependency.getIdentifier());
                        if (dependency == null) {
                            report.getDetails().add(new ModelValidationReport.Detail("CLASS_MISSING_IMPLEMENTATION_DEPENDENCY", Level.SEVERE, ClassFileProcessor.getMessage("missingDependency", implementation.getIdentifier(), decodedDependency.getName()), new ObjectFactory().createImplementation(implementation)));
                        } else if (decodedDependency.getImplementationName() != null && dependency.getImplementationName() == null) {
                            report.getDetails().add(new ModelValidationReport.Detail("CLASS_MISSING_DEPENDENCY_IMPLEMENTATION_NAME", Level.SEVERE, ClassFileProcessor.getMessage("missingDependencyImplementationName", implementation.getIdentifier(), decodedDependency.getName()), new ObjectFactory().createImplementation(implementation)));
                        }
                        if (s == null || s.getVersion() == null || decodedDependency.getVersion() == null || VersionParser.compare((String)decodedDependency.getVersion(), (String)s.getVersion()) <= 0) continue;
                        Module moduleOfSpecification = this.getModules().getModuleOfSpecification(s.getIdentifier());
                        Module moduleOfImplementation = this.getModules().getModuleOfImplementation(implementation.getIdentifier());
                        report.getDetails().add(new ModelValidationReport.Detail("CLASS_INCOMPATIBLE_IMPLEMENTATION_DEPENDENCY", Level.SEVERE, ClassFileProcessor.getMessage("incompatibleDependency", javaClass.getClassName(), moduleOfImplementation == null ? "<>" : moduleOfImplementation.getName(), s.getIdentifier(), moduleOfSpecification == null ? "<>" : moduleOfSpecification.getName(), decodedDependency.getVersion(), s.getVersion()), new ObjectFactory().createImplementation(implementation)));
                    }
                } else if (this.isLoggable(Level.WARNING)) {
                    this.log(Level.WARNING, ClassFileProcessor.getMessage("cannotValidateImplementation", implementation.getIdentifier(), Dependencies.class.getName()), null);
                }
                if (decodedProperties != null) {
                    s0 = decodedProperties.getProperty().size();
                    for (i = 0; i < s0; ++i) {
                        Property decodedProperty = (Property)decodedProperties.getProperty().get(i);
                        Property property = properties.getProperty(decodedProperty.getName());
                        if (property == null) {
                            report.getDetails().add(new ModelValidationReport.Detail("CLASS_MISSING_IMPLEMENTATION_PROPERTY", Level.SEVERE, ClassFileProcessor.getMessage("missingProperty", implementation.getIdentifier(), decodedProperty.getName()), new ObjectFactory().createImplementation(implementation)));
                            continue;
                        }
                        if (!(decodedProperty.getType() == null ? property.getType() != null : !decodedProperty.getType().equals(property.getType()))) continue;
                        report.getDetails().add(new ModelValidationReport.Detail("CLASS_ILLEGAL_IMPLEMENTATION_PROPERTY", Level.SEVERE, ClassFileProcessor.getMessage("illegalPropertyType", implementation.getIdentifier(), decodedProperty.getName(), property.getType() == null ? "<>" : property.getType(), decodedProperty.getType() == null ? "<>" : decodedProperty.getType()), new ObjectFactory().createImplementation(implementation)));
                    }
                } else if (this.isLoggable(Level.WARNING)) {
                    this.log(Level.WARNING, ClassFileProcessor.getMessage("cannotValidateImplementation", implementation.getIdentifier(), Properties.class.getName()), null);
                }
                if (decodedMessages != null) {
                    s0 = decodedMessages.getMessage().size();
                    for (i = 0; i < s0; ++i) {
                        Message decodedMessage = (Message)decodedMessages.getMessage().get(i);
                        Message message = messages.getMessage(decodedMessage.getName());
                        if (message != null) continue;
                        report.getDetails().add(new ModelValidationReport.Detail("CLASS_MISSING_IMPLEMENTATION_MESSAGE", Level.SEVERE, ClassFileProcessor.getMessage("missingMessage", implementation.getIdentifier(), decodedMessage.getName()), new ObjectFactory().createImplementation(implementation)));
                    }
                } else if (this.isLoggable(Level.WARNING)) {
                    this.log(Level.WARNING, ClassFileProcessor.getMessage("cannotValidateImplementation", implementation.getIdentifier(), Messages.class.getName()), null);
                }
                if (decodedSpecifications != null) {
                    Specification specification;
                    s0 = decodedSpecifications.getSpecification().size();
                    for (i = 0; i < s0; ++i) {
                        Specification decodedSpecification = (Specification)decodedSpecifications.getSpecification().get(i);
                        specification = this.getModules().getSpecification(decodedSpecification.getIdentifier());
                        if (specification == null) {
                            report.getDetails().add(new ModelValidationReport.Detail("CLASS_MISSING_SPECIFICATION", Level.SEVERE, ClassFileProcessor.getMessage("missingSpecification", implementation.getIdentifier(), decodedSpecification.getIdentifier()), new ObjectFactory().createImplementation(implementation)));
                            continue;
                        }
                        if (decodedSpecification.getMultiplicity() != specification.getMultiplicity()) {
                            report.getDetails().add(new ModelValidationReport.Detail("CLASS_ILLEGAL_SPECIFICATION_MULTIPLICITY", Level.SEVERE, ClassFileProcessor.getMessage("illegalMultiplicity", specification.getIdentifier(), specification.getMultiplicity().value(), decodedSpecification.getMultiplicity().value()), new ObjectFactory().createImplementation(implementation)));
                        }
                        if (decodedSpecification.getScope() == null ? specification.getScope() != null : !decodedSpecification.getScope().equals(specification.getScope())) {
                            report.getDetails().add(new ModelValidationReport.Detail("CLASS_ILLEGAL_SPECIFICATION_SCOPE", Level.SEVERE, ClassFileProcessor.getMessage("illegalScope", decodedSpecification.getIdentifier(), specification.getScope() == null ? "Multiton" : specification.getScope(), decodedSpecification.getScope() == null ? "Multiton" : decodedSpecification.getScope()), new ObjectFactory().createImplementation(implementation)));
                        }
                        if (!(decodedSpecification.getClazz() == null ? specification.getClazz() != null : !decodedSpecification.getClazz().equals(specification.getClazz()))) continue;
                        report.getDetails().add(new ModelValidationReport.Detail("CLASS_ILLEGAL_SPECIFICATION_CLASS", Level.SEVERE, ClassFileProcessor.getMessage("illegalSpecificationClass", decodedSpecification.getIdentifier(), specification.getClazz(), decodedSpecification.getClazz()), new ObjectFactory().createImplementation(implementation)));
                    }
                    s0 = decodedSpecifications.getReference().size();
                    for (i = 0; i < s0; ++i) {
                        SpecificationReference decodedReference = (SpecificationReference)decodedSpecifications.getReference().get(i);
                        specification = specifications.getSpecification(decodedReference.getIdentifier());
                        if (specification == null) {
                            report.getDetails().add(new ModelValidationReport.Detail("CLASS_MISSING_SPECIFICATION", Level.SEVERE, ClassFileProcessor.getMessage("missingSpecification", implementation.getIdentifier(), decodedReference.getIdentifier()), new ObjectFactory().createImplementation(implementation)));
                            continue;
                        }
                        if (decodedReference.getVersion() == null || specification.getVersion() == null || VersionParser.compare((String)decodedReference.getVersion(), (String)specification.getVersion()) == 0) continue;
                        Module moduleOfSpecification = this.getModules().getModuleOfSpecification(decodedReference.getIdentifier());
                        Module moduleOfImplementation = this.getModules().getModuleOfImplementation(implementation.getIdentifier());
                        report.getDetails().add(new ModelValidationReport.Detail("CLASS_INCOMPATIBLE_IMPLEMENTATION", Level.SEVERE, ClassFileProcessor.getMessage("incompatibleImplementation", javaClass.getClassName(), moduleOfImplementation == null ? "<>" : moduleOfImplementation.getName(), specification.getIdentifier(), moduleOfSpecification == null ? "<>" : moduleOfSpecification.getName(), decodedReference.getVersion(), specification.getVersion()), new ObjectFactory().createImplementation(implementation)));
                    }
                } else if (this.isLoggable(Level.WARNING)) {
                    this.log(Level.WARNING, ClassFileProcessor.getMessage("cannotValidateImplementation", implementation.getIdentifier(), Specifications.class.getName()), null);
                }
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("implementationNotFound", implementation.getIdentifier()), null);
            }
            return report;
        }
        catch (ParseException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
        catch (TokenMgrError e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public final void transformModelObjects(ModelContext context, File classesDirectory, List<Transformer> transformers) throws IOException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        if (transformers == null) {
            throw new NullPointerException("transformers");
        }
        if (!classesDirectory.isDirectory()) {
            throw new IOException(ClassFileProcessor.getMessage("directoryNotFound", classesDirectory.getAbsolutePath()));
        }
        try {
            if (this.getModules() != null) {
                Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
                Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
                Schema s = context.createSchema(this.getModel().getIdentifier());
                u.setSchema(s);
                m.setSchema(s);
                this.transformModelObjects(this.getModules().getSpecifications(), this.getModules().getImplementations(), u, m, classesDirectory, transformers);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("modulesNotFound", this.getModel().getIdentifier()), null);
            }
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public final void transformModelObjects(Module module, ModelContext context, File classesDirectory, List<Transformer> transformers) throws IOException {
        if (module == null) {
            throw new NullPointerException("module");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        if (transformers == null) {
            throw new NullPointerException("transformers");
        }
        if (!classesDirectory.isDirectory()) {
            throw new IOException(ClassFileProcessor.getMessage("directoryNotFound", classesDirectory.getAbsolutePath()));
        }
        try {
            if (this.getModules() != null && this.getModules().getModule(module.getName()) != null) {
                Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
                Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
                Schema s = context.createSchema(this.getModel().getIdentifier());
                u.setSchema(s);
                m.setSchema(s);
                this.transformModelObjects(module.getSpecifications(), module.getImplementations(), u, m, classesDirectory, transformers);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("moduleNotFound", module.getName()), null);
            }
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public final void transformModelObjects(Specification specification, ModelContext context, File classesDirectory, List<Transformer> transformers) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        if (transformers == null) {
            throw new NullPointerException("transformers");
        }
        if (!classesDirectory.isDirectory()) {
            throw new IOException(ClassFileProcessor.getMessage("directoryNotFound", classesDirectory.getAbsolutePath()));
        }
        try {
            if (this.getModules() != null && this.getModules().getSpecification(specification.getIdentifier()) != null) {
                Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
                Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
                Schema s = context.createSchema(this.getModel().getIdentifier());
                u.setSchema(s);
                m.setSchema(s);
                this.transformModelObjects(specification, m, u, classesDirectory, transformers);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("specificationNotFound", specification.getIdentifier()), null);
            }
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public final void transformModelObjects(Implementation implementation, ModelContext context, File classesDirectory, List<Transformer> transformers) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (classesDirectory == null) {
            throw new NullPointerException("classesDirectory");
        }
        if (transformers == null) {
            throw new NullPointerException("transformers");
        }
        if (!classesDirectory.isDirectory()) {
            throw new IOException(ClassFileProcessor.getMessage("directoryNotFound", classesDirectory.getAbsolutePath()));
        }
        try {
            if (this.getModules() != null && this.getModules().getImplementation(implementation.getIdentifier()) != null) {
                Unmarshaller u = context.createUnmarshaller(this.getModel().getIdentifier());
                Marshaller m = context.createMarshaller(this.getModel().getIdentifier());
                Schema s = context.createSchema(this.getModel().getIdentifier());
                u.setSchema(s);
                m.setSchema(s);
                this.transformModelObjects(implementation, m, u, classesDirectory, transformers);
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("implementationNotFound", implementation.getIdentifier()), null);
            }
        }
        catch (ModelException e) {
            throw (IOException)new IOException(ClassFileProcessor.getMessage(e)).initCause(e);
        }
    }

    public void transformModelObjects(Specification specification, Marshaller marshaller, Unmarshaller unmarshaller, JavaClass javaClass, List<Transformer> transformers) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (marshaller == null) {
            throw new NullPointerException("marshaller");
        }
        if (unmarshaller == null) {
            throw new NullPointerException("unmarshaller");
        }
        if (javaClass == null) {
            throw new NullPointerException("javaClass");
        }
        if (transformers == null) {
            throw new NullPointerException("transformers");
        }
        try {
            if (this.getModules() != null && this.getModules().getSpecification(specification.getIdentifier()) != null) {
                Specification decodedSpecification = null;
                ObjectFactory objectFactory = new ObjectFactory();
                byte[] bytes = this.getClassfileAttribute(javaClass, Specification.class.getName());
                if (bytes != null) {
                    decodedSpecification = this.decodeModelObject(unmarshaller, bytes, Specification.class);
                }
                if (decodedSpecification != null) {
                    int l = transformers.size();
                    for (int i = 0; i < l; ++i) {
                        JAXBSource source = new JAXBSource(marshaller, (Object)objectFactory.createSpecification(decodedSpecification));
                        JAXBResult result = new JAXBResult(unmarshaller);
                        transformers.get(i).transform((Source)source, (Result)result);
                        if (!(result.getResult() instanceof JAXBElement) || !(((JAXBElement)result.getResult()).getValue() instanceof Specification)) {
                            throw new IOException(ClassFileProcessor.getMessage("illegalSpecificationTransformationResult", specification.getIdentifier()));
                        }
                        decodedSpecification = (Specification)((JAXBElement)result.getResult()).getValue();
                    }
                    this.setClassfileAttribute(javaClass, Specification.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)objectFactory.createSpecification(decodedSpecification)));
                }
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("specificationNotFound", specification.getIdentifier()), null);
            }
        }
        catch (JAXBException e) {
            String message = ClassFileProcessor.getMessage(e);
            if (message == null && e.getLinkedException() != null) {
                message = ClassFileProcessor.getMessage(e.getLinkedException());
            }
            throw (IOException)new IOException(message).initCause(e);
        }
        catch (TransformerException e) {
            String message = ClassFileProcessor.getMessage(e);
            if (message == null && e.getException() != null) {
                message = ClassFileProcessor.getMessage(e.getException());
            }
            throw (IOException)new IOException(message).initCause(e);
        }
    }

    public void transformModelObjects(Implementation implementation, Marshaller marshaller, Unmarshaller unmarshaller, JavaClass javaClass, List<Transformer> transformers) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (marshaller == null) {
            throw new NullPointerException("marshaller");
        }
        if (unmarshaller == null) {
            throw new NullPointerException("unmarshaller");
        }
        if (javaClass == null) {
            throw new NullPointerException("javaClass");
        }
        if (transformers == null) {
            throw new NullPointerException("transformers");
        }
        try {
            if (this.getModules() != null && this.getModules().getImplementation(implementation.getIdentifier()) != null) {
                Dependencies decodedDependencies = null;
                byte[] bytes = this.getClassfileAttribute(javaClass, Dependencies.class.getName());
                if (bytes != null) {
                    decodedDependencies = this.decodeModelObject(unmarshaller, bytes, Dependencies.class);
                }
                Messages decodedMessages = null;
                bytes = this.getClassfileAttribute(javaClass, Messages.class.getName());
                if (bytes != null) {
                    decodedMessages = this.decodeModelObject(unmarshaller, bytes, Messages.class);
                }
                Properties decodedProperties = null;
                bytes = this.getClassfileAttribute(javaClass, Properties.class.getName());
                if (bytes != null) {
                    decodedProperties = this.decodeModelObject(unmarshaller, bytes, Properties.class);
                }
                Specifications decodedSpecifications = null;
                bytes = this.getClassfileAttribute(javaClass, Specifications.class.getName());
                if (bytes != null) {
                    decodedSpecifications = this.decodeModelObject(unmarshaller, bytes, Specifications.class);
                }
                ObjectFactory of = new ObjectFactory();
                int l = transformers.size();
                for (int i = 0; i < l; ++i) {
                    JAXBResult result;
                    JAXBSource source;
                    Transformer transformer = transformers.get(i);
                    if (decodedDependencies != null) {
                        source = new JAXBSource(marshaller, (Object)of.createDependencies(decodedDependencies));
                        result = new JAXBResult(unmarshaller);
                        transformer.transform((Source)source, (Result)result);
                        if (result.getResult() instanceof JAXBElement && ((JAXBElement)result.getResult()).getValue() instanceof Dependencies) {
                            decodedDependencies = (Dependencies)((JAXBElement)result.getResult()).getValue();
                        } else {
                            throw new IOException(ClassFileProcessor.getMessage("illegalImplementationTransformationResult", implementation.getIdentifier()));
                        }
                    }
                    if (decodedMessages != null) {
                        source = new JAXBSource(marshaller, (Object)of.createMessages(decodedMessages));
                        result = new JAXBResult(unmarshaller);
                        transformer.transform((Source)source, (Result)result);
                        if (result.getResult() instanceof JAXBElement && ((JAXBElement)result.getResult()).getValue() instanceof Messages) {
                            decodedMessages = (Messages)((JAXBElement)result.getResult()).getValue();
                        } else {
                            throw new IOException(ClassFileProcessor.getMessage("illegalImplementationTransformationResult", implementation.getIdentifier()));
                        }
                    }
                    if (decodedProperties != null) {
                        source = new JAXBSource(marshaller, (Object)of.createProperties(decodedProperties));
                        result = new JAXBResult(unmarshaller);
                        transformer.transform((Source)source, (Result)result);
                        if (result.getResult() instanceof JAXBElement && ((JAXBElement)result.getResult()).getValue() instanceof Properties) {
                            decodedProperties = (Properties)((JAXBElement)result.getResult()).getValue();
                        } else {
                            throw new IOException(ClassFileProcessor.getMessage("illegalImplementationTransformationResult", implementation.getIdentifier()));
                        }
                    }
                    if (decodedSpecifications == null) continue;
                    source = new JAXBSource(marshaller, (Object)of.createSpecifications(decodedSpecifications));
                    result = new JAXBResult(unmarshaller);
                    transformer.transform((Source)source, (Result)result);
                    if (result.getResult() instanceof JAXBElement && ((JAXBElement)result.getResult()).getValue() instanceof Specifications) {
                        decodedSpecifications = (Specifications)((JAXBElement)result.getResult()).getValue();
                        continue;
                    }
                    throw new IOException(ClassFileProcessor.getMessage("illegalImplementationTransformationResult", implementation.getIdentifier()));
                }
                if (decodedDependencies != null) {
                    this.setClassfileAttribute(javaClass, Dependencies.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createDependencies(decodedDependencies)));
                }
                if (decodedMessages != null) {
                    this.setClassfileAttribute(javaClass, Messages.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createMessages(decodedMessages)));
                }
                if (decodedProperties != null) {
                    this.setClassfileAttribute(javaClass, Properties.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createProperties(decodedProperties)));
                }
                if (decodedSpecifications != null) {
                    this.setClassfileAttribute(javaClass, Specifications.class.getName(), this.encodeModelObject(marshaller, (JAXBElement<? extends ModelObject>)of.createSpecifications(decodedSpecifications)));
                }
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, ClassFileProcessor.getMessage("implementationNotFound", implementation.getIdentifier()), null);
            }
        }
        catch (JAXBException e) {
            String message = ClassFileProcessor.getMessage(e);
            if (message == null && e.getLinkedException() != null) {
                message = ClassFileProcessor.getMessage(e.getLinkedException());
            }
            throw (IOException)new IOException(message).initCause(e);
        }
        catch (TransformerException e) {
            String message = ClassFileProcessor.getMessage(e);
            if (message == null && e.getException() != null) {
                message = ClassFileProcessor.getMessage(e.getException());
            }
            throw (IOException)new IOException(message).initCause(e);
        }
    }

    public byte[] getClassfileAttribute(JavaClass clazz, String attributeName) throws IOException {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (attributeName == null) {
            throw new NullPointerException("attributeName");
        }
        Attribute[] attributes = clazz.getAttributes();
        for (int i = attributes.length - 1; i >= 0; --i) {
            Constant constant = clazz.getConstantPool().getConstant(attributes[i].getNameIndex());
            if (!(constant instanceof ConstantUtf8) || !attributeName.equals(((ConstantUtf8)constant).getBytes())) continue;
            Unknown unknown = (Unknown)attributes[i];
            return unknown.getBytes();
        }
        return null;
    }

    public void setClassfileAttribute(JavaClass clazz, String attributeName, byte[] data) throws IOException {
        Constant[] tmp;
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        if (attributeName == null) {
            throw new NullPointerException("attributeName");
        }
        byte[] attributeData = data != null ? data : NO_BYTES;
        Attribute[] attributes = clazz.getAttributes();
        int attributeIndex = -1;
        int nameIndex = -1;
        for (int i = attributes.length - 1; i >= 0; --i) {
            Constant constant = clazz.getConstantPool().getConstant(attributes[i].getNameIndex());
            if (!(constant instanceof ConstantUtf8) || !attributeName.equals(((ConstantUtf8)constant).getBytes())) continue;
            attributeIndex = i;
            nameIndex = attributes[i].getNameIndex();
        }
        if (nameIndex == -1) {
            Constant[] pool = clazz.getConstantPool().getConstantPool();
            tmp = new Constant[pool.length + 1];
            System.arraycopy(pool, 0, tmp, 0, pool.length);
            tmp[pool.length] = new ConstantUtf8(attributeName);
            nameIndex = pool.length;
            clazz.setConstantPool(new ConstantPool(tmp));
        }
        Unknown unknown = new Unknown(nameIndex, attributeData.length, attributeData, clazz.getConstantPool());
        if (attributeIndex == -1) {
            tmp = new Attribute[attributes.length + 1];
            System.arraycopy(attributes, 0, tmp, 0, attributes.length);
            tmp[attributes.length] = unknown;
            attributes = tmp;
        } else {
            attributes[attributeIndex] = unknown;
        }
        clazz.setAttributes(attributes);
    }

    public byte[] encodeModelObject(Marshaller marshaller, JAXBElement<? extends ModelObject> modelObject) throws IOException {
        if (marshaller == null) {
            throw new NullPointerException("marshaller");
        }
        if (modelObject == null) {
            throw new NullPointerException("modelObject");
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(baos);
            marshaller.marshal(modelObject, (OutputStream)out);
            out.close();
            return baos.toByteArray();
        }
        catch (JAXBException e) {
            String message = ClassFileProcessor.getMessage(e);
            if (message == null && e.getLinkedException() != null) {
                message = ClassFileProcessor.getMessage(e.getLinkedException());
            }
            throw (IOException)new IOException(message).initCause(e);
        }
    }

    public <T extends ModelObject> T decodeModelObject(Unmarshaller unmarshaller, byte[] bytes, Class<T> type) throws IOException {
        if (unmarshaller == null) {
            throw new NullPointerException("unmarshaller");
        }
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            GZIPInputStream in = new GZIPInputStream(bais);
            JAXBElement element = (JAXBElement)unmarshaller.unmarshal((InputStream)in);
            in.close();
            return (T)((ModelObject)element.getValue());
        }
        catch (JAXBException e) {
            String message = ClassFileProcessor.getMessage(e);
            if (message == null && e.getLinkedException() != null) {
                message = ClassFileProcessor.getMessage(e.getLinkedException());
            }
            throw (IOException)new IOException(message).initCause(e);
        }
    }

    private void commitModelObjects(Specifications specifications, Implementations implementations, Marshaller marshaller, File classesDirectory) throws IOException, ModelObjectException {
        int i;
        if (specifications != null) {
            for (i = specifications.getSpecification().size() - 1; i >= 0; --i) {
                this.commitModelObjects((Specification)specifications.getSpecification().get(i), marshaller, classesDirectory);
            }
        }
        if (implementations != null) {
            for (i = implementations.getImplementation().size() - 1; i >= 0; --i) {
                this.commitModelObjects((Implementation)implementations.getImplementation().get(i), marshaller, classesDirectory);
            }
        }
    }

    private void commitModelObjects(Specification specification, Marshaller marshaller, File classesDirectory) throws IOException, ModelObjectException {
        if (specification.isClassDeclaration() && specification.getJavaTypeName() != null) {
            String classLocation = specification.getJavaTypeName().getClassName().replace('.', File.separatorChar) + ".class";
            File classFile = new File(classesDirectory, classLocation);
            if (!classesDirectory.isDirectory()) {
                throw new IOException(ClassFileProcessor.getMessage("directoryNotFound", classesDirectory.getAbsolutePath()));
            }
            if (!classFile.isFile()) {
                throw new IOException(ClassFileProcessor.getMessage("fileNotFound", classFile.getAbsolutePath()));
            }
            if (!classFile.canRead() || !classFile.canWrite()) {
                throw new IOException(ClassFileProcessor.getMessage("fileAccessDenied", classFile.getAbsolutePath()));
            }
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("committing", classFile.getAbsolutePath()), null);
            }
            JavaClass javaClass = this.readJavaClass(classFile);
            this.commitModelObjects(specification, marshaller, javaClass);
            this.writeJavaClass(javaClass, classFile);
        }
    }

    private void commitModelObjects(Implementation implementation, Marshaller marshaller, File classesDirectory) throws IOException, ModelObjectException {
        if (implementation.isClassDeclaration() && implementation.getJavaTypeName() != null) {
            String classLocation = implementation.getJavaTypeName().getClassName().replace('.', File.separatorChar) + ".class";
            File classFile = new File(classesDirectory, classLocation);
            if (!classesDirectory.isDirectory()) {
                throw new IOException(ClassFileProcessor.getMessage("directoryNotFound", classesDirectory.getAbsolutePath()));
            }
            if (!classFile.isFile()) {
                throw new IOException(ClassFileProcessor.getMessage("fileNotFound", classFile.getAbsolutePath()));
            }
            if (!classFile.canRead() || !classFile.canWrite()) {
                throw new IOException(ClassFileProcessor.getMessage("fileAccessDenied", classFile.getAbsolutePath()));
            }
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("committing", classFile.getAbsolutePath()), null);
            }
            JavaClass javaClass = this.readJavaClass(classFile);
            this.commitModelObjects(implementation, marshaller, javaClass);
            this.writeJavaClass(javaClass, classFile);
        }
    }

    private ModelValidationReport validateModelObjects(Specifications specifications, Implementations implementations, Unmarshaller unmarshaller, File classesDirectory) throws IOException, ModelObjectException {
        ModelValidationReport current;
        int i;
        int s0;
        ModelValidationReport report = new ModelValidationReport();
        if (specifications != null) {
            s0 = specifications.getSpecification().size();
            for (i = 0; i < s0; ++i) {
                current = this.validateModelObjects((Specification)specifications.getSpecification().get(i), unmarshaller, classesDirectory);
                report.getDetails().addAll(current.getDetails());
            }
        }
        if (implementations != null) {
            s0 = implementations.getImplementation().size();
            for (i = 0; i < s0; ++i) {
                current = this.validateModelObjects((Implementation)implementations.getImplementation().get(i), unmarshaller, classesDirectory);
                report.getDetails().addAll(current.getDetails());
            }
        }
        return report;
    }

    private ModelValidationReport validateModelObjects(Specification specification, Unmarshaller unmarshaller, File classesDirectory) throws IOException, ModelObjectException {
        ModelValidationReport report = new ModelValidationReport();
        if (specification.isClassDeclaration() && specification.getJavaTypeName() != null) {
            String classLocation = specification.getJavaTypeName().getClassName().replace('.', File.separatorChar) + ".class";
            File classFile = new File(classesDirectory, classLocation);
            if (!classesDirectory.isDirectory()) {
                throw new IOException(ClassFileProcessor.getMessage("directoryNotFound", classesDirectory.getAbsolutePath()));
            }
            if (!classFile.isFile()) {
                throw new IOException(ClassFileProcessor.getMessage("fileNotFound", classFile.getAbsolutePath()));
            }
            if (!classFile.canRead()) {
                throw new IOException(ClassFileProcessor.getMessage("fileAccessDenied", classFile.getAbsolutePath()));
            }
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("validating", classFile.getAbsolutePath()), null);
            }
            JavaClass javaClass = this.readJavaClass(classFile);
            report.getDetails().addAll(this.validateModelObjects(specification, unmarshaller, javaClass).getDetails());
        }
        return report;
    }

    private ModelValidationReport validateModelObjects(Implementation implementation, Unmarshaller unmarshaller, File classesDirectory) throws IOException, ModelObjectException {
        ModelValidationReport report = new ModelValidationReport();
        if (implementation.isClassDeclaration() && implementation.getJavaTypeName() != null) {
            String classLocation = implementation.getJavaTypeName().getClassName().replace('.', File.separatorChar) + ".class";
            File classFile = new File(classesDirectory, classLocation);
            if (!classesDirectory.isDirectory()) {
                throw new IOException(ClassFileProcessor.getMessage("directoryNotFound", classesDirectory.getAbsolutePath()));
            }
            if (!classFile.isFile()) {
                throw new IOException(ClassFileProcessor.getMessage("fileNotFound", classFile.getAbsolutePath()));
            }
            if (!classFile.canRead()) {
                throw new IOException(ClassFileProcessor.getMessage("fileAccessDenied", classFile.getAbsolutePath()));
            }
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("validating", classFile.getAbsolutePath()), null);
            }
            JavaClass javaClass = this.readJavaClass(classFile);
            report.getDetails().addAll(this.validateModelObjects(implementation, unmarshaller, javaClass).getDetails());
        }
        return report;
    }

    private ModelValidationReport validateModelObjects(Specifications specifications, Implementations implementations, Unmarshaller unmarshaller, ModelContext context) throws IOException, ModelException {
        ModelValidationReport current;
        int i;
        int s0;
        ModelValidationReport report = new ModelValidationReport();
        if (specifications != null) {
            s0 = specifications.getSpecification().size();
            for (i = 0; i < s0; ++i) {
                current = this.validateModelObjects((Specification)specifications.getSpecification().get(i), unmarshaller, context);
                report.getDetails().addAll(current.getDetails());
            }
        }
        if (implementations != null) {
            s0 = implementations.getImplementation().size();
            for (i = 0; i < s0; ++i) {
                current = this.validateModelObjects((Implementation)implementations.getImplementation().get(i), unmarshaller, context);
                report.getDetails().addAll(current.getDetails());
            }
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelValidationReport validateModelObjects(Specification specification, Unmarshaller unmarshaller, ModelContext context) throws IOException, ModelException {
        ModelValidationReport report = new ModelValidationReport();
        if (specification.isClassDeclaration() && specification.getJavaTypeName() != null) {
            String classLocation = specification.getJavaTypeName().getClassName().replace('.', '/') + ".class";
            URL classUrl = context.findResource(classLocation);
            if (classUrl == null) {
                throw new IOException(ClassFileProcessor.getMessage("resourceNotFound", classLocation));
            }
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("validatingSpecification", specification.getIdentifier()), null);
            }
            InputStream in = null;
            JavaClass javaClass = null;
            boolean suppressExceptionOnClose = true;
            try {
                in = classUrl.openStream();
                javaClass = new ClassParser(in, classUrl.toExternalForm()).parse();
                suppressExceptionOnClose = false;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    if (suppressExceptionOnClose) {
                        this.log(Level.SEVERE, ClassFileProcessor.getMessage(e), e);
                    }
                    throw e;
                }
            }
            report.getDetails().addAll(this.validateModelObjects(specification, unmarshaller, javaClass).getDetails());
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelValidationReport validateModelObjects(Implementation implementation, Unmarshaller unmarshaller, ModelContext context) throws IOException, ModelException {
        ModelValidationReport report = new ModelValidationReport();
        if (implementation.isClassDeclaration() && implementation.getJavaTypeName() != null) {
            String classLocation = implementation.getJavaTypeName().getClassName().replace('.', '/') + ".class";
            URL classUrl = context.findResource(classLocation);
            if (classUrl == null) {
                throw new IOException(ClassFileProcessor.getMessage("resourceNotFound", classLocation));
            }
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("validatingImplementation", implementation.getIdentifier()), null);
            }
            InputStream in = null;
            JavaClass javaClass = null;
            boolean suppressExceptionOnClose = true;
            try {
                in = classUrl.openStream();
                javaClass = new ClassParser(in, classUrl.toExternalForm()).parse();
                suppressExceptionOnClose = false;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    if (suppressExceptionOnClose) {
                        this.log(Level.SEVERE, ClassFileProcessor.getMessage(e), e);
                    }
                    throw e;
                }
            }
            report.getDetails().addAll(this.validateModelObjects(implementation, unmarshaller, javaClass).getDetails());
        }
        return report;
    }

    private void transformModelObjects(Specifications specifications, Implementations implementations, Unmarshaller unmarshaller, Marshaller marshaller, File classesDirectory, List<Transformer> transformers) throws IOException, ModelObjectException {
        int i;
        int s0;
        if (specifications != null) {
            s0 = specifications.getSpecification().size();
            for (i = 0; i < s0; ++i) {
                this.transformModelObjects((Specification)specifications.getSpecification().get(i), marshaller, unmarshaller, classesDirectory, transformers);
            }
        }
        if (implementations != null) {
            s0 = implementations.getImplementation().size();
            for (i = 0; i < s0; ++i) {
                this.transformModelObjects((Implementation)implementations.getImplementation().get(i), marshaller, unmarshaller, classesDirectory, transformers);
            }
        }
    }

    private void transformModelObjects(Specification specification, Marshaller marshaller, Unmarshaller unmarshaller, File classesDirectory, List<Transformer> transformers) throws IOException, ModelObjectException {
        if (specification.isClassDeclaration() && specification.getJavaTypeName() != null) {
            String classLocation = specification.getJavaTypeName().getClassName().replace('.', File.separatorChar) + ".class";
            File classFile = new File(classesDirectory, classLocation);
            if (!classesDirectory.isDirectory()) {
                throw new IOException(ClassFileProcessor.getMessage("directoryNotFound", classesDirectory.getAbsolutePath()));
            }
            if (!classFile.isFile()) {
                throw new IOException(ClassFileProcessor.getMessage("fileNotFound", classFile.getAbsolutePath()));
            }
            if (!classFile.canRead() || !classFile.canWrite()) {
                throw new IOException(ClassFileProcessor.getMessage("fileAccessDenied", classFile.getAbsolutePath()));
            }
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("transforming", classFile.getAbsolutePath()), null);
            }
            JavaClass javaClass = this.readJavaClass(classFile);
            this.transformModelObjects(specification, marshaller, unmarshaller, javaClass, transformers);
            this.writeJavaClass(javaClass, classFile);
        }
    }

    private void transformModelObjects(Implementation implementation, Marshaller marshaller, Unmarshaller unmarshaller, File classesDirectory, List<Transformer> transformers) throws IOException, ModelObjectException {
        if (implementation.isClassDeclaration() && implementation.getJavaTypeName() != null) {
            String classLocation = implementation.getJavaTypeName().getClassName().replace('.', File.separatorChar) + ".class";
            File classFile = new File(classesDirectory, classLocation);
            if (!classesDirectory.isDirectory()) {
                throw new IOException(ClassFileProcessor.getMessage("directoryNotFound", classesDirectory.getAbsolutePath()));
            }
            if (!classFile.isFile()) {
                throw new IOException(ClassFileProcessor.getMessage("fileNotFound", classFile.getAbsolutePath()));
            }
            if (!classFile.canRead() || !classFile.canWrite()) {
                throw new IOException(ClassFileProcessor.getMessage("fileAccessDenied", classFile.getAbsolutePath()));
            }
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ClassFileProcessor.getMessage("transforming", classFile.getAbsolutePath()), null);
            }
            JavaClass javaClass = this.readJavaClass(classFile);
            this.transformModelObjects(implementation, marshaller, unmarshaller, javaClass, transformers);
            this.writeJavaClass(javaClass, classFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JavaClass readJavaClass(File classFile) throws IOException {
        JavaClass javaClass;
        FileInputStream in = null;
        FileChannel fileChannel = null;
        FileLock fileLock = null;
        boolean suppressExceptionOnClose = true;
        try {
            in = new FileInputStream(classFile);
            fileChannel = in.getChannel();
            fileLock = fileChannel.lock(0L, classFile.length(), true);
            JavaClass javaClass2 = new ClassParser((InputStream)in, classFile.getAbsolutePath()).parse();
            suppressExceptionOnClose = false;
            javaClass = javaClass2;
        }
        catch (Throwable throwable) {
            this.releaseAndClose(fileLock, fileChannel, in, suppressExceptionOnClose);
            throw throwable;
        }
        this.releaseAndClose(fileLock, fileChannel, in, suppressExceptionOnClose);
        return javaClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeJavaClass(JavaClass javaClass, File classFile) throws IOException {
        RandomAccessFile randomAccessFile = null;
        FileChannel fileChannel = null;
        FileLock fileLock = null;
        boolean suppressExceptionOnClose = true;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        javaClass.dump((OutputStream)byteStream);
        byteStream.close();
        byte[] bytes = byteStream.toByteArray();
        try {
            randomAccessFile = new RandomAccessFile(classFile, "rw");
            fileChannel = randomAccessFile.getChannel();
            fileLock = fileChannel.lock();
            fileChannel.truncate(bytes.length);
            fileChannel.position(0L);
            fileChannel.write(ByteBuffer.wrap(bytes));
            fileChannel.force(true);
            suppressExceptionOnClose = false;
        }
        catch (Throwable throwable) {
            this.releaseAndClose(fileLock, fileChannel, randomAccessFile, suppressExceptionOnClose);
            throw throwable;
        }
        this.releaseAndClose(fileLock, fileChannel, randomAccessFile, suppressExceptionOnClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void releaseAndClose(FileLock fileLock, FileChannel fileChannel, Closeable closeable, boolean suppressExceptions) throws IOException {
        try {
            if (fileLock == null) return;
            fileLock.release();
            return;
        }
        catch (IOException e) {
            if (!suppressExceptions) throw e;
            this.log(Level.SEVERE, null, e);
            return;
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (IOException e) {
                if (!suppressExceptions) throw e;
                this.log(Level.SEVERE, null, e);
            }
            finally {
                try {
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (IOException e) {
                    if (!suppressExceptions) throw e;
                    this.log(Level.SEVERE, null, e);
                }
            }
        }
    }

    private static String getMessage(String key, Object ... arguments) {
        return MessageFormat.format(ResourceBundle.getBundle(ClassFileProcessor.class.getName().replace('.', '/')).getString(key), arguments);
    }

    private static String getMessage(Throwable t) {
        return t != null ? (t.getMessage() != null && t.getMessage().trim().length() > 0 ? t.getMessage() : ClassFileProcessor.getMessage(t.getCause())) : null;
    }
}

