/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import javax.activation.MimeTypeParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.URLResourceLoader;
import org.jomc.model.Argument;
import org.jomc.model.Dependency;
import org.jomc.model.Implementation;
import org.jomc.model.InheritanceModel;
import org.jomc.model.JavaIdentifier;
import org.jomc.model.JavaTypeName;
import org.jomc.model.Message;
import org.jomc.model.ModelObjectException;
import org.jomc.model.Modules;
import org.jomc.model.Multiplicity;
import org.jomc.model.Property;
import org.jomc.model.Specification;
import org.jomc.model.SpecificationReference;
import org.jomc.model.Text;
import org.jomc.model.Texts;
import org.jomc.model.modlet.ModelHelper;
import org.jomc.modlet.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JomcTool {
    private static final byte[] NO_BYTES = new byte[0];
    private static final String TEMPLATE_PREFIX = JomcTool.class.getPackage().getName().replace('.', '/') + "/templates/";
    private static final String DEFAULT_TEMPLATE_PROFILE = "jomc-java";
    private static final String PARENT_TEMPLATE_PROFILE_PROPERTY_NAME = "parent-template-profile";
    private static final String TEMPLATE_ENCODING_PROFILE_PROPERTY_NAME = "template-encoding";
    private String defaultTemplateEncoding;
    private static volatile String defaultTemplateProfile;
    private static final Level DEFAULT_LOG_LEVEL;
    private static volatile Level defaultLogLevel;
    private Model model;
    private VelocityEngine velocityEngine;
    private boolean defaultVelocityEngine;
    private URL templateLocation;
    private String inputEncoding;
    private String outputEncoding;
    private Map<String, Object> templateParameters;
    private String templateProfile;
    private String indentation;
    private String lineSeparator;
    private List<Listener> listeners;
    private Level logLevel;
    private Locale locale;
    private volatile Reference<Map<String, String>> indentationCache;
    private volatile Reference<Map<String, TemplateData>> templateCache;
    private volatile Reference<Map<String, Properties>> templateProfileContextPropertiesCache;
    private volatile Reference<Map<String, Properties>> templateProfilePropertiesCache;
    private volatile Reference<Set<String>> javaKeywordsCache;

    public JomcTool() {
    }

    public JomcTool(JomcTool tool) throws IOException {
        this();
        if (tool == null) {
            throw new NullPointerException("tool");
        }
        this.indentation = tool.indentation;
        this.inputEncoding = tool.inputEncoding;
        this.lineSeparator = tool.lineSeparator;
        this.listeners = tool.listeners != null ? new CopyOnWriteArrayList<Listener>(tool.listeners) : null;
        this.logLevel = tool.logLevel;
        this.model = tool.model != null ? tool.model.clone() : null;
        this.outputEncoding = tool.outputEncoding;
        this.defaultTemplateEncoding = tool.defaultTemplateEncoding;
        this.templateProfile = tool.templateProfile;
        this.velocityEngine = tool.velocityEngine;
        this.defaultVelocityEngine = tool.defaultVelocityEngine;
        this.locale = tool.locale;
        this.templateParameters = tool.templateParameters != null ? Collections.synchronizedMap(new HashMap<String, Object>(tool.templateParameters)) : null;
        this.templateLocation = tool.templateLocation != null ? new URL(tool.templateLocation.toExternalForm()) : null;
    }

    public List<Listener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<Listener>();
        }
        return this.listeners;
    }

    public static Level getDefaultLogLevel() {
        if (defaultLogLevel == null) {
            defaultLogLevel = Level.parse(System.getProperty("org.jomc.tools.JomcTool.defaultLogLevel", DEFAULT_LOG_LEVEL.getName()));
        }
        return defaultLogLevel;
    }

    public static void setDefaultLogLevel(Level value) {
        defaultLogLevel = value;
    }

    public final Level getLogLevel() {
        if (this.logLevel == null) {
            this.logLevel = JomcTool.getDefaultLogLevel();
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, JomcTool.getMessage("defaultLogLevelInfo", this.logLevel.getLocalizedName()), null);
            }
        }
        return this.logLevel;
    }

    public final void setLogLevel(Level value) {
        this.logLevel = value;
    }

    public boolean isLoggable(Level level) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        return level.intValue() >= this.getLogLevel().intValue();
    }

    @Deprecated
    public String getJavaPackageName(Specification specification) throws ModelObjectException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        JavaTypeName javaTypeName = specification.getJavaTypeName();
        return javaTypeName != null ? javaTypeName.getPackageName() : null;
    }

    @Deprecated
    public String getJavaTypeName(Specification specification, boolean qualified) throws ModelObjectException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        JavaTypeName javaTypeName = specification.getJavaTypeName();
        return javaTypeName != null ? javaTypeName.getName(qualified) : null;
    }

    @Deprecated
    public String getJavaClasspathLocation(Specification specification) throws ModelObjectException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        JavaTypeName javaTypeName = specification.getJavaTypeName();
        return javaTypeName != null ? javaTypeName.getQualifiedName().replace('.', '/') : null;
    }

    @Deprecated
    public String getJavaPackageName(SpecificationReference reference) throws ModelObjectException {
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        Specification s = null;
        String javaPackageName = null;
        if (this.getModules() != null && (s = this.getModules().getSpecification(reference.getIdentifier())) != null) {
            JavaTypeName javaTypeName = s.getJavaTypeName();
            javaPackageName = javaTypeName != null ? javaTypeName.getPackageName() : null;
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, JomcTool.getMessage("specificationNotFound", reference.getIdentifier()), null);
        }
        return javaPackageName;
    }

    @Deprecated
    public String getJavaTypeName(SpecificationReference reference, boolean qualified) throws ModelObjectException {
        if (reference == null) {
            throw new NullPointerException("reference");
        }
        Specification s = null;
        String typeName = null;
        if (this.getModules() != null && (s = this.getModules().getSpecification(reference.getIdentifier())) != null) {
            JavaTypeName javaTypeName = s.getJavaTypeName();
            typeName = javaTypeName != null ? javaTypeName.getName(qualified) : null;
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, JomcTool.getMessage("specificationNotFound", reference.getIdentifier()), null);
        }
        return typeName;
    }

    @Deprecated
    public String getJavaPackageName(Implementation implementation) throws ModelObjectException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        JavaTypeName javaTypeName = implementation.getJavaTypeName();
        return javaTypeName != null ? javaTypeName.getPackageName() : null;
    }

    @Deprecated
    public String getJavaTypeName(Implementation implementation, boolean qualified) throws ModelObjectException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        JavaTypeName javaTypeName = implementation.getJavaTypeName();
        return javaTypeName != null ? javaTypeName.getName(qualified) : null;
    }

    @Deprecated
    public String getJavaClasspathLocation(Implementation implementation) throws ModelObjectException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        JavaTypeName javaTypeName = implementation.getJavaTypeName();
        return javaTypeName != null ? javaTypeName.getQualifiedName().replace('.', '/') : null;
    }

    @Deprecated
    public List<String> getJavaInterfaceNames(Implementation implementation, boolean qualified) throws ModelObjectException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        return this.getImplementedJavaTypeNames(implementation, qualified);
    }

    @Deprecated
    public List<String> getImplementedJavaTypeNames(Implementation implementation, boolean qualified) throws ModelObjectException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        List col = null;
        if (this.getModules() != null) {
            List javaTypeNames = this.getModules().getImplementedJavaTypeNames(implementation.getIdentifier());
            if (javaTypeNames != null) {
                col = new ArrayList(javaTypeNames.size());
                int s0 = javaTypeNames.size();
                for (int i = 0; i < s0; ++i) {
                    if (col.contains(((JavaTypeName)javaTypeNames.get(i)).getName(qualified))) continue;
                    col.add(((JavaTypeName)javaTypeNames.get(i)).getName(qualified));
                }
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, JomcTool.getMessage("modulesNotFound", this.getModel().getIdentifier()), null);
        }
        return Collections.unmodifiableList(col != null ? col : Collections.emptyList());
    }

    @Deprecated
    public String getJavaTypeName(Argument argument) throws ModelObjectException {
        if (argument == null) {
            throw new NullPointerException("argument");
        }
        JavaTypeName javaTypeName = argument.getJavaTypeName();
        return javaTypeName != null ? javaTypeName.getName(true) : null;
    }

    @Deprecated
    public String getJavaMethodParameterName(Argument argument) throws ModelObjectException {
        if (argument == null) {
            throw new NullPointerException("argument");
        }
        return this.getJavaMethodParameterName(argument.getName());
    }

    @Deprecated
    public String getJavaTypeName(Property property, boolean boxify) throws ModelObjectException {
        if (property == null) {
            throw new NullPointerException("property");
        }
        JavaTypeName javaTypeName = property.getJavaTypeName();
        if (javaTypeName != null) {
            if (boxify && javaTypeName.isPrimitive()) {
                javaTypeName = javaTypeName.getBoxedName();
            }
            return javaTypeName.getName(true);
        }
        return null;
    }

    @Deprecated
    public boolean isJavaPrimitiveType(Property property) throws ModelObjectException {
        if (property == null) {
            throw new NullPointerException("property");
        }
        JavaTypeName javaTypeName = property.getJavaTypeName();
        return javaTypeName != null && javaTypeName.isPrimitive();
    }

    @Deprecated
    public String getJavaGetterMethodName(Property property) throws ModelObjectException {
        if (property == null) {
            throw new NullPointerException("property");
        }
        String prefix = "get";
        String javaTypeName = this.getJavaTypeName(property, true);
        if (Boolean.class.getName().equals(javaTypeName)) {
            prefix = "is";
        }
        return prefix + this.getJavaIdentifier(property.getName(), true);
    }

    @Deprecated
    public String getJavaSetterMethodName(Property property) throws ModelObjectException {
        if (property == null) {
            throw new NullPointerException("property");
        }
        return "set" + this.getJavaIdentifier(property.getName(), true);
    }

    @Deprecated
    public String getJavaMethodParameterName(Property property) throws ModelObjectException {
        if (property == null) {
            throw new NullPointerException("property");
        }
        return this.getJavaMethodParameterName(property.getName());
    }

    @Deprecated
    public String getJavaFieldName(Property property) throws ModelObjectException {
        if (property == null) {
            throw new NullPointerException("property");
        }
        return this.getJavaFieldName(property.getName());
    }

    @Deprecated
    public String getJavaTypeName(Dependency dependency) throws ModelObjectException {
        if (dependency == null) {
            throw new NullPointerException("dependency");
        }
        Specification s = null;
        StringBuilder typeName = null;
        String javaTypeName = null;
        try {
            if (this.getModules() != null && (s = this.getModules().getSpecification(dependency.getIdentifier())) != null) {
                if (s.getClazz() != null) {
                    typeName = new StringBuilder(s.getClazz().length());
                    typeName.append(this.getJavaTypeName(s, true));
                    if (s.getMultiplicity() == Multiplicity.MANY && dependency.getImplementationName() == null) {
                        typeName.append("[]");
                    }
                    javaTypeName = JavaTypeName.parse((String)typeName.toString()).getName(true);
                }
            } else if (this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, JomcTool.getMessage("specificationNotFound", dependency.getIdentifier()), null);
            }
            return javaTypeName;
        }
        catch (ParseException e) {
            throw new ModelObjectException(JomcTool.getMessage("dependencyJavaTypeNameParseException", typeName, JomcTool.getMessage(e)), (Throwable)e);
        }
    }

    @Deprecated
    public String getJavaGetterMethodName(Dependency dependency) throws ModelObjectException {
        if (dependency == null) {
            throw new NullPointerException("dependency");
        }
        return "get" + this.getJavaIdentifier(dependency.getName(), true);
    }

    @Deprecated
    public String getJavaSetterMethodName(Dependency dependency) throws ModelObjectException {
        if (dependency == null) {
            throw new NullPointerException("dependency");
        }
        return "set" + this.getJavaIdentifier(dependency.getName(), true);
    }

    @Deprecated
    public String getJavaMethodParameterName(Dependency dependency) throws ModelObjectException {
        if (dependency == null) {
            throw new NullPointerException("dependency");
        }
        return this.getJavaMethodParameterName(dependency.getName());
    }

    @Deprecated
    public String getJavaFieldName(Dependency dependency) throws ModelObjectException {
        if (dependency == null) {
            throw new NullPointerException("dependency");
        }
        return this.getJavaFieldName(dependency.getName());
    }

    @Deprecated
    public String getJavaGetterMethodName(Message message) throws ModelObjectException {
        if (message == null) {
            throw new NullPointerException("message");
        }
        return "get" + this.getJavaIdentifier(message.getName(), true);
    }

    @Deprecated
    public String getJavaSetterMethodName(Message message) throws ModelObjectException {
        if (message == null) {
            throw new NullPointerException("message");
        }
        return "set" + this.getJavaIdentifier(message.getName(), true);
    }

    @Deprecated
    public String getJavaMethodParameterName(Message message) throws ModelObjectException {
        if (message == null) {
            throw new NullPointerException("message");
        }
        return this.getJavaMethodParameterName(message.getName());
    }

    @Deprecated
    public String getJavaFieldName(Message message) throws ModelObjectException {
        if (message == null) {
            throw new NullPointerException("message");
        }
        return this.getJavaFieldName(message.getName());
    }

    @Deprecated
    public String getJavaModifierName(Implementation implementation, Dependency dependency) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (dependency == null) {
            throw new NullPointerException("dependency");
        }
        String modifierName = "private";
        if (this.getModules() != null && (modifierName = this.getModules().getDependencyJavaModifierName(implementation.getIdentifier(), dependency.getName())) == null) {
            modifierName = "private";
        }
        return modifierName;
    }

    @Deprecated
    public String getJavaModifierName(Implementation implementation, Message message) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (message == null) {
            throw new NullPointerException("message");
        }
        String modifierName = "private";
        if (this.getModules() != null && (modifierName = this.getModules().getMessageJavaModifierName(implementation.getIdentifier(), message.getName())) == null) {
            modifierName = "private";
        }
        return modifierName;
    }

    @Deprecated
    public String getJavaModifierName(Implementation implementation, Property property) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (property == null) {
            throw new NullPointerException("property");
        }
        String modifierName = "private";
        if (this.getModules() != null && (modifierName = this.getModules().getPropertyJavaModifierName(implementation.getIdentifier(), property.getName())) == null) {
            modifierName = "private";
        }
        return modifierName;
    }

    @Deprecated
    public String getJavadocComment(Text text, int indentationLevel, String linePrefix) throws ModelObjectException {
        if (text == null) {
            throw new NullPointerException("text");
        }
        if (linePrefix == null) {
            throw new NullPointerException("linePrefix");
        }
        if (indentationLevel < 0) {
            throw new IllegalArgumentException(Integer.toString(indentationLevel));
        }
        BufferedReader reader = null;
        boolean suppressExceptionOnClose = true;
        try {
            String javadoc = "";
            if (text.getValue() != null) {
                String line;
                String indent = this.getIndentation(indentationLevel);
                reader = new BufferedReader(new StringReader(text.getValue()));
                StringBuilder builder = new StringBuilder(text.getValue().length());
                while ((line = reader.readLine()) != null) {
                    builder.append(this.getLineSeparator()).append(indent).append(linePrefix).append(line.replaceAll("\\/\\*\\*", "/*").replaceAll("\\*/", "/"));
                }
                if (builder.length() > 0) {
                    javadoc = builder.substring(this.getLineSeparator().length() + indent.length() + linePrefix.length());
                    if (!text.getMimeType().match("text/html")) {
                        javadoc = StringEscapeUtils.escapeHtml((String)javadoc);
                    }
                }
            }
            suppressExceptionOnClose = false;
            String string = javadoc;
            return string;
        }
        catch (MimeTypeParseException e) {
            throw new AssertionError((Object)e);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                if (suppressExceptionOnClose) {
                    this.log(Level.SEVERE, JomcTool.getMessage(e), e);
                }
                throw new AssertionError((Object)e);
            }
        }
    }

    @Deprecated
    public String getJavadocComment(Texts texts, int indentationLevel, String linePrefix) throws ModelObjectException {
        if (texts == null) {
            throw new NullPointerException("texts");
        }
        if (linePrefix == null) {
            throw new NullPointerException("linePrefix");
        }
        if (indentationLevel < 0) {
            throw new IllegalArgumentException(Integer.toString(indentationLevel));
        }
        return this.getJavadocComment(texts.getText(this.getLocale().getLanguage()), indentationLevel, linePrefix);
    }

    public String getJavaString(String str) {
        return StringEscapeUtils.escapeJava((String)str);
    }

    @Deprecated
    public String getJavaClasspathLocation(String str, boolean absolute) {
        String classpathLocation = null;
        if (str != null) {
            classpathLocation = str.replace('.', '/');
            if (absolute) {
                classpathLocation = "/" + classpathLocation;
            }
        }
        return classpathLocation;
    }

    @Deprecated
    public String getJavaIdentifier(String str, boolean capitalize) {
        String identifier = null;
        if (str != null) {
            int len = str.length();
            StringBuilder builder = new StringBuilder(len);
            boolean uc = capitalize;
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                String charString = Character.toString(c);
                if (builder.length() > 0) {
                    if (Character.isJavaIdentifierPart(c)) {
                        builder.append(uc ? charString.toUpperCase(this.getLocale()) : charString);
                        uc = false;
                        continue;
                    }
                    uc = true;
                    continue;
                }
                if (Character.isJavaIdentifierStart(c)) {
                    builder.append(uc ? charString.toUpperCase(this.getLocale()) : charString.toLowerCase(this.getLocale()));
                    uc = false;
                    continue;
                }
                uc = capitalize;
            }
            identifier = builder.toString();
            if (identifier.length() <= 0 && this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, JomcTool.getMessage("invalidJavaIdentifier", str), null);
            }
        }
        return identifier;
    }

    @Deprecated
    public String getJavaMethodParameterName(String str) {
        String methodParameterName = null;
        if (str != null) {
            int len = str.length();
            StringBuilder builder = new StringBuilder(len);
            boolean uc = false;
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                String charString = Character.toString(c);
                if (builder.length() > 0) {
                    if (Character.isJavaIdentifierPart(c)) {
                        builder.append(uc ? charString.toUpperCase(this.getLocale()) : charString);
                        uc = false;
                        continue;
                    }
                    uc = true;
                    continue;
                }
                if (!Character.isJavaIdentifierStart(c)) continue;
                builder.append(charString.toLowerCase(this.getLocale()));
            }
            methodParameterName = builder.toString();
            if (methodParameterName.length() <= 0 && this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, JomcTool.getMessage("invalidJavaMethodParameterName", str), null);
            }
            if (this.getJavaKeywords().contains(methodParameterName)) {
                methodParameterName = "_" + methodParameterName;
            }
        }
        return methodParameterName;
    }

    @Deprecated
    public String getJavaFieldName(String str) {
        String fieldName = null;
        if (str != null) {
            int len = str.length();
            StringBuilder builder = new StringBuilder(len);
            boolean uc = false;
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                String charString = Character.toString(c);
                if (builder.length() > 0) {
                    if (Character.isJavaIdentifierPart(c)) {
                        builder.append(uc ? charString.toUpperCase(this.getLocale()) : charString);
                        uc = false;
                        continue;
                    }
                    uc = true;
                    continue;
                }
                if (!Character.isJavaIdentifierStart(c)) continue;
                builder.append(charString.toLowerCase(this.getLocale()));
            }
            fieldName = builder.toString();
            if (fieldName.length() <= 0 && this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, JomcTool.getMessage("invalidJavaFieldName", str), null);
            }
            if (this.getJavaKeywords().contains(fieldName)) {
                fieldName = "_" + fieldName;
            }
        }
        return fieldName;
    }

    @Deprecated
    public String getJavaConstantName(String str) {
        String name = null;
        if (str != null) {
            int len = str.length();
            StringBuilder builder = new StringBuilder(len);
            boolean separator = false;
            for (int i = 0; i < len; ++i) {
                char c = str.charAt(i);
                if (builder.length() > 0 ? Character.isJavaIdentifierPart(c) : Character.isJavaIdentifierStart(c)) {
                    if (builder.length() > 0) {
                        if (!separator) {
                            char previous = builder.charAt(builder.length() - 1);
                            boolean bl = separator = Character.isLowerCase(previous) && Character.isUpperCase(c);
                        }
                        if (separator) {
                            builder.append('_');
                        }
                    }
                    builder.append(c);
                    separator = false;
                    continue;
                }
                separator = true;
            }
            name = builder.toString().toUpperCase(this.getLocale());
            if (name.length() <= 0 && this.isLoggable(Level.WARNING)) {
                this.log(Level.WARNING, JomcTool.getMessage("invalidJavaConstantName", str), null);
            }
        }
        return name;
    }

    public JavaIdentifier toJavaConstantName(String str) throws ParseException {
        JavaIdentifier constantName = null;
        if (str != null) {
            constantName = JavaIdentifier.normalize((String)str, (JavaIdentifier.NormalizationMode)JavaIdentifier.NormalizationMode.CONSTANT_NAME_CONVENTION);
        }
        return constantName;
    }

    public JavaIdentifier toJavaMethodName(String str) throws ParseException {
        JavaIdentifier variableName = null;
        if (str != null) {
            variableName = JavaIdentifier.normalize((String)str, (JavaIdentifier.NormalizationMode)JavaIdentifier.NormalizationMode.METHOD_NAME_CONVENTION);
        }
        return variableName;
    }

    public JavaIdentifier toJavaVariableName(String str) throws ParseException {
        JavaIdentifier variableName = null;
        if (str != null) {
            variableName = JavaIdentifier.normalize((String)str, (JavaIdentifier.NormalizationMode)JavaIdentifier.NormalizationMode.VARIABLE_NAME_CONVENTION);
        }
        return variableName;
    }

    @Deprecated
    public boolean isJavaDefaultPackage(Specification specification) throws ModelObjectException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        JavaTypeName javaTypeName = specification.getJavaTypeName();
        return javaTypeName != null && javaTypeName.isUnnamedPackage();
    }

    @Deprecated
    public boolean isJavaDefaultPackage(Implementation implementation) throws ModelObjectException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        JavaTypeName javaTypeName = implementation.getJavaTypeName();
        return javaTypeName != null && javaTypeName.isUnnamedPackage();
    }

    public String getHtmlString(String str) {
        return str != null ? str.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("*", "&lowast;") : null;
    }

    public String getXmlString(String str) {
        return StringEscapeUtils.escapeXml((String)str);
    }

    public String getJavaScriptString(String str) {
        return StringEscapeUtils.escapeJavaScript((String)str);
    }

    public String getSqlString(String str) {
        return StringEscapeUtils.escapeSql((String)str);
    }

    public String getCsvString(String str) {
        return StringEscapeUtils.escapeCsv((String)str);
    }

    public String getBooleanString(Boolean b) {
        MessageFormat messageFormat = new MessageFormat(ResourceBundle.getBundle(JomcTool.class.getName().replace('.', '/'), this.getLocale()).getString(b != false ? "booleanStringTrue" : "booleanStringFalse"), this.getLocale());
        return messageFormat.format(null);
    }

    public String getDisplayLanguage(String language) {
        if (language == null) {
            throw new NullPointerException("language");
        }
        Locale l = new Locale(language);
        return l.getDisplayLanguage(l);
    }

    public String getShortDate(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return DateFormat.getDateInstance(3, this.getLocale()).format(calendar.getTime());
    }

    public String getMediumDate(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return DateFormat.getDateInstance(2, this.getLocale()).format(calendar.getTime());
    }

    public String getLongDate(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return DateFormat.getDateInstance(1, this.getLocale()).format(calendar.getTime());
    }

    public String getIsoDate(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return new SimpleDateFormat("yyyy-DDD", this.getLocale()).format(calendar.getTime());
    }

    public String getShortTime(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return DateFormat.getTimeInstance(3, this.getLocale()).format(calendar.getTime());
    }

    public String getMediumTime(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return DateFormat.getTimeInstance(2, this.getLocale()).format(calendar.getTime());
    }

    public String getLongTime(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return DateFormat.getTimeInstance(1, this.getLocale()).format(calendar.getTime());
    }

    public String getIsoTime(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return new SimpleDateFormat("HH:mm", this.getLocale()).format(calendar.getTime());
    }

    public String getShortDateTime(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return DateFormat.getDateTimeInstance(3, 3, this.getLocale()).format(calendar.getTime());
    }

    public String getMediumDateTime(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return DateFormat.getDateTimeInstance(2, 2, this.getLocale()).format(calendar.getTime());
    }

    public String getLongDateTime(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return DateFormat.getDateTimeInstance(1, 1, this.getLocale()).format(calendar.getTime());
    }

    public String getIsoDateTime(Calendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar");
        }
        return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", this.getLocale()).format(calendar.getTime());
    }

    public String getYears(Calendar start, Calendar end) {
        if (start == null) {
            throw new NullPointerException("start");
        }
        if (end == null) {
            throw new NullPointerException("end");
        }
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy", this.getLocale());
        int s = start.get(1);
        int e = end.get(1);
        StringBuilder years = new StringBuilder();
        if (s != e) {
            if (s < e) {
                years.append(yearFormat.format((Object)start.getTime())).append(" - ").append(yearFormat.format((Object)end.getTime()));
            } else {
                years.append(yearFormat.format((Object)end.getTime())).append(" - ").append(yearFormat.format((Object)start.getTime()));
            }
        } else {
            years.append(yearFormat.format((Object)start.getTime()));
        }
        return years.toString();
    }

    public final Model getModel() {
        if (this.model == null) {
            this.model = new Model();
            this.model.setIdentifier("http://jomc.org/model");
        }
        return this.model;
    }

    public final void setModel(Model value) {
        this.model = value;
    }

    public final Modules getModules() {
        return ModelHelper.getModules((Model)this.getModel());
    }

    public final VelocityEngine getVelocityEngine() throws IOException {
        if (this.velocityEngine == null) {
            VelocityEngine engine = new VelocityEngine();
            engine.setProperty("runtime.references.strict", (Object)Boolean.TRUE.toString());
            engine.setProperty("velocimacro.arguments.strict", (Object)Boolean.TRUE.toString());
            engine.setProperty("runtime.strict.math", (Object)Boolean.TRUE.toString());
            class JomcLogChute
            implements LogChute {
                JomcLogChute() {
                }

                public void init(RuntimeServices runtimeServices) throws Exception {
                }

                public void log(int level, String message) {
                    this.log(level, message, null);
                }

                public void log(int level, String message, Throwable throwable) {
                    JomcTool.this.log(Level.FINEST, message, throwable);
                }

                public boolean isLevelEnabled(int level) {
                    return JomcTool.this.isLoggable(Level.FINEST);
                }
            }
            engine.setProperty("runtime.log.logsystem", (Object)new JomcLogChute());
            engine.setProperty("resource.loader", (Object)"class");
            engine.setProperty("class.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            engine.setProperty("class.resource.loader.cache", (Object)Boolean.TRUE.toString());
            if (this.getTemplateLocation() != null) {
                engine.setProperty("resource.loader", (Object)"class,url");
                engine.setProperty("url.resource.loader.class", (Object)URLResourceLoader.class.getName());
                engine.setProperty("url.resource.loader.cache", (Object)Boolean.TRUE.toString());
                engine.setProperty("url.resource.loader.root", (Object)this.getTemplateLocation().toExternalForm());
                engine.setProperty("url.resource.loader.timeout", (Object)Integer.toString(60000));
            }
            this.velocityEngine = engine;
            this.defaultVelocityEngine = true;
        }
        return this.velocityEngine;
    }

    public final void setVelocityEngine(VelocityEngine value) {
        this.velocityEngine = value;
        this.defaultVelocityEngine = false;
    }

    public VelocityContext getVelocityContext() throws IOException {
        Calendar now = Calendar.getInstance();
        VelocityContext ctx = new VelocityContext(new HashMap<String, Object>(this.getTemplateParameters()));
        this.mergeTemplateProfileContextProperties(this.getTemplateProfile(), this.getLocale().getLanguage(), ctx);
        this.mergeTemplateProfileContextProperties(this.getTemplateProfile(), null, ctx);
        Model clonedModel = this.getModel().clone();
        Modules clonedModules = ModelHelper.getModules((Model)clonedModel);
        assert (clonedModules != null) : "Unexpected missing modules for model '" + clonedModel.getIdentifier() + "'.";
        ctx.put("model", (Object)clonedModel);
        ctx.put("modules", (Object)clonedModules);
        ctx.put("imodel", (Object)new InheritanceModel(clonedModules));
        ctx.put("tool", (Object)this);
        ctx.put("toolName", (Object)this.getClass().getName());
        ctx.put("toolVersion", (Object)JomcTool.getMessage("projectVersion", new Object[0]));
        ctx.put("toolUrl", (Object)JomcTool.getMessage("projectUrl", new Object[0]));
        ctx.put("calendar", (Object)now.getTime());
        ctx.put("now", (Object)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", this.getLocale()).format(now.getTime()));
        ctx.put("year", (Object)new SimpleDateFormat("yyyy", this.getLocale()).format(now.getTime()));
        ctx.put("month", (Object)new SimpleDateFormat("MM", this.getLocale()).format(now.getTime()));
        ctx.put("day", (Object)new SimpleDateFormat("dd", this.getLocale()).format(now.getTime()));
        ctx.put("hour", (Object)new SimpleDateFormat("HH", this.getLocale()).format(now.getTime()));
        ctx.put("minute", (Object)new SimpleDateFormat("mm", this.getLocale()).format(now.getTime()));
        ctx.put("second", (Object)new SimpleDateFormat("ss", this.getLocale()).format(now.getTime()));
        ctx.put("timezone", (Object)new SimpleDateFormat("Z", this.getLocale()).format(now.getTime()));
        ctx.put("shortDate", (Object)this.getShortDate(now));
        ctx.put("mediumDate", (Object)this.getMediumDate(now));
        ctx.put("longDate", (Object)this.getLongDate(now));
        ctx.put("isoDate", (Object)this.getIsoDate(now));
        ctx.put("shortTime", (Object)this.getShortTime(now));
        ctx.put("mediumTime", (Object)this.getMediumTime(now));
        ctx.put("longTime", (Object)this.getLongTime(now));
        ctx.put("isoTime", (Object)this.getIsoTime(now));
        ctx.put("shortDateTime", (Object)this.getShortDateTime(now));
        ctx.put("mediumDateTime", (Object)this.getMediumDateTime(now));
        ctx.put("longDateTime", (Object)this.getLongDateTime(now));
        ctx.put("isoDateTime", (Object)this.getIsoDateTime(now));
        return ctx;
    }

    public final Map<String, Object> getTemplateParameters() {
        if (this.templateParameters == null) {
            this.templateParameters = Collections.synchronizedMap(new HashMap());
        }
        return this.templateParameters;
    }

    public final URL getTemplateLocation() {
        return this.templateLocation;
    }

    public final void setTemplateLocation(URL value) {
        this.templateLocation = value;
        this.templateProfileContextPropertiesCache = null;
        this.templateProfilePropertiesCache = null;
        if (this.defaultVelocityEngine) {
            this.setVelocityEngine(null);
        }
    }

    @Deprecated
    public final String getTemplateEncoding() {
        return this.getDefaultTemplateEncoding();
    }

    @Deprecated
    public final void setTemplateEncoding(String value) {
        this.setDefaultTemplateEncoding(value);
    }

    public final String getDefaultTemplateEncoding() {
        if (this.defaultTemplateEncoding == null) {
            this.defaultTemplateEncoding = JomcTool.getMessage("buildSourceEncoding", new Object[0]);
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, JomcTool.getMessage("defaultTemplateEncoding", this.defaultTemplateEncoding), null);
            }
        }
        return this.defaultTemplateEncoding;
    }

    public final void setDefaultTemplateEncoding(String value) {
        this.defaultTemplateEncoding = value;
        this.templateCache = null;
    }

    public final String getTemplateEncoding(String tp) {
        String te;
        block3: {
            if (tp == null) {
                throw new NullPointerException("tp");
            }
            te = null;
            try {
                te = this.getTemplateProfileProperties(tp).getProperty(TEMPLATE_ENCODING_PROFILE_PROPERTY_NAME);
            }
            catch (IOException e) {
                if (!this.isLoggable(Level.SEVERE)) break block3;
                this.log(Level.SEVERE, JomcTool.getMessage(e), e);
            }
        }
        return te != null ? te : this.getDefaultTemplateEncoding();
    }

    public final String getInputEncoding() {
        if (this.inputEncoding == null) {
            this.inputEncoding = new InputStreamReader(new ByteArrayInputStream(NO_BYTES)).getEncoding();
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, JomcTool.getMessage("defaultInputEncoding", this.inputEncoding), null);
            }
        }
        return this.inputEncoding;
    }

    public final void setInputEncoding(String value) {
        this.inputEncoding = value;
    }

    public final String getOutputEncoding() {
        if (this.outputEncoding == null) {
            this.outputEncoding = new OutputStreamWriter(new ByteArrayOutputStream()).getEncoding();
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, JomcTool.getMessage("defaultOutputEncoding", this.outputEncoding), null);
            }
        }
        return this.outputEncoding;
    }

    public final void setOutputEncoding(String value) {
        this.outputEncoding = value;
    }

    @Deprecated
    public static String getDefaultTemplateProfile() {
        if (defaultTemplateProfile == null) {
            defaultTemplateProfile = System.getProperty("org.jomc.tools.JomcTool.defaultTemplateProfile", DEFAULT_TEMPLATE_PROFILE);
        }
        return defaultTemplateProfile;
    }

    @Deprecated
    public static void setDefaultTemplateProfile(String value) {
        defaultTemplateProfile = value;
    }

    public final String getTemplateProfile() {
        if (this.templateProfile == null) {
            this.templateProfile = JomcTool.getDefaultTemplateProfile();
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, JomcTool.getMessage("defaultTemplateProfile", this.templateProfile), null);
            }
        }
        return this.templateProfile;
    }

    public final void setTemplateProfile(String value) {
        this.templateProfile = value;
    }

    public final String getParentTemplateProfile(String tp) {
        String parentTemplateProfile;
        block3: {
            if (tp == null) {
                throw new NullPointerException("tp");
            }
            parentTemplateProfile = null;
            try {
                parentTemplateProfile = this.getTemplateProfileProperties(tp).getProperty(PARENT_TEMPLATE_PROFILE_PROPERTY_NAME);
            }
            catch (IOException e) {
                if (!this.isLoggable(Level.SEVERE)) break block3;
                this.log(Level.SEVERE, JomcTool.getMessage(e), e);
            }
        }
        return parentTemplateProfile != null ? parentTemplateProfile : (tp.equals(this.getDefaultTemplateProfile()) ? null : this.getDefaultTemplateProfile());
    }

    public final String getIndentation() {
        if (this.indentation == null) {
            this.indentation = "    ";
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, JomcTool.getMessage("defaultIndentation", StringEscapeUtils.escapeJava((String)this.indentation)), null);
            }
        }
        return this.indentation;
    }

    public final String getIndentation(int level) {
        String key;
        String idt;
        Map<String, String> map;
        if (level < 0) {
            throw new IllegalArgumentException(Integer.toString(level));
        }
        Map<String, String> map2 = map = this.indentationCache == null ? null : this.indentationCache.get();
        if (map == null) {
            map = new ConcurrentHashMap<String, String>(8);
            this.indentationCache = new SoftReference<Map<String, String>>(map);
        }
        if ((idt = map.get(key = this.getIndentation() + "|" + level)) == null) {
            StringBuilder b = new StringBuilder(this.getIndentation().length() * level);
            for (int i = level; i > 0; --i) {
                b.append(this.getIndentation());
            }
            idt = b.toString();
            map.put(key, idt);
        }
        return idt;
    }

    public final void setIndentation(String value) {
        this.indentation = value;
    }

    public final String getLineSeparator() {
        if (this.lineSeparator == null) {
            this.lineSeparator = System.getProperty("line.separator", "\n");
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, JomcTool.getMessage("defaultLineSeparator", StringEscapeUtils.escapeJava((String)this.lineSeparator)), null);
            }
        }
        return this.lineSeparator;
    }

    public final void setLineSeparator(String value) {
        this.lineSeparator = value;
    }

    public final Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.ENGLISH;
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, JomcTool.getMessage("defaultLocale", this.locale), null);
            }
        }
        return this.locale;
    }

    public final void setLocale(Locale value) {
        this.locale = value;
    }

    public Template getVelocityTemplate(String templateName) throws FileNotFoundException, IOException {
        if (templateName == null) {
            throw new NullPointerException("templateName");
        }
        return this.getVelocityTemplate(this.getTemplateProfile(), templateName);
    }

    public void log(Level level, String message, Throwable throwable) {
        if (level == null) {
            throw new NullPointerException("level");
        }
        if (this.isLoggable(level)) {
            for (int i = this.getListeners().size() - 1; i >= 0; --i) {
                this.getListeners().get(i).onLog(level, message, throwable);
            }
        }
    }

    private Template findVelocityTemplate(String location, String encoding) throws IOException {
        try {
            return this.getVelocityEngine().getTemplate(location, encoding);
        }
        catch (ResourceNotFoundException e) {
            if (this.isLoggable(Level.FINER)) {
                this.log(Level.FINER, JomcTool.getMessage("templateNotFound", location), null);
            }
            return null;
        }
        catch (ParseErrorException e) {
            String m = JomcTool.getMessage(e);
            m = m == null ? "" : " " + m;
            throw (IOException)new IOException(JomcTool.getMessage("invalidTemplate", location, m)).initCause(e);
        }
        catch (VelocityException e) {
            String m = JomcTool.getMessage(e);
            m = m == null ? "" : " " + m;
            throw (IOException)new IOException(JomcTool.getMessage("velocityException", location, m)).initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getTemplateProfileContextProperties(String profileName, String language) throws IOException {
        Map<String, Properties> map;
        Map<String, Properties> map2 = map = this.templateProfileContextPropertiesCache == null ? null : this.templateProfileContextPropertiesCache.get();
        if (map == null) {
            map = new ConcurrentHashMap<String, Properties>();
            this.templateProfileContextPropertiesCache = new SoftReference<Map<String, Properties>>(map);
        }
        String key = profileName + "|" + language;
        Properties profileProperties = map.get(key);
        boolean suppressExceptionOnClose = true;
        if (profileProperties == null) {
            InputStream in = null;
            URL url = null;
            profileProperties = new Properties();
            String resourceName = TEMPLATE_PREFIX + profileName + (language == null ? "" : "/" + language) + "/context.properties";
            try {
                url = this.getClass().getResource("/" + resourceName);
                if (url != null) {
                    in = url.openStream();
                    if (this.isLoggable(Level.CONFIG)) {
                        this.log(Level.CONFIG, JomcTool.getMessage("contextPropertiesFound", url.toExternalForm()), null);
                    }
                    profileProperties.load(in);
                } else if (this.getTemplateLocation() != null) {
                    if (this.isLoggable(Level.CONFIG)) {
                        this.log(Level.CONFIG, JomcTool.getMessage("contextPropertiesNotFound", resourceName), null);
                    }
                    url = new URL(this.getTemplateLocation(), resourceName);
                    in = url.openStream();
                    if (this.isLoggable(Level.CONFIG)) {
                        this.log(Level.CONFIG, JomcTool.getMessage("contextPropertiesFound", url.toExternalForm()), null);
                    }
                    profileProperties.load(in);
                } else if (this.isLoggable(Level.CONFIG)) {
                    this.log(Level.CONFIG, JomcTool.getMessage("contextPropertiesNotFound", resourceName), null);
                }
                suppressExceptionOnClose = false;
            }
            catch (FileNotFoundException e) {
                if (this.isLoggable(Level.CONFIG)) {
                    this.log(Level.CONFIG, JomcTool.getMessage("contextPropertiesNotFound", url.toExternalForm()), null);
                }
            }
            finally {
                map.put(key, profileProperties);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    if (suppressExceptionOnClose) {
                        this.log(Level.SEVERE, JomcTool.getMessage(e), e);
                    }
                    throw e;
                }
            }
        }
        return profileProperties;
    }

    private void mergeTemplateProfileContextProperties(String profileName, String language, VelocityContext velocityContext) throws IOException {
        if (profileName != null) {
            Properties templateProfileProperties = this.getTemplateProfileContextProperties(profileName, language);
            Enumeration<?> e = templateProfileProperties.propertyNames();
            while (e.hasMoreElements()) {
                String name = e.nextElement().toString();
                String value = templateProfileProperties.getProperty(name);
                String[] values = value.split("\\|");
                if (velocityContext.containsKey((Object)name)) continue;
                String className = values[0];
                try {
                    if (values.length > 1) {
                        Class<?> valueClass = Class.forName(className);
                        velocityContext.put(name, valueClass.getConstructor(String.class).newInstance(values[1]));
                        continue;
                    }
                    if (value.contains("|")) {
                        velocityContext.put(name, Class.forName(values[0]).newInstance());
                        continue;
                    }
                    velocityContext.put(name, (Object)value);
                }
                catch (InstantiationException ex) {
                    throw (IOException)new IOException(JomcTool.getMessage("contextPropertiesException", profileName + (language != null ? ", " + language : ""))).initCause(ex);
                }
                catch (IllegalAccessException ex) {
                    throw (IOException)new IOException(JomcTool.getMessage("contextPropertiesException", profileName + (language != null ? ", " + language : ""))).initCause(ex);
                }
                catch (InvocationTargetException ex) {
                    throw (IOException)new IOException(JomcTool.getMessage("contextPropertiesException", profileName + (language != null ? ", " + language : ""))).initCause(ex);
                }
                catch (NoSuchMethodException ex) {
                    throw (IOException)new IOException(JomcTool.getMessage("contextPropertiesException", profileName + (language != null ? ", " + language : ""))).initCause(ex);
                }
                catch (ClassNotFoundException ex) {
                    throw (IOException)new IOException(JomcTool.getMessage("contextPropertiesException", profileName + (language != null ? ", " + language : ""))).initCause(ex);
                }
            }
            this.mergeTemplateProfileContextProperties(this.getParentTemplateProfile(profileName), language, velocityContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getTemplateProfileProperties(String profileName) throws IOException {
        Map<String, Properties> map;
        Map<String, Properties> map2 = map = this.templateProfilePropertiesCache == null ? null : this.templateProfilePropertiesCache.get();
        if (map == null) {
            map = new ConcurrentHashMap<String, Properties>();
            this.templateProfilePropertiesCache = new SoftReference<Map<String, Properties>>(map);
        }
        Properties profileProperties = map.get(profileName);
        boolean suppressExceptionOnClose = true;
        if (profileProperties == null) {
            InputStream in = null;
            profileProperties = new Properties();
            String resourceName = TEMPLATE_PREFIX + profileName + "/profile.properties";
            URL url = null;
            try {
                url = this.getClass().getResource("/" + resourceName);
                if (url != null) {
                    in = url.openStream();
                    if (this.isLoggable(Level.CONFIG)) {
                        this.log(Level.CONFIG, JomcTool.getMessage("templateProfilePropertiesFound", url.toExternalForm()), null);
                    }
                    profileProperties.load(in);
                } else if (this.getTemplateLocation() != null) {
                    if (this.isLoggable(Level.CONFIG)) {
                        this.log(Level.CONFIG, JomcTool.getMessage("templateProfilePropertiesNotFound", resourceName), null);
                    }
                    url = new URL(this.getTemplateLocation(), resourceName);
                    in = url.openStream();
                    if (this.isLoggable(Level.CONFIG)) {
                        this.log(Level.CONFIG, JomcTool.getMessage("templateProfilePropertiesFound", url.toExternalForm()), null);
                    }
                    profileProperties.load(in);
                } else if (this.isLoggable(Level.CONFIG)) {
                    this.log(Level.CONFIG, JomcTool.getMessage("templateProfilePropertiesNotFound", resourceName), null);
                }
                suppressExceptionOnClose = false;
            }
            catch (FileNotFoundException e) {
                if (this.isLoggable(Level.CONFIG)) {
                    this.log(Level.CONFIG, JomcTool.getMessage("templateProfilePropertiesNotFound", url.toExternalForm()), null);
                }
            }
            finally {
                map.put(profileName, profileProperties);
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException e) {
                    if (suppressExceptionOnClose) {
                        this.log(Level.SEVERE, JomcTool.getMessage(e), e);
                    }
                    throw e;
                }
            }
        }
        return profileProperties;
    }

    private Set<String> getJavaKeywords() {
        Reader in = null;
        Set<String> set = this.javaKeywordsCache == null ? null : this.javaKeywordsCache.get();
        try {
            if (set == null) {
                in = new InputStreamReader(this.getClass().getResourceAsStream("/" + this.getClass().getPackage().getName().replace(".", "/") + "/JavaKeywords.txt"), "UTF-8");
                set = new CopyOnWriteArraySet<String>(IOUtils.readLines((Reader)in));
                this.javaKeywordsCache = new SoftReference<Set<String>>(set);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(JomcTool.getMessage(e), e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(JomcTool.getMessage(e), e);
            }
        }
        return set;
    }

    private Template getVelocityTemplate(String tp, String tn) throws IOException {
        Template template = null;
        if (tp != null) {
            TemplateData templateData;
            Map<String, TemplateData> map;
            String key = this.getLocale() + "|" + this.getTemplateProfile() + "|" + this.getDefaultTemplateProfile() + "|" + tn;
            Map<String, TemplateData> map2 = map = this.templateCache == null ? null : this.templateCache.get();
            if (map == null) {
                map = new ConcurrentHashMap<String, TemplateData>(32);
                this.templateCache = new SoftReference<Map<String, TemplateData>>(map);
            }
            if ((templateData = map.get(key)) == null) {
                templateData = new TemplateData();
                if (!"".equals(this.getLocale().getLanguage())) {
                    templateData.location = JomcTool.TEMPLATE_PREFIX + tp + "/" + this.getLocale().getLanguage() + "/" + tn;
                    templateData.template = this.findVelocityTemplate(templateData.location, this.getTemplateEncoding(tp));
                }
                if (templateData.template == null) {
                    templateData.location = JomcTool.TEMPLATE_PREFIX + tp + "/" + tn;
                    templateData.template = this.findVelocityTemplate(templateData.location, this.getTemplateEncoding(tp));
                }
                if (templateData.template == null) {
                    template = this.getVelocityTemplate(this.getParentTemplateProfile(tp), tn);
                    if (template == null) {
                        map.put(key, new TemplateData());
                        throw new FileNotFoundException(JomcTool.getMessage("noSuchTemplate", tn));
                    }
                } else {
                    if (this.isLoggable(Level.FINER)) {
                        this.log(Level.FINER, JomcTool.getMessage("templateInfo", tn, templateData.location), null);
                    }
                    template = templateData.template;
                    map.put(key, templateData);
                }
            } else {
                if (templateData.template == null) {
                    throw new FileNotFoundException(JomcTool.getMessage("noSuchTemplate", tn));
                }
                if (this.isLoggable(Level.FINER)) {
                    this.log(Level.FINER, JomcTool.getMessage("templateInfo", tn, templateData.location), null);
                }
                template = templateData.template;
            }
        }
        return template;
    }

    private static String getMessage(String key, Object ... arguments) {
        return MessageFormat.format(ResourceBundle.getBundle(JomcTool.class.getName().replace('.', '/')).getString(key), arguments);
    }

    private static String getMessage(Throwable t) {
        return t != null ? (t.getMessage() != null && t.getMessage().trim().length() > 0 ? t.getMessage() : JomcTool.getMessage(t.getCause())) : null;
    }

    static {
        DEFAULT_LOG_LEVEL = Level.WARNING;
    }

    private static class TemplateData {
        private String location;
        private Template template;

        private TemplateData() {
        }
    }

    public static abstract class Listener {
        public void onLog(Level level, String message, Throwable throwable) {
            if (level == null) {
                throw new NullPointerException("level");
            }
        }
    }
}

