/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.velocity.VelocityContext;
import org.jomc.model.Implementation;
import org.jomc.model.JavaTypeName;
import org.jomc.model.Message;
import org.jomc.model.Messages;
import org.jomc.model.ModelObjectException;
import org.jomc.model.Module;
import org.jomc.model.Specification;
import org.jomc.model.Text;
import org.jomc.tools.JomcTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFileProcessor
extends JomcTool {
    private Locale resourceBundleDefaultLocale;

    public ResourceFileProcessor() {
    }

    public ResourceFileProcessor(ResourceFileProcessor tool) throws IOException {
        super(tool);
        this.resourceBundleDefaultLocale = tool.resourceBundleDefaultLocale;
    }

    public final Locale getResourceBundleDefaultLocale() {
        if (this.resourceBundleDefaultLocale == null) {
            this.resourceBundleDefaultLocale = Locale.ENGLISH;
            if (this.isLoggable(Level.CONFIG)) {
                this.log(Level.CONFIG, ResourceFileProcessor.getMessage("defaultResourceBundleDefaultLocale", this.resourceBundleDefaultLocale), null);
            }
        }
        return this.resourceBundleDefaultLocale;
    }

    public final void setResourceBundleDefaultLocale(Locale value) {
        this.resourceBundleDefaultLocale = value;
    }

    public void writeResourceBundleResourceFiles(File resourcesDirectory) throws IOException, ModelObjectException {
        if (resourcesDirectory == null) {
            throw new NullPointerException("resourcesDirectory");
        }
        if (this.getModules() != null) {
            int s0 = this.getModules().getModule().size();
            for (int i = 0; i < s0; ++i) {
                this.writeResourceBundleResourceFiles((Module)this.getModules().getModule().get(i), resourcesDirectory);
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, ResourceFileProcessor.getMessage("modulesNotFound", this.getModel().getIdentifier()), null);
        }
    }

    public void writeResourceBundleResourceFiles(Module module, File resourcesDirectory) throws IOException, ModelObjectException {
        if (module == null) {
            throw new NullPointerException("module");
        }
        if (resourcesDirectory == null) {
            throw new NullPointerException("resourcesDirectory");
        }
        if (this.getModules() != null && this.getModules().getModule(module.getName()) != null) {
            int i;
            int s0;
            if (module.getSpecifications() != null) {
                s0 = module.getSpecifications().getSpecification().size();
                for (i = 0; i < s0; ++i) {
                    this.writeResourceBundleResourceFiles((Specification)module.getSpecifications().getSpecification().get(i), resourcesDirectory);
                }
            }
            if (module.getImplementations() != null) {
                s0 = module.getImplementations().getImplementation().size();
                for (i = 0; i < s0; ++i) {
                    this.writeResourceBundleResourceFiles((Implementation)module.getImplementations().getImplementation().get(i), resourcesDirectory);
                }
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, ResourceFileProcessor.getMessage("moduleNotFound", module.getName()), null);
        }
    }

    public void writeResourceBundleResourceFiles(Specification specification, File resourcesDirectory) throws IOException, ModelObjectException {
        if (specification == null) {
            throw new NullPointerException("implementation");
        }
        if (resourcesDirectory == null) {
            throw new NullPointerException("resourcesDirectory");
        }
        if (this.getModules() != null && this.getModules().getSpecification(specification.getIdentifier()) != null) {
            if (specification.isClassDeclaration()) {
                if (!resourcesDirectory.isDirectory()) {
                    throw new IOException(ResourceFileProcessor.getMessage("directoryNotFound", resourcesDirectory.getAbsolutePath()));
                }
                this.assertValidTemplates(specification);
                JavaTypeName javaTypeName = specification.getJavaTypeName();
                if (javaTypeName != null) {
                    String bundlePath = javaTypeName.getQualifiedName().replace('.', File.separatorChar);
                    this.writeResourceBundleResourceFiles(this.getResourceBundleResources(specification), resourcesDirectory, bundlePath);
                }
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, ResourceFileProcessor.getMessage("specificationNotFound", specification.getIdentifier()), null);
        }
    }

    public void writeResourceBundleResourceFiles(Implementation implementation, File resourcesDirectory) throws IOException, ModelObjectException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (resourcesDirectory == null) {
            throw new NullPointerException("resourcesDirectory");
        }
        if (this.getModules() != null && this.getModules().getImplementation(implementation.getIdentifier()) != null) {
            if (implementation.isClassDeclaration()) {
                if (!resourcesDirectory.isDirectory()) {
                    throw new IOException(ResourceFileProcessor.getMessage("directoryNotFound", resourcesDirectory.getAbsolutePath()));
                }
                this.assertValidTemplates(implementation);
                JavaTypeName javaTypeName = implementation.getJavaTypeName();
                if (javaTypeName != null) {
                    String bundlePath = javaTypeName.getQualifiedName().replace('.', File.separatorChar);
                    this.writeResourceBundleResourceFiles(this.getResourceBundleResources(implementation), resourcesDirectory, bundlePath);
                }
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, ResourceFileProcessor.getMessage("implementationNotFound", implementation.getIdentifier()), null);
        }
    }

    public Map<Locale, Properties> getResourceBundleResources(Specification specification) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        HashMap properties = null;
        if (this.getModules() != null && this.getModules().getSpecification(specification.getIdentifier()) != null) {
            properties = new HashMap();
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, ResourceFileProcessor.getMessage("specificationNotFound", specification.getIdentifier()), null);
        }
        return properties;
    }

    public Map<Locale, Properties> getResourceBundleResources(Implementation implementation) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        HashMap<Locale, Properties> properties = null;
        if (this.getModules() != null && this.getModules().getImplementation(implementation.getIdentifier()) != null) {
            properties = new HashMap<Locale, Properties>(10);
            Messages messages = this.getModules().getMessages(implementation.getIdentifier());
            if (messages != null) {
                int s0 = messages.getMessage().size();
                for (int i = 0; i < s0; ++i) {
                    Message message = (Message)messages.getMessage().get(i);
                    if (message.getTemplate() == null) continue;
                    int s1 = message.getTemplate().getText().size();
                    for (int j = 0; j < s1; ++j) {
                        Text text = (Text)message.getTemplate().getText().get(j);
                        Locale locale = new Locale(text.getLanguage().toLowerCase());
                        Properties bundleProperties = (Properties)properties.get(locale);
                        if (bundleProperties == null) {
                            bundleProperties = new Properties();
                            properties.put(locale, bundleProperties);
                        }
                        bundleProperties.setProperty(message.getName(), text.getValue());
                    }
                }
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, ResourceFileProcessor.getMessage("implementationNotFound", implementation.getIdentifier()), null);
        }
        return properties;
    }

    private void writeResourceBundleResourceFiles(Map<Locale, Properties> resources, File resourcesDirectory, String bundlePath) throws IOException {
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        if (resourcesDirectory == null) {
            throw new NullPointerException("resourcesDirectory");
        }
        if (bundlePath == null) {
            throw new NullPointerException("bundlePath");
        }
        Properties defProperties = null;
        Properties fallbackProperties = null;
        VelocityContext ctx = this.getVelocityContext();
        String toolName = ctx.get("toolName").toString();
        String toolVersion = ctx.get("toolVersion").toString();
        String toolUrl = ctx.get("toolUrl").toString();
        for (Map.Entry<Locale, Properties> e : resources.entrySet()) {
            String language = e.getKey().getLanguage().toLowerCase();
            Properties p = e.getValue();
            File file = new File(resourcesDirectory, bundlePath + "_" + language + ".properties");
            if (this.getResourceBundleDefaultLocale().getLanguage().equalsIgnoreCase(language)) {
                defProperties = p;
            }
            fallbackProperties = p;
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException(ResourceFileProcessor.getMessage("failedCreatingDirectory", file.getParentFile().getAbsolutePath()));
            }
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ResourceFileProcessor.getMessage("writing", file.getCanonicalPath()), null);
            }
            this.writePropertiesFile(p, toolName + ' ' + toolVersion + " - See " + toolUrl, file);
        }
        if (defProperties == null) {
            defProperties = fallbackProperties;
        }
        if (defProperties != null) {
            File file = new File(resourcesDirectory, bundlePath + ".properties");
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException(ResourceFileProcessor.getMessage("failedCreatingDirectory", file.getParentFile().getAbsolutePath()));
            }
            if (this.isLoggable(Level.INFO)) {
                this.log(Level.INFO, ResourceFileProcessor.getMessage("writing", file.getCanonicalPath()), null);
            }
            this.writePropertiesFile(defProperties, toolName + ' ' + toolVersion + " - See " + toolUrl, file);
        }
    }

    private void assertValidTemplates(Specification specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
    }

    private void assertValidTemplates(Implementation implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        Messages messages = this.getModules().getMessages(implementation.getIdentifier());
        if (messages != null) {
            for (int i = messages.getMessage().size() - 1; i >= 0; --i) {
                Message m = (Message)messages.getMessage().get(i);
                if (m.getTemplate() == null) continue;
                for (int j = m.getTemplate().getText().size() - 1; j >= 0; --j) {
                    new MessageFormat(((Text)m.getTemplate().getText().get(j)).getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertiesFile(Properties properties, String comments, File propertiesFile) throws IOException {
        RandomAccessFile randomAccessFile = null;
        FileChannel fileChannel = null;
        FileLock fileLock = null;
        boolean suppressExceptionOnClose = true;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        properties.store(byteStream, comments);
        byteStream.close();
        byte[] bytes = byteStream.toByteArray();
        try {
            randomAccessFile = new RandomAccessFile(propertiesFile, "rw");
            fileChannel = randomAccessFile.getChannel();
            fileLock = fileChannel.lock();
            fileChannel.truncate(bytes.length);
            fileChannel.position(0L);
            fileChannel.write(ByteBuffer.wrap(bytes));
            fileChannel.force(true);
            suppressExceptionOnClose = false;
        }
        catch (Throwable throwable) {
            this.releaseAndClose(fileLock, fileChannel, randomAccessFile, suppressExceptionOnClose);
            throw throwable;
        }
        this.releaseAndClose(fileLock, fileChannel, randomAccessFile, suppressExceptionOnClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void releaseAndClose(FileLock fileLock, FileChannel fileChannel, Closeable closeable, boolean suppressExceptions) throws IOException {
        try {
            if (fileLock == null) return;
            fileLock.release();
            return;
        }
        catch (IOException e) {
            if (!suppressExceptions) throw e;
            this.log(Level.SEVERE, null, e);
            return;
        }
        finally {
            try {
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
            catch (IOException e) {
                if (!suppressExceptions) throw e;
                this.log(Level.SEVERE, null, e);
            }
            finally {
                try {
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (IOException e) {
                    if (!suppressExceptions) throw e;
                    this.log(Level.SEVERE, null, e);
                }
            }
        }
    }

    private static String getMessage(String key, Object ... arguments) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return MessageFormat.format(ResourceBundle.getBundle(ResourceFileProcessor.class.getName().replace('.', '/')).getString(key), arguments);
    }
}

