/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.jomc.model.Implementation;
import org.jomc.model.Implementations;
import org.jomc.model.Instance;
import org.jomc.model.Module;
import org.jomc.model.Specification;
import org.jomc.tools.JomcTool;
import org.jomc.tools.model.SourceFileType;
import org.jomc.tools.model.SourceFilesType;
import org.jomc.tools.model.SourceSectionType;
import org.jomc.tools.model.SourceSectionsType;
import org.jomc.util.LineEditor;
import org.jomc.util.Section;
import org.jomc.util.SectionEditor;
import org.jomc.util.TrailingWhitespaceEditor;

public class SourceFileProcessor
extends JomcTool {
    private SourceFileEditor sourceFileEditor;
    @Deprecated
    private SourceFilesType sourceFilesType;

    public SourceFileProcessor() {
    }

    public SourceFileProcessor(SourceFileProcessor tool) throws IOException {
        super(tool);
        this.sourceFilesType = tool.sourceFilesType != null ? tool.sourceFilesType.clone() : null;
        this.sourceFileEditor = tool.sourceFileEditor;
    }

    @Deprecated
    public SourceFilesType getSourceFilesType() {
        if (this.sourceFilesType == null) {
            this.sourceFilesType = new SourceFilesType();
        }
        return this.sourceFilesType;
    }

    @Deprecated
    public SourceFileType getSourceFileType(Specification specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        SourceFileType sourceFileType = null;
        if (this.getModules() != null && this.getModules().getSpecification(specification.getIdentifier()) != null) {
            sourceFileType = this.getSourceFilesType().getSourceFile(specification.getIdentifier());
            if (sourceFileType == null) {
                sourceFileType = (SourceFileType)specification.getAnyObject(SourceFileType.class);
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, SourceFileProcessor.getMessage("specificationNotFound", specification.getIdentifier()), null);
        }
        return sourceFileType;
    }

    public SourceFilesType getSourceFilesType(Specification specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        SourceFilesType model = null;
        if (this.getModules() != null && this.getModules().getSpecification(specification.getIdentifier()) != null) {
            SourceFileType sourceFileType = this.getSourceFileType(specification);
            if (sourceFileType != null) {
                model = new SourceFilesType();
                model.getSourceFile().add(sourceFileType);
            } else {
                model = (SourceFilesType)specification.getAnyObject(SourceFilesType.class);
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, SourceFileProcessor.getMessage("specificationNotFound", specification.getIdentifier()), null);
        }
        return model;
    }

    @Deprecated
    public SourceFileType getSourceFileType(Implementation implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        SourceFileType sourceFileType = null;
        if (this.getModules() != null && this.getModules().getImplementation(implementation.getIdentifier()) != null) {
            sourceFileType = this.getSourceFilesType().getSourceFile(implementation.getIdentifier());
            if (sourceFileType == null) {
                sourceFileType = (SourceFileType)implementation.getAnyObject(SourceFileType.class);
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, SourceFileProcessor.getMessage("implementationNotFound", implementation.getIdentifier()), null);
        }
        return sourceFileType;
    }

    public SourceFilesType getSourceFilesType(Implementation implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        SourceFilesType model = null;
        if (this.getModules() != null && this.getModules().getImplementation(implementation.getIdentifier()) != null) {
            SourceFileType sourceFileType = this.getSourceFileType(implementation);
            if (sourceFileType != null) {
                model = new SourceFilesType();
                model.getSourceFile().add(sourceFileType);
            } else {
                Instance instance = this.getModules().getInstance(implementation.getIdentifier());
                assert (instance != null) : "Instance '" + implementation.getIdentifier() + "' not found.";
                model = (SourceFilesType)instance.getAnyObject(SourceFilesType.class);
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, SourceFileProcessor.getMessage("implementationNotFound", implementation.getIdentifier()), null);
        }
        return model;
    }

    public final SourceFileEditor getSourceFileEditor() {
        if (this.sourceFileEditor == null) {
            this.sourceFileEditor = new SourceFileEditor((LineEditor)new TrailingWhitespaceEditor(this.getLineSeparator()), this.getLineSeparator());
        }
        return this.sourceFileEditor;
    }

    public final void setSourceFileEditor(SourceFileEditor value) {
        this.sourceFileEditor = value;
    }

    @Deprecated
    public SourceFileEditor getSourceFileEditor(Specification specification) {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        return this.getSourceFileEditor();
    }

    @Deprecated
    public SourceFileEditor getSourceFileEditor(Implementation implementation) {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        return this.getSourceFileEditor();
    }

    public void manageSourceFiles(File sourcesDirectory) throws IOException {
        if (sourcesDirectory == null) {
            throw new NullPointerException("sourcesDirectory");
        }
        if (this.getModules() != null) {
            for (int i = this.getModules().getModule().size() - 1; i >= 0; --i) {
                this.manageSourceFiles((Module)this.getModules().getModule().get(i), sourcesDirectory);
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, SourceFileProcessor.getMessage("modulesNotFound", this.getModel().getIdentifier()), null);
        }
    }

    public void manageSourceFiles(Module module, File sourcesDirectory) throws IOException {
        if (module == null) {
            throw new NullPointerException("module");
        }
        if (sourcesDirectory == null) {
            throw new NullPointerException("sourcesDirectory");
        }
        if (this.getModules() != null && this.getModules().getModule(module.getName()) != null) {
            int i;
            int s0;
            if (module.getSpecifications() != null) {
                s0 = module.getSpecifications().getSpecification().size();
                for (i = 0; i < s0; ++i) {
                    this.manageSourceFiles((Specification)module.getSpecifications().getSpecification().get(i), sourcesDirectory);
                }
            }
            if (module.getImplementations() != null) {
                s0 = module.getImplementations().getImplementation().size();
                for (i = 0; i < s0; ++i) {
                    this.manageSourceFiles((Implementation)module.getImplementations().getImplementation().get(i), sourcesDirectory);
                }
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, SourceFileProcessor.getMessage("moduleNotFound", module.getName()), null);
        }
    }

    public void manageSourceFiles(Specification specification, File sourcesDirectory) throws IOException {
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (sourcesDirectory == null) {
            throw new NullPointerException("sourcesDirectory");
        }
        if (this.getModules() != null && this.getModules().getSpecification(specification.getIdentifier()) != null) {
            if (specification.isClassDeclaration()) {
                SourceFilesType model;
                boolean manage = true;
                Implementations implementations = this.getModules().getImplementations();
                if (implementations != null) {
                    int s0 = implementations.getImplementation().size();
                    for (int i = 0; i < s0; ++i) {
                        Implementation impl = (Implementation)implementations.getImplementation().get(i);
                        if (!impl.isClassDeclaration() || !specification.getClazz().equals(impl.getClazz())) continue;
                        this.manageSourceFiles(impl, sourcesDirectory);
                        manage = false;
                        break;
                    }
                }
                if (manage && (model = this.getSourceFilesType(specification)) != null) {
                    int s0 = model.getSourceFile().size();
                    for (int i = 0; i < s0; ++i) {
                        this.getSourceFileEditor().edit(specification, model.getSourceFile().get(i), sourcesDirectory);
                    }
                }
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, SourceFileProcessor.getMessage("specificationNotFound", specification.getIdentifier()), null);
        }
    }

    public void manageSourceFiles(Implementation implementation, File sourcesDirectory) throws IOException {
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (sourcesDirectory == null) {
            throw new NullPointerException("sourcesDirectory");
        }
        if (this.getModules() != null && this.getModules().getImplementation(implementation.getIdentifier()) != null) {
            SourceFilesType model;
            if (implementation.isClassDeclaration() && (model = this.getSourceFilesType(implementation)) != null) {
                int s0 = model.getSourceFile().size();
                for (int i = 0; i < s0; ++i) {
                    this.getSourceFileEditor().edit(implementation, model.getSourceFile().get(i), sourcesDirectory);
                }
            }
        } else if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, SourceFileProcessor.getMessage("implementationNotFound", implementation.getIdentifier()), null);
        }
    }

    private static String getMessage(String key, Object ... arguments) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        return MessageFormat.format(ResourceBundle.getBundle(SourceFileProcessor.class.getName().replace('.', '/')).getString(key), arguments);
    }

    private static String getMessage(Throwable t) {
        return t != null ? (t.getMessage() != null && t.getMessage().trim().length() > 0 ? t.getMessage() : SourceFileProcessor.getMessage(t.getCause())) : null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SourceFileEditor
    extends SectionEditor {
        private Specification specification;
        private Implementation implementation;
        private SourceFileType sourceFileType;
        private VelocityContext velocityContext;
        @Deprecated
        private List<Section> addedSections;
        @Deprecated
        private List<Section> unknownSections;

        public SourceFileEditor() {
            this((LineEditor)null, (String)null);
        }

        public SourceFileEditor(String lineSeparator) {
            this((LineEditor)null, lineSeparator);
        }

        public SourceFileEditor(LineEditor editor) {
            this(editor, null);
        }

        public SourceFileEditor(LineEditor editor, String lineSeparator) {
            super(editor, lineSeparator);
        }

        @Deprecated
        public SourceFileEditor(Specification specification) {
            this(specification, null, null);
        }

        @Deprecated
        public SourceFileEditor(Specification specification, String lineSeparator) {
            this(specification, null, lineSeparator);
        }

        @Deprecated
        public SourceFileEditor(Specification specification, LineEditor lineEditor) {
            this(specification, lineEditor, null);
        }

        @Deprecated
        public SourceFileEditor(Specification specification, LineEditor lineEditor, String lineSeparator) {
            super(lineEditor, lineSeparator);
            this.specification = specification;
            this.implementation = null;
            assert (SourceFileProcessor.this.getModules().getSpecification(specification.getIdentifier()) != null) : "Specification '" + specification.getIdentifier() + "' not found.";
        }

        @Deprecated
        public SourceFileEditor(Implementation implementation) {
            this(implementation, null, null);
        }

        @Deprecated
        public SourceFileEditor(Implementation implementation, String lineSeparator) {
            this(implementation, null, lineSeparator);
        }

        @Deprecated
        public SourceFileEditor(Implementation implementation, LineEditor lineEditor) {
            this(implementation, lineEditor, null);
        }

        @Deprecated
        public SourceFileEditor(Implementation implementation, LineEditor lineEditor, String lineSeparator) {
            super(lineEditor, lineSeparator);
            this.implementation = implementation;
            this.specification = null;
            assert (SourceFileProcessor.this.getModules().getImplementation(implementation.getIdentifier()) != null) : "Implementation '" + implementation.getIdentifier() + "' not found.";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void edit(Specification specification, SourceFileType sourceFileType, File sourcesDirectory) throws IOException {
            block7: {
                if (specification == null) {
                    throw new NullPointerException("specification");
                }
                if (sourceFileType == null) {
                    throw new NullPointerException("sourceFileType");
                }
                if (sourcesDirectory == null) {
                    throw new NullPointerException("sourcesDirectory");
                }
                try {
                    if (SourceFileProcessor.this.getModules() != null && SourceFileProcessor.this.getModules().getSpecification(specification.getIdentifier()) != null) {
                        this.specification = specification;
                        this.sourceFileType = sourceFileType;
                        this.velocityContext = SourceFileProcessor.this.getVelocityContext();
                        this.velocityContext.put("specification", (Object)specification);
                        this.velocityContext.put("smodel", (Object)sourceFileType);
                        this.editSourceFile(sourcesDirectory);
                        break block7;
                    }
                    throw new IOException(SourceFileProcessor.getMessage("specificationNotFound", new Object[]{specification.getIdentifier()}));
                }
                finally {
                    this.specification = null;
                    this.implementation = null;
                    this.sourceFileType = null;
                    this.velocityContext = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void edit(Implementation implementation, SourceFileType sourceFileType, File sourcesDirectory) throws IOException {
            block7: {
                if (implementation == null) {
                    throw new NullPointerException("implementation");
                }
                if (sourceFileType == null) {
                    throw new NullPointerException("sourceFileType");
                }
                if (sourcesDirectory == null) {
                    throw new NullPointerException("sourcesDirectory");
                }
                try {
                    if (SourceFileProcessor.this.getModules() != null && SourceFileProcessor.this.getModules().getImplementation(implementation.getIdentifier()) != null) {
                        this.implementation = implementation;
                        this.sourceFileType = sourceFileType;
                        this.velocityContext = SourceFileProcessor.this.getVelocityContext();
                        this.velocityContext.put("implementation", (Object)implementation);
                        this.velocityContext.put("smodel", (Object)sourceFileType);
                        this.editSourceFile(sourcesDirectory);
                        break block7;
                    }
                    throw new IOException(SourceFileProcessor.getMessage("implementationNotFound", new Object[]{implementation.getIdentifier()}));
                }
                finally {
                    this.specification = null;
                    this.implementation = null;
                    this.sourceFileType = null;
                    this.velocityContext = null;
                }
            }
        }

        @Deprecated
        public List<Section> getAddedSections() {
            if (this.addedSections == null) {
                this.addedSections = new LinkedList<Section>();
            }
            return this.addedSections;
        }

        @Deprecated
        public List<Section> getUnknownSections() {
            if (this.unknownSections == null) {
                this.unknownSections = new LinkedList<Section>();
            }
            return this.unknownSections;
        }

        @Deprecated
        protected SourceFileType getSourceFileType() {
            if (this.sourceFileType == null) {
                if (this.specification != null) {
                    return SourceFileProcessor.this.getSourceFileType(this.specification);
                }
                if (this.implementation != null) {
                    return SourceFileProcessor.this.getSourceFileType(this.implementation);
                }
            }
            return this.sourceFileType;
        }

        @Deprecated
        protected VelocityContext getVelocityContext() throws IOException {
            if (this.velocityContext == null) {
                VelocityContext ctx = SourceFileProcessor.this.getVelocityContext();
                if (this.specification != null) {
                    ctx.put("specification", (Object)this.specification);
                }
                if (this.implementation != null) {
                    ctx.put("implementation", (Object)this.implementation);
                }
                return ctx;
            }
            return this.velocityContext;
        }

        protected String getOutput(Section section) throws IOException {
            this.getAddedSections().clear();
            this.getUnknownSections().clear();
            SourceFileType model = this.getSourceFileType();
            if (model != null) {
                this.createSections(model, model.getSourceSections(), section);
            }
            return super.getOutput(section);
        }

        protected void editSection(Section s) throws IOException {
            try {
                super.editSection(s);
                SourceFileType model = this.getSourceFileType();
                if (s.getName() != null && model != null && model.getSourceSections() != null) {
                    SourceSectionType sourceSectionType = model.getSourceSections().getSourceSection(s.getName());
                    if (sourceSectionType != null) {
                        VelocityContext ctx;
                        Template template;
                        StringWriter writer;
                        if (s.getStartingLine() != null) {
                            s.setStartingLine(SourceFileProcessor.this.getIndentation(sourceSectionType.getIndentationLevel()) + s.getStartingLine().trim());
                        }
                        if (s.getEndingLine() != null) {
                            s.setEndingLine(SourceFileProcessor.this.getIndentation(sourceSectionType.getIndentationLevel()) + s.getEndingLine().trim());
                        }
                        if (!(sourceSectionType.getHeadTemplate() == null || sourceSectionType.isEditable() && s.getHeadContent().toString().trim().length() != 0)) {
                            writer = new StringWriter();
                            template = SourceFileProcessor.this.getVelocityTemplate(sourceSectionType.getHeadTemplate());
                            ctx = this.getVelocityContext();
                            ctx.put("template", (Object)template);
                            ctx.put("ssection", (Object)sourceSectionType);
                            template.merge((Context)ctx, (Writer)writer);
                            writer.close();
                            s.getHeadContent().setLength(0);
                            s.getHeadContent().append(writer.toString());
                            ctx.remove((Object)"template");
                            ctx.remove((Object)"ssection");
                        }
                        if (!(sourceSectionType.getTailTemplate() == null || sourceSectionType.isEditable() && s.getTailContent().toString().trim().length() != 0)) {
                            writer = new StringWriter();
                            template = SourceFileProcessor.this.getVelocityTemplate(sourceSectionType.getTailTemplate());
                            ctx = this.getVelocityContext();
                            ctx.put("template", (Object)template);
                            ctx.put("ssection", (Object)sourceSectionType);
                            template.merge((Context)ctx, (Writer)writer);
                            writer.close();
                            s.getTailContent().setLength(0);
                            s.getTailContent().append(writer.toString());
                            ctx.remove((Object)"template");
                            ctx.remove((Object)"ssection");
                        }
                    } else {
                        if (SourceFileProcessor.this.isLoggable(Level.WARNING)) {
                            if (this.implementation != null) {
                                Module m = SourceFileProcessor.this.getModules().getModuleOfImplementation(this.implementation.getIdentifier());
                                SourceFileProcessor.this.log(Level.WARNING, SourceFileProcessor.getMessage("unknownImplementationSection", new Object[]{m.getName(), this.implementation.getIdentifier(), model.getIdentifier(), s.getName()}), null);
                            } else if (this.specification != null) {
                                Module m = SourceFileProcessor.this.getModules().getModuleOfSpecification(this.specification.getIdentifier());
                                SourceFileProcessor.this.log(Level.WARNING, SourceFileProcessor.getMessage("unknownSpecificationSection", new Object[]{m.getName(), this.specification.getIdentifier(), model.getIdentifier(), s.getName()}), null);
                            }
                        }
                        this.getUnknownSections().add(s);
                    }
                }
            }
            catch (VelocityException e) {
                throw (IOException)new IOException(SourceFileProcessor.getMessage(e)).initCause(e);
            }
        }

        private void createSections(SourceFileType sourceFileType, SourceSectionsType sourceSectionsType, Section section) throws IOException {
            if (sourceSectionsType != null && section != null) {
                int s0 = sourceSectionsType.getSourceSection().size();
                for (int i = 0; i < s0; ++i) {
                    SourceSectionType sourceSectionType = sourceSectionsType.getSourceSection().get(i);
                    Section childSection = section.getSection(sourceSectionType.getName());
                    if (childSection == null && !sourceSectionType.isOptional()) {
                        childSection = this.createSection(StringUtils.defaultString((String)sourceFileType.getHeadComment()), StringUtils.defaultString((String)sourceFileType.getTailComment()), sourceSectionType);
                        section.getSections().add(childSection);
                        if (SourceFileProcessor.this.isLoggable(Level.FINE)) {
                            SourceFileProcessor.this.log(Level.FINE, SourceFileProcessor.getMessage("addedSection", new Object[]{sourceFileType.getIdentifier(), childSection.getName()}), null);
                        }
                        this.getAddedSections().add(childSection);
                    }
                    this.createSections(sourceFileType, sourceSectionType.getSourceSections(), childSection);
                }
            }
        }

        private Section createSection(String headComment, String tailComment, SourceSectionType sourceSectionType) throws IOException {
            if (headComment == null) {
                throw new NullPointerException("headComment");
            }
            if (tailComment == null) {
                throw new NullPointerException("tailComment");
            }
            if (sourceSectionType == null) {
                throw new NullPointerException("sourceSectionType");
            }
            Section s = new Section();
            s.setName(sourceSectionType.getName());
            StringBuilder head = new StringBuilder(255);
            head.append(SourceFileProcessor.this.getIndentation(sourceSectionType.getIndentationLevel())).append(headComment);
            s.setStartingLine(head + " SECTION-START[" + sourceSectionType.getName() + ']' + tailComment);
            s.setEndingLine(head + " SECTION-END" + tailComment);
            return s;
        }

        private void editSourceFile(File sourcesDirectory) throws IOException {
            if (sourcesDirectory == null) {
                throw new NullPointerException("sourcesDirectory");
            }
            if (!sourcesDirectory.isDirectory()) {
                throw new IOException(SourceFileProcessor.getMessage("directoryNotFound", new Object[]{sourcesDirectory.getAbsolutePath()}));
            }
            SourceFileType model = this.getSourceFileType();
            if (model != null && model.getLocation() != null) {
                File f = new File(sourcesDirectory, model.getLocation());
                try {
                    String content = "";
                    String edited = null;
                    boolean creating = false;
                    if (!f.exists()) {
                        if (model.getTemplate() != null) {
                            StringWriter writer = new StringWriter();
                            Template template = SourceFileProcessor.this.getVelocityTemplate(model.getTemplate());
                            VelocityContext ctx = this.getVelocityContext();
                            ctx.put("template", (Object)template);
                            template.merge((Context)ctx, (Writer)writer);
                            writer.close();
                            content = writer.toString();
                            ctx.remove((Object)"template");
                            creating = true;
                        }
                    } else {
                        if (SourceFileProcessor.this.isLoggable(Level.FINER)) {
                            SourceFileProcessor.this.log(Level.FINER, SourceFileProcessor.getMessage("reading", new Object[]{f.getAbsolutePath()}), null);
                        }
                        content = this.readSourceFile(f);
                    }
                    try {
                        edited = super.edit(content);
                    }
                    catch (IOException e) {
                        throw (IOException)new IOException(SourceFileProcessor.getMessage("failedEditing", new Object[]{f.getAbsolutePath(), SourceFileProcessor.getMessage(e)})).initCause(e);
                    }
                    if (!edited.equals(content) || edited.length() == 0) {
                        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
                            throw new IOException(SourceFileProcessor.getMessage("failedCreatingDirectory", new Object[]{f.getParentFile().getAbsolutePath()}));
                        }
                        if (SourceFileProcessor.this.isLoggable(Level.INFO)) {
                            SourceFileProcessor.this.log(Level.INFO, SourceFileProcessor.getMessage(creating ? "creating" : "editing", new Object[]{f.getAbsolutePath()}), null);
                        }
                        this.writeSourceFile(f, edited);
                    } else if (SourceFileProcessor.this.isLoggable(Level.FINER)) {
                        SourceFileProcessor.this.log(Level.FINER, SourceFileProcessor.getMessage("unchanged", new Object[]{f.getAbsolutePath()}), null);
                    }
                }
                catch (VelocityException e) {
                    throw (IOException)new IOException(SourceFileProcessor.getMessage("failedEditing", new Object[]{f.getAbsolutePath(), SourceFileProcessor.getMessage(e)})).initCause(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readSourceFile(File file) throws IOException {
            String string;
            if (file == null) {
                throw new NullPointerException("file");
            }
            RandomAccessFile randomAccessFile = null;
            FileChannel fileChannel = null;
            FileLock fileLock = null;
            boolean suppressExceptionOnClose = true;
            int length = file.length() > 0L ? Long.valueOf(file.length()).intValue() : 1;
            ByteBuffer buf = ByteBuffer.allocate(length);
            StringBuilder appendable = new StringBuilder(length);
            try {
                randomAccessFile = new RandomAccessFile(file, "r");
                fileChannel = randomAccessFile.getChannel();
                fileLock = fileChannel.lock(0L, file.length(), true);
                fileChannel.position(0L);
                buf.clear();
                int read = fileChannel.read(buf);
                while (read != -1) {
                    appendable.append(new String(buf.array(), buf.arrayOffset(), read, SourceFileProcessor.this.getInputEncoding()));
                    buf.clear();
                    read = fileChannel.read(buf);
                }
                suppressExceptionOnClose = false;
                string = appendable.toString();
            }
            catch (Throwable throwable) {
                this.releaseAndClose(fileLock, fileChannel, randomAccessFile, suppressExceptionOnClose);
                throw throwable;
            }
            this.releaseAndClose(fileLock, fileChannel, randomAccessFile, suppressExceptionOnClose);
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeSourceFile(File file, String content) throws IOException {
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (content == null) {
                throw new NullPointerException("content");
            }
            RandomAccessFile randomAccessFile = null;
            FileChannel fileChannel = null;
            FileLock fileLock = null;
            boolean suppressExceptionOnClose = true;
            byte[] bytes = content.getBytes(SourceFileProcessor.this.getOutputEncoding());
            try {
                randomAccessFile = new RandomAccessFile(file, "rw");
                fileChannel = randomAccessFile.getChannel();
                fileLock = fileChannel.lock(0L, bytes.length, false);
                fileChannel.truncate(bytes.length);
                fileChannel.position(0L);
                fileChannel.write(ByteBuffer.wrap(bytes));
                fileChannel.force(true);
                suppressExceptionOnClose = false;
            }
            catch (Throwable throwable) {
                this.releaseAndClose(fileLock, fileChannel, randomAccessFile, suppressExceptionOnClose);
                throw throwable;
            }
            this.releaseAndClose(fileLock, fileChannel, randomAccessFile, suppressExceptionOnClose);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void releaseAndClose(FileLock fileLock, FileChannel fileChannel, RandomAccessFile randomAccessFile, boolean suppressExceptions) throws IOException {
            try {
                if (fileLock == null) return;
                fileLock.release();
                return;
            }
            catch (IOException e) {
                if (!suppressExceptions) throw e;
                SourceFileProcessor.this.log(Level.SEVERE, null, e);
                return;
            }
            finally {
                try {
                    if (fileChannel != null) {
                        fileChannel.close();
                    }
                }
                catch (IOException e) {
                    if (!suppressExceptions) throw e;
                    SourceFileProcessor.this.log(Level.SEVERE, null, e);
                }
                finally {
                    try {
                        if (randomAccessFile != null) {
                            randomAccessFile.close();
                        }
                    }
                    catch (IOException e) {
                        if (!suppressExceptions) throw e;
                        SourceFileProcessor.this.log(Level.SEVERE, null, e);
                    }
                }
            }
        }
    }
}

