/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools.modlet;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.jomc.model.Dependencies;
import org.jomc.model.Implementation;
import org.jomc.model.JavaTypeName;
import org.jomc.model.Messages;
import org.jomc.model.ModelObjectException;
import org.jomc.model.Module;
import org.jomc.model.Modules;
import org.jomc.model.Properties;
import org.jomc.model.Specification;
import org.jomc.model.Specifications;
import org.jomc.model.modlet.ModelHelper;
import org.jomc.modlet.Model;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelException;
import org.jomc.modlet.ModelProcessor;
import org.jomc.tools.model.SourceFileType;
import org.jomc.tools.model.SourceFilesType;
import org.jomc.tools.model.SourceSectionType;
import org.jomc.tools.model.SourceSectionsType;

public class ToolsModelProcessor
implements ModelProcessor {
    public static final String ENABLED_ATTRIBUTE_NAME = "org.jomc.tools.modlet.ToolsModelProcessor.enabledAttribute";
    private static final String DEFAULT_ENABLED_PROPERTY_NAME = "org.jomc.tools.modlet.ToolsModelProcessor.defaultEnabled";
    private static final Boolean DEFAULT_ENABLED = Boolean.TRUE;
    private static volatile Boolean defaultEnabled;
    private Boolean enabled;
    public static final String MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED_ATTRIBUTE_NAME = "org.jomc.tools.modlet.ToolsModelProcessor.modelObjectClasspathResolutionEnabledAttribute";
    private static final String DEFAULT_MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED_PROPERTY_NAME = "org.jomc.tools.modlet.ToolsModelProcessor.defaultModelObjectClasspathResolutionEnabled";
    private static final Boolean DEFAULT_MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED;
    private static volatile Boolean defaultModelObjectClasspathResolutionEnabled;
    private Boolean modelObjectClasspathResolutionEnabled;
    public static final String HEAD_COMMENT_ATTRIBUTE_NAME = "org.jomc.tools.modlet.ToolsModelProcessor.headCommentAttribute";
    private static final String DEFAULT_HEAD_COMMENT_PROPERTY_NAME = "org.jomc.tools.modlet.ToolsModelProcessor.defaultHeadComment";
    private static final String DEFAULT_HEAD_COMMENT = "//";
    private static volatile String defaultHeadComment;
    private String headComment;
    public static final String TAIL_COMMENT_ATTRIBUTE_NAME = "org.jomc.tools.modlet.ToolsModelProcessor.tailCommentAttribute";
    private static final String DEFAULT_TAIL_COMMENT_PROPERTY_NAME = "org.jomc.tools.modlet.ToolsModelProcessor.defaultTailComment";
    private static final String DEFAULT_TAIL_COMMENT;
    private static volatile String defaultTailComment;
    private String tailComment;

    public static boolean isDefaultEnabled() {
        if (defaultEnabled == null) {
            defaultEnabled = Boolean.valueOf(System.getProperty(DEFAULT_ENABLED_PROPERTY_NAME, Boolean.toString(DEFAULT_ENABLED)));
        }
        return defaultEnabled;
    }

    public static void setDefaultEnabled(Boolean value) {
        defaultEnabled = value;
    }

    public final boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = ToolsModelProcessor.isDefaultEnabled();
        }
        return this.enabled;
    }

    public final void setEnabled(Boolean value) {
        this.enabled = value;
    }

    public static boolean isDefaultModelObjectClasspathResolutionEnabled() {
        if (defaultModelObjectClasspathResolutionEnabled == null) {
            defaultModelObjectClasspathResolutionEnabled = Boolean.valueOf(System.getProperty(DEFAULT_MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED_PROPERTY_NAME, Boolean.toString(DEFAULT_MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED)));
        }
        return defaultModelObjectClasspathResolutionEnabled;
    }

    public static void setDefaultModelObjectClasspathResolutionEnabled(Boolean value) {
        defaultModelObjectClasspathResolutionEnabled = value;
    }

    public final boolean isModelObjectClasspathResolutionEnabled() {
        if (this.modelObjectClasspathResolutionEnabled == null) {
            this.modelObjectClasspathResolutionEnabled = ToolsModelProcessor.isDefaultModelObjectClasspathResolutionEnabled();
        }
        return this.modelObjectClasspathResolutionEnabled;
    }

    public final void setModelObjectClasspathResolutionEnabled(Boolean value) {
        this.modelObjectClasspathResolutionEnabled = value;
    }

    public static String getDefaultHeadComment() {
        if (defaultHeadComment == null) {
            defaultHeadComment = System.getProperty(DEFAULT_HEAD_COMMENT_PROPERTY_NAME, DEFAULT_HEAD_COMMENT);
        }
        return defaultHeadComment;
    }

    public static void setDefaultHeadComment(String value) {
        defaultHeadComment = value;
    }

    public final String getHeadComment() {
        if (this.headComment == null) {
            this.headComment = ToolsModelProcessor.getDefaultHeadComment();
        }
        return this.headComment;
    }

    public final void setHeadComment(String value) {
        this.headComment = value;
    }

    public static String getDefaultTailComment() {
        if (defaultTailComment == null) {
            defaultTailComment = System.getProperty(DEFAULT_TAIL_COMMENT_PROPERTY_NAME, DEFAULT_TAIL_COMMENT);
        }
        return defaultTailComment;
    }

    public static void setDefaultTailComment(String value) {
        defaultTailComment = value;
    }

    public final String getTailComment() {
        if (this.tailComment == null) {
            this.tailComment = ToolsModelProcessor.getDefaultTailComment();
        }
        return this.tailComment;
    }

    public final void setTailComment(String value) {
        this.tailComment = value;
    }

    public Model processModel(ModelContext context, Model model) throws ModelException {
        boolean contextModelObjectClasspathResolutionEnabled;
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (model == null) {
            throw new NullPointerException("model");
        }
        Model processed = model;
        boolean contextEnabled = this.isEnabled();
        if (DEFAULT_ENABLED == contextEnabled && context.getAttribute(ENABLED_ATTRIBUTE_NAME) instanceof Boolean) {
            contextEnabled = (Boolean)context.getAttribute(ENABLED_ATTRIBUTE_NAME);
        }
        if ((contextModelObjectClasspathResolutionEnabled = this.isModelObjectClasspathResolutionEnabled()) == DEFAULT_MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED && context.getAttribute(MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED_ATTRIBUTE_NAME) instanceof Boolean) {
            contextModelObjectClasspathResolutionEnabled = (Boolean)context.getAttribute(MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED_ATTRIBUTE_NAME);
        }
        if (contextEnabled) {
            processed = model.clone();
            Modules modules = ModelHelper.getModules((Model)processed);
            if (modules != null) {
                SourceFilesType sourceFilesType;
                SourceFileType sourceFileType;
                int i;
                int s0;
                Module classpathModule = null;
                if (contextModelObjectClasspathResolutionEnabled) {
                    classpathModule = modules.getClasspathModule(Modules.getDefaultClasspathModuleName(), context.getClassLoader());
                    if (classpathModule != null && modules.getModule(Modules.getDefaultClasspathModuleName()) == null) {
                        modules.getModule().add(classpathModule);
                    } else {
                        classpathModule = null;
                    }
                }
                if (modules.getSpecifications() != null) {
                    s0 = modules.getSpecifications().getSpecification().size();
                    for (i = 0; i < s0; ++i) {
                        Specification specification = (Specification)modules.getSpecifications().getSpecification().get(i);
                        sourceFileType = (SourceFileType)specification.getAnyObject(SourceFileType.class);
                        sourceFilesType = (SourceFilesType)specification.getAnyObject(SourceFilesType.class);
                        if (sourceFileType != null) {
                            if (sourceFileType.getLocation() == null && specification.getClazz() != null) {
                                sourceFileType.setLocation(new StringBuilder(specification.getClazz().length() + 5).append(specification.getClazz().replace('.', '/')).append(".java").toString());
                            }
                            if (sourceFileType.getHeadComment() == null) {
                                sourceFileType.setHeadComment(DEFAULT_HEAD_COMMENT);
                            }
                        }
                        if (sourceFilesType == null) continue;
                        this.applyDefaults(context, modules, specification, sourceFilesType);
                    }
                }
                if (modules.getImplementations() != null) {
                    s0 = modules.getImplementations().getImplementation().size();
                    for (i = 0; i < s0; ++i) {
                        Implementation implementation = (Implementation)modules.getImplementations().getImplementation().get(i);
                        sourceFileType = (SourceFileType)implementation.getAnyObject(SourceFileType.class);
                        sourceFilesType = (SourceFilesType)implementation.getAnyObject(SourceFilesType.class);
                        if (sourceFileType != null) {
                            if (sourceFileType.getLocation() == null && implementation.getClazz() != null) {
                                sourceFileType.setLocation(new StringBuilder(implementation.getClazz().length() + 5).append(implementation.getClazz().replace('.', '/')).append(".java").toString());
                            }
                            if (sourceFileType.getHeadComment() == null) {
                                sourceFileType.setHeadComment(DEFAULT_HEAD_COMMENT);
                            }
                        }
                        if (sourceFilesType == null) continue;
                        this.applyDefaults(context, modules, implementation, sourceFilesType);
                    }
                }
                if (classpathModule != null) {
                    modules.getModule().remove(classpathModule);
                }
            }
        } else if (context.isLoggable(Level.FINER)) {
            context.log(Level.FINER, ToolsModelProcessor.getMessage("disabled", this.getClass().getSimpleName(), model.getIdentifier()), null);
        }
        return processed;
    }

    protected String getDefaultSourceFileLocation(ModelContext context, Modules modules, Specification specification) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        String location = null;
        try {
            if (specification.getJavaTypeName() != null) {
                location = specification.getJavaTypeName().getQualifiedName().replace('.', '/') + ".java";
            }
        }
        catch (ModelObjectException e) {
            context.log(Level.WARNING, ToolsModelProcessor.getMessage(e), null);
        }
        return location;
    }

    protected String getDefaultSourceFileLocation(ModelContext context, Modules modules, Implementation implementation) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        String location = null;
        try {
            if (implementation.getJavaTypeName() != null) {
                location = implementation.getJavaTypeName().getQualifiedName().replace('.', '/') + ".java";
            }
        }
        catch (ModelObjectException e) {
            context.log(Level.WARNING, ToolsModelProcessor.getMessage(e), null);
        }
        return location;
    }

    protected String getDefaultSourceSectionName(ModelContext context, Modules modules, Specification specification) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        String sectionName = null;
        try {
            JavaTypeName javaTypeName = specification.getJavaTypeName();
            if (javaTypeName != null) {
                sectionName = javaTypeName.getName(false);
            }
        }
        catch (ModelObjectException e) {
            context.log(Level.WARNING, ToolsModelProcessor.getMessage(e), null);
        }
        return sectionName;
    }

    protected String getDefaultSourceSectionName(ModelContext context, Modules modules, Implementation implementation) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        String sectionName = null;
        try {
            JavaTypeName javaTypeName = implementation.getJavaTypeName();
            if (javaTypeName != null) {
                sectionName = javaTypeName.getName(false);
            }
        }
        catch (ModelObjectException e) {
            context.log(Level.WARNING, ToolsModelProcessor.getMessage(e), null);
        }
        return sectionName;
    }

    private void applyDefaults(ModelContext context, Modules modules, Specification specification, SourceFilesType sourceFilesType) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        if (sourceFilesType == null) {
            throw new NullPointerException("sourceFilesType");
        }
        String contextHeadComment = this.getHeadComment();
        if ((DEFAULT_HEAD_COMMENT != null ? DEFAULT_HEAD_COMMENT.equals(contextHeadComment) : contextHeadComment == null) && context.getAttribute(HEAD_COMMENT_ATTRIBUTE_NAME) instanceof String) {
            contextHeadComment = (String)context.getAttribute(HEAD_COMMENT_ATTRIBUTE_NAME);
        }
        if (contextHeadComment != null && contextHeadComment.length() == 0) {
            contextHeadComment = null;
        }
        String contextTailComment = this.getTailComment();
        if ((DEFAULT_TAIL_COMMENT != null ? DEFAULT_TAIL_COMMENT.equals(contextTailComment) : contextTailComment == null) && context.getAttribute(TAIL_COMMENT_ATTRIBUTE_NAME) instanceof String) {
            contextTailComment = (String)context.getAttribute(TAIL_COMMENT_ATTRIBUTE_NAME);
        }
        if (contextTailComment != null && contextTailComment.length() == 0) {
            contextTailComment = null;
        }
        int s0 = sourceFilesType.getSourceFile().size();
        for (int i = 0; i < s0; ++i) {
            SourceFileType s = sourceFilesType.getSourceFile().get(i);
            if (s.getTemplate() == null) {
                s.setTemplate("Specification.java.vm");
            }
            if (s.getLocation() == null) {
                s.setLocation(this.getDefaultSourceFileLocation(context, modules, specification));
            }
            if (s.getHeadComment() == null) {
                s.setHeadComment(contextHeadComment);
            }
            if (s.getTailComment() == null) {
                s.setTailComment(contextTailComment);
            }
            this.applyDefaults(context, modules, specification, s.getSourceSections());
        }
    }

    private void applyDefaults(ModelContext context, Modules modules, Specification specification, SourceSectionsType sourceSectionsType) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        try {
            if (sourceSectionsType != null) {
                int s0 = sourceSectionsType.getSourceSection().size();
                for (int i = 0; i < s0; ++i) {
                    String sectionName;
                    SourceSectionType s = sourceSectionsType.getSourceSection().get(i);
                    if ("License Header".equals(s.getName())) {
                        if (!ToolsModelProcessor.isFieldSet(s, "optional")) {
                            s.setOptional(true);
                        }
                        if (s.getHeadTemplate() == null) {
                            s.setHeadTemplate("specification-license.vm");
                        }
                    }
                    if ("Annotations".equals(s.getName()) && s.getHeadTemplate() == null) {
                        s.setHeadTemplate("specification-annotations.vm");
                    }
                    if ("Documentation".equals(s.getName())) {
                        if (!ToolsModelProcessor.isFieldSet(s, "optional")) {
                            s.setOptional(true);
                        }
                        if (s.getHeadTemplate() == null) {
                            s.setHeadTemplate("specification-documentation.vm");
                        }
                    }
                    if ((sectionName = this.getDefaultSourceSectionName(context, modules, specification)) != null && sectionName.equals(s.getName())) {
                        if (!ToolsModelProcessor.isFieldSet(s, "editable")) {
                            s.setEditable(true);
                        }
                        if (!ToolsModelProcessor.isFieldSet(s, "indentationLevel")) {
                            s.setIndentationLevel(1);
                        }
                    }
                    this.applyDefaults(context, modules, specification, s.getSourceSections());
                }
            }
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void applyDefaults(ModelContext context, Modules modules, Implementation implementation, SourceFilesType sourceFilesType) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        if (sourceFilesType == null) {
            throw new NullPointerException("sourceFilesType");
        }
        String contextHeadComment = this.getHeadComment();
        if ((DEFAULT_HEAD_COMMENT != null ? DEFAULT_HEAD_COMMENT.equals(contextHeadComment) : contextHeadComment == null) && context.getAttribute(HEAD_COMMENT_ATTRIBUTE_NAME) instanceof String) {
            contextHeadComment = (String)context.getAttribute(HEAD_COMMENT_ATTRIBUTE_NAME);
        }
        if (contextHeadComment != null && contextHeadComment.length() == 0) {
            contextHeadComment = null;
        }
        String contextTailComment = this.getTailComment();
        if ((DEFAULT_TAIL_COMMENT != null ? DEFAULT_TAIL_COMMENT.equals(contextTailComment) : contextTailComment == null) && context.getAttribute(TAIL_COMMENT_ATTRIBUTE_NAME) instanceof String) {
            contextTailComment = (String)context.getAttribute(TAIL_COMMENT_ATTRIBUTE_NAME);
        }
        if (contextTailComment != null && contextTailComment.length() == 0) {
            contextTailComment = null;
        }
        int s0 = sourceFilesType.getSourceFile().size();
        for (int i = 0; i < s0; ++i) {
            SourceFileType s = sourceFilesType.getSourceFile().get(i);
            if (s.getTemplate() == null) {
                s.setTemplate("Implementation.java.vm");
            }
            if (s.getLocation() == null) {
                s.setLocation(this.getDefaultSourceFileLocation(context, modules, implementation));
            }
            if (s.getHeadComment() == null) {
                s.setHeadComment(contextHeadComment);
            }
            if (s.getTailComment() == null) {
                s.setTailComment(contextTailComment);
            }
            this.applyDefaults(context, modules, implementation, s.getSourceSections());
        }
    }

    private void applyDefaults(ModelContext context, Modules modules, Implementation implementation, SourceSectionsType sourceSectionsType) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        Specifications specifications = modules.getSpecifications(implementation.getIdentifier());
        Dependencies dependencies = modules.getDependencies(implementation.getIdentifier());
        Messages messages = modules.getMessages(implementation.getIdentifier());
        Properties properties = modules.getProperties(implementation.getIdentifier());
        try {
            if (sourceSectionsType != null) {
                int s0 = sourceSectionsType.getSourceSection().size();
                for (int i = 0; i < s0; ++i) {
                    String sectionName;
                    SourceSectionType s = sourceSectionsType.getSourceSection().get(i);
                    if ("License Header".equals(s.getName())) {
                        if (!ToolsModelProcessor.isFieldSet(s, "optional")) {
                            s.setOptional(true);
                        }
                        if (s.getHeadTemplate() == null) {
                            s.setHeadTemplate("implementation-license.vm");
                        }
                    }
                    if ("Annotations".equals(s.getName()) && s.getHeadTemplate() == null) {
                        s.setHeadTemplate("implementation-annotations.vm");
                    }
                    if ("Documentation".equals(s.getName())) {
                        if (!ToolsModelProcessor.isFieldSet(s, "optional")) {
                            s.setOptional(true);
                        }
                        if (s.getHeadTemplate() == null) {
                            s.setHeadTemplate("implementation-documentation.vm");
                        }
                    }
                    if ("Constructors".equals(s.getName())) {
                        if (!ToolsModelProcessor.isFieldSet(s, "indentationLevel")) {
                            s.setIndentationLevel(1);
                        }
                        if (s.getHeadTemplate() == null) {
                            s.setHeadTemplate("implementation-constructors-head.vm");
                        }
                        if (s.getTailTemplate() == null) {
                            s.setTailTemplate("implementation-constructors-tail.vm");
                        }
                        if (!ToolsModelProcessor.isFieldSet(s, "optional")) {
                            s.setOptional(specifications == null || specifications.getSpecification().isEmpty() && specifications.getReference().isEmpty());
                        }
                    }
                    if ("Default Constructor".equals(s.getName())) {
                        if (!ToolsModelProcessor.isFieldSet(s, "editable")) {
                            s.setEditable(true);
                        }
                        if (!ToolsModelProcessor.isFieldSet(s, "indentationLevel")) {
                            s.setIndentationLevel(2);
                        }
                        if (s.getHeadTemplate() == null) {
                            s.setHeadTemplate("implementation-default-constructor.vm");
                        }
                    }
                    if ("Dependencies".equals(s.getName())) {
                        if (!ToolsModelProcessor.isFieldSet(s, "optional")) {
                            s.setOptional(dependencies == null || dependencies.getDependency().isEmpty());
                        }
                        if (!ToolsModelProcessor.isFieldSet(s, "indentationLevel")) {
                            s.setIndentationLevel(1);
                        }
                        if (s.getHeadTemplate() == null) {
                            s.setHeadTemplate("implementation-dependencies.vm");
                        }
                    }
                    if ("Properties".equals(s.getName())) {
                        if (!ToolsModelProcessor.isFieldSet(s, "optional")) {
                            s.setOptional(properties == null || properties.getProperty().isEmpty());
                        }
                        if (!ToolsModelProcessor.isFieldSet(s, "indentationLevel")) {
                            s.setIndentationLevel(1);
                        }
                        if (s.getHeadTemplate() == null) {
                            s.setHeadTemplate("implementation-properties.vm");
                        }
                    }
                    if ("Messages".equals(s.getName())) {
                        if (!ToolsModelProcessor.isFieldSet(s, "optional")) {
                            s.setOptional(messages == null || messages.getMessage().isEmpty());
                        }
                        if (!ToolsModelProcessor.isFieldSet(s, "indentationLevel")) {
                            s.setIndentationLevel(1);
                        }
                        if (s.getHeadTemplate() == null) {
                            s.setHeadTemplate("implementation-messages.vm");
                        }
                    }
                    if (specifications != null) {
                        for (Specification specification : specifications.getSpecification()) {
                            String sectionName2 = this.getDefaultSourceSectionName(context, modules, specification);
                            if (sectionName2 == null || !sectionName2.equals(s.getName())) continue;
                            if (!ToolsModelProcessor.isFieldSet(s, "editable")) {
                                s.setEditable(true);
                            }
                            if (ToolsModelProcessor.isFieldSet(s, "indentationLevel")) continue;
                            s.setIndentationLevel(1);
                        }
                    }
                    if ((sectionName = this.getDefaultSourceSectionName(context, modules, implementation)) != null && sectionName.equals(s.getName())) {
                        if (!ToolsModelProcessor.isFieldSet(s, "editable")) {
                            s.setEditable(true);
                        }
                        if (!ToolsModelProcessor.isFieldSet(s, "indentationLevel")) {
                            s.setIndentationLevel(1);
                        }
                    }
                    this.applyDefaults(context, modules, implementation, s.getSourceSections());
                }
            }
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static boolean isFieldSet(Object object, String fieldName) throws NoSuchFieldException {
        Field field = object.getClass().getDeclaredField(fieldName);
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            boolean bl = field.get(object) != null;
            return bl;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    private static String getMessage(Throwable t) {
        return t != null ? (t.getMessage() != null && t.getMessage().trim().length() > 0 ? t.getMessage() : ToolsModelProcessor.getMessage(t.getCause())) : null;
    }

    private static String getMessage(String key, Object ... args) {
        return MessageFormat.format(ResourceBundle.getBundle(ToolsModelProcessor.class.getName().replace('.', '/'), Locale.getDefault()).getString(key), args);
    }

    static {
        DEFAULT_MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED = Boolean.TRUE;
        DEFAULT_TAIL_COMMENT = null;
    }
}

