/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools.modlet;

import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.jomc.model.Dependencies;
import org.jomc.model.Implementation;
import org.jomc.model.InheritanceModel;
import org.jomc.model.JavaTypeName;
import org.jomc.model.Messages;
import org.jomc.model.ModelObjectException;
import org.jomc.model.Module;
import org.jomc.model.Modules;
import org.jomc.model.Properties;
import org.jomc.model.Specification;
import org.jomc.model.Specifications;
import org.jomc.model.modlet.ModelHelper;
import org.jomc.modlet.Model;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelException;
import org.jomc.modlet.ModelProvider;
import org.jomc.tools.model.ObjectFactory;
import org.jomc.tools.model.SourceFileType;
import org.jomc.tools.model.SourceFilesType;
import org.jomc.tools.model.SourceSectionType;
import org.jomc.tools.model.SourceSectionsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolsModelProvider
implements ModelProvider {
    private static final QName SOURCE_FILES_QNAME = new ObjectFactory().createSourceFiles(null).getName();
    public static final String ENABLED_ATTRIBUTE_NAME = "org.jomc.tools.modlet.ToolsModelProvider.enabledAttribute";
    private static final String DEFAULT_ENABLED_PROPERTY_NAME = "org.jomc.tools.modlet.ToolsModelProvider.defaultEnabled";
    private static final Boolean DEFAULT_ENABLED = Boolean.TRUE;
    private static volatile Boolean defaultEnabled;
    private Boolean enabled;
    public static final String MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED_ATTRIBUTE_NAME = "org.jomc.tools.modlet.ToolsModelProvider.modelObjectClasspathResolutionEnabledAttribute";
    private static final String DEFAULT_MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED_PROPERTY_NAME = "org.jomc.tools.modlet.ToolsModelProvider.defaultModelObjectClasspathResolutionEnabled";
    private static final Boolean DEFAULT_MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED;
    private static volatile Boolean defaultModelObjectClasspathResolutionEnabled;
    private Boolean modelObjectClasspathResolutionEnabled;
    public static final String HEAD_COMMENT_ATTRIBUTE_NAME = "org.jomc.tools.modlet.ToolsModelProvider.headCommentAttribute";
    private static final String DEFAULT_HEAD_COMMENT_PROPERTY_NAME = "org.jomc.tools.modlet.ToolsModelProvider.defaultHeadComment";
    private static final String DEFAULT_HEAD_COMMENT = "//";
    private static volatile String defaultHeadComment;
    private String headComment;
    public static final String TAIL_COMMENT_ATTRIBUTE_NAME = "org.jomc.tools.modlet.ToolsModelProvider.tailCommentAttribute";
    private static final String DEFAULT_TAIL_COMMENT_PROPERTY_NAME = "org.jomc.tools.modlet.ToolsModelProvider.defaultTailComment";
    private static final String DEFAULT_TAIL_COMMENT;
    private static volatile String defaultTailComment;
    private String tailComment;

    public static boolean isDefaultEnabled() {
        if (defaultEnabled == null) {
            defaultEnabled = Boolean.valueOf(System.getProperty(DEFAULT_ENABLED_PROPERTY_NAME, Boolean.toString(DEFAULT_ENABLED)));
        }
        return defaultEnabled;
    }

    public static void setDefaultEnabled(Boolean value) {
        defaultEnabled = value;
    }

    public final boolean isEnabled() {
        if (this.enabled == null) {
            this.enabled = ToolsModelProvider.isDefaultEnabled();
        }
        return this.enabled;
    }

    public final void setEnabled(Boolean value) {
        this.enabled = value;
    }

    public static boolean isDefaultModelObjectClasspathResolutionEnabled() {
        if (defaultModelObjectClasspathResolutionEnabled == null) {
            defaultModelObjectClasspathResolutionEnabled = Boolean.valueOf(System.getProperty(DEFAULT_MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED_PROPERTY_NAME, Boolean.toString(DEFAULT_MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED)));
        }
        return defaultModelObjectClasspathResolutionEnabled;
    }

    public static void setDefaultModelObjectClasspathResolutionEnabled(Boolean value) {
        defaultModelObjectClasspathResolutionEnabled = value;
    }

    public final boolean isModelObjectClasspathResolutionEnabled() {
        if (this.modelObjectClasspathResolutionEnabled == null) {
            this.modelObjectClasspathResolutionEnabled = ToolsModelProvider.isDefaultModelObjectClasspathResolutionEnabled();
        }
        return this.modelObjectClasspathResolutionEnabled;
    }

    public final void setModelObjectClasspathResolutionEnabled(Boolean value) {
        this.modelObjectClasspathResolutionEnabled = value;
    }

    public static String getDefaultHeadComment() {
        if (defaultHeadComment == null) {
            defaultHeadComment = System.getProperty(DEFAULT_HEAD_COMMENT_PROPERTY_NAME, DEFAULT_HEAD_COMMENT);
        }
        return defaultHeadComment;
    }

    public static void setDefaultHeadComment(String value) {
        defaultHeadComment = value;
    }

    public final String getHeadComment() {
        if (this.headComment == null) {
            this.headComment = ToolsModelProvider.getDefaultHeadComment();
        }
        return this.headComment;
    }

    public final void setHeadComment(String value) {
        this.headComment = value;
    }

    public static String getDefaultTailComment() {
        if (defaultTailComment == null) {
            defaultTailComment = System.getProperty(DEFAULT_TAIL_COMMENT_PROPERTY_NAME, DEFAULT_TAIL_COMMENT);
        }
        return defaultTailComment;
    }

    public static void setDefaultTailComment(String value) {
        defaultTailComment = value;
    }

    public final String getTailComment() {
        if (this.tailComment == null) {
            this.tailComment = ToolsModelProvider.getDefaultTailComment();
        }
        return this.tailComment;
    }

    public final void setTailComment(String value) {
        this.tailComment = value;
    }

    public Model findModel(ModelContext context, Model model) throws ModelException {
        boolean contextModelObjectClasspathResolutionEnabled;
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (model == null) {
            throw new NullPointerException("model");
        }
        Model provided = null;
        boolean contextEnabled = this.isEnabled();
        if (DEFAULT_ENABLED == contextEnabled && context.getAttribute(ENABLED_ATTRIBUTE_NAME) instanceof Boolean) {
            contextEnabled = (Boolean)context.getAttribute(ENABLED_ATTRIBUTE_NAME);
        }
        if ((contextModelObjectClasspathResolutionEnabled = this.isModelObjectClasspathResolutionEnabled()) == DEFAULT_MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED && context.getAttribute(MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED_ATTRIBUTE_NAME) instanceof Boolean) {
            contextModelObjectClasspathResolutionEnabled = (Boolean)context.getAttribute(MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED_ATTRIBUTE_NAME);
        }
        if (contextEnabled) {
            provided = model.clone();
            Modules modules = ModelHelper.getModules((Model)provided);
            if (modules != null) {
                Module classpathModule = null;
                if (contextModelObjectClasspathResolutionEnabled) {
                    classpathModule = modules.getClasspathModule(Modules.getDefaultClasspathModuleName(), context.getClassLoader());
                    if (classpathModule != null && modules.getModule(Modules.getDefaultClasspathModuleName()) == null) {
                        modules.getModule().add(classpathModule);
                    } else {
                        classpathModule = null;
                    }
                }
                if (modules.getSpecifications() != null) {
                    int s0 = modules.getSpecifications().getSpecification().size();
                    for (int i = 0; i < s0; ++i) {
                        Specification specification = (Specification)modules.getSpecifications().getSpecification().get(i);
                        SourceFileType sourceFileType = (SourceFileType)specification.getAnyObject(SourceFileType.class);
                        SourceFilesType sourceFilesType = (SourceFilesType)specification.getAnyObject(SourceFilesType.class);
                        if (sourceFileType != null || !specification.isClassDeclaration()) continue;
                        SourceFilesType defaultSourceFiles = this.getDefaultSourceFilesType(context, modules, specification);
                        if (sourceFilesType != null) {
                            this.overwriteSourceFiles(sourceFilesType, defaultSourceFiles, true);
                            continue;
                        }
                        specification.getAny().add(new ObjectFactory().createSourceFiles(defaultSourceFiles));
                    }
                }
                if (modules.getImplementations() != null) {
                    Implementation implementation;
                    HashMap<Implementation, SourceFilesType> userSourceFiles = new HashMap<Implementation, SourceFilesType>(modules.getImplementations().getImplementation().size());
                    InheritanceModel imodel = new InheritanceModel(modules);
                    int s0 = modules.getImplementations().getImplementation().size();
                    for (int i = 0; i < s0; ++i) {
                        implementation = (Implementation)modules.getImplementations().getImplementation().get(i);
                        SourceFileType sourceFileType = (SourceFileType)implementation.getAnyObject(SourceFileType.class);
                        SourceFilesType sourceFilesType = (SourceFilesType)implementation.getAnyObject(SourceFilesType.class);
                        if (sourceFileType != null) continue;
                        if (sourceFilesType != null) {
                            userSourceFiles.put(implementation, sourceFilesType);
                            continue;
                        }
                        if (!implementation.isClassDeclaration()) continue;
                        SourceFilesType defaultSourceFiles = this.getDefaultSourceFilesType(context, modules, implementation);
                        boolean finalAncestor = false;
                        Set sourceFilesNodes = imodel.getJaxbElementNodes(implementation.getIdentifier(), SOURCE_FILES_QNAME);
                        for (InheritanceModel.Node sourceFilesNode : sourceFilesNodes) {
                            if (!(((JAXBElement)sourceFilesNode.getModelObject()).getValue() instanceof SourceFilesType)) continue;
                            SourceFilesType ancestorSourceFiles = (SourceFilesType)((JAXBElement)sourceFilesNode.getModelObject()).getValue();
                            this.overwriteSourceFiles(defaultSourceFiles, ancestorSourceFiles, false);
                            if (!ancestorSourceFiles.isFinal()) continue;
                            finalAncestor = true;
                        }
                        if (finalAncestor) continue;
                        implementation.getAny().add(new ObjectFactory().createSourceFiles(defaultSourceFiles));
                    }
                    for (Map.Entry e : userSourceFiles.entrySet()) {
                        this.overwriteSourceFiles((SourceFilesType)e.getValue(), this.getDefaultSourceFilesType(context, modules, (Implementation)e.getKey()), true);
                    }
                    imodel = new InheritanceModel(modules);
                    s0 = modules.getImplementations().getImplementation().size();
                    for (int i = 0; i < s0; ++i) {
                        implementation = (Implementation)modules.getImplementations().getImplementation().get(i);
                        SourceFilesType sourceFilesType = (SourceFilesType)implementation.getAnyObject(SourceFilesType.class);
                        if (sourceFilesType == null || userSourceFiles.containsKey(implementation)) continue;
                        boolean override = false;
                        Set sourceFilesNodes = imodel.getJaxbElementNodes(implementation.getIdentifier(), SOURCE_FILES_QNAME);
                        for (InheritanceModel.Node e : sourceFilesNodes) {
                            if (e.getOverriddenNodes().isEmpty()) continue;
                            override = true;
                            break;
                        }
                        if (!override) continue;
                        sourceFilesType.setOverride(override);
                    }
                }
                if (classpathModule != null) {
                    modules.getModule().remove(classpathModule);
                }
            }
        } else if (context.isLoggable(Level.FINER)) {
            context.log(Level.FINER, ToolsModelProvider.getMessage("disabled", this.getClass().getSimpleName(), model.getIdentifier()), null);
        }
        return provided;
    }

    protected String getDefaultSourceFileLocation(ModelContext context, Modules modules, Specification specification) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        String location = null;
        try {
            if (specification.getJavaTypeName() != null) {
                location = specification.getJavaTypeName().getQualifiedName().replace('.', '/') + ".java";
            }
        }
        catch (ModelObjectException e) {
            context.log(Level.WARNING, ToolsModelProvider.getMessage(e), null);
        }
        return location;
    }

    protected String getDefaultSourceFileLocation(ModelContext context, Modules modules, Implementation implementation) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        String location = null;
        try {
            if (implementation.getJavaTypeName() != null) {
                location = implementation.getJavaTypeName().getQualifiedName().replace('.', '/') + ".java";
            }
        }
        catch (ModelObjectException e) {
            context.log(Level.WARNING, ToolsModelProvider.getMessage(e), null);
        }
        return location;
    }

    protected String getDefaultSourceSectionName(ModelContext context, Modules modules, Specification specification) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        String sectionName = null;
        try {
            JavaTypeName javaTypeName = specification.getJavaTypeName();
            if (javaTypeName != null) {
                sectionName = javaTypeName.getName(false);
            }
        }
        catch (ModelObjectException e) {
            context.log(Level.WARNING, ToolsModelProvider.getMessage(e), null);
        }
        return sectionName;
    }

    protected String getDefaultSourceSectionName(ModelContext context, Modules modules, Implementation implementation) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        String sectionName = null;
        try {
            JavaTypeName javaTypeName = implementation.getJavaTypeName();
            if (javaTypeName != null) {
                sectionName = javaTypeName.getName(false);
            }
        }
        catch (ModelObjectException e) {
            context.log(Level.WARNING, ToolsModelProvider.getMessage(e), null);
        }
        return sectionName;
    }

    protected SourceFilesType getDefaultSourceFilesType(ModelContext context, Modules modules, Specification specification) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        if (specification == null) {
            throw new NullPointerException("specification");
        }
        String contextHeadComment = this.getHeadComment();
        if ((DEFAULT_HEAD_COMMENT != null ? DEFAULT_HEAD_COMMENT.equals(contextHeadComment) : contextHeadComment == null) && context.getAttribute(HEAD_COMMENT_ATTRIBUTE_NAME) instanceof String) {
            contextHeadComment = (String)context.getAttribute(HEAD_COMMENT_ATTRIBUTE_NAME);
        }
        if (contextHeadComment != null && contextHeadComment.length() == 0) {
            contextHeadComment = null;
        }
        String contextTailComment = this.getTailComment();
        if ((DEFAULT_TAIL_COMMENT != null ? DEFAULT_TAIL_COMMENT.equals(contextTailComment) : contextTailComment == null) && context.getAttribute(TAIL_COMMENT_ATTRIBUTE_NAME) instanceof String) {
            contextTailComment = (String)context.getAttribute(TAIL_COMMENT_ATTRIBUTE_NAME);
        }
        if (contextTailComment != null && contextTailComment.length() == 0) {
            contextTailComment = null;
        }
        HashSet<String> uniqueSectionNames = new HashSet<String>(16);
        HashSet<String> sectionNames = new HashSet<String>(16);
        sectionNames.add("License Header");
        sectionNames.add("Annotations");
        sectionNames.add("Documentation");
        SourceFilesType sourceFilesType = new SourceFilesType();
        SourceFileType sourceFileType = new SourceFileType();
        sourceFilesType.getSourceFile().add(sourceFileType);
        sourceFileType.setIdentifier("Default");
        sourceFileType.setLocation(this.getDefaultSourceFileLocation(context, modules, specification));
        sourceFileType.setTemplate("Specification.java.vm");
        sourceFileType.setHeadComment(contextHeadComment);
        sourceFileType.setTailComment(contextTailComment);
        sourceFileType.setSourceSections(new SourceSectionsType());
        SourceSectionType s = new SourceSectionType();
        s.setName("License Header");
        s.setHeadTemplate("specification-license.vm");
        s.setOptional(true);
        sourceFileType.getSourceSections().getSourceSection().add(s);
        s = new SourceSectionType();
        s.setName("Annotations");
        s.setHeadTemplate("specification-annotations.vm");
        sourceFileType.getSourceSections().getSourceSection().add(s);
        s = new SourceSectionType();
        s.setName("Documentation");
        s.setHeadTemplate("specification-documentation.vm");
        s.setOptional(true);
        sourceFileType.getSourceSections().getSourceSection().add(s);
        String sectionName = this.getDefaultSourceSectionName(context, modules, specification);
        if (sectionName != null) {
            if (sectionNames.add(sectionName)) {
                s = new SourceSectionType();
                s.setName(sectionName);
                s.setIndentationLevel(1);
                s.setEditable(true);
                sourceFileType.getSourceSections().getSourceSection().add(s);
            } else if (uniqueSectionNames.add(sectionName)) {
                Module module = modules.getModuleOfSpecification(specification.getIdentifier());
                context.log(Level.WARNING, ToolsModelProvider.getMessage("specificationSectionNameUniqueness", specification.getIdentifier(), module.getName(), sourceFileType.getIdentifier(), sectionName), null);
            }
        }
        return sourceFilesType;
    }

    protected SourceFilesType getDefaultSourceFilesType(ModelContext context, Modules modules, Implementation implementation) {
        String sectionName;
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (modules == null) {
            throw new NullPointerException("modules");
        }
        if (implementation == null) {
            throw new NullPointerException("implementation");
        }
        String contextHeadComment = this.getHeadComment();
        if ((DEFAULT_HEAD_COMMENT != null ? DEFAULT_HEAD_COMMENT.equals(contextHeadComment) : contextHeadComment == null) && context.getAttribute(HEAD_COMMENT_ATTRIBUTE_NAME) instanceof String) {
            contextHeadComment = (String)context.getAttribute(HEAD_COMMENT_ATTRIBUTE_NAME);
        }
        if (contextHeadComment != null && contextHeadComment.length() == 0) {
            contextHeadComment = null;
        }
        String contextTailComment = this.getTailComment();
        if ((DEFAULT_TAIL_COMMENT != null ? DEFAULT_TAIL_COMMENT.equals(contextTailComment) : contextTailComment == null) && context.getAttribute(TAIL_COMMENT_ATTRIBUTE_NAME) instanceof String) {
            contextTailComment = (String)context.getAttribute(TAIL_COMMENT_ATTRIBUTE_NAME);
        }
        if (contextTailComment != null && contextTailComment.length() == 0) {
            contextTailComment = null;
        }
        HashSet<String> uniqueSectionNames = new HashSet<String>(16);
        ArrayList<String> sectionNames = new ArrayList<String>(16);
        sectionNames.add("License Header");
        sectionNames.add("Annotations");
        sectionNames.add("Documentation");
        sectionNames.add("Constructors");
        sectionNames.add("Default Constructor");
        sectionNames.add("Dependencies");
        sectionNames.add("Properties");
        sectionNames.add("Messages");
        SourceFilesType sourceFilesType = new SourceFilesType();
        SourceFileType sourceFileType = new SourceFileType();
        sourceFilesType.getSourceFile().add(sourceFileType);
        Specifications specifications = modules.getSpecifications(implementation.getIdentifier());
        Dependencies dependencies = modules.getDependencies(implementation.getIdentifier());
        Messages messages = modules.getMessages(implementation.getIdentifier());
        Properties properties = modules.getProperties(implementation.getIdentifier());
        sourceFileType.setIdentifier("Default");
        sourceFileType.setLocation(this.getDefaultSourceFileLocation(context, modules, implementation));
        sourceFileType.setTemplate("Implementation.java.vm");
        sourceFileType.setHeadComment(contextHeadComment);
        sourceFileType.setTailComment(contextTailComment);
        sourceFileType.setSourceSections(new SourceSectionsType());
        SourceSectionType s = new SourceSectionType();
        s.setName("License Header");
        s.setHeadTemplate("implementation-license.vm");
        s.setOptional(true);
        sourceFileType.getSourceSections().getSourceSection().add(s);
        s = new SourceSectionType();
        s.setName("Annotations");
        s.setHeadTemplate("implementation-annotations.vm");
        sourceFileType.getSourceSections().getSourceSection().add(s);
        s = new SourceSectionType();
        s.setName("Documentation");
        s.setHeadTemplate("implementation-documentation.vm");
        s.setOptional(true);
        sourceFileType.getSourceSections().getSourceSection().add(s);
        if (specifications != null) {
            sectionNames.ensureCapacity(sectionNames.size() + specifications.getSpecification().size());
            for (Specification specification : specifications.getSpecification()) {
                String sectionName2 = this.getDefaultSourceSectionName(context, modules, specification);
                if (sectionName2 == null) continue;
                if (!sectionNames.contains(sectionName2)) {
                    sectionNames.add(sectionName2);
                    s = new SourceSectionType();
                    s.setName(sectionName2);
                    s.setIndentationLevel(1);
                    s.setEditable(true);
                    sourceFileType.getSourceSections().getSourceSection().add(s);
                    continue;
                }
                if (!uniqueSectionNames.add(sectionName2)) continue;
                Module module = modules.getModuleOfImplementation(implementation.getIdentifier());
                context.log(Level.WARNING, ToolsModelProvider.getMessage("implementationSectionNameUniqueness", implementation.getIdentifier(), module.getName(), sourceFileType.getIdentifier(), sectionName2), null);
            }
        }
        if ((sectionName = this.getDefaultSourceSectionName(context, modules, implementation)) != null) {
            if (!sectionNames.contains(sectionName)) {
                sectionNames.add(sectionName);
                s = new SourceSectionType();
                s.setName(sectionName);
                s.setIndentationLevel(1);
                s.setEditable(true);
                sourceFileType.getSourceSections().getSourceSection().add(s);
            } else if (uniqueSectionNames.add(sectionName)) {
                Module module = modules.getModuleOfImplementation(implementation.getIdentifier());
                context.log(Level.WARNING, ToolsModelProvider.getMessage("implementationSectionNameUniqueness", implementation.getIdentifier(), module.getName(), sourceFileType.getIdentifier(), sectionName), null);
            }
        }
        s = new SourceSectionType();
        s.setName("Constructors");
        s.setIndentationLevel(1);
        s.setHeadTemplate("implementation-constructors-head.vm");
        s.setTailTemplate("implementation-constructors-tail.vm");
        s.setOptional(specifications == null || specifications.getSpecification().isEmpty() && specifications.getReference().isEmpty());
        s.setSourceSections(new SourceSectionsType());
        sourceFileType.getSourceSections().getSourceSection().add(s);
        SourceSectionType defaultCtor = new SourceSectionType();
        defaultCtor.setName("Default Constructor");
        defaultCtor.setIndentationLevel(2);
        defaultCtor.setHeadTemplate("implementation-default-constructor.vm");
        defaultCtor.setEditable(true);
        s.getSourceSections().getSourceSection().add(defaultCtor);
        s = new SourceSectionType();
        s.setName("Dependencies");
        s.setIndentationLevel(1);
        s.setHeadTemplate("implementation-dependencies.vm");
        s.setOptional(dependencies == null || dependencies.getDependency().isEmpty());
        sourceFileType.getSourceSections().getSourceSection().add(s);
        s = new SourceSectionType();
        s.setName("Properties");
        s.setIndentationLevel(1);
        s.setHeadTemplate("implementation-properties.vm");
        s.setOptional(properties == null || properties.getProperty().isEmpty());
        sourceFileType.getSourceSections().getSourceSection().add(s);
        s = new SourceSectionType();
        s.setName("Messages");
        s.setIndentationLevel(1);
        s.setHeadTemplate("implementation-messages.vm");
        s.setOptional(messages == null || messages.getMessage().isEmpty());
        sourceFileType.getSourceSections().getSourceSection().add(s);
        return sourceFilesType;
    }

    private void overwriteSourceFiles(SourceFilesType targetSourceFiles, SourceFilesType sourceSourceFiles, boolean preserveExisting) {
        if (targetSourceFiles == null) {
            throw new NullPointerException("targetSourceFiles");
        }
        if (sourceSourceFiles == null) {
            throw new NullPointerException("sourceSourceFiles");
        }
        try {
            for (SourceFileType s : sourceSourceFiles.getSourceFile()) {
                SourceFileType targetSourceFile = targetSourceFiles.getSourceFile(s.getIdentifier());
                if (targetSourceFile == null) continue;
                this.overwriteSourceFile(targetSourceFile, s, preserveExisting);
            }
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void overwriteSourceFile(SourceFileType targetSourceFile, SourceFileType sourceSourceFile, boolean preserveExisting) throws NoSuchFieldException {
        if (targetSourceFile == null) {
            throw new NullPointerException("targetSourceFile");
        }
        if (sourceSourceFile == null) {
            throw new NullPointerException("sourceSourceFile");
        }
        if (!preserveExisting) {
            targetSourceFile.setIdentifier(sourceSourceFile.getIdentifier());
            targetSourceFile.setLocation(sourceSourceFile.getLocation());
            targetSourceFile.setTemplate(sourceSourceFile.getTemplate());
            targetSourceFile.setHeadComment(sourceSourceFile.getHeadComment());
            targetSourceFile.setTailComment(sourceSourceFile.getTailComment());
            if (ToolsModelProvider.isFieldSet(sourceSourceFile, "_final")) {
                targetSourceFile.setFinal(sourceSourceFile.isFinal());
            }
            if (ToolsModelProvider.isFieldSet(sourceSourceFile, "modelVersion")) {
                targetSourceFile.setModelVersion(sourceSourceFile.getModelVersion());
            }
            if (ToolsModelProvider.isFieldSet(sourceSourceFile, "override")) {
                targetSourceFile.setOverride(sourceSourceFile.isOverride());
            }
        }
        if (sourceSourceFile.getSourceSections() != null) {
            if (targetSourceFile.getSourceSections() == null) {
                targetSourceFile.setSourceSections(new SourceSectionsType());
            }
            this.overwriteSourceSections(targetSourceFile.getSourceSections(), sourceSourceFile.getSourceSections(), preserveExisting);
        }
    }

    private void overwriteSourceSections(SourceSectionsType targetSourceSections, SourceSectionsType sourceSourceSections, boolean preserveExisting) throws NoSuchFieldException {
        if (targetSourceSections == null) {
            throw new NullPointerException("targetSourceSections");
        }
        if (sourceSourceSections == null) {
            throw new NullPointerException("sourceSourceSections");
        }
        for (SourceSectionType sourceSection : sourceSourceSections.getSourceSection()) {
            SourceSectionType targetSection = null;
            for (SourceSectionType t : targetSourceSections.getSourceSection()) {
                if (!sourceSection.getName().equals(t.getName())) continue;
                targetSection = t;
                break;
            }
            if (targetSection != null) {
                if (!preserveExisting) {
                    targetSection.setName(sourceSection.getName());
                    targetSection.setHeadTemplate(sourceSection.getHeadTemplate());
                    targetSection.setTailTemplate(sourceSection.getTailTemplate());
                    if (ToolsModelProvider.isFieldSet(sourceSection, "editable")) {
                        targetSection.setEditable(sourceSection.isEditable());
                    }
                    if (ToolsModelProvider.isFieldSet(sourceSection, "indentationLevel")) {
                        targetSection.setIndentationLevel(sourceSection.getIndentationLevel());
                    }
                    if (ToolsModelProvider.isFieldSet(sourceSection, "modelVersion")) {
                        targetSection.setModelVersion(sourceSection.getModelVersion());
                    }
                    if (ToolsModelProvider.isFieldSet(sourceSection, "optional")) {
                        targetSection.setOptional(sourceSection.isOptional());
                    }
                }
            } else {
                targetSection = sourceSection.clone();
                targetSourceSections.getSourceSection().add(targetSection);
            }
            if (sourceSection.getSourceSections() == null) continue;
            if (targetSection.getSourceSections() == null) {
                targetSection.setSourceSections(new SourceSectionsType());
            }
            this.overwriteSourceSections(targetSection.getSourceSections(), sourceSection.getSourceSections(), preserveExisting);
        }
    }

    private static boolean isFieldSet(Object object, String fieldName) throws NoSuchFieldException {
        Field field = ToolsModelProvider.getField(object.getClass(), fieldName);
        if (field == null) {
            throw new NoSuchFieldException(fieldName);
        }
        boolean accessible = field.isAccessible();
        try {
            field.setAccessible(true);
            boolean bl = field.get(object) != null;
            return bl;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        finally {
            field.setAccessible(accessible);
        }
    }

    private static Field getField(Class<?> clazz, String name) {
        if (clazz != null) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                return ToolsModelProvider.getField(clazz.getSuperclass(), name);
            }
        }
        return null;
    }

    private static String getMessage(Throwable t) {
        return t != null ? (t.getMessage() != null && t.getMessage().trim().length() > 0 ? t.getMessage() : ToolsModelProvider.getMessage(t.getCause())) : null;
    }

    private static String getMessage(String key, Object ... args) {
        return MessageFormat.format(ResourceBundle.getBundle(ToolsModelProvider.class.getName().replace('.', '/'), Locale.getDefault()).getString(key), args);
    }

    static {
        DEFAULT_MODEL_OBJECT_CLASSPATH_RESOLUTION_ENABLED = Boolean.TRUE;
        DEFAULT_TAIL_COMMENT = null;
    }
}

