/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools.modlet;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.xml.bind.JAXBElement;
import org.jomc.model.Dependencies;
import org.jomc.model.Dependency;
import org.jomc.model.Implementation;
import org.jomc.model.Message;
import org.jomc.model.Messages;
import org.jomc.model.ModelObjectException;
import org.jomc.model.Module;
import org.jomc.model.Modules;
import org.jomc.model.Specification;
import org.jomc.model.modlet.ModelHelper;
import org.jomc.modlet.Model;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelException;
import org.jomc.modlet.ModelValidationReport;
import org.jomc.modlet.ModelValidator;
import org.jomc.tools.model.ObjectFactory;
import org.jomc.tools.model.SourceFileType;
import org.jomc.tools.model.SourceFilesType;
import org.jomc.tools.model.SourceSectionType;
import org.jomc.tools.model.SourceSectionsType;
import org.jomc.tools.model.TemplateParameterType;
import org.jomc.tools.model.ToolsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolsModelValidator
implements ModelValidator {
    public static final String VALIDATE_JAVA_ATTRIBUTE_NAME = "org.jomc.tools.modlet.ToolsModelValidator.validateJavaAttribute";
    private static final String DEFAULT_VALIDATE_JAVA_PROPERTY_NAME = "org.jomc.tools.modlet.ToolsModelValidator.defaultValidateJava";
    private static final Boolean DEFAULT_VALIDATE_JAVA = Boolean.TRUE;
    private static volatile Boolean defaultValidateJava;
    private Boolean validateJava;

    public static boolean isDefaultValidateJava() {
        if (defaultValidateJava == null) {
            defaultValidateJava = Boolean.valueOf(System.getProperty(DEFAULT_VALIDATE_JAVA_PROPERTY_NAME, Boolean.toString(DEFAULT_VALIDATE_JAVA)));
        }
        return defaultValidateJava;
    }

    public static void setDefaultValidateJava(Boolean value) {
        defaultValidateJava = value;
    }

    public final boolean isValidateJava() {
        if (this.validateJava == null) {
            this.validateJava = ToolsModelValidator.isDefaultValidateJava();
        }
        return this.validateJava;
    }

    public final void setValidateJava(Boolean value) {
        this.validateJava = value;
    }

    public ModelValidationReport validateModel(ModelContext context, Model model) throws ModelException {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (model == null) {
            throw new NullPointerException("model");
        }
        ModelValidationReport report = new ModelValidationReport();
        this.assertValidToolsTypes(context, model, report);
        return report;
    }

    private void assertValidToolsTypes(ModelContext context, Model model, ModelValidationReport report) {
        Modules modules;
        String message;
        List sourceFileType = model.getAnyObjects(SourceFileType.class);
        List sourceFilesType = model.getAnyObjects(SourceFilesType.class);
        List sourceSectionType = model.getAnyObjects(SourceSectionType.class);
        List sourceSectionsType = model.getAnyObjects(SourceSectionsType.class);
        if (sourceFileType != null) {
            for (ToolsType s : sourceFileType) {
                report.getDetails().add(new ModelValidationReport.Detail("MODEL_SOURCE_FILE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("modelSourceFileConstraint", model.getIdentifier(), ((SourceFileType)s).getIdentifier()), new ObjectFactory().createSourceFile((SourceFileType)s)));
                if (this.isValidateJava()) {
                    for (TemplateParameterType templateParameterType : ((SourceFileType)s).getTemplateParameter()) {
                        try {
                            templateParameterType.getJavaValue(context.getClassLoader());
                        }
                        catch (ModelObjectException e) {
                            message = ToolsModelValidator.getMessage(e);
                            if (context.isLoggable(Level.FINE)) {
                                context.log(Level.FINE, message, (Throwable)e);
                            }
                            report.getDetails().add(new ModelValidationReport.Detail("MODEL_SOURCE_FILE_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("modelSourceFileTemplateParameterJavaValueConstraint", model.getIdentifier(), ((SourceFileType)s).getIdentifier(), templateParameterType.getName(), message != null && message.length() > 0 ? " " + message : ""), new ObjectFactory().createSourceFile((SourceFileType)s)));
                        }
                    }
                }
                this.validateTemplateParameters(report, context, ((SourceFileType)s).getSourceSections(), "MODEL_SOURCE_FILE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new ObjectFactory().createSourceFile((SourceFileType)s), "modelSourceFileSectionTemplateParameterJavaValueConstraint", model.getIdentifier(), ((SourceFileType)s).getIdentifier());
            }
        }
        if (sourceFilesType != null) {
            for (SourceFilesType files : sourceFilesType) {
                for (SourceFileType sourceFileType2 : files.getSourceFile()) {
                    report.getDetails().add(new ModelValidationReport.Detail("MODEL_SOURCE_FILE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("modelSourceFileConstraint", model.getIdentifier(), sourceFileType2.getIdentifier()), new ObjectFactory().createSourceFile(sourceFileType2)));
                    if (this.isValidateJava()) {
                        for (TemplateParameterType p : sourceFileType2.getTemplateParameter()) {
                            try {
                                p.getJavaValue(context.getClassLoader());
                            }
                            catch (ModelObjectException e) {
                                String message2 = ToolsModelValidator.getMessage(e);
                                if (context.isLoggable(Level.FINE)) {
                                    context.log(Level.FINE, message2, (Throwable)e);
                                }
                                report.getDetails().add(new ModelValidationReport.Detail("MODEL_SOURCE_FILE_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("modelSourceFileTemplateParameterJavaValueConstraint", model.getIdentifier(), sourceFileType2.getIdentifier(), p.getName(), message2 != null && message2.length() > 0 ? " " + message2 : ""), new ObjectFactory().createSourceFile(sourceFileType2)));
                            }
                        }
                    }
                    this.validateTemplateParameters(report, context, sourceFileType2.getSourceSections(), "MODEL_SOURCE_FILE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new ObjectFactory().createSourceFile(sourceFileType2), "modelSourceFileSectionTemplateParameterJavaValueConstraint", model.getIdentifier(), sourceFileType2.getIdentifier());
                }
                if (!files.getSourceFile().isEmpty()) continue;
                report.getDetails().add(new ModelValidationReport.Detail("MODEL_SOURCE_FILES_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("modelSourceFilesConstraint", model.getIdentifier()), new ObjectFactory().createSourceFiles(files)));
            }
        }
        if (sourceSectionType != null) {
            for (ToolsType s : sourceSectionType) {
                report.getDetails().add(new ModelValidationReport.Detail("MODEL_SOURCE_SECTION_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("modelSourceSectionConstraint", model.getIdentifier(), ((SourceSectionType)s).getName()), new ObjectFactory().createSourceSection((SourceSectionType)s)));
                if (this.isValidateJava()) {
                    for (TemplateParameterType templateParameterType : ((SourceSectionType)s).getTemplateParameter()) {
                        try {
                            templateParameterType.getJavaValue(context.getClassLoader());
                        }
                        catch (ModelObjectException e) {
                            message = ToolsModelValidator.getMessage(e);
                            if (context.isLoggable(Level.FINE)) {
                                context.log(Level.FINE, message, (Throwable)e);
                            }
                            report.getDetails().add(new ModelValidationReport.Detail("MODEL_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("modelSourceSectionTemplateParameterJavaValueConstraint", model.getIdentifier(), ((SourceSectionType)s).getName(), templateParameterType.getName(), message != null && message.length() > 0 ? " " + message : ""), new ObjectFactory().createSourceSection((SourceSectionType)s)));
                        }
                    }
                }
                this.validateTemplateParameters(report, context, ((SourceSectionType)s).getSourceSections(), "MODEL_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new ObjectFactory().createSourceSection((SourceSectionType)s), "modelSourceSectionTemplateParameterJavaValueConstraint", model.getIdentifier());
            }
        }
        if (sourceSectionsType != null) {
            for (SourceSectionsType sections : sourceSectionsType) {
                for (SourceSectionType sourceSectionType2 : sections.getSourceSection()) {
                    report.getDetails().add(new ModelValidationReport.Detail("MODEL_SOURCE_SECTION_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("modelSourceSectionConstraint", model.getIdentifier(), sourceSectionType2.getName()), new ObjectFactory().createSourceSection(sourceSectionType2)));
                }
                if (sections.getSourceSection().isEmpty()) {
                    report.getDetails().add(new ModelValidationReport.Detail("MODEL_SOURCE_SECTIONS_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("modelSourceSectionsConstraint", model.getIdentifier()), new ObjectFactory().createSourceSections(sections)));
                }
                this.validateTemplateParameters(report, context, sections, "MODEL_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new ObjectFactory().createSourceSections(sections), "modelSourceSectionTemplateParameterJavaValueConstraint", model.getIdentifier());
            }
        }
        if ((modules = ModelHelper.getModules((Model)model)) != null) {
            this.assertValidToolsTypes(context, modules, report);
        }
    }

    private void assertValidToolsTypes(ModelContext context, Modules modules, ModelValidationReport report) {
        int s0 = modules.getModule().size();
        for (int i = 0; i < s0; ++i) {
            this.assertValidToolsTypes(context, (Module)modules.getModule().get(i), report);
        }
    }

    private void assertValidToolsTypes(ModelContext context, Module module, ModelValidationReport report) {
        String message;
        List sourceFileType = module.getAnyObjects(SourceFileType.class);
        List sourceFilesType = module.getAnyObjects(SourceFilesType.class);
        List sourceSectionType = module.getAnyObjects(SourceSectionType.class);
        List sourceSectionsType = module.getAnyObjects(SourceSectionsType.class);
        if (sourceFileType != null) {
            for (ToolsType s : sourceFileType) {
                report.getDetails().add(new ModelValidationReport.Detail("MODULE_SOURCE_FILE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("moduleSourceFileConstraint", module.getName(), ((SourceFileType)s).getIdentifier()), new ObjectFactory().createSourceFile((SourceFileType)s)));
                if (this.isValidateJava()) {
                    for (TemplateParameterType templateParameterType : ((SourceFileType)s).getTemplateParameter()) {
                        try {
                            templateParameterType.getJavaValue(context.getClassLoader());
                        }
                        catch (ModelObjectException e) {
                            String message2 = ToolsModelValidator.getMessage(e);
                            if (context.isLoggable(Level.FINE)) {
                                context.log(Level.FINE, message2, (Throwable)e);
                            }
                            report.getDetails().add(new ModelValidationReport.Detail("MODULE_SOURCE_FILE_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("moduleSourceFileTemplateParameterJavaValueConstraint", module.getName(), ((SourceFileType)s).getIdentifier(), templateParameterType.getName(), message2 != null && message2.length() > 0 ? " " + message2 : ""), new ObjectFactory().createSourceFile((SourceFileType)s)));
                        }
                    }
                }
                this.validateTemplateParameters(report, context, ((SourceFileType)s).getSourceSections(), "MODULE_SOURCE_FILE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new ObjectFactory().createSourceFile((SourceFileType)s), "moduleSourceFileSectionTemplateParameterJavaValueConstraint", module.getName(), ((SourceFileType)s).getIdentifier());
            }
        }
        if (sourceFilesType != null) {
            for (SourceFilesType files : sourceFilesType) {
                for (SourceFileType sourceFileType2 : files.getSourceFile()) {
                    report.getDetails().add(new ModelValidationReport.Detail("MODULE_SOURCE_FILE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("moduleSourceFileConstraint", module.getName(), sourceFileType2.getIdentifier()), new ObjectFactory().createSourceFile(sourceFileType2)));
                    if (this.isValidateJava()) {
                        for (TemplateParameterType p : sourceFileType2.getTemplateParameter()) {
                            try {
                                p.getJavaValue(context.getClassLoader());
                            }
                            catch (ModelObjectException e) {
                                message = ToolsModelValidator.getMessage(e);
                                if (context.isLoggable(Level.FINE)) {
                                    context.log(Level.FINE, message, (Throwable)e);
                                }
                                report.getDetails().add(new ModelValidationReport.Detail("MODULE_SOURCE_FILE_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("moduleSourceFileTemplateParameterJavaValueConstraint", module.getName(), sourceFileType2.getIdentifier(), p.getName(), message != null && message.length() > 0 ? " " + message : ""), new ObjectFactory().createSourceFile(sourceFileType2)));
                            }
                        }
                    }
                    this.validateTemplateParameters(report, context, sourceFileType2.getSourceSections(), "MODULE_SOURCE_FILE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new ObjectFactory().createSourceFile(sourceFileType2), "moduleSourceFileSectionTemplateParameterJavaValueConstraint", module.getName(), sourceFileType2.getIdentifier());
                }
                if (!files.getSourceFile().isEmpty()) continue;
                report.getDetails().add(new ModelValidationReport.Detail("MODULE_SOURCE_FILES_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("moduleSourceFilesConstraint", module.getName()), new ObjectFactory().createSourceFiles(files)));
            }
        }
        if (sourceSectionType != null) {
            for (ToolsType s : sourceSectionType) {
                report.getDetails().add(new ModelValidationReport.Detail("MODULE_SOURCE_SECTION_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("moduleSourceSectionConstraint", module.getName(), ((SourceSectionType)s).getName()), new ObjectFactory().createSourceSection((SourceSectionType)s)));
                if (this.isValidateJava()) {
                    for (TemplateParameterType templateParameterType : ((SourceSectionType)s).getTemplateParameter()) {
                        try {
                            templateParameterType.getJavaValue(context.getClassLoader());
                        }
                        catch (ModelObjectException e) {
                            String message2 = ToolsModelValidator.getMessage(e);
                            if (context.isLoggable(Level.FINE)) {
                                context.log(Level.FINE, message2, (Throwable)e);
                            }
                            report.getDetails().add(new ModelValidationReport.Detail("MODULE_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("moduleSourceSectionTemplateParameterJavaValueConstraint", module.getName(), ((SourceSectionType)s).getName(), templateParameterType.getName(), message2 != null && message2.length() > 0 ? " " + message2 : ""), new ObjectFactory().createSourceSection((SourceSectionType)s)));
                        }
                    }
                }
                this.validateTemplateParameters(report, context, ((SourceSectionType)s).getSourceSections(), "MODULE_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new ObjectFactory().createSourceSection((SourceSectionType)s), "moduleSourceSectionTemplateParameterJavaValueConstraint", module.getName(), ((SourceSectionType)s).getName());
            }
        }
        if (sourceSectionsType != null) {
            for (SourceSectionsType sections : sourceSectionsType) {
                for (SourceSectionType sourceSectionType2 : sections.getSourceSection()) {
                    report.getDetails().add(new ModelValidationReport.Detail("MODULE_SOURCE_SECTION_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("moduleSourceSectionConstraint", module.getName(), sourceSectionType2.getName()), new ObjectFactory().createSourceSection(sourceSectionType2)));
                    if (this.isValidateJava()) {
                        for (TemplateParameterType p : sourceSectionType2.getTemplateParameter()) {
                            try {
                                p.getJavaValue(context.getClassLoader());
                            }
                            catch (ModelObjectException e) {
                                message = ToolsModelValidator.getMessage(e);
                                if (context.isLoggable(Level.FINE)) {
                                    context.log(Level.FINE, message, (Throwable)e);
                                }
                                report.getDetails().add(new ModelValidationReport.Detail("MODULE_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("moduleSourceSectionTemplateParameterJavaValueConstraint", module.getName(), sourceSectionType2.getName(), p.getName(), message != null && message.length() > 0 ? " " + message : ""), new ObjectFactory().createSourceSection(sourceSectionType2)));
                            }
                        }
                    }
                    this.validateTemplateParameters(report, context, sourceSectionType2.getSourceSections(), "MODULE_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new ObjectFactory().createSourceSection(sourceSectionType2), "moduleSourceSectionTemplateParameterJavaValueConstraint", module.getName(), sourceSectionType2.getName());
                }
                if (!sections.getSourceSection().isEmpty()) continue;
                report.getDetails().add(new ModelValidationReport.Detail("MODULE_SOURCE_SECTIONS_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("moduleSourceSectionsConstraint", module.getName()), new ObjectFactory().createSourceSections(sections)));
            }
        }
        if (module.getImplementations() != null) {
            int s0 = module.getImplementations().getImplementation().size();
            for (int i = 0; i < s0; ++i) {
                this.assertValidToolsTypes(context, module, (Implementation)module.getImplementations().getImplementation().get(i), report);
            }
        }
        if (module.getSpecifications() != null) {
            int s0 = module.getSpecifications().getSpecification().size();
            for (int i = 0; i < s0; ++i) {
                this.assertValidToolsTypes(context, module, (Specification)module.getSpecifications().getSpecification().get(i), report);
            }
        }
    }

    private void assertValidToolsTypes(ModelContext context, Module module, Implementation implementation, ModelValidationReport report) {
        String message;
        List sourceFileType = implementation.getAnyObjects(SourceFileType.class);
        List sourceFilesType = implementation.getAnyObjects(SourceFilesType.class);
        List sourceSectionType = implementation.getAnyObjects(SourceSectionType.class);
        List sourceSectionsType = implementation.getAnyObjects(SourceSectionsType.class);
        if (sourceFileType != null) {
            for (ToolsType s : sourceFileType) {
                if (this.isValidateJava()) {
                    for (TemplateParameterType templateParameterType : ((SourceFileType)s).getTemplateParameter()) {
                        try {
                            templateParameterType.getJavaValue(context.getClassLoader());
                        }
                        catch (ModelObjectException e) {
                            String message2 = ToolsModelValidator.getMessage(e);
                            if (context.isLoggable(Level.FINE)) {
                                context.log(Level.FINE, message2, (Throwable)e);
                            }
                            report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_SOURCE_FILE_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("implementationSourceFileTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), ((SourceFileType)s).getIdentifier(), templateParameterType.getName(), message2 != null && message2.length() > 0 ? " " + message2 : ""), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                        }
                    }
                }
                this.validateTemplateParameters(report, context, ((SourceFileType)s).getSourceSections(), "IMPLEMENTATION_SOURCE_FILE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createImplementation(implementation), "implementationSourceFileSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), ((SourceFileType)s).getIdentifier());
            }
            if (sourceFileType.size() > 1) {
                report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_SOURCE_FILE_MULTIPLICITY_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("implementationSourceFileMultiplicityConstraint", module.getName(), implementation.getIdentifier(), sourceFileType.size()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
            } else if (sourceFileType.size() == 1) {
                report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_SOURCE_FILE_INFORMATION", Level.INFO, ToolsModelValidator.getMessage("implementationSourceFileInfo", module.getName(), implementation.getIdentifier(), ((SourceFileType)sourceFileType.get(0)).getIdentifier()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
            }
        }
        if (sourceFilesType != null) {
            if (sourceFilesType.size() > 1) {
                report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_SOURCE_FILES_MULTIPLICITY_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("implementationSourceFilesMultiplicityConstraint", module.getName(), implementation.getIdentifier(), sourceFilesType.size()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
            }
            for (SourceFilesType l : sourceFilesType) {
                for (SourceFileType sourceFileType2 : l.getSourceFile()) {
                    if (this.isValidateJava()) {
                        for (TemplateParameterType p : sourceFileType2.getTemplateParameter()) {
                            try {
                                p.getJavaValue(context.getClassLoader());
                            }
                            catch (ModelObjectException e) {
                                message = ToolsModelValidator.getMessage(e);
                                if (context.isLoggable(Level.FINE)) {
                                    context.log(Level.FINE, message, (Throwable)e);
                                }
                                report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_SOURCE_FILE_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("implementationSourceFileTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), sourceFileType2.getIdentifier(), p.getName(), message != null && message.length() > 0 ? " " + message : ""), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                            }
                        }
                    }
                    this.validateTemplateParameters(report, context, sourceFileType2.getSourceSections(), "IMPLEMENTATION_SOURCE_FILE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createImplementation(implementation), "implementationSourceFileSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), sourceFileType2.getIdentifier());
                }
            }
        }
        if (sourceSectionType != null) {
            for (ToolsType s : sourceSectionType) {
                report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_SOURCE_SECTION_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("implementationSourceSectionConstraint", module.getName(), implementation.getIdentifier(), ((SourceSectionType)s).getName()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                if (this.isValidateJava()) {
                    for (TemplateParameterType templateParameterType : ((SourceSectionType)s).getTemplateParameter()) {
                        try {
                            templateParameterType.getJavaValue(context.getClassLoader());
                        }
                        catch (ModelObjectException e) {
                            String message2 = ToolsModelValidator.getMessage(e);
                            if (context.isLoggable(Level.FINE)) {
                                context.log(Level.FINE, message2, (Throwable)e);
                            }
                            report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("implementationSourceSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), ((SourceSectionType)s).getName(), templateParameterType.getName(), message2 != null && message2.length() > 0 ? " " + message2 : ""), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                        }
                    }
                }
                this.validateTemplateParameters(report, context, ((SourceSectionType)s).getSourceSections(), "IMPLEMENTATION_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createImplementation(implementation), "implementationSourceSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier());
            }
        }
        if (sourceSectionsType != null) {
            for (SourceSectionsType sections : sourceSectionsType) {
                for (SourceSectionType sourceSectionType2 : sections.getSourceSection()) {
                    report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_SOURCE_SECTION_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("implementationSourceSectionConstraint", module.getName(), implementation.getIdentifier(), sourceSectionType2.getName()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                    if (this.isValidateJava()) {
                        for (TemplateParameterType p : sourceSectionType2.getTemplateParameter()) {
                            try {
                                p.getJavaValue(context.getClassLoader());
                            }
                            catch (ModelObjectException e) {
                                message = ToolsModelValidator.getMessage(e);
                                if (context.isLoggable(Level.FINE)) {
                                    context.log(Level.FINE, message, (Throwable)e);
                                }
                                report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("implementationSourceSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), sourceSectionType2.getName(), p.getName(), message != null && message.length() > 0 ? " " + message : ""), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                            }
                        }
                    }
                    this.validateTemplateParameters(report, context, sourceSectionType2.getSourceSections(), "IMPLEMENTATION_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createImplementation(implementation), "implementationSourceSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier());
                }
                if (!sections.getSourceSection().isEmpty()) continue;
                report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_SOURCE_SECTIONS_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("implementationSourceSectionsConstraint", module.getName(), implementation.getIdentifier()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
            }
        }
        if (implementation.getDependencies() != null) {
            this.assertValidToolsTypes(context, module, implementation, implementation.getDependencies(), report);
        }
        if (implementation.getMessages() != null) {
            this.assertValidToolsTypes(context, module, implementation, implementation.getMessages(), report);
        }
    }

    private void assertValidToolsTypes(ModelContext context, Module module, Implementation implementation, Dependencies dependencies, ModelValidationReport report) {
        for (Dependency d : dependencies.getDependency()) {
            String message;
            List sourceFileType = d.getAnyObjects(SourceFileType.class);
            List sourceFilesType = d.getAnyObjects(SourceFilesType.class);
            List sourceSectionType = d.getAnyObjects(SourceSectionType.class);
            List sourceSectionsType = d.getAnyObjects(SourceSectionsType.class);
            if (sourceFileType != null) {
                for (ToolsType s : sourceFileType) {
                    report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_DEPENDENCY_SOURCE_FILE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("dependencySourceFileConstraint", module.getName(), implementation.getIdentifier(), d.getName(), ((SourceFileType)s).getIdentifier()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                    if (this.isValidateJava()) {
                        for (TemplateParameterType templateParameterType : ((SourceFileType)s).getTemplateParameter()) {
                            try {
                                templateParameterType.getJavaValue(context.getClassLoader());
                            }
                            catch (ModelObjectException e) {
                                String message2 = ToolsModelValidator.getMessage(e);
                                if (context.isLoggable(Level.FINE)) {
                                    context.log(Level.FINE, message2, (Throwable)e);
                                }
                                report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_DEPENDENCY_SOURCE_FILE_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("dependencySourceFileTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), d.getName(), ((SourceFileType)s).getIdentifier(), templateParameterType.getName(), message2 != null && message2.length() > 0 ? " " + message2 : ""), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                            }
                        }
                    }
                    this.validateTemplateParameters(report, context, ((SourceFileType)s).getSourceSections(), "IMPLEMENTATION_DEPENDENCY_SOURCE_FILE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createImplementation(implementation), "dependencySourceFileSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), d.getName(), ((SourceFileType)s).getIdentifier());
                }
            }
            if (sourceFilesType != null) {
                for (SourceFilesType files : sourceFilesType) {
                    for (SourceFileType sourceFileType2 : files.getSourceFile()) {
                        report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_DEPENDENCY_SOURCE_FILE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("dependencySourceFileConstraint", module.getName(), implementation.getIdentifier(), d.getName(), sourceFileType2.getIdentifier()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                        if (this.isValidateJava()) {
                            for (TemplateParameterType p : sourceFileType2.getTemplateParameter()) {
                                try {
                                    p.getJavaValue(context.getClassLoader());
                                }
                                catch (ModelObjectException e) {
                                    message = ToolsModelValidator.getMessage(e);
                                    if (context.isLoggable(Level.FINE)) {
                                        context.log(Level.FINE, message, (Throwable)e);
                                    }
                                    report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_DEPENDENCY_SOURCE_FILE_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("dependencySourceFileTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), d.getName(), sourceFileType2.getIdentifier(), p.getName(), message != null && message.length() > 0 ? " " + message : ""), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                                }
                            }
                        }
                        this.validateTemplateParameters(report, context, sourceFileType2.getSourceSections(), "IMPLEMENTATION_DEPENDENCY_SOURCE_FILE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createImplementation(implementation), "dependencySourceFileSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), d.getName(), sourceFileType2.getIdentifier());
                    }
                    if (!files.getSourceFile().isEmpty()) continue;
                    report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_DEPENDENCY_SOURCE_FILES_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("dependencySourceFilesConstraint", module.getName(), implementation.getIdentifier(), d.getName()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                }
            }
            if (sourceSectionType != null) {
                for (ToolsType s : sourceSectionType) {
                    report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_DEPENDENCY_SOURCE_SECTION_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("dependencySourceSectionConstraint", module.getName(), implementation.getIdentifier(), d.getName(), ((SourceSectionType)s).getName()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                    if (this.isValidateJava()) {
                        for (TemplateParameterType templateParameterType : ((SourceSectionType)s).getTemplateParameter()) {
                            try {
                                templateParameterType.getJavaValue(context.getClassLoader());
                            }
                            catch (ModelObjectException e) {
                                String message2 = ToolsModelValidator.getMessage(e);
                                if (context.isLoggable(Level.FINE)) {
                                    context.log(Level.FINE, message2, (Throwable)e);
                                }
                                report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_DEPENDENCY_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("dependencySourceSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), d.getName(), ((SourceSectionType)s).getName(), templateParameterType.getName(), message2 != null && message2.length() > 0 ? " " + message2 : ""), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                            }
                        }
                    }
                    this.validateTemplateParameters(report, context, ((SourceSectionType)s).getSourceSections(), "IMPLEMENTATION_DEPENDENCY_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createImplementation(implementation), "dependencySourceSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), d.getName());
                }
            }
            if (sourceSectionsType == null) continue;
            for (SourceSectionsType sections : sourceSectionsType) {
                for (SourceSectionType sourceSectionType2 : sections.getSourceSection()) {
                    report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_DEPENDENCY_SOURCE_SECTION_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("dependencySourceSectionConstraint", module.getName(), implementation.getIdentifier(), d.getName(), sourceSectionType2.getName()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                    if (this.isValidateJava()) {
                        for (TemplateParameterType p : sourceSectionType2.getTemplateParameter()) {
                            try {
                                p.getJavaValue(context.getClassLoader());
                            }
                            catch (ModelObjectException e) {
                                message = ToolsModelValidator.getMessage(e);
                                if (context.isLoggable(Level.FINE)) {
                                    context.log(Level.FINE, message, (Throwable)e);
                                }
                                report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_DEPENDENCY_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("dependencySourceSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), d.getName(), sourceSectionType2.getName(), p.getName(), message != null && message.length() > 0 ? " " + message : ""), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                            }
                        }
                    }
                    this.validateTemplateParameters(report, context, sourceSectionType2.getSourceSections(), "IMPLEMENTATION_DEPENDENCY_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createImplementation(implementation), "dependencySourceSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), d.getName());
                }
                if (!sections.getSourceSection().isEmpty()) continue;
                report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_DEPENDENCY_SOURCE_SECTIONS_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("dependencySourceSectionsConstraint", module.getName(), implementation.getIdentifier(), d.getName()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertValidToolsTypes(ModelContext context, Module module, Implementation implementation, Messages messages, ModelValidationReport report) {
        for (Message m : messages.getMessage()) {
            String message;
            List sourceFileType = m.getAnyObjects(SourceFileType.class);
            List sourceFilesType = m.getAnyObjects(SourceFilesType.class);
            List sourceSectionType = m.getAnyObjects(SourceSectionType.class);
            List sourceSectionsType = m.getAnyObjects(SourceSectionsType.class);
            if (sourceFileType != null) {
                for (ToolsType s : sourceFileType) {
                    report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_MESSAGE_SOURCE_FILE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("messageSourceFileConstraint", module.getName(), implementation.getIdentifier(), m.getName(), ((SourceFileType)s).getIdentifier()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                    if (this.isValidateJava()) {
                        for (TemplateParameterType templateParameterType : ((SourceFileType)s).getTemplateParameter()) {
                            try {
                                templateParameterType.getJavaValue(context.getClassLoader());
                            }
                            catch (ModelObjectException e) {
                                String message2 = ToolsModelValidator.getMessage(e);
                                if (context.isLoggable(Level.FINE)) {
                                    context.log(Level.FINE, message2, (Throwable)e);
                                }
                                report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_MESSAGE_SOURCE_FILE_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("messageSourceFileTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), m.getName(), ((SourceFileType)s).getIdentifier(), templateParameterType.getName(), message2 != null && message2.length() > 0 ? " " + message2 : ""), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                            }
                        }
                    }
                    this.validateTemplateParameters(report, context, ((SourceFileType)s).getSourceSections(), "IMPLEMENTATION_MESSAGE_SOURCE_FILE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createImplementation(implementation), "messageSourceFileSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), m.getName(), ((SourceFileType)s).getIdentifier());
                }
            }
            if (sourceFilesType != null) {
                for (SourceFilesType files : sourceFilesType) {
                    for (SourceFileType sourceFileType2 : files.getSourceFile()) {
                        report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_MESSAGE_SOURCE_FILE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("messageSourceFileConstraint", module.getName(), implementation.getIdentifier(), m.getName(), sourceFileType2.getIdentifier()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                        if (this.isValidateJava()) {
                            for (TemplateParameterType p : sourceFileType2.getTemplateParameter()) {
                                try {
                                    p.getJavaValue(context.getClassLoader());
                                }
                                catch (ModelObjectException e) {
                                    message = ToolsModelValidator.getMessage(e);
                                    if (context.isLoggable(Level.FINE)) {
                                        context.log(Level.FINE, message, (Throwable)e);
                                    }
                                    report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_MESSAGE_SOURCE_FILE_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("messageSourceFileTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), m.getName(), sourceFileType2.getIdentifier(), p.getName(), message != null && message.length() > 0 ? " " + message : ""), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                                }
                            }
                        }
                        this.validateTemplateParameters(report, context, sourceFileType2.getSourceSections(), "IMPLEMENTATION_MESSAGE_SOURCE_FILE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createImplementation(implementation), "messageSourceFileSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), m.getName(), sourceFileType2.getIdentifier());
                    }
                    if (!files.getSourceFile().isEmpty()) continue;
                    report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_MESSAGE_SOURCE_FILES_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("messageSourceFilesConstraint", module.getName(), implementation.getIdentifier(), m.getName()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                }
            }
            if (sourceSectionType != null) {
                for (ToolsType s : sourceSectionType) {
                    report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_MESSAGE_SOURCE_SECTION_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("messageSourceSectionConstraint", module.getName(), implementation.getIdentifier(), m.getName(), ((SourceSectionType)s).getName()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                    if (this.isValidateJava()) {
                        for (TemplateParameterType templateParameterType : ((SourceSectionType)s).getTemplateParameter()) {
                            try {
                                templateParameterType.getJavaValue(context.getClassLoader());
                            }
                            catch (ModelObjectException e) {
                                String message2 = ToolsModelValidator.getMessage(e);
                                if (context.isLoggable(Level.FINE)) {
                                    context.log(Level.FINE, message2, (Throwable)e);
                                }
                                report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_MESSAGE_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("messageSourceSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), m.getName(), ((SourceSectionType)s).getName(), templateParameterType.getName(), message2 != null && message2.length() > 0 ? " " + message2 : ""), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                            }
                        }
                    }
                    this.validateTemplateParameters(report, context, ((SourceSectionType)s).getSourceSections(), "IMPLEMENTATION_MESSAGE_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createImplementation(implementation), "messageSourceSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), m.getName());
                }
            }
            if (sourceSectionsType == null) continue;
            for (SourceSectionsType sections : sourceSectionsType) {
                for (SourceSectionType sourceSectionType2 : sections.getSourceSection()) {
                    report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_MESSAGE_SOURCE_SECTION_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("messageSourceSectionConstraint", module.getName(), implementation.getIdentifier(), m.getName(), sourceSectionType2.getName()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                    if (this.isValidateJava()) {
                        for (TemplateParameterType p : sourceSectionType2.getTemplateParameter()) {
                            try {
                                p.getJavaValue(context.getClassLoader());
                            }
                            catch (ModelObjectException e) {
                                message = ToolsModelValidator.getMessage(e);
                                if (context.isLoggable(Level.FINE)) {
                                    context.log(Level.FINE, message, (Throwable)e);
                                }
                                report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_MESSAGE_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("messageSourceSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), m.getName(), sourceSectionType2.getName(), p.getName(), message != null && message.length() > 0 ? " " + message : ""), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
                            }
                        }
                    }
                    this.validateTemplateParameters(report, context, sourceSectionType2.getSourceSections(), "IMPLEMENTATION_MESSAGE_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createImplementation(implementation), "messageSourceSectionTemplateParameterJavaValueConstraint", module.getName(), implementation.getIdentifier(), m.getName());
                }
                if (!sections.getSourceSection().isEmpty()) continue;
                report.getDetails().add(new ModelValidationReport.Detail("IMPLEMENTATION_MESSAGE_SOURCE_SECTIONS_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("messageSourceSectionsConstraint", module.getName(), implementation.getIdentifier(), m.getName()), new org.jomc.model.ObjectFactory().createImplementation(implementation)));
            }
        }
    }

    private void assertValidToolsTypes(ModelContext context, Module module, Specification specification, ModelValidationReport report) {
        String message;
        List sourceFileType = specification.getAnyObjects(SourceFileType.class);
        List sourceFilesType = specification.getAnyObjects(SourceFilesType.class);
        List sourceSectionType = specification.getAnyObjects(SourceSectionType.class);
        List sourceSectionsType = specification.getAnyObjects(SourceSectionsType.class);
        if (sourceFileType != null) {
            for (ToolsType s : sourceFileType) {
                if (this.isValidateJava()) {
                    for (TemplateParameterType templateParameterType : ((SourceFileType)s).getTemplateParameter()) {
                        try {
                            templateParameterType.getJavaValue(context.getClassLoader());
                        }
                        catch (ModelObjectException e) {
                            String message2 = ToolsModelValidator.getMessage(e);
                            if (context.isLoggable(Level.FINE)) {
                                context.log(Level.FINE, message2, (Throwable)e);
                            }
                            report.getDetails().add(new ModelValidationReport.Detail("SPECIFICATION_SOURCE_FILE_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("specificationSourceFileTemplateParameterJavaValueConstraint", module.getName(), specification.getIdentifier(), ((SourceFileType)s).getIdentifier(), templateParameterType.getName(), message2 != null && message2.length() > 0 ? " " + message2 : ""), new org.jomc.model.ObjectFactory().createSpecification(specification)));
                        }
                    }
                }
                this.validateTemplateParameters(report, context, ((SourceFileType)s).getSourceSections(), "SPECIFICATION_SOURCE_FILE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createSpecification(specification), "specificationSourceFileSectionTemplateParameterJavaValueConstraint", module.getName(), specification.getIdentifier(), ((SourceFileType)s).getIdentifier());
            }
            if (sourceFileType.size() > 1) {
                report.getDetails().add(new ModelValidationReport.Detail("SPECIFICATION_SOURCE_FILE_MULTIPLICITY_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("specificationSourceFileMultiplicityConstraint", module.getName(), specification.getIdentifier(), sourceFileType.size()), new org.jomc.model.ObjectFactory().createSpecification(specification)));
            } else if (sourceFileType.size() == 1) {
                report.getDetails().add(new ModelValidationReport.Detail("SPECIFICATION_SOURCE_FILE_INFORMATION", Level.INFO, ToolsModelValidator.getMessage("specificationSourceFileInfo", module.getName(), specification.getIdentifier(), ((SourceFileType)sourceFileType.get(0)).getIdentifier()), new org.jomc.model.ObjectFactory().createSpecification(specification)));
            }
        }
        if (sourceFilesType != null) {
            for (SourceFilesType l : sourceFilesType) {
                for (SourceFileType sourceFileType2 : l.getSourceFile()) {
                    if (this.isValidateJava()) {
                        for (TemplateParameterType p : sourceFileType2.getTemplateParameter()) {
                            try {
                                p.getJavaValue(context.getClassLoader());
                            }
                            catch (ModelObjectException e) {
                                message = ToolsModelValidator.getMessage(e);
                                if (context.isLoggable(Level.FINE)) {
                                    context.log(Level.FINE, message, (Throwable)e);
                                }
                                report.getDetails().add(new ModelValidationReport.Detail("SPECIFICATION_SOURCE_FILE_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("specificationSourceFileTemplateParameterJavaValueConstraint", module.getName(), specification.getIdentifier(), sourceFileType2.getIdentifier(), p.getName(), message != null && message.length() > 0 ? " " + message : ""), new org.jomc.model.ObjectFactory().createSpecification(specification)));
                            }
                        }
                    }
                    this.validateTemplateParameters(report, context, sourceFileType2.getSourceSections(), "SPECIFICATION_SOURCE_FILE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createSpecification(specification), "specificationSourceFileSectionTemplateParameterJavaValueConstraint", module.getName(), specification.getIdentifier(), sourceFileType2.getIdentifier());
                }
            }
            if (sourceFilesType.size() > 1) {
                report.getDetails().add(new ModelValidationReport.Detail("SPECIFICATION_SOURCE_FILES_MULTIPLICITY_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("specificationSourceFilesMultiplicityConstraint", module.getName(), specification.getIdentifier(), sourceFilesType.size()), new org.jomc.model.ObjectFactory().createSpecification(specification)));
            }
        }
        if (sourceSectionType != null) {
            for (ToolsType s : sourceSectionType) {
                report.getDetails().add(new ModelValidationReport.Detail("SPECIFICATION_SOURCE_SECTION_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("specificationSourceSectionConstraint", specification.getIdentifier(), ((SourceSectionType)s).getName()), new org.jomc.model.ObjectFactory().createSpecification(specification)));
                if (this.isValidateJava()) {
                    for (TemplateParameterType templateParameterType : ((SourceSectionType)s).getTemplateParameter()) {
                        try {
                            templateParameterType.getJavaValue(context.getClassLoader());
                        }
                        catch (ModelObjectException e) {
                            String message2 = ToolsModelValidator.getMessage(e);
                            if (context.isLoggable(Level.FINE)) {
                                context.log(Level.FINE, message2, (Throwable)e);
                            }
                            report.getDetails().add(new ModelValidationReport.Detail("SPECIFICATION_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("specificationSourceSectionTemplateParameterJavaValueConstraint", module.getName(), specification.getIdentifier(), ((SourceSectionType)s).getName(), templateParameterType.getName(), message2 != null && message2.length() > 0 ? " " + message2 : ""), new org.jomc.model.ObjectFactory().createSpecification(specification)));
                        }
                    }
                }
                this.validateTemplateParameters(report, context, ((SourceSectionType)s).getSourceSections(), "SPECIFICATION_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createSpecification(specification), "specificationSourceSectionTemplateParameterJavaValueConstraint", module.getName(), specification.getIdentifier());
            }
        }
        if (sourceSectionsType != null) {
            for (SourceSectionsType sections : sourceSectionsType) {
                for (SourceSectionType sourceSectionType2 : sections.getSourceSection()) {
                    report.getDetails().add(new ModelValidationReport.Detail("SPECIFICATION_SOURCE_SECTION_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("specificationSourceSectionConstraint", specification.getIdentifier(), sourceSectionType2.getName()), new org.jomc.model.ObjectFactory().createSpecification(specification)));
                    if (this.isValidateJava()) {
                        for (TemplateParameterType p : sourceSectionType2.getTemplateParameter()) {
                            try {
                                p.getJavaValue(context.getClassLoader());
                            }
                            catch (ModelObjectException e) {
                                message = ToolsModelValidator.getMessage(e);
                                if (context.isLoggable(Level.FINE)) {
                                    context.log(Level.FINE, message, (Throwable)e);
                                }
                                report.getDetails().add(new ModelValidationReport.Detail("SPECIFICATION_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("specificationSourceSectionTemplateParameterJavaValueConstraint", module.getName(), specification.getIdentifier(), sourceSectionType2.getName(), p.getName(), message != null && message.length() > 0 ? " " + message : ""), new org.jomc.model.ObjectFactory().createSpecification(specification)));
                            }
                        }
                    }
                    this.validateTemplateParameters(report, context, sourceSectionType2.getSourceSections(), "SPECIFICATION_SOURCE_SECTION_TEMPLATE_PARAMETER_JAVA_VALUE_CONSTRAINT", new org.jomc.model.ObjectFactory().createSpecification(specification), "specificationSourceSectionTemplateParameterJavaValueConstraint", module.getName(), specification.getIdentifier());
                }
                if (!sections.getSourceSection().isEmpty()) continue;
                report.getDetails().add(new ModelValidationReport.Detail("SPECIFICATION_SOURCE_SECTIONS_CONSTRAINT", Level.SEVERE, ToolsModelValidator.getMessage("specificationSourceSectionsConstraint", specification.getIdentifier()), new org.jomc.model.ObjectFactory().createSpecification(specification)));
            }
        }
    }

    private void validateTemplateParameters(ModelValidationReport report, ModelContext context, SourceSectionsType sourceSectionsType, String detailIdentifier, JAXBElement<?> detailElement, String messageKey, Object ... messageArguments) {
        if (sourceSectionsType != null && this.isValidateJava()) {
            for (SourceSectionType s : sourceSectionsType.getSourceSection()) {
                for (TemplateParameterType p : s.getTemplateParameter()) {
                    try {
                        p.getJavaValue(context.getClassLoader());
                    }
                    catch (ModelObjectException e) {
                        String message = ToolsModelValidator.getMessage(e);
                        if (context.isLoggable(Level.FINE)) {
                            context.log(Level.FINE, message, (Throwable)e);
                        }
                        ArrayList<Object> arguments = new ArrayList<Object>(Arrays.asList(messageArguments));
                        arguments.add(s.getName());
                        arguments.add(p.getName());
                        arguments.add(message != null && message.length() > 0 ? " " + message : "");
                        report.getDetails().add(new ModelValidationReport.Detail(detailIdentifier, Level.SEVERE, ToolsModelValidator.getMessage(messageKey, arguments.toArray(new Object[arguments.size()])), detailElement));
                    }
                }
                this.validateTemplateParameters(report, context, s.getSourceSections(), detailIdentifier, detailElement, messageKey, messageArguments);
            }
        }
    }

    private static String getMessage(String key, Object ... args) {
        return MessageFormat.format(ResourceBundle.getBundle(ToolsModelValidator.class.getName().replace('.', '/'), Locale.getDefault()).getString(key), args);
    }

    private static String getMessage(Throwable t) {
        return t != null ? (t.getMessage() != null && t.getMessage().trim().length() > 0 ? t.getMessage() : ToolsModelValidator.getMessage(t.getCause())) : null;
    }
}

