/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.tools.modlet.test;

import java.util.HashSet;
import java.util.logging.Level;
import org.jomc.model.Implementation;
import org.jomc.model.Implementations;
import org.jomc.model.Module;
import org.jomc.model.Modules;
import org.jomc.model.Specification;
import org.jomc.model.SpecificationReference;
import org.jomc.model.Specifications;
import org.jomc.model.modlet.ModelHelper;
import org.jomc.modlet.Model;
import org.jomc.modlet.ModelContext;
import org.jomc.modlet.ModelContextFactory;
import org.jomc.tools.model.SourceFileType;
import org.jomc.tools.model.SourceFilesType;
import org.jomc.tools.model.SourceSectionType;
import org.jomc.tools.model.SourceSectionsType;
import org.jomc.tools.modlet.ToolsModelProvider;
import org.junit.Assert;
import org.junit.Test;

public class ToolsModelProviderTest {
    private ToolsModelProvider toolsModelProvider;

    public ToolsModelProvider getModelProvider() {
        if (this.toolsModelProvider == null) {
            this.toolsModelProvider = this.newModelProvider();
        }
        return this.toolsModelProvider;
    }

    protected ToolsModelProvider newModelProvider() {
        return new ToolsModelProvider();
    }

    @Test
    public final void testFindModel() throws Exception {
        ModelContext context = ModelContextFactory.newInstance().newModelContext();
        context.setLogLevel(Level.ALL);
        context.getListeners().add(new ModelContext.Listener(){

            public void onLog(Level level, String message, Throwable t) {
                super.onLog(level, message, t);
                System.out.println("[" + level.getLocalizedName() + "] " + message);
                if (t != null) {
                    t.printStackTrace(System.out);
                }
            }
        });
        Model model = new Model();
        model.setIdentifier("http://jomc.org/model");
        Modules modules = new Modules();
        Module module = new Module();
        module.setName(this.getClass().getName());
        module.setSpecifications(new Specifications());
        module.setImplementations(new Implementations());
        Specification specification = new Specification();
        specification.setClassDeclaration(Boolean.valueOf(true));
        specification.setClazz("specification.Documentation");
        specification.setIdentifier(this.getClass().getName() + " Specification");
        Implementation implementation = new Implementation();
        implementation.setClassDeclaration(Boolean.valueOf(true));
        implementation.setClazz("implementation.Documentation");
        implementation.setIdentifier(this.getClass().getName() + " Implementation");
        implementation.setName(this.getClass().getName() + " Implementation");
        implementation.setSpecifications(new Specifications());
        implementation.getSpecifications().getReference().add(new SpecificationReference());
        ((SpecificationReference)implementation.getSpecifications().getReference().get(0)).setIdentifier(specification.getIdentifier());
        module.getSpecifications().getSpecification().add(specification);
        module.getImplementations().getImplementation().add(implementation);
        modules.getModule().add(module);
        ModelHelper.setModules((Model)model, (Modules)modules);
        try {
            this.getModelProvider().findModel(null, model);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e.toString());
        }
        try {
            this.getModelProvider().findModel(context, null);
            Assert.fail((String)"Expected NullPointerException not thrown.");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
            System.out.println(e.toString());
        }
        Model found = this.getModelProvider().findModel(context, model);
        Assert.assertNotNull((Object)found);
        modules = ModelHelper.getModules((Model)found);
        Assert.assertNotNull((Object)modules);
        specification = modules.getSpecification(this.getClass().getName() + " Specification");
        Assert.assertNotNull((Object)specification);
        implementation = modules.getImplementation(this.getClass().getName() + " Implementation");
        Assert.assertNotNull((Object)implementation);
        SourceFilesType specificationSourceFiles = (SourceFilesType)specification.getAnyObject(SourceFilesType.class);
        SourceFilesType implementationSourceFiles = (SourceFilesType)implementation.getAnyObject(SourceFilesType.class);
        Assert.assertNotNull((Object)specificationSourceFiles);
        Assert.assertNotNull((Object)implementationSourceFiles);
        SourceFileType specificationSourceFile = specificationSourceFiles.getSourceFile("Default");
        SourceFileType implementationSourceFile = implementationSourceFiles.getSourceFile("Default");
        Assert.assertNotNull((Object)specificationSourceFile);
        ToolsModelProviderTest.assertSectionNameUniqueness(specificationSourceFile.getSourceSections());
        Assert.assertNotNull((Object)implementationSourceFile);
        ToolsModelProviderTest.assertSectionNameUniqueness(implementationSourceFile.getSourceSections());
        this.getModelProvider().setEnabled(Boolean.valueOf(false));
        found = this.getModelProvider().findModel(context, model);
        Assert.assertNull((Object)found);
        this.getModelProvider().setEnabled(Boolean.valueOf(true));
    }

    @Test
    public final void testDefaultEnabled() throws Exception {
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultEnabled");
        ToolsModelProvider.setDefaultEnabled(null);
        Assert.assertTrue((boolean)ToolsModelProvider.isDefaultEnabled());
        System.setProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultEnabled", Boolean.toString(false));
        ToolsModelProvider.setDefaultEnabled(null);
        Assert.assertFalse((boolean)ToolsModelProvider.isDefaultEnabled());
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultEnabled");
        ToolsModelProvider.setDefaultEnabled(null);
        Assert.assertTrue((boolean)ToolsModelProvider.isDefaultEnabled());
        System.setProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultEnabled", Boolean.toString(true));
        ToolsModelProvider.setDefaultEnabled(null);
        Assert.assertTrue((boolean)ToolsModelProvider.isDefaultEnabled());
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultEnabled");
        ToolsModelProvider.setDefaultEnabled(null);
        Assert.assertTrue((boolean)ToolsModelProvider.isDefaultEnabled());
    }

    @Test
    public final void testEnabled() throws Exception {
        Model model = new Model();
        model.setIdentifier("http://jomc.org/model");
        ToolsModelProvider.setDefaultEnabled(null);
        this.getModelProvider().setEnabled(null);
        Assert.assertTrue((boolean)this.getModelProvider().isEnabled());
        this.getModelProvider().findModel(ModelContextFactory.newInstance().newModelContext(), model);
        ToolsModelProvider.setDefaultEnabled((Boolean)false);
        this.getModelProvider().setEnabled(null);
        Assert.assertFalse((boolean)this.getModelProvider().isEnabled());
        this.getModelProvider().findModel(ModelContextFactory.newInstance().newModelContext(), model);
        ToolsModelProvider.setDefaultEnabled(null);
        this.getModelProvider().setEnabled(null);
    }

    @Test
    public final void testDefaultHeadComment() throws Exception {
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultHeadComment");
        ToolsModelProvider.setDefaultHeadComment(null);
        Assert.assertEquals((Object)"//", (Object)ToolsModelProvider.getDefaultHeadComment());
        System.setProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultHeadComment", "/*");
        ToolsModelProvider.setDefaultHeadComment(null);
        Assert.assertEquals((Object)"/*", (Object)ToolsModelProvider.getDefaultHeadComment());
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultHeadComment");
        ToolsModelProvider.setDefaultHeadComment(null);
        Assert.assertEquals((Object)"//", (Object)ToolsModelProvider.getDefaultHeadComment());
    }

    @Test
    public final void testHeadComment() throws Exception {
        ToolsModelProvider.setDefaultHeadComment(null);
        this.getModelProvider().setHeadComment(null);
        Assert.assertEquals((Object)"//", (Object)this.getModelProvider().getHeadComment());
        ToolsModelProvider.setDefaultHeadComment((String)"/*");
        this.getModelProvider().setHeadComment(null);
        Assert.assertEquals((Object)"/*", (Object)this.getModelProvider().getHeadComment());
        ToolsModelProvider.setDefaultHeadComment(null);
        this.getModelProvider().setHeadComment(null);
        Assert.assertEquals((Object)"//", (Object)this.getModelProvider().getHeadComment());
    }

    @Test
    public final void testDefaultTailComment() throws Exception {
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultTailComment");
        ToolsModelProvider.setDefaultTailComment(null);
        Assert.assertNull((Object)ToolsModelProvider.getDefaultTailComment());
        System.setProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultTailComment", "*/");
        ToolsModelProvider.setDefaultTailComment(null);
        Assert.assertEquals((Object)"*/", (Object)ToolsModelProvider.getDefaultTailComment());
        System.clearProperty("org.jomc.tools.modlet.ToolsModelProvider.defaultTailComment");
        ToolsModelProvider.setDefaultTailComment(null);
        Assert.assertNull((Object)ToolsModelProvider.getDefaultTailComment());
    }

    @Test
    public final void testTailComment() throws Exception {
        ToolsModelProvider.setDefaultTailComment(null);
        this.getModelProvider().setTailComment(null);
        Assert.assertNull((Object)this.getModelProvider().getTailComment());
        ToolsModelProvider.setDefaultTailComment((String)"*/");
        this.getModelProvider().setTailComment(null);
        Assert.assertEquals((Object)"*/", (Object)this.getModelProvider().getTailComment());
        ToolsModelProvider.setDefaultTailComment(null);
        this.getModelProvider().setTailComment(null);
        Assert.assertNull((Object)this.getModelProvider().getTailComment());
    }

    private static void assertSectionNameUniqueness(SourceSectionsType sections) {
        if (sections != null) {
            HashSet<String> sectionNames = new HashSet<String>(sections.getSourceSection().size());
            int s0 = sections.getSourceSection().size();
            for (int i = 0; i < s0; ++i) {
                SourceSectionType section = (SourceSectionType)sections.getSourceSection().get(i);
                Assert.assertTrue((String)("Multiple '" + section.getName() + "' sections."), (boolean)sectionNames.add(section.getName()));
                ToolsModelProviderTest.assertSectionNameUniqueness(section.getSourceSections());
            }
        }
    }
}

