/*
 * Decompiled with CFR 0.152.
 */
package org.jomc.logging.ri.jdk;

import java.util.logging.Level;
import org.jomc.ObjectManagerFactory;
import org.jomc.logging.Logger;
import org.jomc.spi.Listener;

public class JdkLogger
implements Logger,
Listener {
    public boolean isDebugEnabled() {
        return this.getLogger().isLoggable(Level.FINE);
    }

    public void debug(String message) {
        this.log(Level.FINE, message, null);
    }

    public void debug(Throwable throwable) {
        this.log(Level.FINE, throwable.getMessage(), throwable);
    }

    public void debug(String message, Throwable throwable) {
        this.log(Level.FINE, message, throwable);
    }

    public boolean isErrorEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    public void error(String message) {
        this.log(Level.SEVERE, message, null);
    }

    public void error(Throwable throwable) {
        this.log(Level.SEVERE, throwable.getMessage(), throwable);
    }

    public void error(String message, Throwable throwable) {
        this.log(Level.SEVERE, message, throwable);
    }

    public boolean isFatalEnabled() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    public void fatal(String message) {
        this.log(Level.SEVERE, message, null);
    }

    public void fatal(Throwable throwable) {
        this.log(Level.SEVERE, throwable.getMessage(), throwable);
    }

    public void fatal(String message, Throwable throwable) {
        this.log(Level.SEVERE, message, throwable);
    }

    public boolean isInfoEnabled() {
        return this.getLogger().isLoggable(Level.INFO);
    }

    public void info(String message) {
        this.log(Level.INFO, message, null);
    }

    public void info(Throwable throwable) {
        this.log(Level.INFO, throwable.getMessage(), throwable);
    }

    public void info(String message, Throwable throwable) {
        this.log(Level.INFO, message, throwable);
    }

    public boolean isTraceEnabled() {
        return this.getLogger().isLoggable(Level.FINEST);
    }

    public void trace(String message) {
        this.log(Level.FINEST, message, null);
    }

    public void trace(Throwable throwable) {
        this.log(Level.FINEST, throwable.getMessage(), throwable);
    }

    public void trace(String message, Throwable throwable) {
        this.log(Level.FINEST, message, throwable);
    }

    public boolean isWarnEnabled() {
        return this.getLogger().isLoggable(Level.WARNING);
    }

    public void warn(String message) {
        this.log(Level.WARNING, message, null);
    }

    public void warn(Throwable throwable) {
        this.log(Level.WARNING, throwable.getMessage(), throwable);
    }

    public void warn(String message, Throwable throwable) {
        this.log(Level.WARNING, message, throwable);
    }

    public void onLog(Level level, String message, Throwable throwable) {
        if (level != null) {
            if (level.equals(Level.CONFIG) || level.equals(Level.FINE)) {
                this.getObjectManagementLogger().debug(message, throwable);
            } else if (level.equals(Level.FINER) || level.equals(Level.FINEST)) {
                this.getObjectManagementLogger().trace(message, throwable);
            } else if (level.equals(Level.INFO)) {
                this.getObjectManagementLogger().info(message, throwable);
            } else if (level.equals(Level.SEVERE)) {
                this.getObjectManagementLogger().error(message, throwable);
            } else if (level.equals(Level.WARNING)) {
                this.getObjectManagementLogger().warn(message, throwable);
            } else {
                this.getObjectManagementLogger().trace(message, throwable);
            }
        }
    }

    public java.util.logging.Logger getLogger() {
        return java.util.logging.Logger.getLogger(this.getName());
    }

    private void log(Level level, String msg, Throwable t) {
        if (this.getLogger().isLoggable(level)) {
            Throwable x = new Throwable();
            StackTraceElement[] elements = x.getStackTrace();
            String cname = "unknown";
            String method = "unknown";
            if (elements != null && elements.length >= this.getStackDepth()) {
                StackTraceElement caller = elements[this.getStackDepth()];
                cname = caller.getClassName();
                method = caller.getMethodName();
            }
            if (t == null) {
                this.getLogger().logp(level, cname, method, msg);
            } else {
                this.getLogger().logp(level, cname, method, msg, t);
            }
        }
    }

    private Logger getObjectManagementLogger() {
        Logger _d = (Logger)ObjectManagerFactory.getObjectManager((ClassLoader)this.getClass().getClassLoader()).getDependency((Object)this, "ObjectManagementLogger");
        assert (_d != null) : "'ObjectManagementLogger' dependency not found.";
        return _d;
    }

    public String getName() {
        String _p = (String)ObjectManagerFactory.getObjectManager((ClassLoader)this.getClass().getClassLoader()).getProperty((Object)this, "name");
        assert (_p != null) : "'name' property not found.";
        return _p;
    }

    private int getStackDepth() {
        Integer _p = (Integer)ObjectManagerFactory.getObjectManager((ClassLoader)this.getClass().getClassLoader()).getProperty((Object)this, "stackDepth");
        assert (_p != null) : "'stackDepth' property not found.";
        return _p;
    }
}

