/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.assets;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.typesafe.config.Config;
import java.io.File;
import org.jooby.MediaType;
import org.jooby.assets.AssetException;
import org.jooby.assets.AssetProblem;
import org.jooby.assets.AssetProcessor;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;

public class Sass
extends AssetProcessor {
    private static final Supplier<ScriptingContainer> rctx = Suppliers.memoize(() -> new ScriptingContainer(LocalContextScope.THREADSAFE));
    private static final Supplier<Object> script = Suppliers.memoize(() -> ((ScriptingContainer)rctx.get()).runScriptlet(PathType.CLASSPATH, "sass.rb"));

    public Sass() {
        this.set("syntax", "scss");
        this.set("sourcemap", false);
        this.set("cache_location", new File(System.getProperty("java.io.tmpdir"), "sass-cache").getAbsolutePath());
    }

    public boolean matches(MediaType type) {
        return MediaType.css.matches(type);
    }

    public String process(String filename, String source, Config conf) throws Exception {
        Object value;
        boolean isMap = filename.endsWith(".map");
        if (isMap) {
            filename = filename.substring(0, filename.length() - ".map".length());
        }
        if ((value = ((ScriptingContainer)rctx.get()).callMethod(script.get(), "render", new Object[]{source, this.options(), filename, ((Object)((Object)this)).getClass(), isMap})) instanceof AssetProblem) {
            throw new AssetException(this.name(), (AssetProblem)value);
        }
        return value.toString();
    }
}

