/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.assets;

import com.google.common.base.Splitter;
import com.google.common.io.ByteStreams;
import com.typesafe.config.Config;
import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Compiler;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import io.bit3.jsass.OutputStyle;
import io.bit3.jsass.context.StringContext;
import io.bit3.jsass.importer.Import;
import io.bit3.jsass.importer.Importer;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jooby.MediaType;
import org.jooby.assets.AssetException;
import org.jooby.assets.AssetProblem;
import org.jooby.assets.AssetProcessor;
import org.jooby.funzy.Throwing;
import org.jooby.funzy.Try;

public class Sass
extends AssetProcessor {
    static final Pattern LOCATION = Pattern.compile("\"(.+?)\":\\s+(\\d+)");
    private static final Function<String, URI> FS = it -> {
        File file = new File((String)it);
        return file.exists() ? file.toURI() : null;
    };
    private static final Function<ClassLoader, Function<String, URI>> CP = classLoader -> filename -> {
        URL resource;
        if (filename.startsWith("/")) {
            filename = filename.substring(1);
        }
        return (resource = classLoader.getResource((String)filename)) == null ? null : (URI)Try.apply(resource::toURI).get();
    };

    public Sass() {
        this.set("syntax", "scss");
        this.set("style", "nested");
        this.set("importer", "classpath");
        this.set("indent", "  ");
        this.set("linefeed", "\n");
        this.set("omitSourceMapUrl", false);
        this.set("precision", 8);
        this.set("sourceComments", false);
    }

    public boolean matches(MediaType type) {
        return MediaType.css.matches(type);
    }

    public String process(String filename, String source, Config conf, ClassLoader loader) throws Exception {
        String syntax = (String)this.get("syntax");
        String importer = this.get("importer").toString().toUpperCase();
        Function<String, URI> resolver = "FILE".equals(importer) ? FS : CP.apply(loader);
        OutputStyle style = OutputStyle.valueOf((String)this.get("style").toString().toUpperCase());
        Options options = new Options();
        options.setIsIndentedSyntaxSrc("sass".equals(syntax));
        options.getImporters().add(new SassImporter(syntax, resolver));
        options.setOutputStyle(style);
        options.setIndent((String)this.get("indent"));
        options.setLinefeed((String)this.get("linefeed"));
        options.setOmitSourceMapUrl(((Boolean)this.get("omitSourceMapUrl")).booleanValue());
        options.setPrecision(((Integer)this.get("precision")).intValue());
        options.setSourceComments(((Boolean)this.get("sourceComments")).booleanValue());
        String sourcemap = (String)this.get("sourcemap");
        if ("inline".equals(sourcemap)) {
            options.setSourceMapEmbed(true);
        } else if ("file".equals(sourcemap)) {
            options.setSourceMapFile(URI.create(filename + ".map"));
        }
        try {
            URI input = URI.create(filename);
            StringContext ctx = new StringContext(source, input, null, options);
            Output output = new Compiler().compile(ctx);
            return filename.endsWith(".map") ? output.getSourceMap() : output.getCss();
        }
        catch (CompilationException x) {
            Matcher matcher = LOCATION.matcher(x.getErrorJson());
            HashMap<String, Integer> location = new HashMap<String, Integer>();
            while (matcher.find()) {
                location.put(matcher.group(1), Integer.parseInt(matcher.group(2)));
            }
            int line = location.getOrDefault("line", -1);
            int column = location.getOrDefault("column", -1);
            throw new AssetException(this.name(), new AssetProblem(Optional.ofNullable(x.getErrorFile()).orElse(filename), line, column, x.getErrorText(), null));
        }
    }

    static class SassImporter
    implements Importer {
        private String ext;
        private Function<String, URI> resolver;

        public SassImporter(String ext, Function<String, URI> resolver) {
            this.ext = ext;
            this.resolver = resolver;
        }

        public Collection<Import> apply(String url, Import previous) {
            String fname = this.nameWithExtension(url);
            List segments = Splitter.on((char)'/').trimResults().omitEmptyStrings().splitToList((CharSequence)previous.getAbsoluteUri().toString());
            String relative = segments.subList(0, segments.size() - 1).stream().collect(Collectors.joining("/", "/", ""));
            return Arrays.asList(relative + fname, fname).stream().map(this.resolver::apply).filter(it -> it != null).findFirst().map(Throwing.throwingFunction(it -> (List)Try.with(it.toURL()::openStream).apply(in -> new String(ByteStreams.toByteArray((InputStream)in), StandardCharsets.UTF_8)).map(content -> Arrays.asList(new Import(it, it, content))).get())).orElse(null);
        }

        private String nameWithExtension(String name) {
            String filename = name;
            if (!filename.endsWith(this.ext)) {
                filename = filename + "." + this.ext;
            }
            if (filename.charAt(0) != '/') {
                return "/" + filename;
            }
            return filename;
        }
    }
}

