/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.banner;

import com.github.lalyos.jfiglet.FigletFont;
import com.google.inject.Binder;
import com.typesafe.config.Config;
import java.util.Objects;
import java.util.Optional;
import org.jooby.Env;
import org.jooby.Jooby;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Banner
implements Jooby.Module {
    private static final String FONT = "classpath:/flf/%s.flf";
    private String font = "speed";
    private final Optional<String> text;

    public Banner(String text) {
        this.text = Optional.of(text);
    }

    public Banner() {
        this.text = Optional.empty();
    }

    public void configure(Env env, Config conf, Binder binder) {
        String name = conf.getString("application.name");
        Logger log = LoggerFactory.getLogger((String)name);
        String v = conf.getString("application.version");
        String text = this.text.orElse(name);
        env.onStart(() -> log.info("\n{} v{}\n", (Object)FigletFont.convertOneLine((String)String.format(FONT, this.font), (String)text).trim(), (Object)v));
    }

    public Banner font(String font) {
        this.font = Objects.requireNonNull(font, "Font is required.");
        return this;
    }
}

