/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.cassandra;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.mapping.Result;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.jooby.Deferred;
import org.jooby.Route;

class CassandraMapper
implements Route.Mapper<Object> {
    CassandraMapper() {
    }

    public String name() {
        return "cassandra";
    }

    public Object map(Object value) throws Throwable {
        if (value instanceof ListenableFuture) {
            return new Deferred((Deferred.Initializer0)new DeferredHandler((ListenableFuture)value));
        }
        return CassandraMapper.resultSet(value);
    }

    private static Object resultSet(Object value) {
        if (value instanceof ResultSet) {
            return ((ResultSet)value).all();
        }
        if (value instanceof Result) {
            return ((Result)value).all();
        }
        return value;
    }

    private static class DeferredHandler
    implements Deferred.Initializer0 {
        private final ListenableFuture future;

        public DeferredHandler(ListenableFuture future) {
            this.future = future;
        }

        public void run(final Deferred deferred) throws Exception {
            Futures.addCallback((ListenableFuture)this.future, (FutureCallback)new FutureCallback(){

                public void onSuccess(Object result) {
                    deferred.resolve(CassandraMapper.resultSet(result));
                }

                public void onFailure(Throwable x) {
                    deferred.reject(x);
                }
            });
        }
    }
}

