/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigValueFactory;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.jooby.Session;
import org.jooby.funzy.Throwing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraSessionStore
implements Session.Store {
    private static final String TIMEOUT = "timeout";
    private static final String ID = "id";
    private static final String ATTRIBUTES = "attributes";
    private static final String SAVED_AT = "savedAt";
    private static final String ACCESSED_AT = "accessedAt";
    private static final String CREATED_AT = "createdAt";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final com.datastax.driver.core.Session session;
    private final int timeout;
    private final String tableName = "session";
    private final Throwing.Function<String, PreparedStatement> insertSQL;
    private final Throwing.Function<String, PreparedStatement> selectSQL;
    private final Throwing.Function<String, PreparedStatement> deleteSQL;

    public CassandraSessionStore(com.datastax.driver.core.Session session, int timeout) {
        this.session = Objects.requireNonNull(session, "Session required.");
        this.timeout = timeout;
        CassandraSessionStore.createTableIfNotExists(session, "session", this.log);
        this.insertSQL = Throwing.throwingFunction(table -> session.prepare(CassandraSessionStore.insertSQL(table, timeout))).memoized();
        this.selectSQL = Throwing.throwingFunction(table -> session.prepare(CassandraSessionStore.selectSQL(table))).memoized();
        this.deleteSQL = Throwing.throwingFunction(table -> session.prepare(CassandraSessionStore.deleteSQL(table))).memoized();
    }

    @Inject
    public CassandraSessionStore(com.datastax.driver.core.Session session, @Named(value="session.timeout") String timeout) {
        this(session, CassandraSessionStore.seconds(timeout));
    }

    public Session get(Session.Builder builder) {
        ResultSet rs = this.session.execute((Statement)new BoundStatement((PreparedStatement)this.selectSQL.apply((Object)"session")).bind(new Object[]{builder.sessionId()}));
        return Optional.ofNullable(rs.one()).map(row -> {
            long createdAt = row.getTimestamp(CREATED_AT).getTime();
            long accessedAt = row.getTimestamp(ACCESSED_AT).getTime();
            long savedAt = row.getTimestamp(SAVED_AT).getTime();
            Map attributes = row.getMap(ATTRIBUTES, String.class, String.class);
            Session session = builder.accessedAt(accessedAt).createdAt(createdAt).savedAt(savedAt).set(attributes).build();
            if (this.timeout > 0) {
                this.save(session);
            }
            return session;
        }).orElse(null);
    }

    public void save(Session session) {
        this.session.execute((Statement)new BoundStatement((PreparedStatement)this.insertSQL.apply((Object)"session")).bind(new Object[]{session.id(), new Date(session.createdAt()), new Date(session.accessedAt()), new Date(session.savedAt()), session.attributes()}));
    }

    public void create(Session session) {
        this.save(session);
    }

    public void delete(String id) {
        this.session.execute((Statement)new BoundStatement((PreparedStatement)this.deleteSQL.apply((Object)"session")).bind(new Object[]{id}));
    }

    private static int seconds(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            Config config = ConfigFactory.empty().withValue(TIMEOUT, ConfigValueFactory.fromAnyRef((Object)value));
            return (int)config.getDuration(TIMEOUT, TimeUnit.SECONDS);
        }
    }

    private static void createTableIfNotExists(com.datastax.driver.core.Session session, String table, final Logger log) {
        Create createTable = (Create)((Create)((Create)((Create)((Create)SchemaBuilder.createTable((String)table).addPartitionKey(ID, DataType.varchar()).addColumn(CREATED_AT, DataType.timestamp())).addColumn(ACCESSED_AT, DataType.timestamp())).addColumn(SAVED_AT, DataType.timestamp())).addColumn(ATTRIBUTES, (DataType)DataType.map((DataType)DataType.varchar(), (DataType)DataType.varchar()))).ifNotExists();
        Futures.addCallback((ListenableFuture)session.executeAsync((Statement)createTable), (FutureCallback)new FutureCallback<ResultSet>(){

            public void onSuccess(ResultSet result) {
                log.debug("Session table successfully created");
            }

            public void onFailure(Throwable x) {
                log.error("Create session table resulted in exception", x);
            }
        });
    }

    private static String selectSQL(String table) {
        return QueryBuilder.select().from(table).where(QueryBuilder.eq((String)ID, (Object)QueryBuilder.raw((String)"?"))).getQueryString();
    }

    private static String deleteSQL(String table) {
        return QueryBuilder.delete().from(table).where(QueryBuilder.eq((String)ID, (Object)QueryBuilder.raw((String)"?"))).getQueryString();
    }

    private static String insertSQL(String table, int timeout) {
        Insert insertInto = QueryBuilder.insertInto((String)table).value(ID, QueryBuilder.raw((String)"?")).value(CREATED_AT, QueryBuilder.raw((String)"?")).value(ACCESSED_AT, QueryBuilder.raw((String)"?")).value(SAVED_AT, QueryBuilder.raw((String)"?")).value(ATTRIBUTES, QueryBuilder.raw((String)"?"));
        if (timeout > 0) {
            insertInto.using(QueryBuilder.ttl((int)timeout));
        }
        return insertInto.getQueryString();
    }
}

