/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.cassandra;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.Result;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;

public class Datastore {
    private final MappingManager manager;

    Datastore(MappingManager manager) {
        this.manager = manager;
    }

    private <T> Mapper<T> mapper(Class<T> entityClass) {
        return this.manager.mapper(entityClass);
    }

    public <T> T get(Class<T> entityClass, Object id) {
        return (T)this.mapper(entityClass).get(new Object[]{id});
    }

    public <T> ListenableFuture<T> getAsync(Class<T> entityClass, Object id) {
        return this.mapper(entityClass).getAsync(new Object[]{id});
    }

    public void delete(Class<?> entityClass, Object id, Mapper.Option ... options) {
        Mapper<?> mapper = this.mapper(entityClass);
        mapper.delete(id, options);
    }

    public ListenableFuture<Void> deleteAsync(Class<?> entityClass, Object id, Mapper.Option ... options) {
        Mapper<?> mapper = this.mapper(entityClass);
        return mapper.deleteAsync(id, options);
    }

    public void delete(Object entity, Mapper.Option ... options) {
        Mapper<?> mapper = this.mapper(entity.getClass());
        mapper.delete(entity, options);
    }

    public ListenableFuture<Void> deleteAsync(Object entity, Mapper.Option ... options) {
        Mapper<?> mapper = this.mapper(entity.getClass());
        return mapper.deleteAsync(entity, options);
    }

    public <T> void save(T entity, Mapper.Option ... options) {
        Class<?> entityClass = entity.getClass();
        Mapper<?> mapper = this.mapper(entityClass);
        mapper.save(entity, options);
    }

    public <T> ListenableFuture<Void> saveAsync(T entity, Mapper.Option ... options) {
        Class<?> entityClass = entity.getClass();
        Mapper<?> mapper = this.mapper(entityClass);
        return mapper.saveAsync(entity, options);
    }

    public <T> Result<T> query(Class<T> entityClass, String statement, Map<String, Object> values) {
        return this.query(entityClass, (Statement)new SimpleStatement(statement, values));
    }

    public <T> Result<T> query(Class<T> entityClass, String statement, Object ... values) {
        return this.query(entityClass, (Statement)new SimpleStatement(statement, values));
    }

    public <T> Result<T> query(Class<T> entityClass, Statement statement) {
        Mapper<T> mapper = this.mapper(entityClass);
        Session session = mapper.getManager().getSession();
        ResultSet rs = session.execute(statement);
        return mapper.map(rs);
    }

    public <T> ListenableFuture<Result<T>> queryAsync(Class<T> entityClass, String statement, Map<String, Object> values) {
        return this.queryAsync(entityClass, (Statement)new SimpleStatement(statement, values));
    }

    public <T> ListenableFuture<Result<T>> queryAsync(Class<T> entityClass, String statement, Object ... values) {
        return this.queryAsync(entityClass, (Statement)new SimpleStatement(statement, values));
    }

    public <T> ListenableFuture<Result<T>> queryAsync(Class<T> entityClass, Statement statement) {
        Mapper mapper = this.mapper(entityClass);
        Session session = mapper.getManager().getSession();
        ResultSetFuture rs = session.executeAsync(statement);
        return Futures.transformAsync((ListenableFuture)rs, rs1 -> Futures.immediateFuture((Object)mapper.map(rs1)));
    }
}

