/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.extras.codecs.jdk8.InstantCodec;
import com.datastax.driver.extras.codecs.jdk8.LocalDateCodec;
import com.datastax.driver.extras.codecs.jdk8.LocalTimeCodec;
import com.datastax.driver.mapping.MappingManager;
import com.google.inject.Binder;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Route;
import org.jooby.cassandra.CassandraMapper;
import org.jooby.cassandra.ConnectionString;
import org.jooby.cassandra.Datastore;
import org.jooby.funzy.Throwing;
import org.jooby.funzy.Try;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cassandra
implements Jooby.Module {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Supplier<Cluster.Builder> BUILDER = Cluster::builder;
    private BiConsumer<Cluster.Builder, Config> ccbuilder;
    private BiConsumer<Cluster, Config> cc;
    private final String db;
    private final List<Class> accesors = new ArrayList<Class>();
    private Supplier<Cluster.Builder> builder = Cluster::builder;

    public Cassandra(String db, Supplier<Cluster.Builder> builder) {
        this.db = Objects.requireNonNull(db, "ContactPoint/db key required.");
        this.builder = Objects.requireNonNull(builder, "Cluster.Builder required.");
    }

    public Cassandra(String db) {
        this(db, BUILDER);
    }

    public Cassandra(Supplier<Cluster.Builder> builder) {
        this("db", builder);
    }

    public Cassandra() {
        this("db");
    }

    public Cassandra accesor(Class<?> accessor) {
        this.accesors.add(accessor);
        return this;
    }

    public Cassandra doWithClusterBuilder(BiConsumer<Cluster.Builder, Config> configurer) {
        this.ccbuilder = Objects.requireNonNull(configurer, "ClusterBuilder conf callback required.");
        return this;
    }

    public Cassandra doWithClusterBuilder(Consumer<Cluster.Builder> configurer) {
        Objects.requireNonNull(configurer, "ClusterBuilder conf callback required.");
        return this.doWithClusterBuilder((Cluster.Builder b, Config c) -> configurer.accept((Cluster.Builder)b));
    }

    public Cassandra doWithCluster(BiConsumer<Cluster, Config> configurer) {
        this.cc = Objects.requireNonNull(configurer, "Cluster conf callbackrequired.");
        return this;
    }

    public Cassandra doWithCluster(Consumer<Cluster> configurer) {
        Objects.requireNonNull(configurer, "Cluster conf callbackrequired.");
        return this.doWithCluster((Cluster cc, Config c) -> configurer.accept((Cluster)cc));
    }

    public void configure(Env env, Config conf, Binder binder) {
        ConnectionString cstr = (ConnectionString)Try.apply(() -> ConnectionString.parse(this.db)).orElseGet(() -> ConnectionString.parse(conf.getString(this.db)));
        Env.ServiceKey serviceKey = env.serviceKey();
        Throwing.Function3 bind = (type, name, value) -> {
            serviceKey.generate(type, name, k -> binder.bind(k).toInstance(value));
            return null;
        };
        Cluster.Builder builder = this.builder.get().addContactPoints(cstr.contactPoints()).withPort(cstr.port());
        if (this.ccbuilder != null) {
            this.ccbuilder.accept(builder, conf);
        }
        this.log.debug("Starting {}", (Object)cstr);
        Cluster cluster = builder.build();
        if (this.cc != null) {
            this.cc.accept(cluster, conf);
        }
        Configuration configuration = cluster.getConfiguration();
        CodecRegistry codecRegistry = configuration.getCodecRegistry();
        codecRegistry.register(new TypeCodec[]{InstantCodec.instance, LocalDateCodec.instance, LocalTimeCodec.instance});
        Cassandra.hierarchy(cluster.getClass(), type -> {
            Void cfr_ignored_0 = (Void)bind.apply(type, (Object)cstr.keyspace(), (Object)cluster);
        });
        Session session = cluster.connect(cstr.keyspace());
        Cassandra.hierarchy(session.getClass(), type -> {
            Void cfr_ignored_0 = (Void)bind.apply(type, (Object)cstr.keyspace(), (Object)session);
        });
        MappingManager manager = new MappingManager(session);
        bind.apply(MappingManager.class, (Object)cstr.keyspace(), (Object)manager);
        bind.apply(Datastore.class, (Object)cstr.keyspace(), (Object)new Datastore(manager));
        this.accesors.forEach(c -> {
            Object accessor = manager.createAccessor(c);
            binder.bind(c).toInstance(accessor);
        });
        env.router().map((Route.Mapper)new CassandraMapper());
        env.onStop(() -> {
            this.log.debug("Stopping {}", (Object)cstr);
            Try.run(() -> ((Session)session).close()).onFailure(x -> this.log.error("session.close() resulted in exception", x));
            cluster.close();
            this.log.info("Stopped {}", (Object)cstr);
        });
    }

    static void hierarchy(Class type, Consumer<Class> consumer) {
        if (type != Object.class) {
            if (type.getName().startsWith("com.datastax")) {
                consumer.accept(type);
            }
            for (Class<?> i : type.getInterfaces()) {
                Cassandra.hierarchy(i, consumer);
            }
            if (!type.isInterface()) {
                Cassandra.hierarchy(type.getSuperclass(), consumer);
            }
        }
    }
}

