/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.cassandra;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.stream.Collectors;

class ConnectionString {
    public static final String SCHEMA = "cassandra://";
    private static final String SAMPLE = "cassandra://host[, host]*[:port]/keyspace";
    private final String[] address;
    private final int port;
    private final String keyspace;

    private ConnectionString(String[] address, int port, String keyspace) {
        this.address = address;
        this.port = port;
        this.keyspace = keyspace;
    }

    public String[] contactPoints() {
        return this.address;
    }

    public int port() {
        return this.port;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public static ConnectionString parse(String connectionString) {
        if (!connectionString.startsWith(SCHEMA)) {
            throw new IllegalArgumentException("Unknown schema " + connectionString + ", expected " + SAMPLE);
        }
        List segments = Splitter.on((char)'/').trimResults().omitEmptyStrings().splitToList((CharSequence)connectionString.replace(SCHEMA, ""));
        if (segments.size() != 2) {
            throw new IllegalArgumentException("Invalid " + connectionString + ", expected " + SAMPLE);
        }
        List values = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)segments.get(0)).stream().map(v -> {
            String host = v;
            int idx = v.indexOf(58);
            int port = 9042;
            if (idx > 0) {
                port = Integer.parseInt(v.substring(idx + 1));
                host = v.substring(0, idx);
            }
            return new Object[]{host, port};
        }).collect(Collectors.toList());
        List<String> hosts = values.stream().map(t -> t[0].toString()).collect(Collectors.toList());
        List port = values.stream().map(t -> (Integer)t[1]).distinct().collect(Collectors.toList());
        if (port.size() > 1) {
            throw new IllegalArgumentException("Found multiple ports: " + port + ", only one port must be present. See " + SAMPLE);
        }
        String keyspace = (String)segments.get(1);
        return new ConnectionString(hosts.toArray(new String[hosts.size()]), (Integer)port.iterator().next(), keyspace);
    }

    public String toString() {
        return SCHEMA + Joiner.on((char)',').join((Object[])this.address) + ':' + this.port + '/' + this.keyspace;
    }
}

