/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.crash;

import com.typesafe.config.Config;
import org.crsh.plugin.CRaSHPlugin;
import org.jooby.Env;
import org.jooby.MediaType;
import org.jooby.Results;
import org.jooby.Route;
import org.jooby.Router;
import org.jooby.WebSocket;
import org.jooby.crash.WebShellHandler;

class WebShellPlugin
extends CRaSHPlugin<WebShellPlugin> {
    WebShellPlugin() {
    }

    public WebShellPlugin getImplementation() {
        return this;
    }

    static void install(Env env, Config conf) {
        Router routes = env.router();
        String path = conf.getString("crash.webshell.path");
        String title = conf.getString("application.name") + " shell";
        routes.assets(path + "/css/**", "META-INF/resources/css/{0}");
        routes.assets(path + "/js/**", "META-INF/resources/js/{0}");
        String rootpath = Route.normalize((String)(conf.getString("application.path") + path));
        routes.get(path, req -> Results.ok((Object)("<!DOCTYPE HTML>\n<html>\n<head>\n    <meta charset=\"utf-8\" />\n    <title>" + title + "</title>\n    <script src=\"" + rootpath + "/js/jquery-1.7.1.min.js\"></script>\n    <script src=\"" + rootpath + "/js/jquery.mousewheel-min.js\"></script>\n    <script src=\"" + rootpath + "/js/jquery.terminal-0.7.12.js\"></script>\n    <script src=\"" + rootpath + "/js/crash.js\"></script>\n    <link href=\"" + rootpath + "/css/jquery.terminal.css\" rel=\"stylesheet\"/>\n</head>\n<body>\n\n<script>\n\n  //\n  $(function() {\n    // Create web socket url\n    var protocol;\n    if (window.location.protocol == 'http:') {\n      protocol = 'ws';\n    } else {\n      protocol = 'wss';\n    }\n    var url = protocol + '://' + window.location.host + '" + rootpath + "';\n    var crash = new CRaSH($('#shell'));\n    crash.connect(url);\n  });\n\n</script>\n\n  <div id=\"shell\"></div>\n\n</body>\n</html>")).type(MediaType.html));
        routes.ws(path, (WebSocket.OnOpen)new WebShellHandler()).consumes(MediaType.json).produces(MediaType.json);
    }
}

