/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.frontend;

import com.github.eirslett.maven.plugins.frontend.lib.FrontendPluginFactory;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.NpmRunner;
import com.github.eirslett.maven.plugins.frontend.lib.ProxyConfig;
import com.typesafe.config.Config;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jooby.frontend.Frontend;
import org.jooby.frontend.NodeTask;

public class Yarn
extends Frontend {
    private String yarnVersion;

    public Yarn(String nodeVersion, String yarnVersion) {
        super(nodeVersion);
        this.yarnVersion = Objects.requireNonNull(yarnVersion, "Yarn version required.");
    }

    @Override
    protected NodeTask newTask(FrontendPluginFactory factory, Config conf, ProxyConfig proxy, Map<String, String> env, String nodeVersion) throws InstallationException {
        Function<String, String> property = key -> conf.hasPath(key) ? conf.getString(key) : null;
        factory.getNPMInstaller(proxy).setNpmVersion(this.yarnVersion).setNodeVersion(nodeVersion).setNpmDownloadRoot(conf.getString("yarn.downloadRoot")).setUserName(property.apply("yarn.username")).setPassword(property.apply("yarn.password")).install();
        NpmRunner npm = factory.getNpmRunner(proxy, conf.getString("yarn.registryURL"));
        return (cmd, args) -> {
            String cmdline = cmd + " " + Arrays.asList(args).stream().collect(Collectors.joining(" "));
            npm.execute(cmdline, env);
        };
    }
}

