/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.run;

import java.net.URLClassLoader;
import java.nio.file.Path;
import org.gradle.api.Project;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.TaskAction;
import org.jooby.apitool.ApiParser;
import org.jooby.run.JoobyProject;

public class ApiToolTask
extends ConventionTask {
    private String mainClassName;

    @TaskAction
    public void process() throws Throwable {
        Project project = this.getProject();
        JoobyProject joobyProject = new JoobyProject(project);
        String mainClass = this.getMainClassName();
        try (URLClassLoader loader = joobyProject.newClassLoader();){
            this.getLogger().debug("Using classloader " + loader);
            Path srcdir = project.getProjectDir().toPath();
            Path bindir = joobyProject.classes().toPath();
            Path output = new ApiParser(srcdir).with((ClassLoader)loader).export(bindir, mainClass);
            this.getLogger().info("API file: " + output);
        }
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    private static class Done
    extends RuntimeException {
        private Done() {
        }
    }
}

