/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.run;

import com.google.common.io.Files;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import me.tongfei.progressbar.ProgressBar;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.jooby.assets.AssetCompiler;
import org.jooby.funzy.Try;
import org.jooby.run.JoobyContainer;

public class AssetTask
extends ConventionTask {
    private String env;
    private String mainClassName;
    @InputDirectory
    private File output;
    @OutputDirectory
    private File assemblyOutput;
    private String maxAge;
    @OutputFile
    private File assetFile;

    @TaskAction
    public void process() throws Throwable {
        try {
            String env = this.getEnv();
            this.assetFile = new File(this.getOutput(), "assets." + env + ".conf");
            new JoobyContainer(this.getProject()).run(this.getMainClassName(), (app, conf) -> AssetTask.compile(this.getLogger(), app.getClass().getClassLoader(), env, this.getMaxAge(), this.getOutput(), this.assetFile, this.getAssemblyOutput(), conf), env);
        }
        catch (CompilationDone compilationDone) {
            // empty catch block
        }
    }

    private static void compile(Logger logger, ClassLoader loader, String env, String maxAge, File output, File distFile, File assemblyOutput, Config conf) {
        Try.run(() -> {
            output.mkdirs();
            logger.debug("claspath: " + loader);
            Config assetConf = ConfigFactory.parseResources((ClassLoader)loader, (String)"assets.conf").withFallback((ConfigMergeable)conf);
            logger.debug("assets.conf: " + assetConf.getConfig("assets"));
            AssetCompiler compiler = new AssetCompiler(loader, assetConf);
            AtomicReference pb = new AtomicReference();
            compiler.setProgressBar((progress, total) -> {
                if (pb.get() == null) {
                    pb.set(new ProgressBar("Compiling assets", (long)total.intValue()).start().stepTo((long)progress.intValue()));
                } else {
                    ((ProgressBar)pb.get()).step();
                }
            });
            long start = System.currentTimeMillis();
            Map fileset = compiler.build(env, output);
            ((ProgressBar)pb.get()).stop();
            StringBuilder dist = new StringBuilder();
            dist.append("assets.fileset {\n").append(fileset.entrySet().stream().map(e -> {
                String files = ((List)e.getValue()).stream().map(file -> output.toPath().relativize(file.toPath())).map(path -> "/" + path.toString().replace("\\", "/")).collect(Collectors.joining("\", \"", "[\"", "\"]"));
                return "  " + (String)e.getKey() + ": " + files;
            }).collect(Collectors.joining("\n"))).append("\n}\n");
            dist.append("assets.cache.maxAge = ").append(maxAge).append("\n");
            dist.append("assets.watch = false\n");
            dist.append("assets.pipeline.dev = {}\n");
            dist.append("assets.pipeline.").append(env).append(" = {}\n");
            try (FileWriter writer = new FileWriter(distFile);){
                writer.write(dist.toString());
            }
            long end = System.currentTimeMillis();
            String summary = compiler.summary(fileset, output.toPath(), env, end - start, new String[]{"        " + assemblyOutput, "Assets: " + distFile});
            logger.info(summary.toString());
            List files = fileset.values().stream().flatMap(it -> it.stream()).collect(Collectors.toList());
            for (File from : files) {
                File to = assemblyOutput.toPath().resolve(output.toPath().relativize(from.toPath())).toFile();
                to.getParentFile().mkdirs();
                logger.debug("copying file to: " + to);
                Files.copy((File)from, (File)to);
            }
        }).unwrap(InvocationTargetException.class).throwException();
    }

    public String getEnv() {
        return this.env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public File getAssemblyOutput() {
        return this.assemblyOutput;
    }

    public void setAssemblyOutput(File assemblyOutput) {
        this.assemblyOutput = assemblyOutput;
    }

    public String getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(String maxAge) {
        this.maxAge = maxAge;
    }

    private static class CompilationDone
    extends RuntimeException {
        private CompilationDone() {
        }
    }
}

