/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.run;

import com.typesafe.config.Config;
import java.net.URLClassLoader;
import java.util.function.BiConsumer;
import org.gradle.api.Project;
import org.jooby.Jooby;
import org.jooby.run.JoobyProject;

public class JoobyContainer {
    private JoobyProject project;

    public JoobyContainer(Project project) {
        this.project = new JoobyProject(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String mainClass, BiConsumer<Jooby, Config> callback, String ... args) throws Throwable {
        ClassLoader global = Thread.currentThread().getContextClassLoader();
        try (URLClassLoader local = this.project.newClassLoader();){
            Thread.currentThread().setContextClassLoader(local);
            if (mainClass == null) {
                throw new IllegalArgumentException("Main class missing. Please set, like: mainClassName = \"my.App\"");
            }
            Jooby app = (Jooby)local.loadClass(mainClass).newInstance();
            Config conf = Jooby.exportConf((Jooby)app);
            callback.accept(app, conf);
        }
        finally {
            Thread.currentThread().setContextClassLoader(global);
        }
    }
}

