/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.run;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.jooby.funzy.Throwing;

public class JoobyProject {
    private Project project;

    public JoobyProject(Project project) {
        this.project = project;
    }

    public File classes() {
        SourceSet sourceSet = this.sourceSet(this.project);
        return sourceSet.getRuntimeClasspath().getFiles().stream().filter(f -> f.exists() && f.isDirectory() && f.toString().contains("classes")).findFirst().get();
    }

    public Set<File> classpath() {
        SourceSet sourceSet = this.sourceSet(this.project);
        LinkedHashSet<File> cp = new LinkedHashSet<File>();
        sourceSet.getResources().getSrcDirs().forEach(cp::add);
        sourceSet.getRuntimeClasspath().getFiles().forEach(cp::add);
        Configuration provided = (Configuration)this.project.getConfigurations().findByName("provided");
        if (provided != null) {
            provided.getFiles().forEach(cp::add);
        }
        return cp;
    }

    public Set<File> sources() {
        SourceSet sourceSet = this.sourceSet(this.project);
        LinkedHashSet<File> src = new LinkedHashSet<File>();
        sourceSet.getResources().getSrcDirs().forEach(src::add);
        sourceSet.getJava().getSrcDirs().forEach(f -> src.add(f.getParentFile()));
        return src;
    }

    public File javaSrc() {
        SourceSet sourceSet = this.sourceSet(this.project);
        return (File)sourceSet.getJava().getSrcDirs().iterator().next();
    }

    private SourceSet sourceSet(Project project) {
        SourceSet sourceSet = (SourceSet)this.getJavaConvention(project).getSourceSets().getByName("main");
        return sourceSet;
    }

    public JavaPluginConvention getJavaConvention(Project project) {
        return (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
    }

    public URLClassLoader newClassLoader() throws MalformedURLException {
        return JoobyProject.toClassLoader(this.classpath().stream().map(Throwing.throwingFunction(f -> f.toURI().toURL())).collect(Collectors.toList()), this.getClass().getClassLoader());
    }

    private static URLClassLoader toClassLoader(final List<URL> cp, ClassLoader parent) {
        return new URLClassLoader(cp.toArray(new URL[cp.size()]), parent){

            public String toString() {
                return cp.toString();
            }
        };
    }
}

