/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.run;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.jooby.funzy.Try;
import org.jooby.run.Main;
import org.jooby.run.Watcher;

public class JoobyTask
extends ConventionTask {
    private static final Object LOCK = new Object();
    private static final List<String> XML_PROPS = Arrays.asList("javax.xml.parsers.DocumentBuilderFactory", "javax.xml.parsers.SAXParserFactory", "javax.xml.stream.XMLInputFactory", "javax.xml.stream.XMLEventFactory", "javax.xml.transform.TransformerFactory", "javax.xml.stream.XMLOutputFactory", "javax.xml.datatype.DatatypeFactory", "org.xml.sax.driver");
    private List<String> includes;
    private List<String> excludes;
    private String logLevel;
    private boolean block;
    private Set<File> classpath;
    private Set<File> src;
    private List<String> watchDirs;
    private List<String> srcExtensions;
    private String mainClassName;
    private String compiler;
    private ProjectConnection connection;

    @TaskAction
    public void run() throws Exception {
        System.setProperty("logLevel", this.getLogLevel());
        Project project = this.getProject();
        String mId = project.getName();
        ArrayList cp = new ArrayList();
        this.getClasspath().forEach(cp::add);
        Main app = new Main(mId, this.getMainClassName(), this.toFiles(this.watchDirs), cp.toArray(new File[cp.size()]));
        if (this.includes != null) {
            app.includes(this.includes.stream().collect(Collectors.joining(File.pathSeparator)));
        }
        if (this.excludes != null) {
            app.excludes(this.excludes.stream().collect(Collectors.joining(File.pathSeparator)));
        }
        String compiler = this.getCompiler();
        this.getLogger().info("compiler is {}", (Object)compiler);
        if ("on".equalsIgnoreCase(compiler)) {
            Path[] watchDirs = this.getSrc().stream().filter(File::exists).map(File::toPath).collect(Collectors.toList()).toArray(new Path[0]);
            this.getLogger().info("watching directories {}", Arrays.asList(watchDirs));
            this.connection = GradleConnector.newConnector().useInstallation(project.getGradle().getGradleHomeDir()).forProjectDirectory(project.getRootDir()).connect();
            Watcher watcher = new Watcher((k, path) -> {
                if (this.getSrcExtensions().stream().anyMatch(ext -> path.toString().endsWith((String)ext))) {
                    this.runTask(this.connection, (Path)path, "classes");
                }
            }, watchDirs);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> Try.run(() -> watcher.stop()).onComplete(() -> this.connection.close()).throwException()));
            watcher.start();
        }
        String[] args = project.getGradle().getStartParameter().getProjectProperties().entrySet().stream().map(e -> e.toString()).collect(Collectors.toList()).toArray(new String[0]);
        app.run(this.isBlock(), args);
    }

    private List<File> toFiles(List<String> watchDirs) {
        ArrayList<File> files = new ArrayList<File>();
        if (watchDirs != null) {
            watchDirs.forEach(f -> files.add(new File((String)f)));
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTask(ProjectConnection connection, Path path, String task) {
        Object object = LOCK;
        synchronized (object) {
            HashMap<String, String> xml = new HashMap<String, String>();
            try {
                XML_PROPS.forEach(p -> xml.put((String)p, (String)System.getProperties().remove(p)));
                try {
                    ((BuildLauncher)((BuildLauncher)connection.newBuild().setStandardError((OutputStream)System.err)).setStandardOutput((OutputStream)System.out)).forTasks(new String[]{task}).run();
                }
                catch (Exception ex) {
                    this.getLogger().debug("Execution of " + task + " resulted in exception", (Throwable)ex);
                }
            }
            finally {
                xml.forEach((k, v) -> {
                    if (v != null) {
                        System.setProperty(k, v);
                    }
                });
            }
        }
    }

    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    @InputFiles
    public Set<File> getClasspath() {
        return this.classpath;
    }

    public void setClasspath(Set<File> classpath) {
        this.classpath = classpath;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public boolean isBlock() {
        return this.block;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public void setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
    }

    public Set<File> getSrc() {
        return this.src;
    }

    public void setSrc(Set<File> watchDirs) {
        this.src = watchDirs;
    }

    public List<String> getWatchDirs() {
        return this.watchDirs;
    }

    public void setWatchDirs(List<String> watchDirs) {
        this.watchDirs = watchDirs;
    }

    public List<String> getSrcExtensions() {
        return this.srcExtensions;
    }

    public void setSrcExtensions(List<String> srcExtensions) {
        this.srcExtensions = srcExtensions;
    }

    public String getCompiler() {
        return this.compiler;
    }

    public void setCompiler(String compiler) {
        this.compiler = compiler;
    }
}

