/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.TypeLiteral;
import org.jooby.MediaType;
import org.jooby.Parser;

class JacksonParser
implements Parser {
    private ObjectMapper mapper;
    private MediaType.Matcher matcher;

    public JacksonParser(ObjectMapper mapper, MediaType type) {
        this.mapper = mapper;
        this.matcher = MediaType.matcher((MediaType)type);
    }

    public Object parse(TypeLiteral<?> type, Parser.Context ctx) throws Exception {
        MediaType ctype = ctx.type();
        if (ctype.isAny()) {
            return ctx.next();
        }
        JavaType javaType = this.mapper.constructType(type.getType());
        if (this.matcher.matches(ctype) && this.mapper.canDeserialize(javaType)) {
            return ctx.ifparam(values -> this.mapper.readValue((String)values.iterator().next(), javaType)).ifbody(body -> this.mapper.readValue(body.bytes(), javaType));
        }
        return ctx.next();
    }

    public String toString() {
        return "json";
    }
}

