/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jooby.MediaType;
import org.jooby.Renderer;

class JacksonRenderer
implements Renderer {
    private ObjectMapper mapper;
    private MediaType type;

    public JacksonRenderer(ObjectMapper mapper, MediaType type) {
        this.mapper = mapper;
        this.type = type;
    }

    public void render(Object value, Renderer.Context ctx) throws Exception {
        if (ctx.accepts(this.type) && this.mapper.canSerialize(value.getClass())) {
            ctx.type(this.type);
            byte[] bytes = this.mapper.writer().writeValueAsBytes(value);
            ctx.length((long)bytes.length).send(bytes);
        }
    }

    public String toString() {
        return "json";
    }
}

