/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.jedis;

import com.google.inject.Binder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.jedis.RedisProvider;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class Redis
implements Jooby.Module {
    private String name;

    public Redis(String name) {
        this.name = Objects.requireNonNull(name, "A db property is required.");
    }

    public Redis() {
        this("db");
    }

    public void configure(Env env, Config config, Binder binder) {
        GenericObjectPoolConfig poolConfig = this.poolConfig(config, this.name);
        int timeout = (int)config.getDuration("jedis.timeout", TimeUnit.MILLISECONDS);
        URI uri = URI.create(config.getString(this.name));
        JedisPool pool = new JedisPool(poolConfig, uri, timeout);
        RedisProvider provider = new RedisProvider(pool, uri, poolConfig);
        env.onStart(provider::start);
        env.onStop(provider::stop);
        Provider jedis = () -> pool.getResource();
        Env.ServiceKey serviceKey = env.serviceKey();
        serviceKey.generate(JedisPool.class, this.name, k -> binder.bind(k).toInstance((Object)pool));
        serviceKey.generate(Jedis.class, this.name, k -> binder.bind(k).toProvider(jedis).asEagerSingleton());
    }

    private GenericObjectPoolConfig poolConfig(Config config, String name) {
        Config poolConfig = config.getConfig("jedis.pool");
        String override = "jedis." + name;
        if (config.hasPath(override)) {
            poolConfig = config.getConfig(override).withFallback((ConfigMergeable)poolConfig);
        }
        return this.poolConfig(poolConfig);
    }

    private GenericObjectPoolConfig poolConfig(Config config) {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setBlockWhenExhausted(config.getBoolean("blockWhenExhausted"));
        poolConfig.setEvictionPolicyClassName(config.getString("evictionPolicyClassName"));
        poolConfig.setJmxEnabled(config.getBoolean("jmxEnabled"));
        poolConfig.setJmxNamePrefix(config.getString("jmxNamePrefix"));
        poolConfig.setLifo(config.getBoolean("lifo"));
        poolConfig.setMaxIdle(config.getInt("maxIdle"));
        poolConfig.setMaxTotal(config.getInt("maxTotal"));
        poolConfig.setMaxWaitMillis(config.getDuration("maxWait", TimeUnit.MILLISECONDS));
        poolConfig.setMinEvictableIdleTimeMillis(config.getDuration("minEvictableIdle", TimeUnit.MILLISECONDS));
        poolConfig.setMinIdle(config.getInt("minIdle"));
        poolConfig.setNumTestsPerEvictionRun(config.getInt("numTestsPerEvictionRun"));
        poolConfig.setSoftMinEvictableIdleTimeMillis(config.getDuration("softMinEvictableIdle", TimeUnit.MILLISECONDS));
        poolConfig.setTestOnBorrow(config.getBoolean("testOnBorrow"));
        poolConfig.setTestOnReturn(config.getBoolean("testOnReturn"));
        poolConfig.setTestWhileIdle(config.getBoolean("testWhileIdle"));
        poolConfig.setTimeBetweenEvictionRunsMillis(config.getDuration("timeBetweenEvictionRuns", TimeUnit.MILLISECONDS));
        return poolConfig;
    }

    public Config config() {
        return ConfigFactory.parseResources(this.getClass(), (String)"jedis.conf");
    }
}

