/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.jedis;

import java.net.URI;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.jooby.jedis.Redis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPool;

class RedisProvider {
    private final Logger log = LoggerFactory.getLogger(Redis.class);
    private JedisPool pool;
    private URI uri;
    private GenericObjectPoolConfig config;

    public RedisProvider(JedisPool pool, URI uri, GenericObjectPoolConfig config) {
        this.pool = pool;
        this.uri = uri;
        this.config = config;
    }

    public void start() {
        this.log.info("Starting {}", (Object)this.uri);
        if (this.log.isDebugEnabled()) {
            this.log.debug("  blockWhenExhausted = {}", (Object)this.config.getBlockWhenExhausted());
            this.log.debug("  evictionPolicyClassName = {}", (Object)this.config.getEvictionPolicyClassName());
            this.log.debug("  jmxEnabled = {}", (Object)this.config.getJmxEnabled());
            this.log.debug("  jmxNamePrefix = {}", (Object)this.config.getJmxNamePrefix());
            this.log.debug("  lifo = {}", (Object)this.config.getLifo());
            this.log.debug("  maxIdle = {}", (Object)this.config.getMaxIdle());
            this.log.debug("  maxTotal = {}", (Object)this.config.getMaxTotal());
            this.log.debug("  maxWaitMillis = {}", (Object)this.config.getMaxWaitMillis());
            this.log.debug("  minEvictableIdleTimeMillis = {}", (Object)this.config.getMinEvictableIdleTimeMillis());
            this.log.debug("  minIdle = {}", (Object)this.config.getMinIdle());
            this.log.debug("  numTestsPerEvictionRun = {}", (Object)this.config.getNumTestsPerEvictionRun());
            this.log.debug("  softMinEvictableIdleTimeMillis = {}", (Object)this.config.getSoftMinEvictableIdleTimeMillis());
            this.log.debug("  testOnBorrow = {}", (Object)this.config.getTestOnBorrow());
            this.log.debug("  testOnReturn = {}", (Object)this.config.getTestOnReturn());
            this.log.debug("  timeBetweenEvictionRunsMillis = {}", (Object)this.config.getTimeBetweenEvictionRunsMillis());
        }
    }

    public void stop() {
        if (this.pool != null) {
            this.log.info("Stopping {}", (Object)this.uri);
            this.pool.destroy();
            this.pool = null;
        }
    }
}

