/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.jongo.Jongo;
import org.jongo.Mapper;
import org.jooby.mongodb.JongoFactory;

public class JongoFactoryImpl
implements JongoFactory,
Provider<Jongo> {
    private MongoClient client;
    private String db;
    private Mapper mapper;

    @Inject
    public JongoFactoryImpl(MongoClientURI uri, MongoClient client, Mapper mapper) {
        this.db = Objects.requireNonNull(uri, "MongoClientURI is required.").getDatabase();
        this.client = Objects.requireNonNull(client, "MongoClient is required.");
        this.mapper = Objects.requireNonNull(mapper, "Mapper is required.");
    }

    public Jongo get() {
        return this.get(this.db);
    }

    @Override
    public Jongo get(String db) {
        return new Jongo(this.client.getDB(db), this.mapper);
    }
}

