/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.internal.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reporter;
import java.io.Closeable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jooby.funzy.Try;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricRegistryInitializer {
    private Set<Closeable> reporters = new HashSet<Closeable>();
    private final Logger log = LoggerFactory.getLogger(MetricRegistry.class);

    @Inject
    public MetricRegistryInitializer(MetricRegistry registry, Map<String, Metric> metrics, Set<Reporter> reporters) {
        metrics.forEach((arg_0, arg_1) -> ((MetricRegistry)registry).register(arg_0, arg_1));
        reporters.forEach(reporter -> {
            if (reporter instanceof Closeable) {
                this.reporters.add((Closeable)reporter);
            }
        });
    }

    public void close() throws Exception {
        this.reporters.forEach(r -> Try.run(r::close).onFailure(cause -> this.log.error("close of {} resulted in error", r, cause)));
    }
}

