/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.metrics;

import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.common.collect.ImmutableSortedMap;
import java.util.SortedMap;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Status;

public class HealthCheckHandler
implements Route.Handler {
    public void handle(Request req, Response rsp) throws Throwable {
        HealthCheckRegistry registry = (HealthCheckRegistry)req.require(HealthCheckRegistry.class);
        SortedMap checks = req.param("name").toOptional().map(name -> {
            ImmutableSortedMap set = ImmutableSortedMap.of((Comparable)((Object)name), (Object)registry.runHealthCheck(name));
            return set;
        }).orElseGet(() -> registry.runHealthChecks());
        Status status = checks.isEmpty() ? Status.NOT_IMPLEMENTED : checks.values().stream().filter(it -> !it.isHealthy()).findFirst().map(it -> Status.SERVER_ERROR).orElse(Status.OK);
        rsp.status(status).header("Cache-Control", (Object)"must-revalidate,no-cache,no-store").send((Object)checks);
    }
}

