/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metered;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Sampling;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Status;

public class MetricHandler
implements Route.Handler {
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String NO_CACHE = "must-revalidate,no-cache,no-store";

    public void handle(Request req, Response rsp) throws Throwable {
        MetricRegistry registry = (MetricRegistry)req.require(MetricRegistry.class);
        Map allmetrics = registry.getMetrics();
        if (allmetrics.isEmpty()) {
            rsp.status(Status.NOT_IMPLEMENTED).header(CACHE_CONTROL, (Object)NO_CACHE).send((Object)allmetrics);
        } else {
            Map<String, Object> timers;
            Map<String, Object> meters;
            Map<String, Object> histograms;
            Map<String, Object> gauges;
            String type = req.param("type").value("*");
            MetricFilter filter = req.param("name").toOptional().map(name -> (n, m) -> n.startsWith((String)name)).orElse(MetricFilter.ALL);
            TimeUnit unit = TimeUnit.valueOf(req.param("unit").value("seconds").toUpperCase());
            String rateUnitLabel = MetricHandler.calculateRateUnit(unit, "ops");
            double rateFactor = unit.toSeconds(1L);
            String durationUnitLabel = unit.toString().toLowerCase(Locale.US);
            double durationFactor = 1.0 / (double)unit.toNanos(1L);
            boolean showSamples = req.param("showSamples").booleanValue(false);
            TreeMap<String, Map<String, Object>> metrics = new TreeMap<String, Map<String, Object>>();
            Map<String, Object> counters = MetricHandler.counters(registry.getCounters(filter));
            if (counters.size() > 0) {
                metrics.put("counters", counters);
            }
            if ((gauges = MetricHandler.gauges(registry.getGauges(filter))).size() > 0) {
                metrics.put("gauges", gauges);
            }
            if ((histograms = MetricHandler.histograms(registry.getHistograms(filter), showSamples)).size() > 0) {
                metrics.put("histograms", histograms);
            }
            if ((meters = MetricHandler.meters(registry.getMeters(filter), rateUnitLabel, rateFactor, durationUnitLabel, durationFactor)).size() > 0) {
                metrics.put("meters", meters);
            }
            if ((timers = MetricHandler.timers(registry.getTimers(filter), rateUnitLabel, rateFactor, durationUnitLabel, durationFactor, showSamples)).size() > 0) {
                metrics.put("timers", timers);
            }
            rsp.status(Status.OK).header(CACHE_CONTROL, (Object)NO_CACHE).send(metrics.getOrDefault(type, metrics));
        }
    }

    private static Map<String, Object> timers(SortedMap<String, Timer> timers, String rateUnit, double rateFactor, String durationUnit, double durationFactor, boolean showSamples) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        timers.forEach((name, timer) -> result.put((String)name, MetricHandler.timer(timer, rateUnit, rateFactor, durationUnit, durationFactor, showSamples)));
        return result;
    }

    private static Map<String, Object> timer(Timer timer, String rateUnit, double rateFactor, String durationUnit, double durationFactor, boolean showSamples) {
        Map<String, Object> result = MetricHandler.meter((Metered)timer, rateUnit, rateFactor, durationUnit, durationFactor);
        result.putAll(MetricHandler.snapshot((Sampling)timer, durationFactor, showSamples));
        return result;
    }

    private static Map<String, Object> snapshot(Sampling sampling, double durationFactor, boolean showSamples) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        Snapshot snapshot = sampling.getSnapshot();
        result.put("max", (double)snapshot.getMax() * durationFactor);
        result.put("mean", snapshot.getMean() * durationFactor);
        result.put("min", (double)snapshot.getMin() * durationFactor);
        result.put("p50", snapshot.getMedian() * durationFactor);
        result.put("p75", snapshot.get75thPercentile() * durationFactor);
        result.put("p95", snapshot.get95thPercentile() * durationFactor);
        result.put("p98", snapshot.get98thPercentile() * durationFactor);
        result.put("p99", snapshot.get99thPercentile() * durationFactor);
        result.put("p999", snapshot.get999thPercentile() * durationFactor);
        if (showSamples) {
            long[] values = snapshot.getValues();
            ArrayList<Double> scaledValues = new ArrayList<Double>(values.length);
            for (long value : values) {
                scaledValues.add((double)value * durationFactor);
            }
            result.put("values", scaledValues);
        }
        return result;
    }

    private static Map<String, Object> gauges(SortedMap<String, Gauge> gauges) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        gauges.forEach((name, gauge) -> {
            try {
                result.put((String)name, gauge.getValue());
            }
            catch (Exception ex) {
                result.put((String)name, ex.toString());
            }
        });
        return result;
    }

    private static Map<String, Object> counters(SortedMap<String, Counter> counters) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        counters.forEach((name, c) -> result.put((String)name, c.getCount()));
        return result;
    }

    private static Map<String, Object> histograms(SortedMap<String, Histogram> histograms, boolean showSamples) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        histograms.forEach((name, timer) -> result.put((String)name, MetricHandler.snapshot((Sampling)timer, 1.0, showSamples)));
        return result;
    }

    private static Map<String, Object> meters(SortedMap<String, Meter> timers, String rateUnit, double rateFactor, String durationUnit, double durationFactor) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        timers.forEach((name, timer) -> result.put((String)name, MetricHandler.meter((Metered)timer, rateUnit, rateFactor, durationUnit, durationFactor)));
        return result;
    }

    private static Map<String, Object> meter(Metered meter, String rateUnit, double rateFactor, String durationUnit, double durationFactor) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        result.put("count", meter.getCount());
        result.put("m15_rate", meter.getFifteenMinuteRate() * rateFactor);
        result.put("m1_rate", meter.getOneMinuteRate() * rateFactor);
        result.put("m5_rate", meter.getFiveMinuteRate() * rateFactor);
        result.put("mean_rate", meter.getMeanRate() * rateFactor);
        result.put("duration_units", durationUnit);
        result.put("rate_units", rateUnit);
        return result;
    }

    private static String calculateRateUnit(TimeUnit unit, String name) {
        String s = unit.toString().toLowerCase(Locale.US);
        return name + '/' + s.substring(0, s.length() - 1);
    }
}

