/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reporter;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.google.inject.Binder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jooby.Env;
import org.jooby.Jooby;
import org.jooby.Route;
import org.jooby.Router;
import org.jooby.internal.metrics.HealthCheckRegistryInitializer;
import org.jooby.internal.metrics.MetricRegistryInitializer;
import org.jooby.metrics.HealthCheckHandler;
import org.jooby.metrics.InstrumentedHandler;
import org.jooby.metrics.MetricHandler;
import org.jooby.metrics.PingHandler;
import org.jooby.metrics.ThreadDumpHandler;

public class Metrics
implements Jooby.Module {
    private String pattern;
    private List<Bindings> bindings = new ArrayList<Bindings>();
    private List<Consumer<Router>> routes = new ArrayList<Consumer<Router>>();
    private Set<BiFunction<MetricRegistry, Config, Reporter>> reporters = new LinkedHashSet<BiFunction<MetricRegistry, Config, Reporter>>();
    private MetricRegistry metricRegistry;
    private HealthCheckRegistry healthCheckRegistry;

    public Metrics(MetricRegistry metricRegistry, HealthCheckRegistry healthCheckRegistry, String pattern) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "Metric registry is required.");
        this.healthCheckRegistry = Objects.requireNonNull(healthCheckRegistry, "Health check registry is required.");
        this.pattern = Objects.requireNonNull(pattern, "A pattern is required.");
    }

    public Metrics(MetricRegistry metricRegistry, String pattern) {
        this(metricRegistry, new HealthCheckRegistry(), pattern);
    }

    public Metrics(String pattern) {
        this(new MetricRegistry(), pattern);
    }

    public Metrics(HealthCheckRegistry healthCheckRegistry) {
        this(new MetricRegistry(), healthCheckRegistry, "/sys");
    }

    public Metrics(MetricRegistry metricRegistry) {
        this(metricRegistry, "/sys");
    }

    public Metrics() {
        this("/sys");
    }

    public Metrics request(String method, String pattern) {
        this.routes.add(r -> r.use(method, pattern, (Route.Handler)new InstrumentedHandler()));
        return this;
    }

    public Metrics request(String pattern) {
        return this.request("GET", pattern);
    }

    public Metrics request() {
        return this.request("*");
    }

    public Metrics ping() {
        this.bindings.add((binder, routes, conf) -> routes.use("GET", this.pattern + "/ping", (Route.Handler)new PingHandler()));
        return this;
    }

    public Metrics threadDump() {
        this.bindings.add((binder, routes, conf) -> routes.use("GET", this.pattern + "/thread-dump", (Route.Handler)new ThreadDumpHandler()));
        return this;
    }

    public Metrics metric(String name, Metric metric) {
        this.bindings.add((binder, routes, conf) -> MapBinder.newMapBinder((Binder)binder, String.class, Metric.class).addBinding((Object)name).toInstance((Object)metric));
        return this;
    }

    public <M extends Metric> Metrics metric(String name, Class<M> metric) {
        this.bindings.add((binder, routes, conf) -> MapBinder.newMapBinder((Binder)binder, String.class, Metric.class).addBinding((Object)name).to(metric));
        return this;
    }

    public Metrics healthCheck(String name, HealthCheck check) {
        this.bindings.add((binder, routes, conf) -> MapBinder.newMapBinder((Binder)binder, String.class, HealthCheck.class).addBinding((Object)name).toInstance((Object)check));
        return this;
    }

    public <H extends HealthCheck> Metrics healthCheck(String name, Class<H> check) {
        this.bindings.add((binder, routes, conf) -> MapBinder.newMapBinder((Binder)binder, String.class, HealthCheck.class).addBinding((Object)name).to(check));
        return this;
    }

    public Metrics reporter(BiFunction<MetricRegistry, Config, Reporter> callback) {
        this.reporters.add(Objects.requireNonNull(callback, "Callback is required."));
        return this;
    }

    public Metrics reporter(Function<MetricRegistry, Reporter> callback) {
        return this.reporter((MetricRegistry registry, Config conf) -> (Reporter)callback.apply((MetricRegistry)registry));
    }

    public void configure(Env env, Config conf, Binder binder) {
        MapBinder.newMapBinder((Binder)binder, String.class, Metric.class);
        MapBinder.newMapBinder((Binder)binder, String.class, HealthCheck.class);
        Router routes = env.router();
        MetricHandler mhandler = new MetricHandler();
        routes.use("GET", this.pattern + "/metrics", (Route.Handler)mhandler);
        routes.use("GET", this.pattern + "/metrics/:type", (Route.Handler)mhandler);
        routes.use("GET", this.pattern + "/healthcheck", (Route.Handler)new HealthCheckHandler());
        Multibinder reporters = Multibinder.newSetBinder((Binder)binder, Reporter.class);
        binder.bind(MetricRegistry.class).toInstance((Object)this.metricRegistry);
        this.reporters.forEach(it -> reporters.addBinding().toInstance(it.apply(this.metricRegistry, conf)));
        binder.bind(MetricRegistryInitializer.class).asEagerSingleton();
        env.onStop(app -> ((MetricRegistryInitializer)app.require(MetricRegistryInitializer.class)).close());
        binder.bind(HealthCheckRegistry.class).toInstance((Object)this.healthCheckRegistry);
        binder.bind(HealthCheckRegistryInitializer.class).asEagerSingleton();
        this.bindings.forEach(it -> it.bind(binder, routes, conf));
        this.routes.forEach(it -> it.accept(routes));
    }

    static interface Bindings {
        public void bind(Binder var1, Router var2, Config var3);
    }
}

