/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.metrics;

import com.codahale.metrics.jvm.ThreadDump;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import org.jooby.MediaType;
import org.jooby.Request;
import org.jooby.Response;
import org.jooby.Route;
import org.jooby.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadDumpHandler
implements Route.Handler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ThreadDump threadDump;

    public ThreadDumpHandler() {
        try {
            this.threadDump = new ThreadDump(ManagementFactory.getThreadMXBean());
        }
        catch (Exception ex) {
            this.log.warn("Thread dump isn't available", (Throwable)ex);
        }
    }

    public void handle(Request req, Response rsp) throws Throwable {
        Status status;
        Object data;
        if (this.threadDump == null) {
            data = "Sorry your runtime environment does not allow to dump threads.";
            status = Status.NOT_IMPLEMENTED;
        } else {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            this.threadDump.dump((OutputStream)output);
            data = output.toByteArray();
            status = Status.OK;
        }
        rsp.type(MediaType.plain).status(status).header("Cache-Control", (Object)"must-revalidate,no-cache,no-store").send(data);
    }
}

