/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta.extensions.jpa;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Entity;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.impl.JPAConverter;
import org.jooq.meta.extensions.AbstractInterpretingDatabase;
import org.jooq.meta.extensions.jpa.AttributeConverterExtractor;
import org.jooq.meta.jaxb.ForcedType;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StringUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class JPADatabase
extends AbstractInterpretingDatabase {
    static final String HIBERNATE_DIALECT = SQLDialect.H2.thirdParty().hibernateDialect();
    static final JooqLogger log = JooqLogger.getLogger(JPADatabase.class);
    Map<String, Object> userSettings = new HashMap<String, Object>();

    protected void export() throws Exception {
        String packages = this.getProperties().getProperty("packages");
        if (StringUtils.isBlank((String)packages)) {
            packages = "";
            log.warn((Object)"No packages defined", (Object)"It is highly recommended that you provide explicit packages to scan");
        }
        boolean useAttributeConverters = Boolean.parseBoolean(this.getProperties().getProperty("useAttributeConverters", this.getProperties().getProperty("use-attribute-converters", "true")));
        LinkedHashMap<String, Object> settings = new LinkedHashMap<String, Object>();
        settings.put("hibernate.dialect", HIBERNATE_DIALECT);
        settings.put("javax.persistence.schema-generation-connection", this.connection());
        settings.put("javax.persistence.create-database-schemas", true);
        settings.put("hibernate.connection.provider_class", this.connectionProvider());
        for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
            String key = "" + entry.getKey();
            if (!key.startsWith("hibernate.") && !key.startsWith("javax.persistence.") && !key.startsWith("jakarta.persistence.")) continue;
            this.userSettings.put(key, entry.getValue());
        }
        settings.putAll(this.userSettings);
        StandardServiceRegistryBuilder builder = new StandardServiceRegistryBuilder();
        builder.applySettings(settings);
        MetadataSources metadata = new MetadataSources((ServiceRegistry)builder.applySettings(settings).build());
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(true);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        int count = 0;
        for (String pkg : packages.split(",")) {
            for (BeanDefinition def : scanner.findCandidateComponents(StringUtils.defaultIfBlank((String)pkg, (String)"").trim())) {
                Class<?> klass = Class.forName(def.getBeanClassName(), true, cl);
                log.debug((Object)"Entity added", (Object)klass.getName());
                metadata.addAnnotatedClass(klass);
                ++count;
            }
        }
        if (count > 0) {
            log.info((Object)"Entities added", (Object)("Number of entities added: " + count));
        } else {
            log.warn((Object)"No entities added", (Object)"No entities were added to the MetadataSources\n\nThis can have several reasons, including:\n- The packages you've listed do not exist ({packages})\n- The entities in the listed packages are not on the JPADatabase classpath (you must compile them before running jOOQ's codegen, see \"how to organise your dependencies\" in the manual: https://www.jooq.org/doc/latest/manual/code-generation/codegen-jpa/!)\n".replace("{packages}", packages));
        }
        SchemaExport export = new SchemaExport();
        export.create(EnumSet.of(TargetType.DATABASE), metadata.buildMetadata());
        if (useAttributeConverters) {
            this.loadAttributeConverters(metadata.getAnnotatedClasses());
        }
    }

    ConnectionProvider connectionProvider() {
        return new ConnectionProvider(){

            public boolean isUnwrappableAs(Class unwrapType) {
                return false;
            }

            public <T> T unwrap(Class<T> unwrapType) {
                return null;
            }

            public Connection getConnection() {
                return JPADatabase.this.connection();
            }

            public void closeConnection(Connection conn) {
            }

            public boolean supportsAggressiveRelease() {
                return true;
            }
        };
    }

    private final void loadAttributeConverters(Collection<? extends Class<?>> classes) {
        try {
            AttributeConverterExtractor extractor = new AttributeConverterExtractor(this, classes);
            for (Map.Entry<Name, AttributeConverter<?, ?>> entry : extractor.extract().entrySet()) {
                Class<?> convertToEntityAttribute = null;
                for (Method method : entry.getValue().getClass().getMethods()) {
                    if (method.isBridge() || !"convertToEntityAttribute".equals(method.getName())) continue;
                    convertToEntityAttribute = method.getReturnType();
                    break;
                }
                if (convertToEntityAttribute == null) {
                    log.info((Object)"AttributeConverter", (Object)("Cannot use AttributeConverter: " + entry.getValue().getClass().getName()));
                    continue;
                }
                String regex = "(.*?\\.)?" + entry.getKey().unquotedName().toString().replace(".", "\\.");
                ForcedType forcedType = new ForcedType().withIncludeExpression("(?i:" + regex + ")").withUserType(convertToEntityAttribute.getName()).withConverter(String.format("new %s(%s.class)", JPAConverter.class.getName(), entry.getValue().getClass().getName()));
                log.info((Object)"AttributeConverter", (Object)("Configuring JPA AttributeConverter: " + forcedType));
                this.getConfiguredForcedTypes().add(forcedType);
            }
        }
        catch (NoClassDefFoundError e) {
            log.warn((Object)"AttributeConverter", (Object)("Cannot load AttributeConverters due to missing class: " + e.getMessage()));
        }
    }
}

