/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.command;

import java.util.List;
import java.util.Map;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.command.KafkaRequestOrResponse;
import org.joyqueue.broker.kafka.helper.KafkaClientHelper;
import org.joyqueue.broker.network.traffic.FetchRequestTrafficPayload;
import org.joyqueue.broker.network.traffic.Traffic;

public class FetchRequest
extends KafkaRequestOrResponse
implements FetchRequestTrafficPayload {
    private int replicaId;
    private int maxWait;
    private int minBytes;
    private int maxBytes;
    private byte isolationLevel;
    private Map<String, List<PartitionRequest>> partitionRequests;
    private Traffic traffic = new Traffic();

    public Traffic getTraffic() {
        return this.traffic;
    }

    public int getMinBytes() {
        return this.minBytes;
    }

    public void setMinBytes(int minBytes) {
        this.minBytes = minBytes;
    }

    public int getMaxBytes() {
        return this.maxBytes;
    }

    public void setMaxBytes(int maxBytes) {
        this.maxBytes = maxBytes;
    }

    public byte getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(byte isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public void setPartitionRequests(Map<String, List<PartitionRequest>> partitionRequests) {
        this.partitionRequests = partitionRequests;
        for (Map.Entry<String, List<PartitionRequest>> entry : partitionRequests.entrySet()) {
            this.traffic.record(entry.getKey(), 1, 1);
        }
    }

    @Override
    public void setClientId(String clientId) {
        super.setClientId(clientId);
        this.traffic.setApp(KafkaClientHelper.parseClient(clientId));
    }

    public Map<String, List<PartitionRequest>> getPartitionRequests() {
        return this.partitionRequests;
    }

    public int getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(int maxWait) {
        this.maxWait = maxWait;
    }

    public int getReplicaId() {
        return this.replicaId;
    }

    public void setReplicaId(int replicaId) {
        this.replicaId = replicaId;
    }

    public int type() {
        return KafkaCommandType.FETCH.getCode();
    }

    public String toString() {
        return this.describe(true);
    }

    public String describe(boolean details) {
        StringBuilder fetchRequest = new StringBuilder();
        fetchRequest.append("Name: " + this.getClass().getSimpleName());
        fetchRequest.append("; ReplicaId: " + this.replicaId);
        fetchRequest.append("; MaxWait: " + this.maxWait + " ms");
        fetchRequest.append("; MinBytes: " + this.minBytes + " bytes");
        return fetchRequest.toString();
    }

    public static class PartitionRequest {
        private int partition;
        private long offset;
        private long logStartOffset;
        private int maxBytes;

        public void setPartition(int partition) {
            this.partition = partition;
        }

        public int getPartition() {
            return this.partition;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setMaxBytes(int maxBytes) {
            this.maxBytes = maxBytes;
        }

        public int getMaxBytes() {
            return this.maxBytes;
        }

        public long getLogStartOffset() {
            return this.logStartOffset;
        }

        public void setLogStartOffset(long logStartOffset) {
            this.logStartOffset = logStartOffset;
        }
    }
}

