/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.command;

import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.command.KafkaRequestOrResponse;
import org.joyqueue.broker.kafka.message.KafkaBrokerMessage;

public class ProduceRequest
extends KafkaRequestOrResponse {
    private short requiredAcks;
    private int ackTimeoutMs;
    private String transactionalId;
    private Map<String, List<PartitionRequest>> partitionRequests;
    private boolean transaction = false;
    private int partitionNum;
    private long producerId;
    private short producerEpoch;

    public short getRequiredAcks() {
        return this.requiredAcks;
    }

    public void setRequiredAcks(short requiredAcks) {
        this.requiredAcks = requiredAcks;
    }

    public void setAckTimeoutMs(int ackTimeoutMs) {
        this.ackTimeoutMs = ackTimeoutMs;
    }

    public int getAckTimeoutMs() {
        return this.ackTimeoutMs;
    }

    public String getTransactionalId() {
        return this.transactionalId;
    }

    public void setTransactionalId(String transactionalId) {
        this.transactionalId = transactionalId;
    }

    public void setPartitionRequests(Map<String, List<PartitionRequest>> partitionRequests) {
        this.partitionRequests = partitionRequests;
    }

    public Map<String, List<PartitionRequest>> getPartitionRequests() {
        return this.partitionRequests;
    }

    public void setPartitionNum(int partitionNum) {
        this.partitionNum = partitionNum;
    }

    public int getPartitionNum() {
        return this.partitionNum;
    }

    public void setTransaction(boolean transaction) {
        this.transaction = transaction;
    }

    public boolean isTransaction() {
        return this.transaction;
    }

    public long getProducerId() {
        return this.producerId;
    }

    public void setProducerId(long producerId) {
        this.producerId = producerId;
    }

    public short getProducerEpoch() {
        return this.producerEpoch;
    }

    public void setProducerEpoch(short producerEpoch) {
        this.producerEpoch = producerEpoch;
    }

    public int type() {
        return KafkaCommandType.PRODUCE.getCode();
    }

    public String toString() {
        return this.describe();
    }

    private String describe() {
        StringBuilder producerRequest = new StringBuilder();
        producerRequest.append("Name: " + this.getClass().getSimpleName());
        producerRequest.append("; RequiredAcks: " + this.requiredAcks);
        producerRequest.append("; AckTimeoutMs: " + this.ackTimeoutMs + " ms");
        return producerRequest.toString();
    }

    public static class PartitionRequest {
        private int partition;
        private List<KafkaBrokerMessage> messages;

        public PartitionRequest() {
        }

        public PartitionRequest(int partition, List<KafkaBrokerMessage> messages) {
            this.partition = partition;
            this.messages = messages;
        }

        public void setPartition(int partition) {
            this.partition = partition;
        }

        public int getPartition() {
            return this.partition;
        }

        public void setMessages(List<KafkaBrokerMessage> messages) {
            this.messages = messages;
        }

        public List<KafkaBrokerMessage> getMessages() {
            return this.messages;
        }

        public int getSize() {
            if (CollectionUtils.isEmpty(this.messages)) {
                return 0;
            }
            int result = 0;
            for (KafkaBrokerMessage message : this.messages) {
                if (message.isBatch()) {
                    result += message.getFlag();
                    continue;
                }
                ++result;
            }
            return result;
        }

        public int getTraffic() {
            if (CollectionUtils.isEmpty(this.messages)) {
                return 0;
            }
            int result = 0;
            for (KafkaBrokerMessage message : this.messages) {
                result += message.getSize();
            }
            return result;
        }
    }
}

