/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.config;

import org.joyqueue.broker.config.BrokerConfig;
import org.joyqueue.broker.kafka.config.KafkaConfigKey;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConfig {
    protected static final Logger logger = LoggerFactory.getLogger(KafkaConfig.class);
    private PropertySupplier propertySupplier;
    private BrokerConfig brokerConfig;

    public KafkaConfig(PropertySupplier propertySupplier) {
        this.propertySupplier = propertySupplier;
        this.brokerConfig = new BrokerConfig(propertySupplier);
    }

    public boolean getAuthEnable(String app) {
        Object appEnable = PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (String)(KafkaConfigKey.AUTH_ENABLE_PREFIX.getName() + app), (PropertyDef.Type)KafkaConfigKey.AUTH_ENABLE_PREFIX.getType(), (Object)KafkaConfigKey.AUTH_ENABLE_PREFIX.getValue());
        if (appEnable != null) {
            return (Boolean)appEnable;
        }
        return (Boolean)this.propertySupplier.getValue((PropertyDef)KafkaConfigKey.AUTH_ENABLE);
    }

    public boolean getProduceDelayEnable() {
        return (Boolean)this.getConfig(KafkaConfigKey.PRODUCE_DELAY_ENABLE);
    }

    public int getProduceDelay() {
        return (Integer)this.getConfig(KafkaConfigKey.PRODUCE_DELAY);
    }

    public int getProduceTimeout() {
        return (Integer)this.getConfig(KafkaConfigKey.PRODUCE_TIMEOUT);
    }

    public boolean getMetadataDelayEnable() {
        return (Boolean)this.getConfig(KafkaConfigKey.METADATA_DELAY_ENABLE);
    }

    public int getMetadataDelay() {
        return (Integer)this.getConfig(KafkaConfigKey.METADATA_DELAY);
    }

    public boolean getMetadataCacheEnable() {
        return (Boolean)this.getConfig(KafkaConfigKey.METADATA_CACHE_ENABLE);
    }

    public int getMetadataCacheExpireTime() {
        return (Integer)this.getConfig(KafkaConfigKey.METADATA_CACHE_EXPIRE_TIME);
    }

    public boolean getMetadataFuzzySearchEnable() {
        return (Boolean)this.getConfig(KafkaConfigKey.METADATA_FUZZY_SEARCH_ENABLE);
    }

    public boolean getFetchDelay() {
        return (Boolean)this.getConfig(KafkaConfigKey.FETCH_DELAY);
    }

    public int getOffsetSyncTimeout() {
        return (Integer)this.getConfig(KafkaConfigKey.OFFSET_SYNC_TIMEOUT);
    }

    public int getTransactionSyncTimeout() {
        return (Integer)this.getConfig(KafkaConfigKey.TRANSACTION_SYNC_TIMEOUT);
    }

    public int getTransactionTimeout() {
        return (Integer)this.getConfig(KafkaConfigKey.TRANSACTION_TIMEOUT);
    }

    public int getTransactionLogRetries() {
        return (Integer)this.getConfig(KafkaConfigKey.TRANSACTION_LOG_RETRIES);
    }

    public int getTransactionLogInterval() {
        return (Integer)this.getConfig(KafkaConfigKey.TRANSACTION_LOG_INTERVAL);
    }

    public int getTransactionProducerSequenceExpire() {
        return (Integer)this.getConfig(KafkaConfigKey.TRANSACTION_PRODUCER_SEQUENCE_EXPIRE);
    }

    public String getTransactionLogApp() {
        return (String)this.getConfig(KafkaConfigKey.TRANSACTION_LOG_APP);
    }

    public int getTransactionLogScanSize() {
        return (Integer)this.getConfig(KafkaConfigKey.TRANSACTION_LOG_SCAN_SIZE);
    }

    public QosLevel getTransactionLogWriteQosLevel() {
        return QosLevel.valueOf((int)((Integer)this.getConfig(KafkaConfigKey.TRANSACTION_LOG_WRITE_QOSLEVEL)));
    }

    public int getSessionMaxTimeout() {
        return (Integer)this.getConfig(KafkaConfigKey.SESSION_MAX_TIMEOUT);
    }

    public int getSessionMinTimeout() {
        return (Integer)this.getConfig(KafkaConfigKey.SESSION_MIN_TIMEOUT);
    }

    public int getRebalanceInitialDelay() {
        return (Integer)this.getConfig(KafkaConfigKey.REBALANCE_INITIAL_DELAY);
    }

    public int getRebalanceTimeout() {
        return (Integer)this.getConfig(KafkaConfigKey.REBALANCE_TIMEOUT);
    }

    public boolean getLogDetail(String app) {
        return this.brokerConfig.getLogDetail(app);
    }

    protected <T> T getConfig(String key, PropertyDef.Type type, Object defaultValue) {
        return (T)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (String)key, (PropertyDef.Type)type, (Object)defaultValue);
    }

    protected <T> T getConfig(PropertyDef key) {
        return (T)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)key);
    }
}

